/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.compat.kjs.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.recipe.RecipeModel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class RecipeBuilderJS {
    private final List<JsonObject> inputs = new ArrayList<JsonObject>();
    private final List<JsonObject> outputs = new ArrayList<JsonObject>();
    private int ticks;
    private ResourceLocation structureId;
    private final ResourceLocation id;

    public RecipeBuilderJS(String id) {
        this.id = new ResourceLocation(id);
    }

    public RecipeBuilderJS input(JsonObject entry) {
        this.inputs.add(entry);
        return this;
    }

    public RecipeBuilderJS output(JsonObject entry) {
        this.outputs.add(entry);
        return this;
    }

    public RecipeBuilderJS ticks(int ticks) {
        this.ticks = ticks;
        return this;
    }

    public RecipeBuilderJS structureId(ResourceLocation id) {
        this.structureId = id;
        return this;
    }

    public RecipeModel build() {
        JsonObject json = new JsonObject();
        json.addProperty("id", this.id.toString());
        json.addProperty("ticks", (Number)this.ticks);
        json.addProperty("structureId", this.structureId.toString());
        JsonArray inputArr = new JsonArray();
        for (JsonObject input : this.inputs) {
            inputArr.add((JsonElement)input);
        }
        JsonArray outputArr = new JsonArray();
        for (JsonObject output : this.outputs) {
            outputArr.add((JsonElement)output);
        }
        json.add("inputs", (JsonElement)inputArr);
        json.add("outputs", (JsonElement)outputArr);
        return RecipeModel.parse(json, this.id);
    }

    public ResourceLocation getId() {
        return this.id;
    }
}

