/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.datagen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.ticticboom.mods.mm.datagen.MMRepositorySource;
import io.ticticboom.mods.mm.datagen.provider.MMBlockTagsProvider;
import io.ticticboom.mods.mm.datagen.provider.MMBlockstateProvider;
import io.ticticboom.mods.mm.datagen.provider.MMItemModelProvider;
import io.ticticboom.mods.mm.datagen.provider.MMLangProvider;
import io.ticticboom.mods.mm.datagen.provider.MMLootTableProvider;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.DetectedVersion;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class DataGenManager {
    private static DataGenerator generator;
    private static boolean hasGenerated;

    public static void generate() {
        if (!hasGenerated) {
            try {
                if (!ModLoader.isLoadingStateValid()) {
                    return;
                }
                generator.m_123917_();
                hasGenerated = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void registerDataProviders() {
        generator = DataGenManager.createDataGenerator();
        ExistingFileHelper efh = new ExistingFileHelper((Collection)ImmutableList.of(), (Set)ImmutableSet.of(), false, null, null);
        CompletableFuture<HolderLookup.Provider> lookupProvider = CompletableFuture.supplyAsync(() -> RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_));
        generator.addProvider(true, (DataProvider)new MMLootTableProvider(generator));
        generator.addProvider(true, (DataProvider)new MMLangProvider(generator, "en_us"));
        generator.addProvider(true, (DataProvider)new MMBlockTagsProvider(generator, lookupProvider));
        if (FMLEnvironment.dist != Dist.DEDICATED_SERVER) {
            generator.addProvider(true, (DataProvider)new MMBlockstateProvider(generator, efh));
            generator.addProvider(true, (DataProvider)new MMItemModelProvider(generator, efh));
        }
    }

    public static DataGenerator createDataGenerator() {
        generator = new DataGenerator(MMRepositorySource.CONFIG_DIR, DetectedVersion.m_195834_(), true);
        return generator;
    }

    static {
        hasGenerated = false;
    }
}

