/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.log;

import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.log.ILogContextElement;
import io.ticticboom.mods.mm.log.StringLogContextElement;
import java.util.Stack;

public class LogContextStack {
    private Stack<ILogContextElement> stack = new Stack();

    public void push(ILogContextElement ctx) {
        this.stack.push(ctx);
    }

    public void push(String ctx) {
        this.push(new StringLogContextElement(ctx));
    }

    public ILogContextElement pop() {
        return this.stack.pop();
    }

    public void doThrow(Exception e) {
        Ref.LOG.warn("START: ERROR CONTEXT STACK");
        for (ILogContextElement elem : this.stack) {
            String format = elem.format();
            Ref.LOG.warn("|- {}", (Object)format);
        }
        Ref.LOG.warn("END: ERROR CONTEXT STACK");
        throw new RuntimeException(e);
    }

    public void reset(ILogContextElement start) {
        this.stack.clear();
        this.stack.push(start);
    }

    public void reset(String start) {
        this.reset(new StringLogContextElement(start));
    }
}

