/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.model;

import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.util.ParserUtils;
import net.minecraft.resources.ResourceLocation;

public record ControllerModel(String id, ResourceLocation type, String name, JsonObject config) {
    public static ControllerModel parse(JsonObject json) {
        String id = json.get("id").getAsString();
        String name = json.get("name").getAsString();
        ResourceLocation type = ParserUtils.parseId(json, "type");
        return new ControllerModel(id, type, name, json);
    }

    public static ControllerModel create(String id, ResourceLocation type, String name) {
        JsonObject json = ControllerModel.paramsToJson(id, type, name);
        return new ControllerModel(id, type, name, json);
    }

    public static JsonObject paramsToJson(String id, ResourceLocation type, String name) {
        JsonObject json = new JsonObject();
        json.addProperty("id", id);
        json.addProperty("type", type.toString());
        json.addProperty("name", name);
        return json;
    }
}

