/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.piece.type.tag;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.piece.StructurePieceSetupMetadata;
import io.ticticboom.mods.mm.piece.type.StructurePiece;
import io.ticticboom.mods.mm.structure.StructureModel;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class TagStructurePiece
extends StructurePiece {
    private final ResourceLocation tagId;
    private final TagKey<Block> tagKey;
    private List<Block> tagBlocks;

    public TagStructurePiece(ResourceLocation tagId) {
        this.tagId = tagId;
        this.tagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)tagId);
    }

    @Override
    public void validateSetup(StructurePieceSetupMetadata meta) {
        this.tagBlocks = ForgeRegistries.BLOCKS.tags().getTag(this.tagKey).stream().toList();
        if (this.tagBlocks.isEmpty()) {
            throw new RuntimeException(String.format("Tag: %s does not contain any blocks or doesnt exist!", this.tagKey));
        }
    }

    @Override
    public boolean formed(Level level, BlockPos pos, StructureModel model) {
        BlockState state = level.m_8055_(pos);
        return state.m_204336_(this.tagKey);
    }

    @Override
    public Supplier<List<Block>> createBlocksSupplier() {
        return () -> this.tagBlocks;
    }

    @Override
    public Component createDisplayComponent() {
        return Component.m_237113_((String)"Block Tag: ").m_7220_((Component)Component.m_237113_((String)this.tagId.toString()).m_130940_(ChatFormatting.DARK_AQUA));
    }

    @Override
    public JsonObject debugExpected(Level level, BlockPos pos, StructureModel model, JsonObject json) {
        json.addProperty("tag", this.tagId.toString());
        JsonArray blocksJson = new JsonArray();
        for (Block tagBlock : this.tagBlocks) {
            blocksJson.add(ForgeRegistries.BLOCKS.getKey((Object)tagBlock).toString());
        }
        json.add("possibleBlocks", (JsonElement)blocksJson);
        return json;
    }

    @Override
    public JsonObject debugFound(Level level, BlockPos pos, StructureModel model, JsonObject json) {
        BlockState foundState = level.m_8055_(pos);
        Block found = foundState.m_60734_();
        ResourceLocation foundId = ForgeRegistries.BLOCKS.getKey((Object)found);
        json.addProperty("block", foundId.toString());
        JsonArray tagsJson = new JsonArray();
        foundState.m_204343_().map(x -> x.f_203868_().toString()).forEach(arg_0 -> ((JsonArray)tagsJson).add(arg_0));
        json.add("foundTags", (JsonElement)tagsJson);
        return json;
    }
}

