/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.botania.mana;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.compat.jei.SlotGrid;
import io.ticticboom.mods.mm.compat.jei.ingredient.MMJeiIngredients;
import io.ticticboom.mods.mm.compat.jei.ingredient.mana.BotaniaManaStack;
import io.ticticboom.mods.mm.port.IPortIngredient;
import io.ticticboom.mods.mm.port.botania.mana.BotaniaManaPortStorage;
import io.ticticboom.mods.mm.recipe.RecipeModel;
import io.ticticboom.mods.mm.recipe.RecipeStateModel;
import io.ticticboom.mods.mm.recipe.RecipeStorages;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import net.minecraft.world.level.Level;

public class BotaniaManaPortIngredient
implements IPortIngredient {
    private final int mana;

    public BotaniaManaPortIngredient(int mana) {
        this.mana = mana;
    }

    @Override
    public boolean canProcess(Level level, RecipeStorages storages, RecipeStateModel state) {
        List<BotaniaManaPortStorage> inputs = storages.getInputStorages(BotaniaManaPortStorage.class);
        int remains = this.mana;
        for (BotaniaManaPortStorage input : inputs) {
            remains -= input.extractMana(remains, true);
        }
        return remains <= 0;
    }

    @Override
    public void process(Level level, RecipeStorages storages, RecipeStateModel state) {
        List<BotaniaManaPortStorage> inputs = storages.getInputStorages(BotaniaManaPortStorage.class);
        int remains = this.mana;
        for (BotaniaManaPortStorage input : inputs) {
            remains -= input.extractMana(remains, false);
        }
    }

    @Override
    public boolean canOutput(Level level, RecipeStorages storages, RecipeStateModel state) {
        List<BotaniaManaPortStorage> outputs = storages.getOutputStorages(BotaniaManaPortStorage.class);
        int remains = this.mana;
        for (BotaniaManaPortStorage output : outputs) {
            remains -= output.receiveMana(remains, true);
        }
        return remains <= 0;
    }

    @Override
    public void output(Level level, RecipeStorages storages, RecipeStateModel state) {
        List<BotaniaManaPortStorage> outputs = storages.getOutputStorages(BotaniaManaPortStorage.class);
        int remains = this.mana;
        for (BotaniaManaPortStorage output : outputs) {
            remains -= output.receiveMana(remains, false);
        }
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, RecipeModel model, IFocusGroup focus, IJeiHelpers helpers, SlotGrid grid, IRecipeSlotBuilder recipeSlot) {
        recipeSlot.addIngredient((IIngredientType)MMJeiIngredients.BOTANIA_MANA, (Object)new BotaniaManaStack(this.mana));
    }

    @Override
    public JsonObject debugInput(Level level, RecipeStorages storages, JsonObject json) {
        List<BotaniaManaPortStorage> inputStorages = storages.getInputStorages(BotaniaManaPortStorage.class);
        JsonArray searchedStoragesJson = new JsonArray();
        JsonArray searchIterationsJson = new JsonArray();
        json.addProperty("ingredientType", Ref.Ports.BOTANIA_MANA.toString());
        json.addProperty("amountToExtract", (Number)this.mana);
        int remaining = this.mana;
        for (BotaniaManaPortStorage storage : inputStorages) {
            JsonObject iterJson = new JsonObject();
            int extracted = storage.extractMana(remaining, true);
            iterJson.addProperty("extracted", (Number)extracted);
            iterJson.addProperty("remainingToExtract", (Number)(remaining -= extracted));
            iterJson.addProperty("storageUid", storage.getStorageUid().toString());
            searchIterationsJson.add((JsonElement)iterJson);
            searchedStoragesJson.add(storage.getStorageUid().toString());
        }
        json.add("extractIterations", (JsonElement)searchIterationsJson);
        json.addProperty("canRun", Boolean.valueOf(remaining <= 0));
        json.add("searchedStorages", (JsonElement)searchedStoragesJson);
        return json;
    }

    @Override
    public JsonObject debugOutput(Level level, RecipeStorages storages, JsonObject json) {
        List<BotaniaManaPortStorage> outputStorages = storages.getOutputStorages(BotaniaManaPortStorage.class);
        JsonArray searchedStoragesJson = new JsonArray();
        JsonArray searchIterationsJson = new JsonArray();
        json.addProperty("ingredientType", Ref.Ports.BOTANIA_MANA.toString());
        json.addProperty("amountToInsert", (Number)this.mana);
        int remaining = this.mana;
        for (BotaniaManaPortStorage storage : outputStorages) {
            JsonObject iterJson = new JsonObject();
            int inserted = storage.receiveMana(remaining, true);
            iterJson.addProperty("inserted", (Number)inserted);
            iterJson.addProperty("remainingToInsert", (Number)(remaining -= inserted));
            searchIterationsJson.add((JsonElement)iterJson);
            searchedStoragesJson.add(storage.getStorageUid().toString());
        }
        json.add("insertIterations", (JsonElement)searchIterationsJson);
        json.addProperty("canRun", Boolean.valueOf(remaining <= 0));
        json.add("searchedStorages", (JsonElement)searchedStoragesJson);
        return json;
    }
}

