/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.fluid;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import io.ticticboom.mods.mm.cap.MMCapabilities;
import io.ticticboom.mods.mm.port.IPortStorage;
import io.ticticboom.mods.mm.port.IPortStorageModel;
import io.ticticboom.mods.mm.port.common.INotifyChangeFunction;
import io.ticticboom.mods.mm.port.fluid.FluidPortHandler;
import io.ticticboom.mods.mm.port.fluid.FluidPortStorageModel;
import io.ticticboom.mods.mm.port.fluid.WrappedFluidPortHandler;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidPortStorage
implements IPortStorage {
    private final FluidPortStorageModel model;
    private final FluidPortHandler handler;
    private final LazyOptional<FluidPortHandler> handlerLazyOptional;
    private final UUID uid = UUID.randomUUID();

    public FluidPortStorage(FluidPortStorageModel model, INotifyChangeFunction changed) {
        this.model = model;
        this.handler = new FluidPortHandler(model.rows() * model.columns(), model.slotCapacity(), changed);
        this.handlerLazyOptional = LazyOptional.of(() -> this.handler);
    }

    public IFluidHandler getWrappedHandler() {
        return new WrappedFluidPortHandler(this.handler);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability) {
        if (this.hasCapability(capability)) {
            return this.handlerLazyOptional.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public <T> boolean hasCapability(Capability<T> capability) {
        return MMCapabilities.FLUID == capability;
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        Tag compoundTag = this.handler.serializeNBT();
        tag.m_128365_("handler", compoundTag);
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
        Tag compoundTag = tag.m_128423_("handler");
        this.handler.deserializeNBT(compoundTag);
    }

    @Override
    public IPortStorageModel getStorageModel() {
        return this.model;
    }

    @Override
    public UUID getStorageUid() {
        return this.uid;
    }

    @Override
    public JsonObject debugDump() {
        JsonObject json = new JsonObject();
        json.addProperty("uid", this.uid.toString());
        json.addProperty("slotCapacity", (Number)this.model.slotCapacity());
        json.addProperty("rows", (Number)this.model.rows());
        json.addProperty("columns", (Number)this.model.columns());
        JsonArray tanks = new JsonArray();
        for (int i = 0; i < this.handler.getTanks(); ++i) {
            FluidStack stack = this.handler.getFluidInTank(i);
            DataResult res = (DataResult)JsonOps.INSTANCE.withEncoder((Encoder)FluidStack.CODEC).apply(stack);
            if (res.result().isPresent()) {
                tanks.add((JsonElement)res.result().get());
                continue;
            }
            tanks.add("Error Serializing Fluid Stack");
        }
        return json;
    }

    public FluidStack getStackInSlot(int slot) {
        return this.handler.getFluidInTank(slot);
    }

    public FluidPortHandler getHandler() {
        return this.handler;
    }
}

