/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.item;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.compat.jei.SlotGrid;
import io.ticticboom.mods.mm.compat.jei.ingredient.MMJeiIngredients;
import io.ticticboom.mods.mm.port.item.BaseItemPortIngredient;
import io.ticticboom.mods.mm.port.item.ItemPortStorage;
import io.ticticboom.mods.mm.recipe.RecipeModel;
import io.ticticboom.mods.mm.recipe.RecipeStateModel;
import io.ticticboom.mods.mm.recipe.RecipeStorages;
import java.util.List;
import java.util.function.Predicate;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class SingleItemPortIngredient
extends BaseItemPortIngredient {
    private final ResourceLocation itemId;
    private final Item item;
    private final ItemStack stack;

    public SingleItemPortIngredient(ResourceLocation itemId, int count) {
        super(count, SingleItemPortIngredient.createPredicate(itemId));
        this.itemId = itemId;
        this.item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
        if (this.item == null) {
            throw new RuntimeException(String.format("Could not find item [%s] which is required by an MM recipe", itemId));
        }
        this.stack = new ItemStack((ItemLike)this.item, count);
    }

    private static Predicate<ItemStack> createPredicate(ResourceLocation id) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
        if (item == null) {
            throw new RuntimeException(String.format("Could not find item [%s] which is required by an MM recipe", id));
        }
        return c -> c.m_150930_(item);
    }

    @Override
    public boolean canOutput(Level level, RecipeStorages storages, RecipeStateModel state) {
        List<ItemPortStorage> itemStorages = storages.getOutputStorages(ItemPortStorage.class);
        int remainingToInsert = this.count;
        for (ItemPortStorage itemStorage : itemStorages) {
            remainingToInsert = itemStorage.canInsert(this.item, remainingToInsert);
        }
        return remainingToInsert <= 0;
    }

    @Override
    public void output(Level level, RecipeStorages storages, RecipeStateModel state) {
        List<ItemPortStorage> itemStorages = storages.getOutputStorages(ItemPortStorage.class);
        int remainingToInsert = this.count;
        for (ItemPortStorage itemStorage : itemStorages) {
            remainingToInsert = itemStorage.insert(this.item, remainingToInsert);
        }
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, RecipeModel model, IFocusGroup focus, IJeiHelpers helpers, SlotGrid grid, IRecipeSlotBuilder recipeSlot) {
        recipeSlot.addIngredient(MMJeiIngredients.ITEM, (Object)this.stack);
    }

    @Override
    public JsonObject debugOutput(Level level, RecipeStorages storages, JsonObject json) {
        List<ItemPortStorage> itemStorages = storages.getOutputStorages(ItemPortStorage.class);
        JsonArray searchedStorages = new JsonArray();
        JsonArray searchIterations = new JsonArray();
        json.addProperty("ingredientType", Ref.Ports.ITEM.toString());
        json.addProperty("amountToInsert", (Number)this.count);
        int remainingToInsert = this.count;
        for (ItemPortStorage storage : itemStorages) {
            JsonObject iterJson = new JsonObject();
            remainingToInsert = storage.canInsert(this.item, remainingToInsert);
            iterJson.addProperty("remaining", (Number)remainingToInsert);
            iterJson.addProperty("storageUid", storage.getStorageUid().toString());
            searchIterations.add((JsonElement)iterJson);
            searchedStorages.add(storage.getStorageUid().toString());
        }
        json.add("insertIterations", (JsonElement)searchIterations);
        json.addProperty("canRun", Boolean.valueOf(remainingToInsert <= 0));
        json.add("searchedStorages", (JsonElement)searchedStorages);
        return json;
    }
}

