/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.item.feature;

import io.ticticboom.mods.mm.port.common.IHandlerCoupling;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class ItemHandlerCoupling
implements IHandlerCoupling {
    private final LazyOptional<IItemHandler> fromHandler;
    private LazyOptional<IItemHandler> toHandler;

    public ItemHandlerCoupling(LazyOptional<IItemHandler> fromHandler, LazyOptional<IItemHandler> toHandler) {
        this.fromHandler = fromHandler;
        this.toHandler = toHandler;
    }

    @Override
    public void attemptTransfer() {
        this.toHandler.ifPresent(handler -> this.fromHandler.ifPresent(from -> this.attemptTransfer((IItemHandler)from, (IItemHandler)handler)));
    }

    private void attemptTransfer(IItemHandler from, IItemHandler to) {
        for (int fromSlot = 0; fromSlot < from.getSlots(); ++fromSlot) {
            ItemStack extracted = from.extractItem(fromSlot, from.getSlotLimit(fromSlot), true);
            if (extracted.m_41619_()) continue;
            ItemStack remaining = this.attemptInsert(from, to, extracted, fromSlot);
            int shouldExtractCount = extracted.m_41613_() - remaining.m_41613_();
            if (shouldExtractCount <= 0) continue;
            from.extractItem(fromSlot, shouldExtractCount, false);
        }
    }

    private ItemStack attemptInsert(IItemHandler from, IItemHandler to, ItemStack toInsert, int fromSlot) {
        ItemStack remaining = toInsert;
        for (int toSlot = 0; toSlot < to.getSlots(); ++toSlot) {
            remaining = to.insertItem(toSlot, toInsert, false);
            if (!remaining.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return remaining;
    }

    public LazyOptional<IItemHandler> getFromHandler() {
        return this.fromHandler;
    }

    public LazyOptional<IItemHandler> getToHandler() {
        return this.toHandler;
    }

    public void setToHandler(LazyOptional<IItemHandler> toHandler) {
        this.toHandler = toHandler;
    }
}

