/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.item.feature;

import io.ticticboom.mods.mm.cap.MMCapabilities;
import io.ticticboom.mods.mm.model.PortModel;
import io.ticticboom.mods.mm.port.IPortBlockEntity;
import io.ticticboom.mods.mm.port.common.AbstractPortAutoPushFeature;
import io.ticticboom.mods.mm.port.item.feature.ItemHandlerCoupling;
import io.ticticboom.mods.mm.port.item.register.ItemPortBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class ItemPortAutoPushAddon
extends AbstractPortAutoPushFeature<ItemHandlerCoupling> {
    public ItemPortAutoPushAddon(ItemPortBlockEntity portBlockEntity, PortModel model) {
        super(portBlockEntity, model);
    }

    @Override
    protected void tryAddNeighborHandler(BlockPos neighborPos, Direction neighborFace) {
        BlockEntity neighborBe = this.portBlockEntity.m_58904_().m_7702_(neighborPos);
        if (neighborBe == null) {
            return;
        }
        boolean valid = this.canAddAsNeighbor(neighborPos, neighborBe);
        if (!valid) {
            return;
        }
        LazyOptional neighborCap = neighborBe.getCapability(MMCapabilities.ITEM, neighborFace);
        if (!neighborCap.isPresent()) {
            return;
        }
        if (this.autoPushNeighbors.containsKey(neighborPos)) {
            ItemHandlerCoupling pairing = (ItemHandlerCoupling)this.autoPushNeighbors.get(neighborPos);
            pairing.setToHandler((LazyOptional<IItemHandler>)neighborCap);
        } else {
            LazyOptional capability = this.portBlockEntity.getCapability(MMCapabilities.ITEM);
            this.autoPushNeighbors.put(neighborPos, new ItemHandlerCoupling((LazyOptional<IItemHandler>)capability, (LazyOptional<IItemHandler>)neighborCap));
        }
    }

    private boolean canAddAsNeighbor(BlockPos pos, BlockEntity be) {
        if (be instanceof IPortBlockEntity) {
            IPortBlockEntity pbe = (IPortBlockEntity)be;
            return pbe.isInput();
        }
        return true;
    }
}

