/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.kinetic.register;

import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.model.PortModel;
import io.ticticboom.mods.mm.port.IPortBlockEntity;
import io.ticticboom.mods.mm.port.IPortStorage;
import io.ticticboom.mods.mm.port.kinetic.CreateKineticPortStorage;
import io.ticticboom.mods.mm.setup.RegistryGroupHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CreateKineticGenPortBlockEntity
extends GeneratingKineticBlockEntity
implements IPortBlockEntity {
    private final PortModel model;
    private final RegistryGroupHolder groupHolder;
    private final CreateKineticPortStorage storage;

    public CreateKineticGenPortBlockEntity(PortModel model, RegistryGroupHolder groupHolder, BlockPos pos, BlockState state) {
        super((BlockEntityType)groupHolder.getBe().get(), pos, state);
        this.model = model;
        this.groupHolder = groupHolder;
        this.storage = (CreateKineticPortStorage)model.config().createPortStorage(this::internalChanged);
        this.setLazyTickRate(20);
    }

    public void initialize() {
        super.initialize();
        this.updateGeneratedRotation();
    }

    @Override
    public PortModel getModel() {
        return this.model;
    }

    @Override
    public IPortStorage getStorage() {
        return this.storage;
    }

    @Override
    public boolean isInput() {
        return this.model.input();
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Kinetic Port");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return null;
    }

    @Override
    public boolean hasMenu() {
        return false;
    }

    public void internalChanged() {
        this.reActivateSource = true;
    }

    public float getGeneratedSpeed() {
        return this.storage.getSpeed();
    }

    protected Block getStressConfigKey() {
        return (Block)this.groupHolder.getBlock().get();
    }

    public float calculateAddedStressCapacity() {
        this.lastCapacityProvided = this.storage.getStress();
        return this.storage.getStress();
    }

    public void tick() {
        super.tick();
        if (this.storage.isShouldStop()) {
            this.storage.updateSpeed(0.0f);
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_(Ref.NBT_STORAGE_KEY, (Tag)this.storage.save(new CompoundTag()));
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.storage.load(compound.m_128469_(Ref.NBT_STORAGE_KEY));
    }
}

