/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.mekanism.chemical;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.port.IPortStorage;
import io.ticticboom.mods.mm.port.IPortStorageModel;
import io.ticticboom.mods.mm.port.common.INotifyChangeFunction;
import io.ticticboom.mods.mm.port.mekanism.chemical.MekanismChemicalPortStorageModel;
import java.util.UUID;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class MekanismChemicalPortStorage<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
implements IPortStorage {
    public IChemicalTank<CHEMICAL, STACK> chemicalTank;
    private final MekanismChemicalPortStorageModel model;
    private final LazyOptional<IChemicalTank<CHEMICAL, STACK>> handleL0;
    private final UUID uid = UUID.randomUUID();

    protected MekanismChemicalPortStorage(MekanismChemicalPortStorageModel model, INotifyChangeFunction changed) {
        this.model = model;
        this.chemicalTank = this.createTank(model.amount(), changed);
        this.handleL0 = LazyOptional.of(() -> this.chemicalTank);
    }

    protected abstract IChemicalTank<CHEMICAL, STACK> createTank(long var1, INotifyChangeFunction var3);

    protected abstract JsonObject debugStack(STACK var1);

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability) {
        if (this.hasCapability(capability)) {
            return this.handleL0.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        tag.m_128365_("handler", (Tag)this.chemicalTank.serializeNBT());
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
        this.chemicalTank.deserializeNBT((Tag)tag.m_128469_("handler"));
    }

    @Override
    public IPortStorageModel getStorageModel() {
        return this.model;
    }

    @Override
    public UUID getStorageUid() {
        return this.uid;
    }

    @Override
    public JsonObject debugDump() {
        JsonObject json = new JsonObject();
        json.addProperty("uid", this.uid.toString());
        json.addProperty("amount", (Number)this.model.amount());
        JsonObject stack = this.debugStack(this.chemicalTank.getStack());
        json.add("stack", (JsonElement)stack);
        return json;
    }

    public STACK extract(long amount, Action action) {
        return (STACK)this.chemicalTank.extract(amount, action, AutomationType.INTERNAL);
    }

    public STACK insert(STACK stack, Action action) {
        ChemicalStack leftInStack = this.chemicalTank.insert(stack, action, AutomationType.INTERNAL);
        long remainingToInsert = stack.getAmount() - leftInStack.getAmount();
        stack.setAmount(remainingToInsert);
        return stack;
    }
}

