/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.port.pneumaticcraft.air;

import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.port.IPortStorage;
import io.ticticboom.mods.mm.port.IPortStorageModel;
import io.ticticboom.mods.mm.port.common.INotifyChangeFunction;
import io.ticticboom.mods.mm.port.pneumaticcraft.air.PneumaticAirPortHandler;
import io.ticticboom.mods.mm.port.pneumaticcraft.air.PneumaticAirPortStorageModel;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class PneumaticAirPortStorage
implements IPortStorage {
    public final PneumaticAirPortStorageModel model;
    private final INotifyChangeFunction changed;
    private PneumaticAirPortHandler airhandler;
    private final LazyOptional<PneumaticAirPortHandler> airhandlerLO;
    public final Map<IAirHandlerMachine, List<Direction>> airHandlerMap = new IdentityHashMap<IAirHandlerMachine, List<Direction>>();
    private final UUID uid = UUID.randomUUID();

    public PneumaticAirPortStorage(PneumaticAirPortStorageModel model, INotifyChangeFunction changed) {
        this.model = model;
        this.changed = changed;
        this.airhandler = new PneumaticAirPortHandler(model.tier(), model.volume(), changed);
        this.airhandlerLO = LazyOptional.of(() -> this.airhandler);
        this.onNeighborBlockUpdate();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability) {
        if (this.hasCapability(capability)) {
            return this.airhandlerLO.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public <T> boolean hasCapability(Capability<T> capability) {
        return capability == PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY;
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        tag.m_128365_("Air", this.serializeNBT());
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
        this.deserializeNBT(tag.m_128423_("Air"));
    }

    @Override
    public IPortStorageModel getStorageModel() {
        return this.model;
    }

    @Override
    public UUID getStorageUid() {
        return this.uid;
    }

    @Override
    public JsonObject debugDump() {
        JsonObject dump = new JsonObject();
        dump.addProperty("uid", this.uid.toString());
        return dump;
    }

    public float getPressure() {
        return this.airhandler.getPressure();
    }

    public int getAir() {
        return this.airhandler.getAir();
    }

    public int getVolume() {
        return this.airhandler.getVolume();
    }

    public void addAir(int air) {
        this.airhandler.addAir(air);
    }

    public Tag serializeNBT() {
        return IntTag.m_128679_((int)this.airhandler.getAir());
    }

    public void deserializeNBT(Tag nbt) {
        if (!(nbt instanceof IntTag)) {
            throw new IllegalArgumentException("Can not deserialize to an instance that isn't the default implementation");
        }
        IntTag intNbt = (IntTag)nbt;
        this.addAir(-this.getAir());
        this.addAir(intNbt.m_7047_());
    }

    public void onNeighborBlockUpdate() {
        this.airHandlerMap.clear();
        for (Direction side : DirectionUtil.VALUES) {
            this.airhandlerLO.cast().ifPresent(handler -> this.airHandlerMap.computeIfAbsent((IAirHandlerMachine)handler, k -> new ArrayList()).add(side));
        }
        this.airHandlerMap.forEach(IAirHandlerMachine::setConnectedFaces);
    }

    public PneumaticAirPortHandler getAirhandler() {
        return this.airhandler;
    }
}

