/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.structure.layout;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.client.structure.GuiStructureLayoutPiece;
import io.ticticboom.mods.mm.piece.MMStructurePieceRegistry;
import io.ticticboom.mods.mm.piece.StructurePieceSetupMetadata;
import io.ticticboom.mods.mm.piece.modifier.StructurePieceModifier;
import io.ticticboom.mods.mm.piece.type.StructurePiece;
import io.ticticboom.mods.mm.structure.StructureModel;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;

public class StructureLayoutPiece {
    private StructurePiece piece;
    private final List<StructurePieceModifier> modifiers;
    private GuiStructureLayoutPiece guiPiece;
    private final String valueId;
    private final JsonObject json;

    public StructureLayoutPiece(StructurePiece piece, List<StructurePieceModifier> modifiers, GuiStructureLayoutPiece guiPiece, String valueId, JsonObject json) {
        this.piece = piece;
        this.modifiers = modifiers;
        this.guiPiece = guiPiece;
        this.valueId = valueId;
        this.json = json;
    }

    public void validate(StructurePieceSetupMetadata meta) {
        this.piece.validateSetup(meta);
        List<Block> blocks = this.piece.createBlocksSupplier().get();
        if (blocks.isEmpty()) {
            Ref.LOG.error("MM ERROR: Render setup failed to validate for: " + this.valueId);
        }
        for (StructurePieceModifier modifier : this.modifiers) {
            modifier.validateSetup(meta, blocks);
        }
    }

    public boolean formed(Level level, BlockPos pos, StructureModel model, Rotation rot) {
        boolean formed = this.piece.formed(level, pos, model);
        if (!formed) {
            return false;
        }
        for (StructurePieceModifier modifier : this.modifiers) {
            formed = modifier.formed(level, pos, model, rot);
            if (formed) continue;
            return false;
        }
        return true;
    }

    public static StructureLayoutPiece parse(JsonObject json, ResourceLocation structureId, String keyChar) {
        StructurePiece piece = MMStructurePieceRegistry.findPieceType(json);
        List<StructurePieceModifier> modifiers = MMStructurePieceRegistry.findModifierTypes(json);
        GuiStructureLayoutPiece guiPiece = new GuiStructureLayoutPiece(piece.createBlocksSupplier(), piece.createDisplayComponent(), modifiers);
        return new StructureLayoutPiece(piece, modifiers, guiPiece, keyChar, json);
    }

    public void setup(StructureModel model) {
        StructurePieceSetupMetadata meta = new StructurePieceSetupMetadata(model.id(), model);
        this.piece.validateSetup(meta);
        List<Block> blocks = this.piece.createBlocksSupplier().get();
        for (StructurePieceModifier modifier : this.modifiers) {
            modifier.validateSetup(meta, blocks);
        }
    }

    public JsonObject debugFormed(Level level, BlockPos pos, StructureModel model, Rotation rot) {
        JsonObject json = new JsonObject();
        json.addProperty("formed", Boolean.valueOf(this.formed(level, pos, model, rot)));
        JsonObject expected = this.piece.debugExpected(level, pos, model, new JsonObject());
        JsonObject found = this.piece.debugFound(level, pos, model, new JsonObject());
        json.add("expected", (JsonElement)expected);
        json.add("found", (JsonElement)found);
        JsonArray modifiersJson = new JsonArray();
        for (StructurePieceModifier modifier : this.modifiers) {
            JsonObject expectedModifier = modifier.debugExpected(level, pos, model, rot, new JsonObject());
            JsonObject foundModifier = modifier.debugFound(level, pos, model, rot, new JsonObject());
            JsonObject modifierInnerJson = new JsonObject();
            modifierInnerJson.addProperty("id", modifier.getId());
            modifierInnerJson.add("expected", (JsonElement)expectedModifier);
            modifierInnerJson.add("found", (JsonElement)foundModifier);
            modifiersJson.add((JsonElement)modifierInnerJson);
        }
        json.add("modifiers", (JsonElement)modifiersJson);
        return json;
    }

    public List<StructurePieceModifier> getModifiers() {
        return this.modifiers;
    }

    public GuiStructureLayoutPiece getGuiPiece() {
        return this.guiPiece;
    }

    public String getValueId() {
        return this.valueId;
    }

    public JsonObject getJson() {
        return this.json;
    }
}

