/*
 * Decompiled with CFR 0.152.
 */
package com.flopingbird.map4image;

import com.flopingbird.map4image.utils.MapGenerationUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class GenerateMapArt {
    public static int[][] generateMapArt(BufferedImage image, ServerLevel level, MapGenerationUtils.DitherType ditherType, int width, int height) {
        int oldMapScanIndex;
        byte[][] newColorMap;
        int heightDiff;
        ServerLevel serverLevel = level;
        Image rescaledImage = image.getScaledInstance(width, height, 8);
        image = new BufferedImage(width, height, image.getType());
        Graphics2D graphics = image.createGraphics();
        graphics.drawImage(rescaledImage, 0, 0, null);
        graphics.dispose();
        byte[][] colorMap = MapGenerationUtils.imageToMinecraftMapColors(image, ditherType);
        int colorMapHeight = colorMap.length;
        int colorMapWidth = colorMap[0].length;
        if (colorMapHeight % 128 != 0) {
            heightDiff = 128 - colorMapHeight % 128;
            newColorMap = new byte[colorMapHeight + heightDiff][colorMapWidth];
            byte[] newRow = new byte[colorMapWidth];
            for (int i = 0; i < newRow.length; ++i) {
                newRow[i] = 0;
            }
            oldMapScanIndex = 0;
            for (int y = 0; y < newColorMap.length; ++y) {
                if (y < heightDiff / 2 || y > heightDiff / 2 - 1 + colorMapHeight) {
                    newColorMap[y] = newRow;
                    continue;
                }
                newColorMap[y] = colorMap[oldMapScanIndex];
                ++oldMapScanIndex;
            }
            colorMap = newColorMap;
            colorMapHeight = colorMap.length;
        }
        if (colorMapWidth % 128 != 0) {
            heightDiff = 128 - colorMapWidth % 128;
            newColorMap = new byte[colorMapHeight][colorMapWidth + heightDiff];
            for (int y = 0; y < colorMapHeight; ++y) {
                oldMapScanIndex = 0;
                for (int x = 0; x < newColorMap[0].length; ++x) {
                    if (x < heightDiff / 2 || x > heightDiff / 2 - 1 + colorMapWidth) {
                        newColorMap[y][x] = 0;
                        continue;
                    }
                    newColorMap[y][x] = colorMap[y][oldMapScanIndex];
                    ++oldMapScanIndex;
                }
            }
            colorMap = newColorMap;
            colorMapWidth = colorMap[0].length;
        }
        int[][] maps = new int[colorMapHeight / 128][colorMapWidth / 128];
        for (int y = 0; y < colorMapHeight; y += 128) {
            for (int x = 0; x < colorMapWidth; x += 128) {
                byte[][] subColorMap = GenerateMapArt.copySubrange(colorMap, x, y, 128, 128);
                MapItemSavedData mapData = MapItemSavedData.createFresh((double)0.0, (double)0.0, (byte)1, (boolean)false, (boolean)false, (ResourceKey)serverLevel.dimension());
                for (int j = 0; j < 128; ++j) {
                    for (int i = 0; i < 128; ++i) {
                        mapData.setColor(i, j, subColorMap[j][i]);
                    }
                }
                mapData = mapData.locked();
                MapId newMapID = level.getFreeMapId();
                level.getLevel().setMapData(newMapID, mapData);
                maps[y / 128][x / 128] = newMapID.id();
            }
        }
        return maps;
    }

    public static ItemStack createPreviewMap(int previewMapID, int width, int height) {
        ItemStack previewMapItem = new ItemStack((ItemLike)Items.FILLED_MAP);
        previewMapItem.set(DataComponents.MAP_ID, (Object)new MapId(previewMapID));
        CompoundTag customDataTag = new CompoundTag();
        customDataTag.putInt("width", width);
        customDataTag.putInt("height", height);
        previewMapItem.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)customDataTag));
        previewMapItem.set(DataComponents.ITEM_NAME, (Object)Component.literal((String)"Map Art"));
        ArrayList<MutableComponent> lore = new ArrayList<MutableComponent>();
        lore.add(Component.literal((String)("Place map at top left of item frame grid of width " + width + " and height " + height)));
        previewMapItem.set(DataComponents.LORE, (Object)new ItemLore(lore));
        previewMapItem.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
        return previewMapItem;
    }

    private static byte[][] copySubrange(byte[][] source, int x, int y, int width, int height) {
        byte[][] dest = new byte[height][width];
        for (int destY = 0; destY < height; ++destY) {
            byte[] srcRow = source[y + destY];
            System.arraycopy(srcRow, x, dest[destY], 0, width);
        }
        return dest;
    }

    public static BufferedImage getBufferedImageFromLink(String link) {
        try {
            return ImageIO.read(new URL(link).openStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

