/*
 * Decompiled with CFR 0.152.
 */
package com.flopingbird.map4image.commands;

import com.flopingbird.map4image.Config;
import com.flopingbird.map4image.commands.CreateCommandThread;
import com.flopingbird.map4image.utils.MapGenerationUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class CreateCommand {
    public static final int MAX_WIDTH = 128 * Config.maxWidth;
    public static final int MAX_HEIGHT = 128 * Config.maxHeight;

    public CreateCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"map4image").then(Commands.literal((String)"create").then(Commands.argument((String)"link", (ArgumentType)StringArgumentType.string()).then(Commands.literal((String)"floydsteinberg").then(Commands.argument((String)"width", (ArgumentType)IntegerArgumentType.integer((int)1, (int)MAX_WIDTH)).then(Commands.argument((String)"height", (ArgumentType)IntegerArgumentType.integer((int)1, (int)MAX_HEIGHT)).executes(command -> this.create((CommandContext<CommandSourceStack>)command, MapGenerationUtils.DitherType.FLOYDSTEINBERG))))))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"map4image").then(Commands.literal((String)"create").then(Commands.argument((String)"link", (ArgumentType)StringArgumentType.string()).then(Commands.literal((String)"none").then(Commands.argument((String)"width", (ArgumentType)IntegerArgumentType.integer((int)1, (int)MAX_WIDTH)).then(Commands.argument((String)"height", (ArgumentType)IntegerArgumentType.integer((int)1, (int)MAX_HEIGHT)).executes(command -> this.create((CommandContext<CommandSourceStack>)command, MapGenerationUtils.DitherType.NONE))))))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"map4image").then(Commands.literal((String)"create").then(Commands.argument((String)"link", (ArgumentType)StringArgumentType.string()).then(Commands.literal((String)"minimizedAverageError").then(Commands.argument((String)"width", (ArgumentType)IntegerArgumentType.integer((int)1, (int)MAX_WIDTH)).then(Commands.argument((String)"height", (ArgumentType)IntegerArgumentType.integer((int)1, (int)MAX_HEIGHT)).executes(command -> this.create((CommandContext<CommandSourceStack>)command, MapGenerationUtils.DitherType.MINIMIZED_AVERAGE_ERROR))))))));
    }

    private int create(CommandContext<CommandSourceStack> command, MapGenerationUtils.DitherType dither) throws CommandSyntaxException {
        if (((CommandSourceStack)command.getSource()).getPlayer() == null) {
            return 0;
        }
        try {
            CreateCommandThread createCommandThread = new CreateCommandThread(command, dither);
            createCommandThread.start();
            ((CommandSourceStack)command.getSource()).sendSystemMessage((Component)Component.literal((String)"Generating map art..."));
        }
        catch (Exception e) {
            System.out.println("Map4Image ran into error when creating map: " + String.valueOf(e));
        }
        return 1;
    }
}

