/*
 * Decompiled with CFR 0.152.
 */
package com.flopingbird.map4image.commands;

import com.flopingbird.map4image.GenerateMapArt;
import com.flopingbird.map4image.utils.MapGenerationUtils;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import java.awt.image.BufferedImage;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.saveddata.maps.MapId;

public class CreateCommandThread
extends Thread {
    CommandContext<CommandSourceStack> command = null;
    MapGenerationUtils.DitherType dither = null;

    CreateCommandThread(CommandContext<CommandSourceStack> command, MapGenerationUtils.DitherType dither) {
        this.command = command;
        this.dither = dither;
    }

    @Override
    public void run() {
        CommandSourceStack source = (CommandSourceStack)this.command.getSource();
        ServerPlayer player = source.getPlayer();
        BufferedImage image = GenerateMapArt.getBufferedImageFromLink(StringArgumentType.getString(this.command, (String)"link"));
        int[][] maps = GenerateMapArt.generateMapArt(image, player.serverLevel(), this.dither, IntegerArgumentType.getInteger(this.command, (String)"width"), IntegerArgumentType.getInteger(this.command, (String)"height"));
        if (maps.length == 1 && maps[0].length == 1) {
            ItemStack mapItem = new ItemStack((ItemLike)Items.FILLED_MAP);
            mapItem.set(DataComponents.MAP_ID, (Object)new MapId(maps[0][0]));
            player.addItem(mapItem);
        } else {
            int previewMap = GenerateMapArt.generateMapArt(image, player.serverLevel(), this.dither, 128, 128)[0][0];
            ItemStack finalMapItem = GenerateMapArt.createPreviewMap(previewMap, maps[0].length, maps.length);
            player.addItem(finalMapItem);
            ((CommandSourceStack)this.command.getSource()).sendSystemMessage((Component)Component.literal((String)"Map art generated!"));
        }
    }
}

