/*
 * Decompiled with CFR 0.152.
 */
package com.flopingbird.map4image.mixin;

import com.flopingbird.map4image.GenerateMapArt;
import com.flopingbird.map4image.utils.TagUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemFrame.class})
public abstract class ItemFrameMixin {
    @Inject(method={"interact"}, at={@At(value="HEAD")}, cancellable=true)
    private void itemFrameFiller(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        int x;
        int y;
        Vec3i widthDirection;
        Vec3i heightDirection;
        ItemStack item = player.getItemInHand(hand);
        if (item.getItem() != Items.FILLED_MAP || item.get(DataComponents.CUSTOM_DATA) == null || !((CustomData)item.get(DataComponents.CUSTOM_DATA)).contains("height")) {
            return;
        }
        int width = (Integer)((CustomData)item.get(DataComponents.CUSTOM_DATA)).copyTag().getInt("width").get();
        int height = (Integer)((CustomData)item.get(DataComponents.CUSTOM_DATA)).copyTag().getInt("height").get();
        int[][] mapIds = new int[height][width];
        int currentMapID = ((MapId)item.get(DataComponents.MAP_ID)).id() - height * width;
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                mapIds[y2][x2] = currentMapID++;
            }
        }
        ItemFrame interactedItemFrame = (ItemFrame)this;
        BlockPos topLeftItemFramePosition = interactedItemFrame.getPos();
        Vec3i direction = interactedItemFrame.getDirection().getUnitVec3i();
        int yDirec = direction.getY();
        if (yDirec != 0) {
            Vec3 playerPos = player.position();
            Vec3 itemFrameToPlayerXZPlane = new Vec3(playerPos.x - (double)topLeftItemFramePosition.getX(), 0.0, playerPos.z - (double)topLeftItemFramePosition.getZ());
            heightDirection = Math.abs(itemFrameToPlayerXZPlane.x) > Math.abs(itemFrameToPlayerXZPlane.z) ? new Vec3i((int)(itemFrameToPlayerXZPlane.x / Math.abs(itemFrameToPlayerXZPlane.x)), 0, 0) : new Vec3i(0, 0, (int)(itemFrameToPlayerXZPlane.z / Math.abs(itemFrameToPlayerXZPlane.z)));
            heightDirection = heightDirection.multiply(yDirec);
            widthDirection = new Vec3i(heightDirection.getZ(), 0, -heightDirection.getX()).multiply(yDirec);
        } else {
            widthDirection = new Vec3i(direction.getZ(), 0, -direction.getX());
            heightDirection = new Vec3i(0, -1, 0);
        }
        ItemFrame[][] itemFrames = new ItemFrame[height][width];
        boolean failed = false;
        block2: for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                BlockPos currentItemFrameBlockPos = topLeftItemFramePosition.offset(widthDirection.multiply(x).offset(heightDirection.multiply(y)));
                List itemFramesAtBlock = interactedItemFrame.level().getEntitiesOfClass(ItemFrame.class, new AABB(currentItemFrameBlockPos));
                if (itemFramesAtBlock.isEmpty()) {
                    failed = true;
                    break block2;
                }
                for (ItemFrame itemFrame : itemFramesAtBlock) {
                    if (!itemFrame.getDirection().getUnitVec3i().equals((Object)direction) || !itemFrame.getItem().is(Items.AIR)) continue;
                    itemFrames[y][x] = itemFrame;
                    break;
                }
                if (itemFrames[y][x] != null) continue;
                failed = true;
                break block2;
            }
        }
        if (failed) {
            player.displayClientMessage((Component)Component.literal((String)("The map you are currently trying to place does not have valid placement. (" + width + "x" + height + ")")), true);
            cir.setReturnValue((Object)InteractionResult.FAIL);
            return;
        }
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                ItemStack mapItem = new ItemStack((ItemLike)Items.FILLED_MAP);
                mapItem.set(DataComponents.MAP_ID, (Object)new MapId(mapIds[y][x]));
                CompoundTag tagPos = new CompoundTag();
                tagPos.put("parentMapPos", (Tag)TagUtils.blockPosToTag(topLeftItemFramePosition));
                mapItem.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tagPos));
                if (x == 0 && y == 0) {
                    CompoundTag sizeTag = ((CustomData)mapItem.get(DataComponents.CUSTOM_DATA)).copyTag();
                    sizeTag.putInt("width", width);
                    sizeTag.putInt("height", height);
                    if (yDirec != 0) {
                        sizeTag.put("heightDirection", (Tag)TagUtils.directionToTag(heightDirection));
                        sizeTag.put("widthDirection", (Tag)TagUtils.directionToTag(widthDirection));
                    }
                    mapItem.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)sizeTag));
                }
                itemFrames[y][x].setItem(mapItem, false);
                int additionalRotation = 0;
                if (yDirec == -1 && widthDirection.getZ() == 0) {
                    additionalRotation = 2;
                }
                if (heightDirection.getY() == -1 || heightDirection.getZ() == 1) {
                    itemFrames[y][x].setRotation(0 + additionalRotation);
                    continue;
                }
                if (heightDirection.getZ() == 0) {
                    if (heightDirection.getX() == 1) {
                        itemFrames[y][x].setRotation(3 + additionalRotation);
                        continue;
                    }
                    itemFrames[y][x].setRotation(1 + additionalRotation);
                    continue;
                }
                itemFrames[x][y].setRotation(2 + additionalRotation);
            }
        }
        cir.setReturnValue((Object)InteractionResult.SUCCESS);
        item.consume(1, (LivingEntity)player);
    }

    @Inject(method={"dropItem(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/Entity;Z)V"}, at={@At(value="HEAD")})
    private void itemFrameFilledRemover(ServerLevel level, Entity entity, boolean dropItem, CallbackInfo ci) {
        Vec3i heightDirection;
        Vec3i widthDirection;
        ItemFrame interactedItemFrame = (ItemFrame)this;
        if (interactedItemFrame.getItem().get(DataComponents.CUSTOM_DATA) == null || !((CustomData)interactedItemFrame.getItem().get(DataComponents.CUSTOM_DATA)).contains("parentMapPos")) {
            return;
        }
        BlockPos blockPosOfParent = TagUtils.tagToBlockPos((CompoundTag)((CustomData)interactedItemFrame.getItem().get(DataComponents.CUSTOM_DATA)).copyTag().getCompound("parentMapPos").get());
        Vec3i direction = interactedItemFrame.getDirection().getUnitVec3i();
        List itemFramesAtParentBlocks = interactedItemFrame.level().getEntitiesOfClass(ItemFrame.class, new AABB(blockPosOfParent));
        if (itemFramesAtParentBlocks.isEmpty()) {
            return;
        }
        ItemFrame parentItemFrame = null;
        for (ItemFrame itemFrame : itemFramesAtParentBlocks) {
            if (!itemFrame.getDirection().getUnitVec3i().equals((Object)direction)) continue;
            parentItemFrame = itemFrame;
            break;
        }
        if (parentItemFrame == null || parentItemFrame.getItem().get(DataComponents.CUSTOM_DATA) == null || !((CustomData)parentItemFrame.getItem().get(DataComponents.CUSTOM_DATA)).copyTag().contains("width")) {
            return;
        }
        int width = (Integer)((CustomData)parentItemFrame.getItem().get(DataComponents.CUSTOM_DATA)).copyTag().getInt("width").get();
        int height = (Integer)((CustomData)parentItemFrame.getItem().get(DataComponents.CUSTOM_DATA)).copyTag().getInt("height").get();
        ItemFrame[][] itemFrames = new ItemFrame[height][width];
        if (direction.getY() == 0) {
            widthDirection = new Vec3i(direction.getZ(), 0, -direction.getX());
            heightDirection = new Vec3i(0, -1, 0);
        } else {
            widthDirection = TagUtils.tagToDirection((CompoundTag)((CustomData)parentItemFrame.getItem().get(DataComponents.CUSTOM_DATA)).copyTag().getCompound("widthDirection").get());
            heightDirection = TagUtils.tagToDirection((CompoundTag)((CustomData)parentItemFrame.getItem().get(DataComponents.CUSTOM_DATA)).copyTag().getCompound("heightDirection").get());
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                BlockPos currentItemFrameBlockPos = blockPosOfParent.offset(widthDirection.multiply(x).offset(heightDirection.multiply(y)));
                List itemFramesAtBlock = interactedItemFrame.level().getEntitiesOfClass(ItemFrame.class, new AABB(currentItemFrameBlockPos));
                if (itemFramesAtBlock.isEmpty()) {
                    return;
                }
                for (ItemFrame itemFrame : itemFramesAtBlock) {
                    if (!itemFrame.getDirection().getUnitVec3i().equals((Object)direction) || itemFrame.getItem().get(DataComponents.CUSTOM_DATA) == null || !((CustomData)itemFrame.getItem().get(DataComponents.CUSTOM_DATA)).contains("parentMapPos")) continue;
                    itemFrames[y][x] = itemFrame;
                    break;
                }
                if (itemFrames[y][x] != null) continue;
                return;
            }
        }
        ItemStack itemDropped = GenerateMapArt.createPreviewMap(width * height + ((MapId)parentItemFrame.getItem().get(DataComponents.MAP_ID)).id(), width, height);
        ItemFrame[][] itemFrameArray = itemFrames;
        int n = itemFrameArray.length;
        for (int i = 0; i < n; ++i) {
            ItemFrame[] itemFrameRow;
            for (ItemFrame itemFrame : itemFrameRow = itemFrameArray[i]) {
                itemFrame.setItem(ItemStack.EMPTY);
            }
        }
        interactedItemFrame.spawnAtLocation(level, itemDropped);
    }
}

