/*
 * Decompiled with CFR 0.152.
 */
package net.anvian.record_days_survived;

import com.mojang.brigadier.CommandDispatcher;
import net.anvian.anvianslib.util.LibUtil;
import net.anvian.record_days_survived.command.RecordCommand;
import net.anvian.record_days_survived.components.DayComponent;
import net.anvian.record_days_survived.components.ModComponents;
import net.anvian.record_days_survived.components.RecordDayComponent;
import net.anvian.record_days_survived.components.TicksPassedComponent;
import net.anvian.record_days_survived.util.DaysUtil;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordDaysSurvivedMod
implements ModInitializer {
    public static final String MOD_ID = "record_days_survived";
    public static final String MOD_VERSION = "2.3";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"record_days_survived");
    private static long ticksPassed = 1200L;

    public void onInitialize() {
        LOGGER.info("Record Days Survived mod initialized!");
        LibUtil.setupTelemetry((String)MOD_ID, (String)MOD_VERSION);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> RecordCommand.register((CommandDispatcher<class_2168>)dispatcher));
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            int recordDay = ((RecordDayComponent)newPlayer.getComponent(ModComponents.RECORD_DAY)).getRecordDay();
            int daysSurvived = ((DayComponent)newPlayer.getComponent(ModComponents.DAY)).getDays();
            newPlayer.method_64398((class_2561)class_2561.method_43471((String)"reset").method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true))));
            newPlayer.method_64398((class_2561)class_2561.method_43471((String)"report_record_day").method_27693(": " + recordDay));
            newPlayer.method_64398((class_2561)class_2561.method_43471((String)"days_survived").method_27693(": " + daysSurvived));
        });
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            long worldTime = server.method_30002().method_8510();
            for (class_1657 player : server.method_3760().method_14571()) {
                if (worldTime % 1200L == 0L) {
                    ((TicksPassedComponent)player.getComponent(ModComponents.TICKS_PASSED)).addTickPassed(worldTime);
                    ticksPassed = ((TicksPassedComponent)player.getComponent(ModComponents.TICKS_PASSED)).getTicksPassed();
                }
                if (ticksPassed % 24000L != 0L) continue;
                DaysUtil.dayPassed((class_1309)player);
                ticksPassed = 1200L;
            }
        });
        EntitySleepEvents.STOP_SLEEPING.register((entity, sleepingPos) -> {
            if (entity instanceof class_1657) {
                DaysUtil.dayPassed(entity);
            }
        });
    }
}

