/*
 * Decompiled with CFR 0.152.
 */
package liedge.bannercapes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import liedge.bannercapes.CapeSmithingRecipe;
import liedge.bannercapes.registry.BannerCapesItems;
import liedge.bannercapes.registry.BannerCapesRecipeSerializers;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public record BannerToCapeRecipe(Ingredient template, Ingredient base) implements CapeSmithingRecipe
{
    private static final MapCodec<BannerToCapeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("template").forGetter(CapeSmithingRecipe::template), (App)Ingredient.CODEC.fieldOf("base").forGetter(CapeSmithingRecipe::base)).apply((Applicative)instance, BannerToCapeRecipe::new));
    private static final StreamCodec<RegistryFriendlyByteBuf, BannerToCapeRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, BannerToCapeRecipe::template, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, BannerToCapeRecipe::base, BannerToCapeRecipe::new);
    public static final RecipeSerializer<BannerToCapeRecipe> SERIALIZER = new RecipeSerializer<BannerToCapeRecipe>(){

        public MapCodec<BannerToCapeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BannerToCapeRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    };

    @Override
    public Ingredient additional() {
        return Ingredient.EMPTY;
    }

    public ItemStack assemble(SmithingRecipeInput input, HolderLookup.Provider registries) {
        ItemStack bannerStack = input.template();
        Item item = bannerStack.getItem();
        if (!(item instanceof BannerItem)) {
            return ItemStack.EMPTY;
        }
        BannerItem bannerItem = (BannerItem)item;
        ItemStack result = BannerCapesItems.BANNER_CAPES.get(bannerItem.getColor()).toStack();
        result.set(DataComponents.BANNER_PATTERNS, (Object)((BannerPatternLayers)bannerStack.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY)));
        return result;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return BannerCapesItems.BANNER_CAPES.get(DyeColor.WHITE).toStack();
    }

    public boolean isIncomplete() {
        return this.template.isEmpty() || this.base.isEmpty();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)BannerCapesRecipeSerializers.BANNER_TO_CAPE_SMITHING.get();
    }
}

