/*
 * Decompiled with CFR 0.152.
 */
package liedge.bannercapes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import liedge.bannercapes.BannerCapeItem;
import liedge.bannercapes.CapeSmithingRecipe;
import liedge.bannercapes.registry.BannerCapesItems;
import liedge.bannercapes.registry.BannerCapesRecipeSerializers;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public record CapeToElytraCapeRecipe(Ingredient base, Ingredient additional) implements CapeSmithingRecipe
{
    private static final MapCodec<CapeToElytraCapeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("base").forGetter(CapeSmithingRecipe::base), (App)Ingredient.CODEC.fieldOf("additional").forGetter(CapeSmithingRecipe::additional)).apply((Applicative)instance, CapeToElytraCapeRecipe::new));
    private static final StreamCodec<RegistryFriendlyByteBuf, CapeToElytraCapeRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, CapeToElytraCapeRecipe::base, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, CapeToElytraCapeRecipe::additional, CapeToElytraCapeRecipe::new);
    public static final RecipeSerializer<CapeToElytraCapeRecipe> SERIALIZER = new RecipeSerializer<CapeToElytraCapeRecipe>(){

        public MapCodec<CapeToElytraCapeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CapeToElytraCapeRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    };

    @Override
    public Ingredient template() {
        return Ingredient.EMPTY;
    }

    public ItemStack assemble(SmithingRecipeInput input, HolderLookup.Provider registries) {
        ItemStack capeStack = input.base();
        ItemStack elytraStack = input.addition();
        Item item = capeStack.getItem();
        if (!(item instanceof BannerCapeItem)) {
            return ItemStack.EMPTY;
        }
        BannerCapeItem capeItem = (BannerCapeItem)item;
        BannerPatternLayers patternsToCopy = (BannerPatternLayers)capeStack.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY);
        ItemEnchantments enchantmentsToCopy = elytraStack.getTagEnchantments();
        ItemStack result = BannerCapesItems.BANNER_ELYTRA_CAPES.get(capeItem.getBaseColor()).toStack();
        result.set(DataComponents.BANNER_PATTERNS, (Object)patternsToCopy);
        result.set(DataComponents.ENCHANTMENTS, (Object)enchantmentsToCopy);
        return result;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return BannerCapesItems.BANNER_ELYTRA_CAPES.get(DyeColor.WHITE).toStack();
    }

    public boolean isIncomplete() {
        return this.base.isEmpty() || this.additional.isEmpty();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)BannerCapesRecipeSerializers.CAPE_TO_ELYTRA_CAPE_SMITHING.get();
    }
}

