/*
 * Decompiled with CFR 0.152.
 */
package liedge.bannercapes.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import liedge.bannercapes.BannerCapeItem;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public final class BannerCapeModel {
    private final ModelPart cape;

    public BannerCapeModel() {
        ModelPart.Cube capeCube = new ModelPart.Cube(0, 0, -10.0f, 0.0f, -1.0f, 20.0f, 40.0f, 1.0f, 0.0f, 0.0f, 0.0f, false, 64.0f, 64.0f, EnumSet.allOf(Direction.class));
        this.cape = new ModelPart(List.of(capeCube), Map.of());
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, AbstractClientPlayer player, ItemStack capeStack, ItemStack chestItem, BannerCapeItem capeItem, float partialTick) {
        if (!player.isInvisible()) {
            this.setupCapeAnimation(player, chestItem);
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 0.125f);
            this.rotateCape(poseStack, player, partialTick);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            BannerRenderer.renderPatterns((PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, (int)OverlayTexture.NO_OVERLAY, (ModelPart)this.cape, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)capeItem.getBaseColor(), (BannerPatternLayers)capeItem.getPatternLayers(capeStack));
            poseStack.popPose();
        }
    }

    private void setupCapeAnimation(AbstractClientPlayer player, ItemStack chestItem) {
        if (chestItem.isEmpty() || chestItem.getItem() instanceof BannerCapeItem) {
            if (player.isCrouching()) {
                this.cape.z = 3.0f;
                this.cape.y = 3.75f;
            } else {
                this.cape.z = 0.0f;
                this.cape.y = 0.0f;
            }
        } else if (player.isCrouching()) {
            this.cape.z = 1.0f;
            this.cape.y = 2.0f;
        } else {
            this.cape.z = -2.0f;
            this.cape.y = 0.0f;
        }
    }

    private void rotateCape(PoseStack poseStack, AbstractClientPlayer player, float partialTick) {
        float speedPitchMax;
        float speedPitchMin;
        double desiredX = Mth.lerp((double)partialTick, (double)player.xCloakO, (double)player.xCloak) - Mth.lerp((double)partialTick, (double)player.xo, (double)player.getX());
        double desiredY = Mth.lerp((double)partialTick, (double)player.yCloakO, (double)player.yCloak) - Mth.lerp((double)partialTick, (double)player.yo, (double)player.getY());
        double desiredZ = Mth.lerp((double)partialTick, (double)player.zCloakO, (double)player.zCloak) - Mth.lerp((double)partialTick, (double)player.zo, (double)player.getZ());
        float bodyYaw = Mth.rotLerp((float)partialTick, (float)player.yBodyRotO, (float)player.yBodyRot);
        double backDirX = Mth.sin((float)(bodyYaw * ((float)Math.PI / 180)));
        double backDirZ = -Mth.cos((float)(bodyYaw * ((float)Math.PI / 180)));
        float pitchMax = player.isFallFlying() ? 16.0f : 32.0f;
        float pitch = Mth.clamp((float)((float)desiredY * 10.0f), (float)-6.0f, (float)pitchMax);
        float speedPitch = (float)(desiredX * backDirX + desiredZ * backDirZ) * 100.0f;
        if (player.isFallFlying()) {
            speedPitchMin = 5.0f;
            speedPitchMax = 10.0f;
        } else {
            speedPitchMin = 0.0f;
            speedPitchMax = 150.0f;
        }
        speedPitch = Mth.clamp((float)speedPitch, (float)speedPitchMin, (float)speedPitchMax);
        float speed = Mth.lerp((float)partialTick, (float)player.oBob, (float)player.bob);
        pitch += Mth.sin((float)(Mth.lerp((float)partialTick, (float)player.walkDistO, (float)player.walkDist) * 6.0f)) * 32.0f * speed;
        if (player.isCrouching()) {
            pitch += 25.0f;
        }
        float yaw = (float)(desiredX * backDirZ - desiredZ * backDirX) * 100.0f;
        yaw = Mth.clamp((float)yaw, (float)-20.0f, (float)20.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(6.0f + speedPitch / 2.0f + pitch));
        poseStack.mulPose(Axis.ZP.rotationDegrees(yaw / 2.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - yaw / 2.0f));
    }
}

