/*
 * Decompiled with CFR 0.152.
 */
package ember.qualitycommands.util;

import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class Calculator {
    static ArrayList<String> UnaryFunctionNames = new ArrayList(0);
    static ArrayList<UnaryCalculatorFunction> UnaryFunctions = new ArrayList(0);
    static ArrayList<String> BinaryFunctionNames = new ArrayList(0);
    static ArrayList<BinaryCalculatorFunction> BinaryFunctions = new ArrayList(0);

    public static Float calculate(Object input) {
        if (input.getClass() == ArrayList.class) {
            ArrayList inputb = (ArrayList)input;
            int type = (Integer)inputb.get(0);
            if (type == 1) {
                float finalValue = 0.0f;
                int numDone = 0;
                for (int i = 0; i < inputb.size(); ++i) {
                    Object subvalue = inputb.get(i);
                    if (numDone != 0) {
                        finalValue += Calculator.calculate(subvalue).floatValue();
                    }
                    ++numDone;
                }
                return Float.valueOf(finalValue);
            }
            if (type == 2) {
                float finalValue = 0.0f;
                int numDone = 0;
                for (int i = 0; i < inputb.size(); ++i) {
                    Object subvalue = inputb.get(i);
                    if (numDone != 0) {
                        finalValue = numDone == 1 ? (finalValue += Calculator.calculate(subvalue).floatValue()) : (finalValue -= Calculator.calculate(subvalue).floatValue());
                    }
                    ++numDone;
                }
                return Float.valueOf(finalValue);
            }
            if (type == 3) {
                float finalValue = 0.0f;
                int numDone = 0;
                for (int i = 0; i < inputb.size(); ++i) {
                    Object subvalue = inputb.get(i);
                    if (numDone != 0) {
                        finalValue = numDone == 1 ? (finalValue += Calculator.calculate(subvalue).floatValue()) : (finalValue *= Calculator.calculate(subvalue).floatValue());
                    }
                    ++numDone;
                }
                return Float.valueOf(finalValue);
            }
            if (type == 4) {
                float finalValue = 0.0f;
                int numDone = 0;
                for (int i = 0; i < inputb.size(); ++i) {
                    Object subvalue = inputb.get(i);
                    if (numDone != 0) {
                        finalValue = numDone == 1 ? (finalValue += Calculator.calculate(subvalue).floatValue()) : (finalValue /= Calculator.calculate(subvalue).floatValue());
                    }
                    ++numDone;
                }
                return Float.valueOf(finalValue);
            }
            if (type == 5) {
                float finalValue = 0.0f;
                int numDone = 0;
                for (int i = 0; i < inputb.size(); ++i) {
                    Object subvalue = inputb.get(i);
                    if (numDone != 0) {
                        finalValue = numDone == 1 ? (finalValue += Calculator.calculate(subvalue).floatValue()) : (float)Math.pow(finalValue, Calculator.calculate(subvalue).floatValue());
                    }
                    ++numDone;
                }
                return Float.valueOf(finalValue);
            }
            if (type == 6) {
                if (inputb.size() == 3) {
                    return UnaryFunctions.get(UnaryFunctionNames.indexOf((String)inputb.get(1))).getValue(Calculator.calculate(inputb.get(2)));
                }
                if (inputb.size() == 4) {
                    return BinaryFunctions.get(BinaryFunctionNames.indexOf((String)inputb.get(1))).getValue(Calculator.calculate(inputb.get(2)), Calculator.calculate(inputb.get(3)));
                }
                return Float.valueOf(0.0f);
            }
            return Float.valueOf(0.0f);
        }
        if (input.getClass() == String.class) {
            return Calculator.calculate(Calculator.parseString((String)input));
        }
        return (Float)input;
    }

    public static Object parseString(String input) {
        if (input.length() == 0) {
            return 0;
        }
        if (Calculator.countChars(input, '(') != Calculator.countChars(input, ')')) {
            return 0;
        }
        String inputwbc = Calculator.removeWithinBrackets(input, "(", ")");
        ArrayList<Object> retval = new ArrayList<Object>(1);
        if (inputwbc.length() == 0) {
            return Calculator.parseString(input.substring(1, input.length() - 1));
        }
        if (Calculator.countChars(inputwbc, '+', 1) + Calculator.countChars(inputwbc, '-', 1) + Calculator.countChars(inputwbc, '*', 1) + Calculator.countChars(inputwbc, '/', 1) != 0) {
            if (Calculator.countChars(inputwbc, '+', 1) + Calculator.countChars(inputwbc, '-', 1) == 0) {
                if (Calculator.countChars(inputwbc, '*', 1) != 0) {
                    retval.add(3);
                    Calculator.splitWhileRespectingBrackets(input, '*', "(", ")").forEach(splitAroundTimes -> {
                        retval.ensureCapacity(retval.size() + 1);
                        retval.add(Calculator.parseString(splitAroundTimes));
                    });
                    return retval;
                }
                if (Calculator.countChars(inputwbc, '/', 1) != 0) {
                    retval.add(4);
                    Calculator.splitWhileRespectingBrackets(input, '/', "(", ")").forEach(splitAroundDivides -> {
                        retval.ensureCapacity(retval.size() + 1);
                        retval.add(Calculator.parseString(splitAroundDivides));
                    });
                    return retval;
                }
                return 0;
            }
            if (Calculator.countChars(inputwbc, '+', 1) != 0) {
                retval.add(1);
                Calculator.splitWhileRespectingBrackets(input, '+', "(", ")").forEach(splitAroundPlus -> {
                    retval.ensureCapacity(retval.size() + 1);
                    retval.add(Calculator.parseString(splitAroundPlus));
                });
                return retval;
            }
            if (Calculator.countChars(inputwbc, '-', 1) != 0) {
                retval.add(2);
                Calculator.splitWhileRespectingBrackets(input, '-', "(", ")").forEach(splitAroundMinus -> {
                    retval.ensureCapacity(retval.size() + 1);
                    retval.add(Calculator.parseString(splitAroundMinus));
                });
                return retval;
            }
            return 0;
        }
        if (Calculator.countChars(inputwbc, '^', 1) != 0) {
            retval.add(5);
            Calculator.splitWhileRespectingBrackets(input, '^', "(", ")").forEach(splitAroundTimes -> {
                retval.ensureCapacity(retval.size() + 1);
                retval.add(Calculator.parseString(splitAroundTimes));
            });
            return retval;
        }
        if (UnaryFunctionNames.contains(inputwbc) || BinaryFunctionNames.contains(inputwbc)) {
            int functionLen = inputwbc.length();
            retval.add(6);
            retval.ensureCapacity(2);
            retval.add(inputwbc);
            Calculator.splitWhileRespectingBrackets(input.substring(1 + functionLen, input.length() - 1), ',', "(", ")").forEach(splitAroundComma -> {
                retval.ensureCapacity(retval.size() + 1);
                retval.add(Calculator.parseString(splitAroundComma));
            });
            return retval;
        }
        return Float.valueOf(Float.parseFloat(input));
    }

    public static int countChars(String input, char find, int max) {
        int totalCount = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) != find || ++totalCount != max) continue;
            return totalCount;
        }
        return totalCount;
    }

    public static int countChars(String input, char find) {
        int totalCount = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) != find) continue;
            ++totalCount;
        }
        return totalCount;
    }

    public static ArrayList<String> splitWhileRespectingBrackets(String input, char splitAround, String leftBrackets, String rightBrackets) {
        ArrayList<String> output = new ArrayList<String>(1);
        output.add("");
        int depth = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (Calculator.countChars(leftBrackets, input.charAt(i), 1) != 0) {
                ++depth;
            } else if (Calculator.countChars(rightBrackets, input.charAt(i), 1) != 0) {
                --depth;
            }
            if (depth == 0) {
                if (input.charAt(i) == splitAround) {
                    output.ensureCapacity(output.size() + 1);
                    output.add("");
                    continue;
                }
                output.set(output.size() - 1, output.get(output.size() - 1) + input.charAt(i));
                continue;
            }
            output.set(output.size() - 1, output.get(output.size() - 1) + input.charAt(i));
        }
        return output;
    }

    public static ArrayList<String> splitWhileRespectingBrackets(String input, String splitAroundEntries, String leftBrackets, String rightBrackets) {
        ArrayList<String> output = new ArrayList<String>(1);
        output.add("");
        int depth = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (Calculator.countChars(leftBrackets, input.charAt(i), 1) != 0) {
                ++depth;
            } else if (Calculator.countChars(rightBrackets, input.charAt(i), 1) != 0) {
                --depth;
            }
            if (depth == 0) {
                if (Calculator.countChars(splitAroundEntries, input.charAt(i), 1) != 0) {
                    output.ensureCapacity(output.size() + 1);
                    output.add("");
                    continue;
                }
                output.set(output.size() - 1, output.get(output.size() - 1) + input.charAt(i));
                continue;
            }
            output.set(output.size() - 1, output.get(output.size() - 1) + input.charAt(i));
        }
        return output;
    }

    public static String removeWithinBrackets(String input, String leftBrackets, String rightBrackets) {
        Object output = "";
        int depth = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (Calculator.countChars(leftBrackets, input.charAt(i), 1) != 0) {
                ++depth;
            }
            if (depth == 0) {
                output = (String)output + input.charAt(i);
            }
            if (Calculator.countChars(rightBrackets, input.charAt(i), 1) == 0) continue;
            --depth;
        }
        return output;
    }

    public static void addUnaryFunction(String name, UnaryCalculatorFunction function) {
        if (!UnaryFunctionNames.contains(name)) {
            UnaryFunctionNames.ensureCapacity(UnaryFunctionNames.size() + 1);
            UnaryFunctionNames.add(name);
            UnaryFunctions.ensureCapacity(UnaryFunctions.size() + 1);
            UnaryFunctions.add(function);
        }
    }

    public static void addBinaryFunction(String name, BinaryCalculatorFunction function) {
        if (!BinaryFunctionNames.contains(name)) {
            BinaryFunctionNames.ensureCapacity(BinaryFunctionNames.size() + 1);
            BinaryFunctionNames.add(name);
            BinaryFunctions.ensureCapacity(BinaryFunctions.size() + 1);
            BinaryFunctions.add(function);
        }
    }

    static {
        Calculator.addUnaryFunction("floor", new UnaryCalculatorFunction(){

            @Override
            public Float getValue(Float arg) {
                return Float.valueOf((float)Math.floor(arg.floatValue()));
            }
        });
        Calculator.addBinaryFunction("min", new BinaryCalculatorFunction(){

            @Override
            public Float getValue(Float arga, Float argb) {
                return Float.valueOf(Math.min(arga.floatValue(), argb.floatValue()));
            }
        });
        Calculator.addBinaryFunction("max", new BinaryCalculatorFunction(){

            @Override
            public Float getValue(Float arga, Float argb) {
                return Float.valueOf(Math.max(arga.floatValue(), argb.floatValue()));
            }
        });
    }

    static abstract class UnaryCalculatorFunction {
        UnaryCalculatorFunction() {
        }

        @Nullable
        public abstract Float getValue(Float var1);
    }

    static abstract class BinaryCalculatorFunction {
        BinaryCalculatorFunction() {
        }

        @Nullable
        public abstract Float getValue(Float var1, Float var2);
    }
}

