/*
 * Decompiled with CFR 0.152.
 */
package ember.qualitycommands.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import ember.qualitycommands.util.Calculator;
import java.text.DecimalFormat;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2203;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2991;
import net.minecraft.class_3162;
import net.minecraft.class_3164;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7924;
import net.minecraft.class_8848;
import net.minecraft.class_8855;
import net.minecraft.class_8936;
import org.jetbrains.annotations.Nullable;

public class WithCommand {
    private static final Dynamic2CommandExceptionType NO_ATTRIBUTE_EXCEPTION = new Dynamic2CommandExceptionType((entityName, attributeName) -> class_2561.method_54159((String)"commands.attribute.failed.no_attribute", (Object[])new Object[]{entityName, attributeName}));
    private static final DynamicCommandExceptionType ARGUMENT_NOT_COMPOUND_EXCEPTION = new DynamicCommandExceptionType(argument -> class_2561.method_54159((String)"commands.function.error.argument_not_compound", (Object[])new Object[]{argument}));
    public static final SuggestionProvider<class_2168> SUGGESTION_PROVIDER = (context, builder) -> {
        class_2991 commandFunctionManager = ((class_2168)context.getSource()).method_9211().method_3740();
        class_2172.method_9258((Iterable)commandFunctionManager.method_29464(), (SuggestionsBuilder)builder, (String)"#");
        return class_2172.method_9270((Iterable)commandFunctionManager.method_29463(), (SuggestionsBuilder)builder);
    };
    private static final DynamicCommandExceptionType ENTITY_FAILED_EXCEPTION = new DynamicCommandExceptionType(name -> class_2561.method_54159((String)"commands.attribute.failed.entity", (Object[])new Object[]{name}));
    private static final class_5819 RANDOM = class_5819.method_43047();
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#");

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        LiteralArgumentBuilder dataSubcommand = class_2170.method_9247((String)"data");
        for (final class_3164.class_3167 objectType : class_3164.field_13792) {
            objectType.method_13925((ArgumentBuilder)dataSubcommand, builder -> builder.then(class_2170.method_9244((String)"path", (ArgumentType)class_2203.method_9360()).then(class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes((com.mojang.brigadier.Command)new Command(){

                @Override
                protected String getArguments(CommandContext<class_2168> context) throws CommandSyntaxException {
                    return WithCommand.toString(class_3164.method_13921((class_2203.class_2209)class_2203.method_9358(context, (String)"path"), (class_3162)objectType.method_13924(context)));
                }
            }))));
        }
        LiteralArgumentBuilder valueSubcommand = class_2170.method_9247((String)"value");
        valueSubcommand.then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes((com.mojang.brigadier.Command)new Command(){

            @Override
            protected String getArguments(CommandContext<class_2168> context) throws CommandSyntaxException {
                return StringArgumentType.getString(context, (String)"value");
            }
        })));
        LiteralArgumentBuilder calculateSubcommand = class_2170.method_9247((String)"calculate");
        calculateSubcommand.then(class_2170.method_9244((String)"math", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes((com.mojang.brigadier.Command)new Command(){

            @Override
            protected String getArguments(CommandContext<class_2168> context) throws CommandSyntaxException {
                return Calculator.calculate(StringArgumentType.getString(context, (String)"math")).toString();
            }
        })));
        LiteralArgumentBuilder calculateIntSubcommand = class_2170.method_9247((String)"calculateint");
        calculateIntSubcommand.then(class_2170.method_9244((String)"math", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes((com.mojang.brigadier.Command)new Command(){

            @Override
            protected String getArguments(CommandContext<class_2168> context) throws CommandSyntaxException {
                return String.valueOf((int)Calculator.calculate(StringArgumentType.getString(context, (String)"math")).floatValue());
            }
        })));
        LiteralArgumentBuilder uuidSubcommand = class_2170.method_9247((String)"uuid");
        uuidSubcommand.then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes((com.mojang.brigadier.Command)new Command(){

            @Override
            protected String getArguments(CommandContext<class_2168> context) throws CommandSyntaxException {
                return class_2186.method_9313(context, (String)"target").method_5845();
            }
        })));
        LiteralArgumentBuilder randomSubcommand = class_2170.method_9247((String)"random");
        LiteralArgumentBuilder randomIntSubcommand = class_2170.method_9247((String)"int");
        LiteralArgumentBuilder randomFloatSubcommand = class_2170.method_9247((String)"float");
        randomIntSubcommand.then(class_2170.method_9244((String)"min", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"max", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes((com.mojang.brigadier.Command)new Command(){

            @Override
            protected String getArguments(CommandContext<class_2168> context) throws CommandSyntaxException {
                return String.valueOf(RANDOM.method_39332(IntegerArgumentType.getInteger(context, (String)"min"), IntegerArgumentType.getInteger(context, (String)"max")));
            }
        }))));
        randomFloatSubcommand.then(class_2170.method_9244((String)"min", (ArgumentType)FloatArgumentType.floatArg()).then(class_2170.method_9244((String)"max", (ArgumentType)FloatArgumentType.floatArg()).then(class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes((com.mojang.brigadier.Command)new Command(){

            @Override
            protected String getArguments(CommandContext<class_2168> context) throws CommandSyntaxException {
                float min = FloatArgumentType.getFloat(context, (String)"min");
                float max = FloatArgumentType.getFloat(context, (String)"max");
                return String.valueOf(RANDOM.method_43057() * (max - min) + min);
            }
        }))));
        ((LiteralArgumentBuilder)randomSubcommand.then((ArgumentBuilder)randomIntSubcommand)).then((ArgumentBuilder)randomFloatSubcommand);
        LiteralArgumentBuilder attributeSubCommand = class_2170.method_9247((String)"attribute");
        attributeSubCommand.then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"attribute", (ArgumentType)class_7733.method_45603((class_7157)registryAccess, (class_5321)class_7924.field_41251)).then(class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes((com.mojang.brigadier.Command)new Command(){

            @Override
            protected String getArguments(CommandContext<class_2168> context) throws CommandSyntaxException {
                return String.valueOf(WithCommand.executeValueGet((class_2168)context.getSource(), class_2186.method_9313(context, (String)"target"), (class_6880<class_1320>)class_7733.method_45601(context, (String)"attribute"), 1.0));
            }
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"with").requires((Predicate)class_2170.method_71774((int)2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).then((ArgumentBuilder)valueSubcommand)).then((ArgumentBuilder)uuidSubcommand)).then((ArgumentBuilder)randomSubcommand)).then((ArgumentBuilder)calculateSubcommand)).then((ArgumentBuilder)calculateIntSubcommand)).then((ArgumentBuilder)attributeSubCommand)).then((ArgumentBuilder)dataSubcommand)));
    }

    private static String toString(class_2520 nbt) {
        if (nbt.method_10711() == 1) {
            return String.valueOf(nbt.method_68600().get());
        }
        if (nbt.method_10711() == 2) {
            return String.valueOf(nbt.method_68601().get());
        }
        if (nbt.method_10711() == 3) {
            return String.valueOf(nbt.method_68602().get());
        }
        if (nbt.method_10711() == 4) {
            return String.valueOf(nbt.method_68603().get());
        }
        if (nbt.method_10711() == 6) {
            return String.valueOf(nbt.method_68605().get());
        }
        if (nbt.method_10711() == 8) {
            return (String)nbt.method_68658().get();
        }
        return nbt.toString();
    }

    static class_2487 getArgument(class_2203.class_2209 path, class_3162 object) throws CommandSyntaxException {
        class_2520 nbtElement = class_3164.method_13921((class_2203.class_2209)path, (class_3162)object);
        if (nbtElement instanceof class_2487) {
            class_2487 nbtCompound = (class_2487)nbtElement;
            return nbtCompound;
        }
        throw ARGUMENT_NOT_COMPOUND_EXCEPTION.create((Object)nbtElement.method_23258().method_23259());
    }

    public static String replaceAllInString(String base, String from, String replace) {
        for (int j = 0; j < 4; ++j) {
            base = base.replace(from, replace);
        }
        return base;
    }

    public static String[] splitString(String base, String splitable) {
        String[] returnval = base.split(splitable, 1000);
        return returnval;
    }

    private static double executeValueGet(class_2168 source, class_1297 target, class_6880<class_1320> attribute, double multiplier) throws CommandSyntaxException {
        class_1309 livingEntity = WithCommand.getLivingEntityWithAttribute(target, attribute);
        double d = livingEntity.method_45325(attribute);
        return d;
    }

    private static class_1309 getLivingEntityWithAttribute(class_1297 entity, class_6880<class_1320> attribute) throws CommandSyntaxException {
        class_1309 livingEntity = WithCommand.getLivingEntity(entity);
        if (!livingEntity.method_6127().method_45331(attribute)) {
            throw NO_ATTRIBUTE_EXCEPTION.create((Object)entity.method_5477(), (Object)WithCommand.getName(attribute));
        }
        return livingEntity;
    }

    private static class_1309 getLivingEntity(class_1297 entity) throws CommandSyntaxException {
        if (!(entity instanceof class_1309)) {
            throw ENTITY_FAILED_EXCEPTION.create((Object)entity.method_5477());
        }
        return (class_1309)entity;
    }

    private static class_2561 getName(class_6880<class_1320> attribute) {
        return class_2561.method_43471((String)((class_1320)attribute.comp_349()).method_26830());
    }

    static abstract class Command
    extends class_8848.class_8850<class_2168>
    implements class_8848.class_8849<class_2168> {
        Command() {
        }

        @Nullable
        protected abstract String getArguments(CommandContext<class_2168> var1) throws CommandSyntaxException;

        public void executeInner(class_2168 serverCommandSource, ContextChain<class_2168> contextChain, class_8936 executionFlags, class_8855<class_2168> executionControl) throws CommandSyntaxException {
            CommandContext commandContext = contextChain.getTopContext().copyFor((Object)serverCommandSource);
            String arg = this.getArguments((CommandContext<class_2168>)commandContext);
            String varname = StringArgumentType.getString((CommandContext)commandContext, (String)"name");
            String commandToRun = StringArgumentType.getString((CommandContext)commandContext, (String)"command");
            serverCommandSource.method_9211().method_3734().method_44252(serverCommandSource, WithCommand.replaceAllInString(commandToRun, "@(" + varname + ")", arg));
        }
    }
}

