/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech;

import com.dairymoose.xenotech.XenoTechUtils;
import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.entity.RenderableBlock;
import com.dairymoose.xenotech.world.level.block.entity.IntegratedGunBlockEntity;
import com.dairymoose.xenotech.world.level.block.entity.ManipulatorBlockEntity;
import com.dairymoose.xenotech.world.level.block.entity.MountedGunBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockEntityUtils {
    public static final Logger LOGGER = LogManager.getLogger();

    static boolean stillValidBlockEntity(BlockEntity p_272877_, Player p_272670_, int p_273411_) {
        Level level = p_272877_.m_58904_();
        BlockPos blockpos = p_272877_.m_58899_();
        if (level == null) {
            LOGGER.debug("failed due to level check");
            return false;
        }
        if (level.m_7702_(blockpos) != p_272877_) {
            LOGGER.debug("failed due to BE check");
            return false;
        }
        LOGGER.debug("failed due to distance check");
        return p_272670_.m_20275_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5) <= (double)(p_273411_ * p_273411_);
    }

    private static void relocateBlockEntity(RenderableBlock renderable, Level level, BlockPos blockRotPos) {
        renderable.tempBlockEntity.m_142339_(level);
        if (!renderable.tempBlockEntity.f_58858_.equals((Object)blockRotPos)) {
            LevelChunk oldChunk;
            LOGGER.trace("update tempBlockEntity to new position: " + blockRotPos + " for entity=" + renderable.tempBlockEntity.getClass().getSimpleName() + " from old position: " + renderable.tempBlockEntity.f_58858_);
            boolean updateChunkData = false;
            if (updateChunkData && (oldChunk = level.m_46745_(renderable.tempBlockEntity.f_58858_)).m_62954_().get(renderable.tempBlockEntity.f_58858_) == renderable.tempBlockEntity) {
                oldChunk.m_62954_().remove(renderable.tempBlockEntity.f_58858_);
            }
            BlockPos oldPos = renderable.tempBlockEntity.f_58858_;
            renderable.tempBlockEntity.f_58858_ = blockRotPos;
            BlockEntity blockEntity = renderable.tempBlockEntity;
            if (blockEntity instanceof ManipulatorBlockEntity) {
                ManipulatorBlockEntity manip = (ManipulatorBlockEntity)blockEntity;
                manip.updateEndpoints(oldPos, blockRotPos);
            }
            if (updateChunkData) {
                LevelChunk newChunk = level.m_46745_(blockRotPos);
                newChunk.m_62954_().put(blockRotPos, renderable.tempBlockEntity);
            }
        }
        BlockState rotated = XenoTechUtils.getRotatedBlockState((DummyEntity)renderable.parent, renderable);
        BlockEntity blockEntity = renderable.tempBlockEntity;
        if (blockEntity instanceof HopperBlockEntity) {
            HopperBlockEntity hopperBlockEntity = (HopperBlockEntity)blockEntity;
        }
        renderable.tempBlockEntity.m_155250_(rotated);
    }

    public static void populateBlockEntity(RenderableBlock renderable, Level level, BlockPos blockRotPos) {
        Block block = renderable.state.m_60734_();
        if (block instanceof EntityBlock) {
            EntityBlock entityBlock = (EntityBlock)block;
            LevelChunk chunk = level.m_46745_(blockRotPos);
            if (chunk != null) {
                if (renderable.tempBlockEntity != null) {
                    BlockEntityUtils.relocateBlockEntity(renderable, level, blockRotPos);
                    if (renderable.tempBlockEntity.m_58901_()) {
                        LOGGER.debug("tempBlockEntity state was set to Removed! " + renderable.tempBlockEntity);
                    }
                    renderable.tempBlockEntity.m_6339_();
                } else {
                    BlockEntity tempEntity = null;
                    BlockEntity existingBlockEntity = chunk.m_5685_(blockRotPos, LevelChunk.EntityCreationType.CHECK);
                    if (existingBlockEntity == null) {
                        LOGGER.trace("existingBlockEntity is null");
                        BlockState rotated = XenoTechUtils.getRotatedBlockState((DummyEntity)renderable.parent, renderable);
                        tempEntity = entityBlock.m_142194_(blockRotPos, rotated);
                        if (tempEntity != null) {
                            LOGGER.debug("made new BE at " + blockRotPos + " of class=" + tempEntity.getClass().getSimpleName() + " for dummy=" + renderable.parent);
                            tempEntity.m_142339_(level);
                            try {
                                tempEntity.m_142466_(renderable.tag);
                            }
                            catch (Exception ex) {
                                LOGGER.error("Error while loading block entity=" + tempEntity, (Throwable)ex);
                            }
                            BlockEntityUtils.enrichMountedGunEntities(tempEntity, renderable);
                            tempEntity.m_6339_();
                            LOGGER.debug("newlyAdded BE=" + tempEntity + " from tag=" + renderable.tag);
                            renderable.tempBlockEntity = tempEntity;
                        }
                    } else {
                        existingBlockEntity.m_6339_();
                        BlockEntityUtils.enrichMountedGunEntities(existingBlockEntity, renderable);
                        renderable.tempBlockEntity = existingBlockEntity;
                    }
                }
            }
        }
    }

    private static void enrichMountedGunEntities(BlockEntity blockEntity, RenderableBlock renderable) {
        if (blockEntity instanceof MountedGunBlockEntity) {
            MountedGunBlockEntity mgb = (MountedGunBlockEntity)blockEntity;
            mgb.renderable = renderable;
        }
        if (blockEntity instanceof IntegratedGunBlockEntity) {
            IntegratedGunBlockEntity igb = (IntegratedGunBlockEntity)blockEntity;
            Entity entity = renderable.parent;
            if (entity instanceof DummyEntity) {
                DummyEntity d = (DummyEntity)entity;
                DummyEntity.IntegratedWeaponInfo iwi = new DummyEntity.IntegratedWeaponInfo();
                iwi.blockEntity = igb;
                iwi.renderablePos = renderable.pos;
                iwi.renderable = renderable;
                iwi.blockEntity.mountedTo = d;
                iwi.blockEntity.carrier = d;
                iwi.blockEntity.barrelRotation = 0.0f;
                iwi.blockEntity.barrelRotationSpeed = 0.0f;
                if (d.integratedWeapons.add(iwi)) {
                    LOGGER.debug("Add new integrated weapon: " + iwi);
                    if (d.weaponAssignments.size() == 0) {
                        d.weaponAssignments.add(iwi);
                        LOGGER.debug("Assigned weapon 1: " + iwi);
                    } else if (d.weaponAssignments.size() == 1) {
                        d.weaponAssignments.add(iwi);
                        LOGGER.debug("Assigned weapon 2: " + iwi);
                    }
                }
            }
        }
    }
}

