/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech;

import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CollisionUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static Vec3 pointRotate(double angle, Vec3 toRotate, Vec3 vec3) {
        double radians = Math.toRadians(-angle);
        double sin = Math.sin(radians);
        double cos = Math.cos(radians);
        double xRot = cos * (toRotate.f_82479_ - vec3.f_82479_) - sin * (toRotate.f_82481_ - vec3.f_82481_) + vec3.f_82479_;
        double zRot = sin * (toRotate.f_82479_ - vec3.f_82479_) + cos * (toRotate.f_82481_ - vec3.f_82481_) + vec3.f_82481_;
        return new Vec3(xRot, toRotate.f_82480_, zRot);
    }

    public static double slope2d(Vec3 p, Vec3 p2) {
        double xDiff = p2.f_82479_ - p.f_82479_;
        double zDiff = p2.f_82481_ - p.f_82481_;
        if (xDiff == 0.0) {
            return 0.0;
        }
        return zDiff / xDiff;
    }

    public static boolean pointIsInsideAABB(Vec3 pt, AABB aabb) {
        return pt.f_82479_ >= aabb.f_82288_ && pt.f_82480_ >= aabb.f_82289_ && pt.f_82481_ >= aabb.f_82290_ && pt.f_82479_ <= aabb.f_82291_ && pt.f_82480_ <= aabb.f_82292_ && pt.f_82481_ <= aabb.f_82293_;
    }

    public static boolean pointIsInsideRotatedBox(Vec3 pt, LineSegment[] segments, double minY, double maxY) {
        if (segments == null || segments.length != 4) {
            return false;
        }
        Double minZ = null;
        Double maxZ = null;
        for (LineSegment segment : segments) {
            if (segment.isValidX(pt.f_82479_)) {
                double z = segment.stdY(pt.f_82479_);
                if (minZ == null) {
                    minZ = z;
                }
                if (maxZ == null) {
                    maxZ = z;
                }
                if (z < minZ) {
                    minZ = z;
                    continue;
                }
                if (!(z > maxZ)) continue;
                maxZ = z;
                continue;
            }
            LOGGER.trace("invalid x: " + pt.f_82479_ + " vs " + segment.start.x + " and " + segment.end.x);
        }
        if (minZ != null && maxZ != null) {
            boolean zMatch = pt.f_82481_ >= minZ && pt.f_82481_ <= maxZ;
            boolean yMatch = pt.f_82480_ >= minY && pt.f_82480_ <= maxY;
            LOGGER.trace("check for zMatch: " + pt.f_82481_ + " vs min=" + minZ + " and max=" + maxZ);
            LOGGER.trace("check for yMatch: " + pt.f_82480_ + " vs min=" + minY + " and max=" + maxY);
            if (zMatch && yMatch) {
                return true;
            }
        }
        return false;
    }

    public static boolean pointIsInsideRotatedAABB(Vec3 pt, AABB toRotate, Vec3 rotX, Vec3 rotY, Vec3 rotZ) {
        Vec3 cubeCenter = toRotate.m_82399_();
        Vec3 vecToPoint = pt.m_82546_(cubeCenter);
        Vec3 halfSize = new Vec3(toRotate.m_82362_() / 2.0, toRotate.m_82376_() / 2.0, toRotate.m_82385_() / 2.0);
        boolean inside = Math.abs(vecToPoint.m_82526_(rotX)) <= halfSize.f_82479_ && Math.abs(vecToPoint.m_82526_(rotY)) <= halfSize.f_82480_ && Math.abs(vecToPoint.m_82526_(rotZ)) <= halfSize.f_82481_;
        return inside;
    }

    public static boolean aabbsIntersectVertically(AABB first, AABB second) {
        if (first.f_82292_ >= second.f_82289_ && first.f_82292_ <= second.f_82292_) {
            return true;
        }
        return second.f_82292_ >= first.f_82289_ && second.f_82292_ <= first.f_82292_;
    }

    public static boolean rotatedIntersects(double angle, AABB toRotate, AABB arrowBb, Vec3 rotCenter) {
        Vec3 rotZ;
        Vec3 rotY;
        LOGGER.trace("check for intersection for angle=" + angle + " and toRotate=" + toRotate + " vs projectile=" + arrowBb + " with toRotate-center=" + toRotate.m_82399_());
        LOGGER.trace("normal intersects? " + toRotate.m_82381_(arrowBb));
        if (angle % 90.0 == 0.0) {
            return toRotate.m_82381_(arrowBb);
        }
        double cubeMidY = (arrowBb.f_82289_ + arrowBb.f_82292_) / 2.0;
        Vec3 center_cubeBottomLeft = new Vec3(arrowBb.f_82288_, cubeMidY, arrowBb.f_82290_);
        Vec3 center_cubeTopLeft = new Vec3(arrowBb.f_82288_, cubeMidY, arrowBb.f_82293_);
        Vec3 center_cubeTopRight = new Vec3(arrowBb.f_82291_, cubeMidY, arrowBb.f_82293_);
        Vec3 center_cubeBottomRight = new Vec3(arrowBb.f_82291_, cubeMidY, arrowBb.f_82290_);
        double toRotateMidY = (toRotate.f_82289_ + toRotate.f_82292_) / 2.0;
        Vec3 bottomLeft = new Vec3(toRotate.f_82288_, toRotateMidY, toRotate.f_82290_);
        Vec3 topLeft = new Vec3(toRotate.f_82288_, toRotateMidY, toRotate.f_82293_);
        Vec3 topRight = new Vec3(toRotate.f_82291_, toRotateMidY, toRotate.f_82293_);
        Vec3 bottomRight = new Vec3(toRotate.f_82291_, toRotateMidY, toRotate.f_82290_);
        Vec3 center_rotBottomLeft = CollisionUtils.pointRotate(angle, bottomLeft, rotCenter);
        Vec3 center_rotTopLeft = CollisionUtils.pointRotate(angle, topLeft, rotCenter);
        Vec3 center_rotTopRight = CollisionUtils.pointRotate(angle, topRight, rotCenter);
        Vec3 center_rotBottomRight = CollisionUtils.pointRotate(angle, bottomRight, rotCenter);
        Vec3 rotX = center_rotBottomRight.m_82546_(center_rotBottomLeft).m_82541_();
        if (CollisionUtils.pointIsInsideRotatedAABB(center_cubeBottomLeft, toRotate, rotX, rotY = new Vec3(0.0, 1.0, 0.0), rotZ = center_rotBottomRight.m_82546_(center_rotTopRight).m_82541_())) {
            LOGGER.trace("pointIsInsideRotatedAABB match");
            return true;
        }
        if (CollisionUtils.pointIsInsideRotatedAABB(center_cubeTopLeft, toRotate, rotX, rotY, rotZ)) {
            LOGGER.trace("pointIsInsideRotatedAABB match");
            return true;
        }
        if (CollisionUtils.pointIsInsideRotatedAABB(center_cubeTopRight, toRotate, rotX, rotY, rotZ)) {
            LOGGER.trace("pointIsInsideRotatedAABB match");
            return true;
        }
        if (CollisionUtils.pointIsInsideRotatedAABB(center_cubeBottomRight, toRotate, rotX, rotY, rotZ)) {
            LOGGER.trace("pointIsInsideRotatedAABB match");
            return true;
        }
        LOGGER.trace("make cubeLeftLine");
        LineSegment cubeLeftLine = new LineSegment(center_cubeBottomLeft, center_cubeTopLeft);
        LineSegment rotLeftLine = new LineSegment(center_rotBottomLeft, center_rotTopLeft);
        LOGGER.trace("make cubeTopLine");
        LineSegment cubeTopLine = new LineSegment(center_cubeTopLeft, center_cubeTopRight);
        LineSegment rotTopLine = new LineSegment(center_rotTopLeft, center_rotTopRight);
        LOGGER.trace("make cubeRightLine");
        LineSegment cubeRightLine = new LineSegment(center_cubeBottomRight, center_cubeTopRight);
        LineSegment rotRightLine = new LineSegment(center_rotBottomRight, center_rotTopRight);
        LOGGER.trace("make cubeBottomLine");
        LineSegment cubeBottomLine = new LineSegment(center_cubeBottomLeft, center_cubeBottomRight);
        LineSegment rotBottomLine = new LineSegment(center_rotBottomLeft, center_rotBottomRight);
        if (CollisionUtils.pointIsInsideAABB(center_rotBottomLeft, arrowBb)) {
            LOGGER.trace("rotBottomLeft match");
            return true;
        }
        if (CollisionUtils.pointIsInsideAABB(center_rotTopLeft, arrowBb)) {
            LOGGER.trace("rotTopLeft match");
            return true;
        }
        if (CollisionUtils.pointIsInsideAABB(center_rotTopRight, arrowBb)) {
            LOGGER.trace("rotTopRight match: " + center_rotTopRight + " was contained within: " + arrowBb);
            return true;
        }
        if (CollisionUtils.pointIsInsideAABB(center_rotBottomRight, arrowBb)) {
            LOGGER.trace("rotBottomRight match");
            return true;
        }
        LineSegment[] rotSegments = new LineSegment[]{rotLeftLine, rotTopLine, rotRightLine, rotBottomLine};
        if (CollisionUtils.aabbsIntersectVertically(toRotate, arrowBb)) {
            LOGGER.trace("check line intersections");
            Vec2 intersectLeft = rotLeftLine.intersectsAny(cubeLeftLine, cubeTopLine, cubeRightLine, cubeBottomLine);
            if (intersectLeft != null) {
                LOGGER.trace("left line intersects at " + intersectLeft);
                return true;
            }
            Vec2 intersectTop = rotTopLine.intersectsAny(cubeLeftLine, cubeTopLine, cubeRightLine, cubeBottomLine);
            if (intersectTop != null) {
                LOGGER.trace("top line intersects at " + intersectTop);
                return true;
            }
            Vec2 intersectRight = rotRightLine.intersectsAny(cubeLeftLine, cubeTopLine, cubeRightLine, cubeBottomLine);
            if (intersectRight != null) {
                LOGGER.trace("right line intersects at " + intersectRight);
                return true;
            }
            Vec2 intersectBottom = rotBottomLine.intersectsAny(cubeLeftLine, cubeTopLine, cubeRightLine, cubeBottomLine);
            if (intersectBottom != null) {
                LOGGER.trace("bottom line intersects at " + intersectBottom);
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        AABB cube = new AABB(-0.5, -0.5, -0.5, 0.5, 0.5, 0.5);
        AABB rotCube = new AABB(0.51, -0.5, -0.5, 1.01, 0.5, 0.5);
        LOGGER.trace("intersect? " + rotCube.m_82381_(cube));
        LOGGER.trace("20deg intersect? " + CollisionUtils.rotatedIntersects(45.0, rotCube, cube, rotCube.m_82399_()));
    }

    private static class LineSegment {
        double m;
        double b;
        Vec2 start;
        Vec2 end;
        Vec3 stdForm;

        public double y(double x) {
            return this.m * x + this.b;
        }

        public double stdY(double x) {
            return (-this.A() * x - this.C()) / this.B();
        }

        public boolean isValidX(double x) {
            return x >= this.start.x && x <= this.end.x;
        }

        public boolean isValidY(double y) {
            return y >= this.start.y && y <= this.end.y;
        }

        public LineSegment(Vec3 start, Vec3 end) {
            if (end.f_82479_ < start.f_82479_) {
                Vec3 temp = end;
                end = start;
                start = temp;
            }
            this.m = CollisionUtils.slope2d(start, end);
            this.b = start.f_82481_ - this.m * start.f_82479_;
            this.start = new Vec2(start.f_82479_, start.f_82481_);
            this.end = new Vec2(end.f_82479_, end.f_82481_);
            double rise = end.f_82481_ - start.f_82481_;
            double run = end.f_82479_ - start.f_82479_;
            LOGGER.trace("calc mx+b = " + this.m + "x+" + this.b + " and rise/run=" + rise + "/" + run + " for points: " + start + ", " + end);
            double C = -(rise * start.f_82479_) - -run * start.f_82481_;
            this.stdForm = new Vec3(rise, -run, C);
        }

        public double A() {
            return this.stdForm.f_82479_;
        }

        public double B() {
            return this.stdForm.f_82480_;
        }

        public double C() {
            return this.stdForm.f_82481_;
        }

        public Vec2 intersectionPoint(LineSegment other) {
            LOGGER.trace("A:" + this.A() + ",B:" + this.B() + ",C:" + this.C());
            LOGGER.trace("other.A:" + other.A() + ",other.B:" + other.B() + ",other.C:" + other.C());
            double div = this.A() * other.B() - other.A() * this.B();
            if (div == 0.0) {
                LOGGER.error("parallel: div=" + div);
                return null;
            }
            double x = (this.B() * other.C() - other.B() * this.C()) / div;
            double z = (this.C() * other.A() - other.C() * this.A()) / div;
            LOGGER.trace("intersection at x=" + x + ", z=" + z + " for span: " + this.start.x + "/" + this.end.x + ", " + this.start.y + "/" + this.end.y + "vs other span: " + other.start.x + "/" + other.end.x + ", " + other.start.y + "/" + other.end.y);
            if (this.isValidX(x) && other.isValidX(x) && this.isValidY(z) && other.isValidY(z)) {
                return new Vec2(x, z);
            }
            return null;
        }

        public Vec2 intersectsAny(LineSegment ... segments) {
            for (LineSegment segment : segments) {
                Vec2 pt = this.intersectionPoint(segment);
                if (pt == null) continue;
                return pt;
            }
            return null;
        }

        public String toString() {
            return "[(" + this.start + "), (" + this.end + "), slope=" + this.m + ", b=" + this.b + "]";
        }
    }

    private static class Vec2 {
        double x;
        double y;

        public Vec2(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "[" + this.x + ", " + this.y + "]";
        }
    }
}

