/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech;

import com.dairymoose.xenotech.XenoTechCommon;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.Language;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.IReverseTag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemStorage {
    private static final Logger LOGGER = LogManager.getLogger();
    private Map<ItemKey, List<ItemRecord>> itemMap = new ConcurrentHashMap<ItemKey, List<ItemRecord>>();
    private SortMethod lastUsedSortMethod = SortMethod.MostRecentTimestamp;
    private SortedMap<Long, List<ItemRecord>> mostRecentTimestampSortedMap = new TreeMap(new ReversibleComparator(true));
    private SortedMap<Long, List<ItemRecord>> oldestTimestampSortedMap = new TreeMap(new ReversibleComparator(false));
    private SortedMap<Integer, List<ItemRecord>> highestCountSortedMap = new TreeMap(new ReversibleComparator(true));
    private SortedMap<Integer, List<ItemRecord>> lowestCountSortedMap = new TreeMap(new ReversibleComparator(false));
    private SortedMap<String, List<ItemRecord>> alphabeticalSortedMap = new TreeMap(new ReversibleComparator(false));
    private SortedMap<String, List<ItemRecord>> reverseAlphabeticalSortedMap = new TreeMap(new ReversibleComparator(true));
    private Set<SavedFilterData> savedFilters = new HashSet<SavedFilterData>();
    private int totalNumberOfItemRecords = 0;
    private int slotsPerRow = 13;
    public int SAVE_FORMAT_VERSION = 1;
    private static List<TagKey<Item>> itemTags = null;
    private static Map<Character, List<TagKey<Item>>> tagsByLetter = new HashMap<Character, List<TagKey<Item>>>();

    public void sendFiltersToPlayer(ServerPlayer player) {
        ArrayList<String> searchTexts = new ArrayList<String>();
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (SavedFilterData sfd : this.savedFilters) {
            LOGGER.debug("send filter to player: " + sfd.searchText);
            searchTexts.add(sfd.searchText);
            itemStacks.add(new ItemStack((ItemLike)sfd.icon));
        }
    }

    public void addSavedFilter(String searchText, ItemStack itemStack) {
        SavedFilterData sfd = new SavedFilterData();
        sfd.searchText = searchText;
        sfd.icon = itemStack.m_41720_();
        this.savedFilters.remove(sfd);
        this.savedFilters.add(sfd);
    }

    public void deleteSavedFilter(String searchText) {
        SavedFilterData sfd = new SavedFilterData();
        sfd.searchText = searchText;
        this.savedFilters.remove(sfd);
    }

    public void setSlotsPerRow(int slotsPerRow) {
        this.slotsPerRow = slotsPerRow;
    }

    public int getTotalNumberOfRecords() {
        return this.totalNumberOfItemRecords;
    }

    public ItemKey itemKeyFromSerialized(byte[] data) {
        ItemKey key = new ItemKey();
        String result = new String(data);
        String[] results = result.split(":");
        if (results.length == 2) {
            String namespace = results[0];
            String path = results[1];
            ResourceLocation rsrc = new ResourceLocation(namespace, path);
            key.item = (Item)BuiltInRegistries.f_257033_.m_7745_(rsrc);
        }
        return key;
    }

    public ItemRecord itemRecordFromSerialized(byte[] data) {
        ItemRecord record = new ItemRecord();
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int nbtSize = buffer.getInt();
        byte[] nbtBytes = new byte[nbtSize];
        buffer.get(nbtBytes);
        int count = buffer.getInt();
        int keySize = buffer.getInt();
        byte[] keyBytes = new byte[keySize];
        buffer.get(keyBytes);
        long timestamp = buffer.getLong();
        CompoundTag tag = null;
        if (nbtSize > 0) {
            ByteArrayInputStream bais = new ByteArrayInputStream(nbtBytes);
            try {
                tag = NbtIo.m_128939_((InputStream)bais);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        record.nbt = tag;
        record.count = count;
        record.key = this.itemKeyFromSerialized(keyBytes);
        record.lastActivityTimestamp = timestamp;
        return record;
    }

    private List<ItemStack> generateStackListFromRecords(List<ItemRecord> itemRecords) {
        ArrayList<ItemStack> toReturn = new ArrayList<ItemStack>();
        if (itemRecords != null) {
            for (ItemRecord record : itemRecords) {
                toReturn.add(this.generateItemStackFromRecord(record));
            }
        }
        return toReturn;
    }

    public ItemStack generateItemStackFromRecord(ItemRecord record) {
        ItemStack toReturn = new ItemStack((ItemLike)record.key.item, record.count);
        toReturn.m_41751_(record.nbt);
        return toReturn;
    }

    private ItemStack takeItemStackFromRecord(ItemRecord record, boolean fullStack) {
        int maxStackSize = record.key.item.m_41459_();
        int itemsToTake = Math.min(record.count, maxStackSize);
        ItemStack toReturn = new ItemStack((ItemLike)record.key.item, itemsToTake);
        record.count -= itemsToTake;
        toReturn.m_41751_(record.nbt);
        return toReturn;
    }

    public ItemRecord getMatchingRecordFromItemStack(ItemStack toMatch) {
        Item item = toMatch.m_41720_();
        ItemKey key = new ItemKey(item);
        List<ItemRecord> records = this.itemMap.get(key);
        if (records == null) {
            return null;
        }
        LOGGER.debug("getMatchingRecordFromItemStack: found " + records.size() + " records for key=" + key);
        for (ItemRecord record : records) {
            LOGGER.debug("record: " + record);
            CompoundTag toMatchTag = toMatch.m_41783_();
            boolean bothTagsNull = record.nbt == null && toMatchTag == null;
            LOGGER.debug("nbt check 1: " + record.nbt);
            LOGGER.debug("nbt check 2 (toMatch itemStack): " + toMatchTag);
            if (!bothTagsNull && (record.nbt == null || !record.nbt.equals((Object)toMatchTag))) continue;
            return record;
        }
        return null;
    }

    private void addRecordToOneMap(Map map, Object key, ItemRecord toAdd) {
        ArrayList<ItemRecord> records = (ArrayList<ItemRecord>)map.get(key);
        if (records == null) {
            records = new ArrayList<ItemRecord>();
        }
        records.add(toAdd);
        map.put(key, records);
    }

    private void addRecordToAllMaps(ItemKey key, ItemRecord toAdd) {
        ++this.totalNumberOfItemRecords;
        LOGGER.debug("Add record to all maps for key=" + key + ", value=" + toAdd);
        if (key == null || toAdd == null || toAdd.count <= 0) {
            return;
        }
        this.addRecordToOneMap(this.itemMap, key, toAdd);
        Long timestampKey = toAdd.lastActivityTimestamp;
        this.addRecordToOneMap(this.mostRecentTimestampSortedMap, timestampKey, toAdd);
        this.addRecordToOneMap(this.oldestTimestampSortedMap, timestampKey, toAdd);
        Integer countKey = toAdd.count;
        this.addRecordToOneMap(this.highestCountSortedMap, countKey, toAdd);
        this.addRecordToOneMap(this.lowestCountSortedMap, countKey, toAdd);
        ItemStack tempItem = this.generateItemStackFromRecord(toAdd);
        String nameKey = toAdd.key.item.m_7626_(tempItem).getString();
        this.addRecordToOneMap(this.alphabeticalSortedMap, nameKey, toAdd);
        this.addRecordToOneMap(this.reverseAlphabeticalSortedMap, nameKey, toAdd);
    }

    private void removeRecordFromOneMap(Map<?, List<ItemRecord>> map, Object key, ItemRecord existing) {
        List<ItemRecord> timestampRecords = map.get(key);
        if (timestampRecords != null) {
            boolean didRemove = timestampRecords.remove(existing);
            if (!didRemove) {
                LOGGER.debug("Could not find existing record [" + existing + "] in recent timestamp map");
            } else if (timestampRecords.isEmpty()) {
                map.remove(key);
            }
        } else {
            LOGGER.debug("Got no records for timestamp [" + key + "] in recent timestamp map");
        }
    }

    private void removeRecordFromAllMaps(ItemRecord existing) {
        --this.totalNumberOfItemRecords;
        LOGGER.debug("Remove existing record from all maps");
        this.removeRecordFromOneMap(this.itemMap, existing.key, existing);
        Long timestampKey = existing.lastActivityTimestamp;
        this.removeRecordFromOneMap(this.mostRecentTimestampSortedMap, timestampKey, existing);
        this.removeRecordFromOneMap(this.oldestTimestampSortedMap, timestampKey, existing);
        Integer countKey = existing.count;
        this.removeRecordFromOneMap(this.highestCountSortedMap, countKey, existing);
        this.removeRecordFromOneMap(this.lowestCountSortedMap, countKey, existing);
        ItemStack tempItem = this.generateItemStackFromRecord(existing);
        String nameKey = existing.key.item.m_7626_(tempItem).getString();
        this.removeRecordFromOneMap(this.alphabeticalSortedMap, nameKey, existing);
        this.removeRecordFromOneMap(this.reverseAlphabeticalSortedMap, nameKey, existing);
    }

    private void addCountToExistingRecord(ItemRecord existing, int count) {
        if (existing == null) {
            return;
        }
        this.removeRecordFromAllMaps(existing);
        existing.count += count;
        existing.updateTimestamp();
        this.addRecordToAllMaps(existing.key, existing);
    }

    private int removeCountFromExistingRecord(ItemRecord existing, int requestedCount) {
        if (existing == null) {
            return 0;
        }
        int removeCount = Math.min(existing.count, requestedCount);
        this.removeRecordFromAllMaps(existing);
        existing.count -= removeCount;
        existing.updateTimestamp();
        this.addRecordToAllMaps(existing.key, existing);
        return removeCount;
    }

    private ItemRecord insertOrCreateRecordFromItemStack(ItemStack itemStack) {
        ItemRecord match = this.getMatchingRecordFromItemStack(itemStack);
        if (match != null) {
            this.addCountToExistingRecord(match, itemStack.m_41613_());
            return match;
        }
        Item item = itemStack.m_41720_();
        ItemKey key = new ItemKey(item);
        ItemRecord record = new ItemRecord(itemStack.m_41783_(), itemStack.m_41613_(), key);
        this.addRecordToAllMaps(key, record);
        LOGGER.debug("new record created, total count=" + this.totalNumberOfItemRecords);
        return record;
    }

    public boolean depositItemStack(ItemStack toDeposit) {
        LOGGER.debug("depositItemStack=" + toDeposit);
        if (toDeposit.m_41720_() != Items.f_41852_ && toDeposit != ItemStack.f_41583_) {
            this.insertOrCreateRecordFromItemStack(toDeposit);
        }
        return true;
    }

    public ItemStack withdrawItemStack(ItemStack toWithdraw, int requestedCount) {
        ItemRecord match;
        LOGGER.debug("withdrawItemStack=" + toWithdraw + " with count=" + requestedCount);
        if (requestedCount > toWithdraw.m_41741_()) {
            requestedCount = toWithdraw.m_41741_();
        }
        if ((match = this.getMatchingRecordFromItemStack(toWithdraw)) != null) {
            int removedCount = this.removeCountFromExistingRecord(match, requestedCount);
            ItemStack generated = this.generateItemStackFromRecord(match);
            generated.m_41764_(removedCount);
            return generated;
        }
        LOGGER.debug("Tried with withdraw but couldn't find the item! " + toWithdraw);
        return ItemStack.f_41583_;
    }

    public SortedMap<?, List<ItemRecord>> getMapForSortMethod(SortMethod method) {
        switch (method) {
            case MostRecentTimestamp: {
                return this.mostRecentTimestampSortedMap;
            }
            case HighestCount: {
                return this.highestCountSortedMap;
            }
            case OldestTimestamp: {
                return this.oldestTimestampSortedMap;
            }
            case LowestCount: {
                return this.lowestCountSortedMap;
            }
            case Alphabetical: {
                return this.alphabeticalSortedMap;
            }
            case ReverseAlphabetical: {
                return this.reverseAlphabeticalSortedMap;
            }
        }
        return null;
    }

    private void addRawRecordsToMaps(List<ItemRecord> records) {
        LOGGER.debug("addRawRecordsToMaps");
        for (ItemRecord record : records) {
            this.addRecordToAllMaps(record.key, record);
        }
    }

    public ItemStack getItemStackForSlot(int slot, SortMethod sortMethod) {
        TreeMap map = (TreeMap)this.getMapForSortMethod(sortMethod);
        Iterator it = map.navigableKeySet().iterator();
        int recordCount = 0;
        int currentHighestSlot = -1;
        while (it.hasNext()) {
            Object key = it.next();
            List records = (List)map.get(key);
            currentHighestSlot = (recordCount += records.size()) - 1;
            if (currentHighestSlot < slot) continue;
            int targetIndex = slot - (recordCount -= records.size());
            LOGGER.debug("requested slot=" + slot + ", recordCount=" + recordCount + ", targetIndex is " + targetIndex + " for records of size " + records.size());
            ItemRecord record = (ItemRecord)records.get(targetIndex);
            return this.generateItemStackFromRecord(record);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getItemStackForSlot(int slot) {
        return this.getItemStackForSlot(slot, this.lastUsedSortMethod);
    }

    public void readAllRecordsFromFile(long uniqueId) {
        String subFolder = XenoTechCommon.getSubFolderPrepend();
        LOGGER.debug("read all records with folder=" + subFolder);
        File chestData = new File(subFolder + "chest_data_" + uniqueId + ".bin");
        LOGGER.debug("Open file with id=" + uniqueId);
        ArrayList<ItemRecord> allRecords = new ArrayList<ItemRecord>();
        if (chestData.exists()) {
            try {
                byte[] data = Files.toByteArray((File)chestData);
                ByteBuffer dataBuf = ByteBuffer.wrap(data);
                int saveFormatVersion = dataBuf.getInt();
                int recordCount = dataBuf.getInt();
                LOGGER.debug("Got file with record count=" + recordCount);
                for (int i = 0; i < recordCount; ++i) {
                    int recordLength = dataBuf.getInt();
                    byte[] alloc = new byte[recordLength];
                    dataBuf.get(alloc);
                    ItemRecord record = this.itemRecordFromSerialized(alloc);
                    allRecords.add(record);
                }
            }
            catch (IOException | NumberFormatException e) {
                LOGGER.error("chest_data_" + uniqueId + ".bin not found", (Throwable)e);
            }
        }
        this.addRawRecordsToMaps(allRecords);
    }

    public void saveAllRecordsToFile(long uniqueId) {
        String subFolder = XenoTechCommon.getSubFolderPrepend();
        LOGGER.debug("save all records with folder=" + subFolder + " with uniqueId=" + uniqueId);
        File chestData = new File(subFolder + "chest_data_" + uniqueId + ".bin");
        try {
            Set<Map.Entry<ItemKey, List<ItemRecord>>> entries = this.itemMap.entrySet();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ArrayList<ItemRecord> allRecords = new ArrayList<ItemRecord>();
            for (Map.Entry<ItemKey, List<ItemRecord>> entry : entries) {
                List<ItemRecord> records = entry.getValue();
                allRecords.addAll(records);
            }
            ByteBuffer headerBuf = ByteBuffer.allocate(8);
            headerBuf.putInt(this.SAVE_FORMAT_VERSION);
            headerBuf.putInt(allRecords.size());
            baos.writeBytes(headerBuf.array());
            for (ItemRecord record : allRecords) {
                ByteBuffer recordHeaderBuf = ByteBuffer.allocate(4);
                byte[] recordData = record.serialize();
                recordHeaderBuf.putInt(recordData.length);
                baos.writeBytes(recordHeaderBuf.array());
                baos.writeBytes(recordData);
            }
            byte[] byArray = baos.toByteArray();
            LOGGER.debug("Saving " + allRecords.size() + " records with byte size=" + byArray.length);
            Files.write((byte[])byArray, (File)chestData);
        }
        catch (IOException e) {
            LOGGER.debug("Error writing to chest_data");
        }
    }

    public void readAllFiltersFromFile(long uniqueId) {
        String subFolder = XenoTechCommon.getSubFolderPrepend();
        LOGGER.debug("read all filters with folder=" + subFolder);
        File chestFilters = new File(subFolder + "chest_filters_" + uniqueId + ".txt");
        LOGGER.debug("Open file with id=" + uniqueId);
        if (chestFilters.exists()) {
            try {
                FileReader fr = new FileReader(chestFilters);
                BufferedReader br = new BufferedReader(fr);
                String line = "";
                while ((line = br.readLine()) != null) {
                    int lastSemi;
                    if (line.startsWith("//") || (lastSemi = line.lastIndexOf(59)) == -1 || line.length() <= lastSemi + 1) continue;
                    String searchText = line.substring(0, lastSemi);
                    String locText = line.substring(lastSemi + 1);
                    String[] locSplit = locText.split(":");
                    if (locSplit.length != 2) continue;
                    ResourceLocation loc = new ResourceLocation(locSplit[0], locSplit[1]);
                    this.addSavedFilter(searchText, new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(loc)));
                }
            }
            catch (IOException | NumberFormatException e) {
                LOGGER.error("chest_data.txt not found", (Throwable)e);
            }
        }
    }

    public void saveAllFiltersToFile(long uniqueId) {
        String subFolder = XenoTechCommon.getSubFolderPrepend();
        LOGGER.debug("save all filters with folder=" + subFolder + " with uniqueId=" + uniqueId);
        File chestFilters = new File(subFolder + "chest_filters_" + uniqueId + ".txt");
        try {
            FileWriter fw = new FileWriter(chestFilters);
            LOGGER.debug("Saving " + this.savedFilters.size() + " filters");
            fw.write("//Chest filters");
            fw.write("\n");
            LocalDateTime dateTime = LocalDateTime.now();
            fw.write("//" + dateTime.format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.MEDIUM)));
            fw.write("\n");
            for (SavedFilterData sfd : this.savedFilters) {
                fw.write(sfd.searchText);
                fw.write(";");
                ResourceLocation loc = BuiltInRegistries.f_257033_.m_7981_((Object)sfd.icon);
                fw.write(loc.m_135827_() + ":" + loc.m_135815_());
                fw.write("\n");
                LOGGER.debug("Save filter: " + sfd.searchText + ";" + loc.m_135827_() + ":" + loc.m_135815_());
            }
            fw.flush();
            fw.close();
            LOGGER.debug("Finished write");
        }
        catch (IOException e) {
            LOGGER.debug("Error writing to chest_data.txt");
        }
    }

    public static List<Expr> buildExpressionList(String searchText) {
        ArrayList<Expr> output = new ArrayList<Expr>();
        if (searchText == null || searchText.length() == 0) {
            return output;
        }
        Object text = "";
        for (int i = 0; i < searchText.length(); ++i) {
            char ch = searchText.charAt(i);
            if (ch == ',' || ch == '&' || ch == '(' || ch == ')') {
                if (((String)text).length() > 0) {
                    output.add(new StringExpr((String)text));
                    text = "";
                }
                output.add(new OpExpr(ch));
                continue;
            }
            text = (String)text + ch;
        }
        if (((String)text).length() > 0) {
            output.add(new StringExpr((String)text));
        }
        LOGGER.debug("BEL: " + output);
        return output;
    }

    public static List<Expr> generatePostfixExpression(List<Expr> expressions) {
        ArrayList<Expr> output = new ArrayList<Expr>();
        LOGGER.debug("start GPE");
        Stack<OpExpr> opStack = new Stack<OpExpr>();
        for (Expr expr : expressions) {
            if (expr instanceof StringExpr) {
                StringExpr stringExpr = (StringExpr)expr;
                output.add(stringExpr);
                continue;
            }
            if (!(expr instanceof OpExpr)) continue;
            OpExpr opExpr = (OpExpr)expr;
            if (opStack.isEmpty()) {
                opStack.push(opExpr);
                continue;
            }
            OpExpr topStackOp = (OpExpr)opStack.peek();
            if (opExpr.isParenthesisOp()) {
                LOGGER.debug("found paren: " + opExpr.toString());
                if (")".equals(opExpr.getRawString())) {
                    OpExpr innerParenItem;
                    LOGGER.debug("opStack before: " + opStack);
                    while (!opStack.isEmpty() && !"(".equals((innerParenItem = (OpExpr)opStack.pop()).getRawString())) {
                        output.add(innerParenItem);
                    }
                    LOGGER.debug("opStack after: " + opStack);
                    opExpr = null;
                }
                if (opExpr == null) continue;
                LOGGER.debug("found paren: push " + opExpr);
                opStack.push(opExpr);
                continue;
            }
            if (opExpr.getPrecedence() > topStackOp.getPrecedence()) {
                opStack.push(opExpr);
                continue;
            }
            while (topStackOp.getPrecedence() > opExpr.getPrecedence()) {
                OpExpr higherPrecedenceOp = (OpExpr)opStack.pop();
                output.add(higherPrecedenceOp);
                if (opStack.isEmpty()) break;
                topStackOp = (OpExpr)opStack.peek();
            }
            opStack.push(opExpr);
        }
        while (!opStack.isEmpty()) {
            output.add((Expr)opStack.pop());
        }
        LOGGER.debug("GPE: " + output);
        return output;
    }

    public static boolean evaluateFilterTextUsingPostfixExpression(ItemStack itemStack, String filterText) {
        return ItemStorage.evaluatePostfixExpression(itemStack, ItemStorage.generatePostfixExpression(ItemStorage.buildExpressionList(filterText)));
    }

    public static boolean evaluatePostfixExpression(ItemStack itemStack, List<Expr> postfix) {
        if (postfix == null || postfix.size() == 0) {
            return true;
        }
        Stack<NoArgExpression> exprStack = new Stack<NoArgExpression>();
        for (Expr expr : postfix) {
            if (expr instanceof StringExpr) {
                StringExpr stringExpr = (StringExpr)expr;
                exprStack.push(stringExpr);
                continue;
            }
            if (!(expr instanceof OpExpr)) continue;
            OpExpr opExpr = (OpExpr)expr;
            if (exprStack.size() >= 2) {
                NoArgExpression right = (NoArgExpression)exprStack.pop();
                NoArgExpression left = (NoArgExpression)exprStack.pop();
                boolean opResult = opExpr.evaluate(itemStack, left, right);
                exprStack.push(new BooleanExpr(opResult));
                continue;
            }
            return false;
        }
        LOGGER.debug("EPE for " + itemStack + ": " + exprStack);
        if (exprStack.size() == 1) {
            NoArgExpression expr = (NoArgExpression)exprStack.pop();
            LOGGER.debug("EPE result: " + expr.evaluate(itemStack));
            return expr.evaluate(itemStack);
        }
        return false;
    }

    public static boolean itemStackMatchesTextFilter(ItemStack itemStack, String searchText) {
        if (searchText == null || searchText.length() == 0) {
            return true;
        }
        if (itemStack == null) {
            return false;
        }
        if (searchText.startsWith("#")) {
            IReverseTag reverseTag;
            Stream tagStream;
            List matchList;
            String searchTag = searchText.substring(1);
            Optional optReverseTag = ForgeRegistries.ITEMS.tags().getReverseTag((Object)itemStack.m_41720_());
            if (optReverseTag.isPresent() && (matchList = (tagStream = (reverseTag = (IReverseTag)optReverseTag.get()).getTagKeys()).filter(x -> x.f_203868_().m_135815_().contains(searchTag)).collect(Collectors.toList())) != null && !matchList.isEmpty()) {
                return true;
            }
        } else if (searchText.startsWith("@")) {
            String searchNamespace = searchText.substring(1);
            ResourceLocation itemLocation = BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_());
            String itemNamespace = itemLocation.m_135827_();
            if (itemNamespace != null && itemNamespace.toLowerCase().contains(searchNamespace)) {
                return true;
            }
        } else {
            String itemNameText = itemStack.m_41720_().m_7626_(itemStack).getString();
            if (itemNameText != null && itemNameText.toLowerCase().contains(searchText.toLowerCase())) {
                return true;
            }
            List tooltipLines = null;
            try {
                tooltipLines = itemStack.m_41651_(null, (TooltipFlag)TooltipFlag.f_256730_);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (tooltipLines != null) {
                for (Component line : tooltipLines) {
                    ComponentContents contents;
                    if (line == null || (contents = line.m_214077_()) == null) continue;
                    if (contents instanceof LiteralContents) {
                        LiteralContents literal = (LiteralContents)contents;
                        String textContents = literal.f_237368_();
                        if (textContents == null || textContents.startsWith("minecraft:") || !textContents.toLowerCase().contains(searchText)) continue;
                        LOGGER.debug("matched literal line " + textContents + " for " + itemStack);
                        return true;
                    }
                    if (!(contents instanceof TranslatableContents)) continue;
                    TranslatableContents translatable = (TranslatableContents)contents;
                    String translated = Language.m_128107_().m_6834_(translatable.m_237508_());
                    if (!translated.toLowerCase().contains(searchText)) continue;
                    LOGGER.debug("matched line " + translated + " for " + itemStack);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean recordMatchesTextFilter(ItemRecord record, String searchText) {
        ItemStack generated = this.generateItemStackFromRecord(record);
        return ItemStorage.itemStackMatchesTextFilter(generated, searchText);
    }

    private boolean shouldRecordBeIncludedInView(ItemRecord record, ViewFilterCriteria filter) {
        String itemNameText = record.key.item.m_7626_(this.generateItemStackFromRecord(record)).getString();
        if (ItemStorage.evaluatePostfixExpression(this.generateItemStackFromRecord(record), filter.searchExpression)) {
            ++filter.currentItemCount;
            if (filter.currentItemCount > filter.itemsToSkip) {
                ++filter.currentViewSize;
                if (filter.currentViewSize <= filter.requestedCount) {
                    return true;
                }
                filter.exceededMaximumCount = true;
            }
        }
        return false;
    }

    public List<ItemStack> getPageView(SortMethod sortMethod, int rowsToSkip, int requestedCount, String searchText) {
        this.lastUsedSortMethod = sortMethod;
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        int totalRowCount = (int)Math.ceil(this.totalNumberOfItemRecords / this.slotsPerRow);
        int startingItemNumber = rowsToSkip * this.slotsPerRow;
        LOGGER.debug("getPageView with rowSkip=" + rowsToSkip + " and requestedCount=" + requestedCount);
        TreeMap mapView = (TreeMap)this.getMapForSortMethod(sortMethod);
        if (mapView == null) {
            LOGGER.error("Tried to sort with unknown sorting method! " + sortMethod);
            return result;
        }
        Iterator it = mapView.navigableKeySet().iterator();
        int mainMapSize = this.itemMap.size();
        LOGGER.debug("This view has " + mapView.size() + " keys");
        LOGGER.debug("Main map has " + mainMapSize + " keys");
        int currentIndex = 0;
        int currentItemCount = 0;
        ViewFilterCriteria filter = new ViewFilterCriteria();
        filter.searchText = searchText;
        filter.itemsToSkip = startingItemNumber;
        filter.currentItemCount = 0;
        filter.requestedCount = requestedCount;
        filter.searchExpression = ItemStorage.generatePostfixExpression(ItemStorage.buildExpressionList(searchText));
        while (it.hasNext()) {
            Object key = it.next();
            List itemRecords = (List)mapView.get(key);
            currentItemCount += itemRecords.size();
            LOGGER.debug("Processed key " + key + " and got " + itemRecords.size() + " records");
            for (ItemRecord record : itemRecords) {
                if (this.shouldRecordBeIncludedInView(record, filter)) {
                    result.add(this.generateItemStackFromRecord(record));
                }
                if (!filter.exceededMaximumCount) continue;
                break;
            }
            ++currentIndex;
        }
        return result;
    }

    public static enum SortMethod {
        MostRecentTimestamp,
        OldestTimestamp,
        Name,
        ReverseName,
        HighestCount,
        LowestCount,
        Alphabetical,
        ReverseAlphabetical;

    }

    public class ReversibleComparator<T extends Comparable>
    implements Comparator<T> {
        private boolean reverse;

        public ReversibleComparator(boolean reverse) {
            this.reverse = reverse;
        }

        public int internalCompare(T left, T right) {
            if (left == null && right == null) {
                return 0;
            }
            if (left == null) {
                return 1;
            }
            if (right == null) {
                return -1;
            }
            return left.compareTo(right);
        }

        @Override
        public int compare(T left, T right) {
            int result = this.internalCompare(left, right);
            if (this.reverse) {
                return -1 * result;
            }
            return result;
        }
    }

    public static class SavedFilterData {
        public String searchText;
        public Item icon;
        public Object clientData;

        public int hashCode() {
            if (this.searchText == null) {
                return 0;
            }
            return this.searchText.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SavedFilterData) {
                SavedFilterData sfd = (SavedFilterData)obj;
                if (this.searchText == null && sfd.searchText == null) {
                    return true;
                }
                if (this.searchText == null) {
                    return false;
                }
                return this.searchText.equals(sfd.searchText);
            }
            return false;
        }
    }

    public class ItemKey {
        public Item item;

        public ItemKey() {
        }

        public ItemKey(Item item) {
            this.item = item;
        }

        public int hashCode() {
            int thisItemId = Item.m_41393_((Item)this.item);
            return Integer.hashCode(thisItemId);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ItemKey) {
                ItemKey otherKey = (ItemKey)obj;
                int thisItemId = Item.m_41393_((Item)this.item);
                int otherItemId = Item.m_41393_((Item)otherKey.item);
                LOGGER.debug("equals check for items: " + this.item + ", " + otherKey.item);
                LOGGER.debug("equals check: this=" + thisItemId + ", other=" + otherItemId);
                LOGGER.debug("equals check is " + (thisItemId == otherItemId));
                return thisItemId == otherItemId;
            }
            return super.equals(obj);
        }

        public String toString() {
            return "[" + this.item + "]";
        }

        public byte[] serialize() {
            ResourceLocation rsrc = BuiltInRegistries.f_257033_.m_7981_((Object)this.item);
            String namespace = rsrc.m_135827_();
            String path = rsrc.m_135815_();
            String result = namespace + ":" + path;
            return result.getBytes();
        }
    }

    public class ItemRecord {
        public CompoundTag nbt;
        public int count;
        public ItemKey key;
        public long lastActivityTimestamp;

        public ItemRecord() {
        }

        public ItemRecord(CompoundTag nbt, int count, ItemKey key) {
            this.nbt = nbt;
            this.count = count;
            this.key = key;
            this.updateTimestamp();
        }

        public void updateTimestamp() {
            this.lastActivityTimestamp = System.currentTimeMillis();
        }

        public boolean equals(Object other) {
            if (other instanceof ItemRecord) {
                boolean bothKeysNull;
                ItemRecord record = (ItemRecord)other;
                boolean bl = bothKeysNull = this.key == record.key;
                if (bothKeysNull || this.key != null && this.key.equals(record.key)) {
                    boolean bothTagsNull;
                    boolean bl2 = bothTagsNull = this.nbt == null && record.nbt == null;
                    if (bothTagsNull || this.nbt != null && this.nbt.equals((Object)record.nbt)) {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        public String toString() {
            return "[" + this.key.item + " with count " + this.count + " and nbt=(" + this.nbt + ")]";
        }

        public byte[] serialize() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] keyBytes = this.key.serialize();
            int keySize = keyBytes.length;
            if (this.nbt != null) {
                try {
                    NbtIo.m_128947_((CompoundTag)this.nbt, (OutputStream)baos);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            byte[] nbtBytes = baos.toByteArray();
            int nbtSize = nbtBytes.length;
            ByteBuffer buffer = ByteBuffer.allocate(4 + nbtSize + 4 + 4 + keySize + 8);
            buffer.putInt(nbtSize);
            buffer.put(nbtBytes);
            buffer.putInt(this.count);
            buffer.putInt(keySize);
            buffer.put(keyBytes);
            buffer.putLong(this.lastActivityTimestamp);
            return buffer.array();
        }
    }

    public static class StringExpr
    extends NoArgExpression {
        String text;

        public StringExpr(String text) {
            this.text = text;
            this.precedence = -1;
        }

        @Override
        public boolean evaluate(ItemStack itemStack) {
            return ItemStorage.itemStackMatchesTextFilter(itemStack, this.getRawString());
        }

        @Override
        public String getRawString() {
            return this.text;
        }

        public String toString() {
            return "StringExpr[" + this.getRawString() + "]";
        }
    }

    public static class OpExpr
    extends Expr {
        char op;

        public OpExpr(char op) {
            this.op = op;
            switch (this.op) {
                case ',': {
                    this.precedence = 1;
                    break;
                }
                case '&': {
                    this.precedence = 2;
                    break;
                }
                case '(': {
                    this.precedence = 0;
                    break;
                }
                case ')': {
                    this.precedence = 3;
                    break;
                }
                default: {
                    this.precedence = 0;
                }
            }
        }

        public boolean isParenthesisOp() {
            return this.op == '(' || this.op == ')';
        }

        public boolean evaluate(ItemStack itemStack, NoArgExpression left, NoArgExpression right) {
            switch (this.op) {
                case ',': {
                    return left.evaluate(itemStack) || right.evaluate(itemStack);
                }
                case '&': {
                    return left.evaluate(itemStack) && right.evaluate(itemStack);
                }
            }
            return false;
        }

        @Override
        public String getRawString() {
            return String.valueOf(this.op);
        }

        public String toString() {
            return "OpExpr[" + this.getRawString() + "]";
        }
    }

    public static abstract class Expr {
        public int precedence = 0;

        public String getRawString() {
            return "";
        }

        public int getPrecedence() {
            return this.precedence;
        }
    }

    public static abstract class NoArgExpression
    extends Expr {
        public abstract boolean evaluate(ItemStack var1);
    }

    public static class BooleanExpr
    extends NoArgExpression {
        boolean booleanValue;

        public BooleanExpr(boolean booleanValue) {
            this.booleanValue = booleanValue;
            this.precedence = -1;
        }

        @Override
        public boolean evaluate(ItemStack itemStack) {
            return this.booleanValue;
        }

        @Override
        public String getRawString() {
            return String.valueOf(this.booleanValue);
        }

        public String toString() {
            return "BooleanExpression[" + this.getRawString() + "]";
        }
    }

    public class ViewFilterCriteria {
        public String searchText;
        public int itemsToSkip;
        public int requestedCount;
        public List<Expr> searchExpression;
        public int currentItemCount;
        public int currentViewSize;
        public boolean exceededMaximumCount;
    }
}

