/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech;

import com.dairymoose.xenotech.XenoTechUtils;
import java.awt.geom.Point2D;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RotatedAABB
extends AABB {
    private static final Logger LOGGER = LogManager.getLogger();
    float angle;
    Vec3 rotatedMin;
    Vec3 rotatedMax;
    Vec3 rotatedTopLeft;
    Vec3 rotatedBottomRight;

    private Vec3 fixMin(Vec3 min, Vec3 max) {
        double minX = min.f_82479_;
        double minY = min.f_82480_;
        double minZ = min.f_82481_;
        if (min.f_82479_ > max.f_82479_) {
            minX = max.f_82479_;
        }
        if (min.f_82480_ > max.f_82480_) {
            minY = max.f_82480_;
        }
        if (min.f_82481_ > max.f_82481_) {
            minZ = max.f_82481_;
        }
        return new Vec3(minX, minY, minZ);
    }

    private Vec3 fixMax(Vec3 min, Vec3 max) {
        double maxX = max.f_82479_;
        double maxY = max.f_82480_;
        double maxZ = max.f_82481_;
        if (max.f_82479_ < min.f_82479_) {
            maxX = max.f_82479_;
        }
        if (max.f_82480_ < min.f_82480_) {
            maxY = max.f_82480_;
        }
        if (max.f_82481_ < min.f_82481_) {
            maxZ = max.f_82481_;
        }
        return new Vec3(maxX, maxY, maxZ);
    }

    public RotatedAABB(float angle, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.angle = angle;
        double xCenter = (maxX - minX) / 2.0;
        double zCenter = (maxZ - minZ) / 2.0;
        Vec3 min = XenoTechUtils.revolve(new Point2D.Double(0.0, 0.0), angle, new Vec3(minX, minY, minZ));
        Vec3 max = XenoTechUtils.revolve(new Point2D.Double(0.0, 0.0), angle, new Vec3(maxX, maxY, maxZ));
        this.rotatedMin = this.fixMin(min, max);
        this.rotatedMax = this.fixMax(min, max);
        this.rotatedTopLeft = XenoTechUtils.revolve(new Point2D.Double(0.0, 0.0), angle, new Vec3(minX, minY, maxZ));
        this.rotatedBottomRight = XenoTechUtils.revolve(new Point2D.Double(0.0, 0.0), angle, new Vec3(maxX, maxY, minZ));
    }

    public RotatedAABB(float angle, AABB aabb) {
        this(angle, aabb.f_82288_, aabb.f_82289_, aabb.f_82290_, aabb.f_82291_, aabb.f_82292_, aabb.f_82293_);
    }

    public boolean m_82314_(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        Vec3 min = XenoTechUtils.revolve(new Point2D.Double(0.0, 0.0), this.angle, new Vec3(minX, minY, minZ));
        Vec3 max = XenoTechUtils.revolve(new Point2D.Double(0.0, 0.0), this.angle, new Vec3(maxX, maxY, maxZ));
        Vec3 rotatedMin = this.fixMin(min, max);
        Vec3 rotatedMax = this.fixMax(min, max);
        Vec3 rotatedTopLeft = XenoTechUtils.revolve(new Point2D.Double(0.0, 0.0), this.angle, new Vec3(minX, minY, maxZ));
        Vec3 rotatedBottomRight = XenoTechUtils.revolve(new Point2D.Double(0.0, 0.0), this.angle, new Vec3(maxX, maxY, minZ));
        double xCenter = (rotatedMax.f_82479_ + rotatedMin.f_82479_) / 2.0;
        double yCenter = (rotatedMax.f_82480_ + rotatedMin.f_82480_) / 2.0;
        double zCenter = (rotatedMax.f_82481_ + rotatedMin.f_82481_) / 2.0;
        double thisXCenter = (this.rotatedMax.f_82479_ + this.rotatedMin.f_82479_) / 2.0;
        double thisYCenter = (this.rotatedMax.f_82480_ + this.rotatedMin.f_82480_) / 2.0;
        double thisZCenter = (this.rotatedMax.f_82481_ + this.rotatedMin.f_82481_) / 2.0;
        return this.rotatedMin.f_82479_ < rotatedMax.f_82479_ && this.rotatedMax.f_82479_ > rotatedMin.f_82479_ && this.rotatedMin.f_82480_ < rotatedMax.f_82480_ && this.rotatedMax.f_82480_ > rotatedMin.f_82480_ && this.rotatedMin.f_82481_ < rotatedMax.f_82481_ && this.rotatedMax.f_82481_ > rotatedMin.f_82481_;
    }
}

