/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech;

import com.dairymoose.xenotech.XenoBlocks;
import com.dairymoose.xenotech.XenoTechCommon;
import com.dairymoose.xenotech.XenoTechConfig;
import com.dairymoose.xenotech.XenoTechUtils;
import com.dairymoose.xenotech.block.DriverSeatBlock;
import com.dairymoose.xenotech.block.SailBlock;
import com.dairymoose.xenotech.block.VerticalRedstoneConduitBlock;
import com.dairymoose.xenotech.client.gui.screens.BlueprintingTableScreen;
import com.dairymoose.xenotech.client.gui.screens.FluidShippingTankScreen;
import com.dairymoose.xenotech.client.gui.screens.TerminalScreen;
import com.dairymoose.xenotech.client.model.CrossModel;
import com.dairymoose.xenotech.client.model.SquareModel;
import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.entity.DummyRenderer;
import com.dairymoose.xenotech.entity.FlagshipHelicopterRotorRenderer;
import com.dairymoose.xenotech.entity.FlagshipPropellerRenderer;
import com.dairymoose.xenotech.entity.FluidShippingTankRenderer;
import com.dairymoose.xenotech.entity.HelicopterRotorRenderer;
import com.dairymoose.xenotech.entity.IntegratedMinigunRenderer;
import com.dairymoose.xenotech.entity.ManipulatorBlockEntityRenderer;
import com.dairymoose.xenotech.entity.MinigunRenderer;
import com.dairymoose.xenotech.entity.RenderableBlock;
import com.dairymoose.xenotech.entity.WaterColliderEntity;
import com.dairymoose.xenotech.entity.WaterColliderRenderer;
import com.dairymoose.xenotech.item.StasisGunItem;
import com.dairymoose.xenotech.item.TeleportationTransponder;
import com.dairymoose.xenotech.network.ServerboundHitscanArrayPacket;
import com.dairymoose.xenotech.network.ServerboundRenderableInteractPacket;
import com.dairymoose.xenotech.network.ServerboundTerminalSelectionPacket;
import com.dairymoose.xenotech.network.XenoTechNetwork;
import com.dairymoose.xenotech.spellrenderer.SparkRenderer;
import com.dairymoose.xenotech.world.level.block.entity.IntegratedGunBlockEntity;
import com.dairymoose.xenotech.world.level.block.entity.ManipulatorBlockEntity;
import com.dairymoose.xenotech.world.level.block.entity.MountedGunBlockEntity;
import com.dairymoose.xenotech.world.level.block.entity.SnowBlockerBlockEntity;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.CameraType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.GameShuttingDownEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jline.utils.Log;

public class XenoTechClient {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final KeyMapping SHIP_DESCENT_HOTKEY = new KeyMapping("key.xenotech.ship_descent", InputConstants.Type.KEYSYM, 341, "key.categories.xenotech");
    public static final KeyMapping SHIP_AUTO_LEFT_HOTKEY = new KeyMapping("key.xenotech.autopilot_left", InputConstants.Type.KEYSYM, 263, "key.categories.xenotech");
    public static final KeyMapping SHIP_AUTO_RIGHT_HOTKEY = new KeyMapping("key.xenotech.autopilot_right", InputConstants.Type.KEYSYM, 262, "key.categories.xenotech");
    public static final KeyMapping SHIP_AUTO_FORWARD_HOTKEY = new KeyMapping("key.xenotech.autopilot_forward", InputConstants.Type.KEYSYM, 265, "key.categories.xenotech");
    public static final KeyMapping SHIP_AUTO_STOP_HOTKEY = new KeyMapping("key.xenotech.autopilot_stop", InputConstants.Type.KEYSYM, 264, "key.categories.xenotech");
    public static final KeyMapping SHIP_AUTO_ASCEND_HOTKEY = new KeyMapping("key.xenotech.autopilot_ascend", InputConstants.Type.KEYSYM, 266, "key.categories.xenotech");
    public static final KeyMapping SHIP_AUTO_DESCEND_HOTKEY = new KeyMapping("key.xenotech.autopilot_descend", InputConstants.Type.KEYSYM, 267, "key.categories.xenotech");
    public static final KeyMapping SHIP_HOVER_STRAFE_HOTKEY = new KeyMapping("key.xenotech.ship_hover_strafe", InputConstants.Type.KEYSYM, 342, "key.categories.xenotech");
    public static final KeyMapping SHIP_FREE_FLIGHT_HOTKEY = new KeyMapping("key.xenotech.ship_free_flight", InputConstants.Type.KEYSYM, 73, "key.categories.xenotech");
    public static final List<KeyMapping> allKeyMappings = List.of(SHIP_DESCENT_HOTKEY, SHIP_AUTO_LEFT_HOTKEY, SHIP_AUTO_RIGHT_HOTKEY, SHIP_AUTO_FORWARD_HOTKEY, SHIP_AUTO_STOP_HOTKEY, SHIP_AUTO_ASCEND_HOTKEY, SHIP_AUTO_DESCEND_HOTKEY, SHIP_HOVER_STRAFE_HOTKEY);
    private static final Map<KeyMapping, Integer> keyMappingToScanCodeMap = new HashMap<KeyMapping, Integer>();
    public static final int KEY_LALT = 342;
    public static final int CONTROL_KEY_CODE = 341;
    public static final int LEFT_ARROW_KEY_CODE = 263;
    public static final int RIGHT_ARROW_KEY_CODE = 262;
    public static final int UP_ARROW_KEY_CODE = 265;
    public static final int DOWN_ARROW_KEY_CODE = 264;
    public static final int PAGE_UP_KEY_CODE = 266;
    public static final int PAGE_DOWN_KEY_CODE = 267;
    public static final int I_KEY_CODE = 73;
    public static long clientTick;
    public static final int BARREL_SPIN_UP_TICKS_TO_REACH_MAX = 25;
    public static final float BARREL_SPEED_MAXIMUM = 2.0f;
    private static final float BARREL_SPEED_GAIN_PER_TICK = 0.08f;
    private static final float BARREL_SPEED_LOSS_PER_TICK = 0.0264f;
    public static List<ServerboundHitscanArrayPacket.SingleHitscanResult> pendingHitscanResults;
    private static boolean oneGunActiveAtATime;
    private static boolean weapon1Active;
    private static boolean weapon2Active;
    private Map<KeyMapping, Boolean> inputKeyStateMap = new HashMap<KeyMapping, Boolean>();
    OnReloadListener reloadListener = new OnReloadListener();
    public static double xInitial;
    public static double yInitial;
    public static double zInitial;
    public static float yRot;
    public static float xRot;
    public static long spellRenderStep;
    public static long spellRenderMax;
    public static long spellRenderStart;
    SparkRenderer[] sparkRenderers = new SparkRenderer[6];
    int disabledRenderTickCount = -1;
    int restoreBatchRenderTickCount = 100;
    boolean tempDisableBatchRender = false;
    public float cameraDistMult = 2.6f;
    public Boolean clientBobViewSetting = null;
    DummyEntity currentExtendedCamera = null;
    public static boolean isControlDown;
    public static boolean isAltDown;
    public static final int BUTTON_DOWN_ACTION = 1;
    public static final int BUTTON_HOLD_ACTION = 2;
    public static final int BUTTON_UP_ACTION = 0;
    private static final boolean lookForClosestBlock = false;
    public long lastItemTimestamp = 0L;
    public InteractionHand lastHand = null;
    private double twitchRand = -1.0;
    private double twitchRandReverse = -1.0;
    private double twitchRandAmplitude = -1.0;
    private double doorInteractDistance = 1.8;
    private double doorInteractDistanceSqr = this.doorInteractDistance * this.doorInteractDistance;
    private static boolean resumeAtAutopilot;
    public static boolean recentlyToggledInvis;
    private double renderableInteractDistance = 0.5;
    private double renderableInteractDistanceSqr = this.renderableInteractDistance * this.renderableInteractDistance;
    public static boolean isLeftMouseDown;
    public static boolean isRightMouseDown;
    public static int CLICKRESULT_SUCCESS;
    public static int CLICKRESULT_DOOR_SKIP;
    public static int CLICKRESULT_MISS;
    public static boolean mirrorSpellRenderX;
    public static float partialTickNow;
    public static float partialTickLast;
    public static List<BulletHoleInfo> bulletHoles;
    private ResourceLocation BULLET_HOLE_1_TEX = new ResourceLocation("xenotech", "textures/item/bullet_hole_1.png");
    private ResourceLocation BULLET_HOLE_2_TEX = new ResourceLocation("xenotech", "textures/item/bullet_hole_2.png");
    private ResourceLocation BULLET_HOLE_3_TEX = new ResourceLocation("xenotech", "textures/item/bullet_hole_3.png");
    private int BULLET_HOLE_TEX_SIZE = 32;
    boolean madeParticles = false;

    public XenoTechClient() {
        LOGGER.debug("XenoTechClient");
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onRegisterReloadListener);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerBlockColors);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerEntityLayers);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(CrossModel.LAYER_LOCATION, CrossModel::createBodyLayer);
        event.registerLayerDefinition(SquareModel.LAYER_LOCATION, SquareModel::createBodyLayer);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_SIFTING_NET_POST.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_SIFTING_NET.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_SHIP_TELEPORTATION_MODULE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_AIRCRAFT_LANDING_GEAR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_GLASS_THIN_HULL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_GLASS_ANGULAR_THIN_HULL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_GLASS_ANGULAR_HULL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_GLASS_ANGULAR_SLAB_HULL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_COMBINE_HARVESTER.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_SMALL_WINDSHIELD.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_MEDIUM_WINDSHIELD.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_LARGE_WINDSHIELD.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_MEDIUM_WINDSHIELD_RIGHT_SIDE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_MEDIUM_WINDSHIELD_LEFT_SIDE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_SMALL_WINDSHIELD_RIGHT_SIDE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_SMALL_WINDSHIELD_LEFT_SIDE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_TRACTOR_WHEEL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_STEAM_ENGINE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_BUZZSAW.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_MANIPULATOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_SNEAKY_MANIPULATOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_XOR_GATE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_OR_GATE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_NOT_GATE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_AND_GATE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_VERTICAL_REDSTONE_CONDUIT.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_SNOW_BLOCKER.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_SPORT_TIRE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_GLASS_EMBEDDED_COMBUSTION_ENGINE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_CRUDE_OIL_BARREL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_OIL_BARREL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_FLUID_SHIPPING_TANK.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_NOSE_CONE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)XenoBlocks.BLOCK_JET_TRAIL_ONLY.get()), (RenderType)RenderType.m_110466_());
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)XenoBlocks.BLOCK_ENTITY_HELICOPTER_ROTOR.get()), context -> new HelicopterRotorRenderer(context));
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)XenoBlocks.BLOCK_ENTITY_FLAGSHIP_HELICOPTER_ROTOR.get()), context -> new FlagshipHelicopterRotorRenderer(context));
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)XenoBlocks.BLOCK_ENTITY_FLAGSHIP_PROPELLER.get()), context -> new FlagshipPropellerRenderer(context));
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)XenoBlocks.BLOCK_ENTITY_MANIPULATOR.get()), context -> new ManipulatorBlockEntityRenderer(context));
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)XenoBlocks.BLOCK_ENTITY_FLUID_SHIPPING_TANK.get()), context -> new FluidShippingTankRenderer(context));
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)XenoBlocks.BLOCK_ENTITY_MINIGUN.get()), context -> new MinigunRenderer(context));
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)XenoBlocks.BLOCK_ENTITY_INTEGRATED_MINIGUN.get()), context -> new IntegratedMinigunRenderer(context));
        EntityRenderers.m_174036_(DummyEntity.DUMMY_ENTITY, context -> new DummyRenderer(context));
        EntityRenderers.m_174036_(WaterColliderEntity.WATER_COLLIDER_ENTITY, context -> new WaterColliderRenderer(context));
        ItemProperties.register((Item)((Item)XenoBlocks.ITEM_PLATINUM_BOW.get()), (ResourceLocation)new ResourceLocation("minecraft", "pulling"), (stack, world, living, value) -> living != null && living.m_6117_() && living.m_21211_() == stack ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)XenoBlocks.ITEM_PLATINUM_BOW.get()), (ResourceLocation)new ResourceLocation("minecraft", "pull"), (stack, world, living, value) -> living != null && living.m_6117_() && living.m_21211_() == stack ? (float)living.m_21252_() / 20.0f : 0.0f);
        MenuScreens.m_96206_((MenuType)((MenuType)XenoBlocks.MENU_TYPE_BLUEPRINTING_TABLE.get()), BlueprintingTableScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)XenoBlocks.MENU_TYPE_FLUID_SHIPPING_TANK.get()), FluidShippingTankScreen::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.getBlockColors().m_92589_(new BlockColor(){

            public int m_92566_(BlockState paramBlockState, BlockAndTintGetter paramBlockAndTintGetter, BlockPos paramBlockPos, int paramInt) {
                int p = (Integer)paramBlockState.m_61143_((Property)VerticalRedstoneConduitBlock.POWER);
                if (p == 0) {
                    return 0x7F0000;
                }
                int r = 8 * (p + 2) + 127;
                return r *= 65536;
            }
        }, new Block[]{(Block)XenoBlocks.BLOCK_VERTICAL_REDSTONE_CONDUIT.get()});
        event.getBlockColors().m_92589_(new BlockColor(){

            public int m_92566_(BlockState paramBlockState, BlockAndTintGetter paramBlockAndTintGetter, BlockPos paramBlockPos, int paramInt) {
                float rMin = 0.6f;
                float gMin = 0.5f;
                float bMin = 1.0f;
                float rMax = 1.0f;
                float gMax = 1.0f;
                float bMax = 1.0f;
                float fSpeedPct = DummyRenderer.currentSpeedPercent;
                float fSpeedPctInv = 1.0f - fSpeedPct;
                float r = rMin * fSpeedPctInv + rMax * fSpeedPct;
                float g = gMin * fSpeedPctInv + gMax * fSpeedPct;
                float b = bMin * fSpeedPctInv + bMax * fSpeedPct;
                int result = (int)(255.0f * r) << 16 | (int)(255.0f * g) << 8 | (int)(255.0f * b);
                return result;
            }
        }, new Block[]{(Block)XenoBlocks.BLOCK_JET_TRAIL_ONLY.get()});
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !Minecraft.m_91087_().m_91104_()) {
            ++clientTick;
        }
        if (event.phase == TickEvent.Phase.END) {
            DummyEntity dummy;
            Entity entity;
            DummyEntity carrier = DummyEntity.getDummyEntityForCarried((Entity)Minecraft.m_91087_().f_91074_);
            DummyEntity.localPlayerBeingCarriedByDummy = carrier != null;
            if (this.playerIsMountingGun() && (entity = Minecraft.m_91087_().f_91074_.m_275832_()) instanceof DummyEntity) {
                dummy = (DummyEntity)entity;
                if (dummy.thisMountedGun != null) {
                    this.processGun(dummy, dummy.thisMountedGun, isLeftMouseDown, isRightMouseDown);
                }
            }
            if (Minecraft.m_91087_().f_91074_ != null && (entity = Minecraft.m_91087_().f_91074_.m_275832_()) instanceof DummyEntity && this.weaponsReady(dummy = (DummyEntity)entity) && !dummy.weaponAssignments.isEmpty()) {
                boolean[] hotkeyActive = new boolean[]{isLeftMouseDown, isRightMouseDown};
                weapon1Active = false;
                weapon2Active = false;
                boolean anyWeaponActive = false;
                for (int i = 0; i < dummy.weaponAssignments.size() && i < hotkeyActive.length; ++i) {
                    boolean isActive = hotkeyActive[i];
                    if (oneGunActiveAtATime && anyWeaponActive) {
                        isActive = false;
                    }
                    if (isActive) {
                        if (i == 0) {
                            weapon1Active = true;
                        } else if (i == 1) {
                            weapon2Active = true;
                        }
                    }
                    this.processGun(dummy, dummy.weaponAssignments.get((int)i).blockEntity, isActive, true);
                    if (!isActive) continue;
                    anyWeaponActive = true;
                }
            }
            if (clientTick % 2L == 0L && !pendingHitscanResults.isEmpty()) {
                XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundHitscanArrayPacket(pendingHitscanResults));
                pendingHitscanResults.clear();
            }
        }
        if (event.phase == TickEvent.Phase.END) {
            for (KeyMapping mapping : allKeyMappings) {
                this.checkForKeyInput(mapping);
            }
        }
    }

    private void checkForKeyInput(KeyMapping mapping) {
        Boolean existingState = this.inputKeyStateMap.get(mapping);
        boolean isDown = this.hotkeyIsDown(mapping);
        if (existingState == null || isDown != existingState) {
            this.onKeyboardInput(isDown ? 1 : 0, keyMappingToScanCodeMap.get(mapping));
        }
        this.inputKeyStateMap.put(mapping, isDown);
    }

    private boolean hotkeyIsDown(KeyMapping mapping) {
        boolean isDown = false;
        while (mapping.m_90859_()) {
            isDown = true;
        }
        return mapping.m_90857_();
    }

    private void onKeyboardInput(int action, int key) {
        Level level;
        if (key == 341) {
            isControlDown = this.keyIsActive(action);
        } else if (key == 342) {
            isAltDown = this.keyIsActive(action);
        }
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91080_ == null && (level = Minecraft.m_91087_().f_91074_.m_9236_()) != null) {
            List dummies = level.m_45976_(DummyEntity.class, Minecraft.m_91087_().f_91074_.m_20191_().m_82400_(2.5));
            if (dummies != null && dummies.size() > 0) {
                DummyEntity dummy = (DummyEntity)((Object)dummies.get(0));
                BlockPos pos = dummy.m_20183_();
                if (action == 1) {
                    if (key == 263) {
                        XenoTechCommon.KEYBOARD_EVENT_SHIP_LEFT = true;
                    }
                    if (key == 262) {
                        XenoTechCommon.KEYBOARD_EVENT_SHIP_RIGHT = true;
                    }
                    if (key == 265) {
                        XenoTechClient.shipForward(dummy, pos);
                    }
                    if (key == 266) {
                        XenoTechCommon.KEYBOARD_EVENT_SHIP_ASCEND = true;
                    }
                    if (key == 267) {
                        XenoTechCommon.KEYBOARD_EVENT_SHIP_DESCEND = true;
                    }
                    if (key == 264) {
                        XenoTechClient.shipWantToBrake(dummy, pos);
                    }
                    if (key == 73) {
                        boolean bl = DummyEntity.freeFlightMode = !DummyEntity.freeFlightMode;
                    }
                }
            }
            if (action == 0) {
                if (key == 263) {
                    XenoTechCommon.KEYBOARD_EVENT_SHIP_LEFT = false;
                }
                if (key == 262) {
                    XenoTechCommon.KEYBOARD_EVENT_SHIP_RIGHT = false;
                }
                if (key == 266) {
                    XenoTechCommon.KEYBOARD_EVENT_SHIP_ASCEND = false;
                }
                if (key == 267) {
                    XenoTechCommon.KEYBOARD_EVENT_SHIP_DESCEND = false;
                }
            }
        }
    }

    public void processGun(DummyEntity dummy, MountedGunBlockEntity mountedGun, boolean isHotkeyActive, boolean aimDownSights) {
        mountedGun.barrelRotationSpeed = isHotkeyActive ? (mountedGun.barrelRotationSpeed += 0.08f) : (mountedGun.barrelRotationSpeed -= 0.0264f);
        if (mountedGun.barrelRotationSpeed > 2.0f) {
            mountedGun.barrelRotationSpeed = 2.0f;
        } else if (mountedGun.barrelRotationSpeed < 0.0f) {
            mountedGun.barrelRotationSpeed = 0.0f;
        }
        if (mountedGun.barrelRotationSpeed > 0.0f) {
            float rotationPct = mountedGun.barrelRotationSpeed / 2.0f;
            float volume = Math.min(rotationPct * 1.0f, 0.8f);
            if (clientTick % 2L == 0L) {
                dummy.m_9236_().m_7785_(dummy.m_20185_(), dummy.m_20186_(), dummy.m_20189_(), (SoundEvent)XenoBlocks.SOUND_EVENT_MINIGUN_SPIN_UP.get(), SoundSource.BLOCKS, volume, rotationPct, false);
            }
        }
        if (mountedGun.barrelRotationSpeed == 2.0f) {
            mountedGun.fireGun((Player)Minecraft.m_91087_().f_91074_, aimDownSights);
            float volume = 0.9f;
            dummy.m_9236_().m_7785_(dummy.m_20185_(), dummy.m_20186_(), dummy.m_20189_(), (SoundEvent)XenoBlocks.SOUND_EVENT_MINIGUN_FIRE.get(), SoundSource.BLOCKS, volume, 1.0f, false);
            if (mountedGun instanceof IntegratedGunBlockEntity) {
                IntegratedGunBlockEntity igb = (IntegratedGunBlockEntity)mountedGun;
            } else {
                Minecraft.m_91087_().f_91074_.m_146926_(Minecraft.m_91087_().f_91074_.m_146909_() - 0.2f);
            }
        } else {
            mountedGun.isFiring = false;
        }
    }

    @SubscribeEvent
    public void onRegisterReloadListener(RegisterClientReloadListenersEvent event) {
        LOGGER.debug("Register reload listener");
        event.registerReloadListener((PreparableReloadListener)this.reloadListener);
    }

    @SubscribeEvent
    public void onClientLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        LOGGER.debug("Client logout");
        if (this.clientBobViewSetting != null) {
            Minecraft.m_91087_().f_91066_.m_231830_().m_231514_((Object)this.clientBobViewSetting);
            this.clientBobViewSetting = null;
        }
        DummyEntity.clearDummiesGlobal();
        DummyEntity.invalidateCachedDummyListServer = true;
        DummyEntity.invalidateCachedDummyListClient = true;
        ManipulatorBlockEntity.uuidList.clear();
        SnowBlockerBlockEntity.snowBlockers.clear();
        TeleportationTransponder.nextUseTickClientSide.clear();
        try {
            ManipulatorBlockEntity.cleanupFakePlayerList(null);
        }
        catch (Exception e) {
            LOGGER.error("Error cleaning up fake players", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onServerStopped(ServerStoppedEvent event) {
        LOGGER.debug("Server being stopped!");
        XenoTechCommon.singleplayerLevelName = null;
    }

    public static boolean isCastingSpell() {
        return spellRenderStep != -1L;
    }

    @SubscribeEvent
    public void renderPlayerEvent(RenderPlayerEvent.Pre event) {
        if (XenoTechClient.isCastingSpell() && event.getEntity() instanceof LocalPlayer) {
            ((PlayerModel)event.getRenderer().m_7200_()).f_102816_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
        }
        if (event.getEntity().m_20202_() instanceof DummyEntity) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void renderEntityEvent(RenderLivingEvent event) {
        if (DummyEntity.disableBatchRenderingDuringOutline && event.getEntity() != null && Minecraft.m_91087_() != null && Minecraft.m_91087_().f_91074_ != null) {
            int ticksSinceDisabled;
            int playerTickCount = Minecraft.m_91087_().f_91074_.f_19797_;
            if (Minecraft.m_91087_().m_91314_((Entity)event.getEntity())) {
                if (!this.tempDisableBatchRender && DummyEntity.doBatchRendering) {
                    this.tempDisableBatchRender = true;
                    if (DummyEntity.showOutlineWarningMessage) {
                        LOGGER.warn("Disabling batch rendering temporarily due to outline...");
                    }
                    DummyEntity.doBatchRendering = false;
                }
                if (this.tempDisableBatchRender) {
                    this.disabledRenderTickCount = playerTickCount;
                }
            } else if (this.disabledRenderTickCount != -1 && (ticksSinceDisabled = playerTickCount - this.disabledRenderTickCount) >= this.restoreBatchRenderTickCount) {
                this.tempDisableBatchRender = false;
                this.disabledRenderTickCount = -1;
                DummyEntity.doBatchRendering = true;
                if (DummyEntity.showOutlineWarningMessage) {
                    LOGGER.warn("Re-enabling batch rendering");
                }
            }
        }
    }

    @SubscribeEvent
    public void fovModifierEvent(ComputeFovModifierEvent event) {
        float fovMod;
        if (event.getPlayer().m_20202_() instanceof DummyEntity) {
            // empty if block
        }
        if (event.getPlayer().m_21211_().m_150930_((Item)XenoBlocks.ITEM_TELEPORTATION_TRANSPONDER.get())) {
            int remaining = event.getPlayer().m_21212_();
            float progress = (float)remaining / (float)((Item)XenoBlocks.ITEM_TELEPORTATION_TRANSPONDER.get()).m_8105_(event.getPlayer().m_21211_());
            fovMod = 1.0f + progress * 1.5f;
            event.setNewFovModifier(fovMod);
        }
        if (event.getPlayer().m_21211_().m_150930_((Item)XenoBlocks.ITEM_PLATINUM_BOW.get())) {
            float zoomPct = 0.15f;
            float ticksForMaxZoom = 20.0f;
            fovMod = 1.0f - zoomPct * Math.min((float)event.getPlayer().m_21252_() / ticksForMaxZoom, 1.0f);
            event.setNewFovModifier(fovMod);
        }
        if (this.playerIsMountingGun() && isRightMouseDown && Minecraft.m_91087_().f_91074_.m_275832_().f_19797_ >= 3) {
            event.setNewFovModifier(0.6f);
        }
    }

    private void drawCrosshairLine(GuiGraphics graphics, int x0, int y0, int w0, int h0) {
        int xOffset = x0;
        int yOffset = y0;
        int x = Minecraft.m_91087_().m_91268_().m_85445_() / 2 + xOffset;
        int y = Minecraft.m_91087_().m_91268_().m_85446_() / 2 + yOffset;
        int w = w0;
        int h = h0;
        graphics.m_280509_(x, y, x + w, y + h, -1);
    }

    private void drawSizedCrosshair(GuiGraphics graphics, int size, int lineLength) {
        this.drawCrosshairLine(graphics, size, 0, lineLength, 1);
        this.drawCrosshairLine(graphics, -size - lineLength + 1, 0, lineLength, 1);
        this.drawCrosshairLine(graphics, 0, size, 1, lineLength);
        this.drawCrosshairLine(graphics, 0, -size - lineLength + 1, 1, lineLength);
    }

    @SubscribeEvent
    public void rawKeyboardEvent(InputEvent.MouseScrollingEvent event) {
        boolean eligible;
        boolean bl = eligible = DummyEntity.localPlayerBeingCarriedByDummy || Minecraft.m_91087_().f_91074_.m_20202_() instanceof DummyEntity;
        if (eligible && !InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) && Minecraft.m_91087_().f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
            float scrollValue = 0.4f;
            if (this.cameraDistMult >= 3.4f) {
                scrollValue = 0.6f;
            }
            this.cameraDistMult = event.getScrollDelta() > 0.0 ? (this.cameraDistMult -= scrollValue) : (this.cameraDistMult += scrollValue);
            if (this.cameraDistMult < 1.0f) {
                this.cameraDistMult = 1.0f;
            }
        }
    }

    public void onGameShutdown(GameShuttingDownEvent e) {
        LOGGER.debug("Game shutdown");
        if (this.clientBobViewSetting != null) {
            Minecraft.m_91087_().f_91066_.m_231830_().m_231514_((Object)this.clientBobViewSetting);
            this.clientBobViewSetting = null;
        }
    }

    @SubscribeEvent
    public void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        if (this.cameraDistMult == 1.0f) {
            if (this.clientBobViewSetting != null) {
                Minecraft.m_91087_().f_91066_.m_231830_().m_231514_((Object)this.clientBobViewSetting);
                this.clientBobViewSetting = null;
            }
            return;
        }
        if ((DummyEntity.localPlayerBeingCarriedByDummy || Minecraft.m_91087_().f_91074_.m_20202_() instanceof DummyEntity) && Minecraft.m_91087_().f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
            if (this.clientBobViewSetting == null) {
                this.clientBobViewSetting = (Boolean)Minecraft.m_91087_().f_91066_.m_231830_().m_231551_();
            }
            Minecraft.m_91087_().f_91066_.m_231830_().m_231514_((Object)false);
            if (this.currentExtendedCamera == null) {
                this.currentExtendedCamera = new DummyEntity(DummyEntity.DUMMY_ENTITY, (Level)Minecraft.m_91087_().f_91073_);
            }
            double camEyeHeight = this.currentExtendedCamera.m_20192_();
            Vec3 playerPos = Minecraft.m_91087_().f_91074_.m_20318_((float)event.getPartialTick());
            Vec3 camPos = event.getCamera().m_90583_().m_82520_(0.0, -camEyeHeight, 0.0);
            Vec3 playerVectorToCamera = camPos.m_82546_(playerPos);
            Vec3 extendedCameraVector = playerVectorToCamera.m_82542_((double)this.cameraDistMult, (double)this.cameraDistMult, (double)this.cameraDistMult);
            Vec3 newCamPos = playerPos.m_82549_(extendedCameraVector);
            this.currentExtendedCamera.m_146922_(Minecraft.m_91087_().f_91074_.m_146908_());
            this.currentExtendedCamera.m_146926_(Minecraft.m_91087_().f_91074_.m_146909_());
            this.currentExtendedCamera.m_20343_(newCamPos.f_82479_, newCamPos.f_82480_, newCamPos.f_82481_);
            this.currentExtendedCamera.m_146867_();
            event.getCamera().m_90575_((BlockGetter)Minecraft.m_91087_().f_91073_, (Entity)this.currentExtendedCamera, false, false, 1.0f);
        } else if (this.clientBobViewSetting != null) {
            Minecraft.m_91087_().f_91066_.m_231830_().m_231514_((Object)this.clientBobViewSetting);
            this.clientBobViewSetting = null;
        }
    }

    public boolean keyIsActive(int action) {
        return action == 1 || action == 2;
    }

    @SubscribeEvent
    public void rawKeyboardEvent(InputEvent.Key event) {
    }

    public static void shipHover(DummyEntity dummy, BlockPos pos) {
        ServerboundTerminalSelectionPacket.shipHoverLogic(dummy);
        XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.SHIP_HOVER, dummy, pos));
    }

    public static void shipForward(DummyEntity dummy, BlockPos pos) {
        ServerboundTerminalSelectionPacket.shipForwardLogic(dummy);
        XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.SHIP_FORWARD, dummy, pos));
    }

    public static void ship45Left(DummyEntity dummy, BlockPos pos) {
        XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.SHIP_LEFT45, dummy, pos));
    }

    public static void ship45Right(DummyEntity dummy, BlockPos pos) {
        XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.SHIP_RIGHT45, dummy, pos));
    }

    public static void shipStopAutopilot(DummyEntity dummy, BlockPos pos) {
        XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.SHIP_STOP_AUTOPILOT, dummy, pos));
    }

    public static void shipWantToBrake(DummyEntity dummy, BlockPos pos) {
        ServerboundTerminalSelectionPacket.shipWantToBrakeLogic(dummy);
        XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.SHIP_WANT_TO_BRAKE, dummy, pos));
    }

    public static void shipStopAutopilotOrBrake(DummyEntity dummy, BlockPos pos) {
        ServerboundTerminalSelectionPacket.shipBrakeOrReverseLogic(dummy);
        XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.SHIP_STOP_AUTOPILOT_OR_BRAKE_OR_REVERSE, dummy, pos));
    }

    public static Button.OnPress onPress_ascend(final TerminalScreen thisTerminal, final DummyEntity dummy) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.begin_ascent"), List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit(1);
                XenoTechCommon.shipAscend(dummy, thisTerminal.pos, true);
            }
        };
    }

    public static Button.OnPress onPress_descend(final TerminalScreen thisTerminal, final DummyEntity dummy) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.begin_descent"), List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit(1);
                XenoTechCommon.shipDescend(dummy, thisTerminal.pos, true);
            }
        };
    }

    public static Button.OnPress onPress_hover(final TerminalScreen thisTerminal, final DummyEntity dummy) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.begin_hover"), List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit(1);
                XenoTechClient.shipHover(dummy, thisTerminal.pos);
            }
        };
    }

    public static Button.OnPress onPress_forward(final TerminalScreen thisTerminal, final DummyEntity dummy) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.begin_forward_motion"), List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit(1);
                XenoTechClient.shipForward(dummy, thisTerminal.pos);
            }
        };
    }

    public static Button.OnPress onPress_45left(final TerminalScreen thisTerminal, final DummyEntity dummy) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.begin_left_turn"), List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit(1);
                XenoTechClient.ship45Left(dummy, thisTerminal.pos);
            }
        };
    }

    public static Button.OnPress onPress_45right(final TerminalScreen thisTerminal, final DummyEntity dummy) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.begin_right_turn"), List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit(1);
                XenoTechClient.ship45Right(dummy, thisTerminal.pos);
            }
        };
    }

    public static Button.OnPress onPress_autopilot_back(final TerminalScreen thisTerminal) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                resumeAtAutopilot = false;
                TerminalScreen.onPress_back(thisTerminal).m_93750_(arg0);
            }
        };
    }

    public static Button.OnPress onPress_autopilot(final TerminalScreen thisTerminal, final DummyEntity dummy) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                boolean isHovering = dummy.m_20184_().m_82556_() == 0.0;
                boolean isAscending = dummy.autopilotAutoAscendTicks > 0;
                boolean isDescending = dummy.autopilotAutoDescendTicks > 0;
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.awaiting_selection"), List.of(!isHovering ? new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.hover"), XenoTechClient.onPress_hover(thisTerminal, dummy)) : new TerminalScreen.TerminalButton(), !isAscending ? new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.ascend"), XenoTechClient.onPress_ascend(thisTerminal, dummy)) : new TerminalScreen.TerminalButton(), !isDescending ? new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.descend"), XenoTechClient.onPress_descend(thisTerminal, dummy)) : new TerminalScreen.TerminalButton(), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.forward"), XenoTechClient.onPress_forward(thisTerminal, dummy)), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.45_left"), XenoTechClient.onPress_45left(thisTerminal, dummy)), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.45_right"), XenoTechClient.onPress_45right(thisTerminal, dummy)), new TerminalScreen.TerminalButton(), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.back"), XenoTechClient.onPress_autopilot_back(thisTerminal)), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit(1);
                resumeAtAutopilot = true;
            }
        };
    }

    public static Button.OnPress onPress_captainsOptions(final TerminalScreen thisTerminal, final DummyEntity dummy) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                List<TerminalScreen.TerminalButton> buttons = Stream.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.rename_ship"), XenoTechClient.onPress_rename(thisTerminal, dummy)), new TerminalScreen.TerminalButton(), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.digitize"), XenoTechClient.onPress_digitize(thisTerminal, dummy)), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.disassemble"), XenoTechClient.onPress_disassemble(thisTerminal, dummy)), new TerminalScreen.TerminalButton(), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.back"), XenoTechClient.onPress_autopilot_back(thisTerminal)), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal))).collect(Collectors.toList());
                if (dummy.hasDrill) {
                    if (dummy.isDrillEnabled()) {
                        buttons.add(2, new TerminalScreen.TerminalButton());
                        buttons.add(2, new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.disable_drill"), XenoTechClient.onPress_disableDrill(thisTerminal, dummy)));
                    } else {
                        buttons.add(2, new TerminalScreen.TerminalButton());
                        buttons.add(2, new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.enable_drill"), XenoTechClient.onPress_enableDrill(thisTerminal, dummy)));
                    }
                }
                if (dummy.hasBuzzsaw) {
                    if (dummy.isBuzzsawEnabled()) {
                        buttons.add(2, new TerminalScreen.TerminalButton());
                        buttons.add(2, new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.disable_buzzsaw"), XenoTechClient.onPress_disableBuzzsaw(thisTerminal, dummy)));
                    } else {
                        buttons.add(2, new TerminalScreen.TerminalButton());
                        buttons.add(2, new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.enable_buzzsaw"), XenoTechClient.onPress_enableBuzzsaw(thisTerminal, dummy)));
                    }
                }
                if (!dummy.weaponAssignments.isEmpty()) {
                    if (dummy.isWeaponsEnabled()) {
                        buttons.add(2, new TerminalScreen.TerminalButton());
                        buttons.add(2, new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.disable_weapons"), XenoTechClient.onPress_disableWeapons(thisTerminal, dummy)));
                    } else {
                        buttons.add(2, new TerminalScreen.TerminalButton());
                        buttons.add(2, new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.enable_weapons"), XenoTechClient.onPress_enableWeapons(thisTerminal, dummy)));
                    }
                }
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.awaiting_selection"), buttons));
                thisTerminal.reinit(1);
            }
        };
    }

    public static Button.OnPress onPress_assumeDirectControl(final TerminalScreen thisTerminal, final DummyEntity dummy) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                Minecraft.m_91087_().m_91152_(null);
                XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.SHIP_TAKE_CONTROL, dummy, thisTerminal.pos));
            }
        };
    }

    private static void appendBlockWeights(DummyEntity dummy, StringBuilder sb) {
        HashMap<Block, Integer> blockCountMap = new HashMap<Block, Integer>();
        for (RenderableBlock renderableBlock : dummy.renderables) {
            BlockState blockState = renderableBlock.state;
            Integer count = (Integer)blockCountMap.get(blockState.m_60734_());
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            blockCountMap.put(blockState.m_60734_(), count);
        }
        TreeMap weightsPerBlock = new TreeMap(Collections.reverseOrder());
        for (Map.Entry entry : blockCountMap.entrySet()) {
            int weight = (int)((float)((Integer)entry.getValue()).intValue() * XenoTechUtils.getWeightForBlock(((Block)entry.getKey()).m_49966_()));
            weightsPerBlock.put(weight, (Block)entry.getKey());
        }
        int n = 5;
        String string = Component.m_237110_((String)"terminal.xenotech.top_x_block_weights", (Object[])new Object[]{n}).getString();
        sb.append(string + ": \n");
        int shown = 0;
        for (Map.Entry entry : weightsPerBlock.entrySet()) {
            sb.append("  ");
            sb.append(((Block)entry.getValue()).m_49954_().getString());
            sb.append(": ");
            int weight = (Integer)entry.getKey();
            sb.append(XenoTechUtils.getImperialOrMetricWeightText(weight));
            sb.append(" \n");
            if (++shown < n) continue;
            break;
        }
    }

    public static Button.OnPress onPress_viewShipStats(final TerminalScreen thisTerminal, final DummyEntity dummy) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                XenoTechUtils.MoverStats copy = new XenoTechUtils.MoverStats();
                copy.acceleration = 9999.0f;
                copy.topSpeed = 9999.0f;
                copy.moverBlockType = dummy.moverStats.moverBlockType;
                XenoTechUtils.limitMaxPowerForMover(copy, false, dummy.vehicleType);
                XenoTechUtils.MoverStats liftCopy = new XenoTechUtils.MoverStats();
                liftCopy.acceleration = 9999.0f;
                liftCopy.topSpeed = 9999.0f;
                liftCopy.moverBlockType = dummy.liftMoverStats.moverBlockType;
                XenoTechUtils.limitMaxPowerForMover(liftCopy, true, dummy.vehicleType);
                StringBuilder sb = new StringBuilder();
                String weightTxt = Component.m_237115_((String)"terminal.xenotech.weight").getString();
                sb.append(weightTxt + " = ");
                sb.append(XenoTechUtils.getImperialOrMetricWeightText(dummy.weight));
                sb.append(" \n");
                String accelText = Component.m_237115_((String)"terminal.xenotech.accel").getString();
                sb.append(accelText + " = ");
                float maxAccelPerSec = copy.acceleration * 20.0f * 20.0f;
                float currentAccelPerSec = dummy.moverStats.acceleration * 20.0f * 20.0f;
                sb.append(String.format("%,.2f", Float.valueOf(currentAccelPerSec)));
                String perSecondText = Component.m_237115_((String)"terminal.xenotech.per_second").getString();
                sb.append(" b/s " + perSecondText);
                String maxForText = Component.m_237115_((String)"terminal.xenotech.max_for").getString();
                if (dummy.moverStats.moverBlockType != null && (double)Math.abs(currentAccelPerSec - maxAccelPerSec) <= 0.01) {
                    String engineName = dummy.moverStats.moverBlockType.m_49954_().getString();
                    if (dummy.moverStats.moverBlockType instanceof SailBlock) {
                        engineName = "Sail";
                    }
                    sb.append(" (" + maxForText + " " + engineName + ")");
                }
                sb.append(" \n");
                String topSpeedText = Component.m_237115_((String)"terminal.xenotech.top_speed").getString();
                sb.append(topSpeedText + " = ");
                float maxBps = copy.topSpeed * 20.0f;
                float currentBps = dummy.moverStats.topSpeed * 20.0f;
                sb.append(String.format("%,.1f", Float.valueOf(currentBps)));
                sb.append(" b/s");
                if (dummy.moverStats.moverBlockType != null && (double)Math.abs(currentBps - maxBps) <= 0.01) {
                    String engineName = dummy.moverStats.moverBlockType.m_49954_().getString();
                    if (dummy.moverStats.moverBlockType instanceof SailBlock) {
                        engineName = "Sail";
                    }
                    sb.append(" (" + maxForText + " " + engineName + ")");
                }
                sb.append(" \n");
                if (dummy.liftMoverStats.acceleration > 0.0f) {
                    String liftAccelText = Component.m_237115_((String)"terminal.xenotech.lift_accel").getString();
                    sb.append(liftAccelText + " = ");
                    float liftMaxAccelPerSec = liftCopy.acceleration * 20.0f * 20.0f;
                    float liftCurrentAccelPerSec = dummy.liftMoverStats.acceleration * 20.0f * 20.0f;
                    sb.append(String.format("%,.2f", Float.valueOf(liftCurrentAccelPerSec)));
                    sb.append(" b/s " + perSecondText);
                    if (dummy.liftMoverStats.moverBlockType != null && (double)Math.abs(liftCurrentAccelPerSec - liftMaxAccelPerSec) <= 0.01) {
                        String engineName = dummy.liftMoverStats.moverBlockType.m_49954_().getString();
                        if (dummy.liftMoverStats.moverBlockType instanceof SailBlock) {
                            engineName = "Sail";
                        }
                        sb.append(" (" + maxForText + " " + engineName + ")");
                    }
                    sb.append(" \n");
                    String liftTopSpeedText = Component.m_237115_((String)"terminal.xenotech.lift_top_speed").getString();
                    sb.append(liftTopSpeedText + " = ");
                    float liftMaxBps = liftCopy.topSpeed * 20.0f;
                    float liftCurrentBps = dummy.liftMoverStats.topSpeed * 20.0f;
                    sb.append(String.format("%,.1f", Float.valueOf(liftCurrentBps)));
                    sb.append(" b/s");
                    if (dummy.liftMoverStats.moverBlockType != null && (double)Math.abs(liftCurrentBps - liftMaxBps) <= 0.01) {
                        String engineName = dummy.liftMoverStats.moverBlockType.m_49954_().getString();
                        if (dummy.liftMoverStats.moverBlockType instanceof SailBlock) {
                            engineName = "Sail";
                        }
                        sb.append(" (" + maxForText + " " + engineName + ")");
                    }
                    sb.append(" \n");
                }
                String blockCountText = Component.m_237115_((String)"terminal.xenotech.block_count").getString();
                sb.append(blockCountText + " = ");
                sb.append(dummy.renderables.size());
                sb.append(" \n");
                String moverCountText = Component.m_237115_((String)"terminal.xenotech.mover_count").getString();
                sb.append(moverCountText + " = ");
                sb.append(dummy.moverStats.moverCount);
                sb.append(" ");
                if (dummy.moverStats.moverBlockType != null) {
                    sb.append(dummy.moverStats.moverBlockType.m_49954_().getString());
                }
                sb.append(" \n");
                if (dummy.liftMoverStats.acceleration > 0.0f) {
                    String liftMoverText = Component.m_237115_((String)"terminal.xenotech.lift_mover_count").getString();
                    sb.append(liftMoverText + " = ");
                    sb.append(dummy.liftMoverStats.moverCount);
                    sb.append(" ");
                    if (dummy.liftMoverStats.moverBlockType != null) {
                        sb.append(dummy.liftMoverStats.moverBlockType.m_49954_().getString());
                    }
                    sb.append(" \n");
                }
                String timeUntilEmpty = this.getTimeTextFromSecondsMetric(dummy.getMetric_TimeUntilEmpty());
                String timeConsumingFuel = this.getTimeTextFromSecondsMetric(dummy.getMetric_TimeSpentConsumingFuel());
                String blocksTraveledText = Component.m_237115_((String)"terminal.xenotech.blocks_traveled").getString();
                String untilEmptyFuelText = Component.m_237115_((String)"terminal.xenotech.until_empty_fuel").getString();
                String timeConsumingFuelText = Component.m_237115_((String)"terminal.xenotech.time_consuming_fuel").getString();
                String createdText = Component.m_237115_((String)"terminal.xenotech.created").getString();
                String creatorText = Component.m_237115_((String)"terminal.xenotech.creator").getString();
                sb.append(" \n");
                sb.append(blocksTraveledText + ": " + dummy.getMetric_BlocksTravelled() + " \n");
                sb.append(untilEmptyFuelText + ": " + timeUntilEmpty + " \n");
                sb.append(timeConsumingFuelText + ": " + timeConsumingFuel + " \n");
                sb.append(createdText + ": " + dummy.getMetric_CreationDate() + " \n");
                sb.append(creatorText + ": " + dummy.getMetric_CreatorName() + " \n");
                sb.append(" \n");
                XenoTechClient.appendBlockWeights(dummy, sb);
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.ship_nav_computer").getString() + sb.toString(), List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.back"), TerminalScreen.onPress_back(thisTerminal)), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit(1);
            }

            private String getTimeTextFromSecondsMetric(long metric) {
                long days = metric / 86400L;
                long hours = metric / 3600L;
                long minutes = metric / 60L;
                long seconds = metric;
                Object result = "";
                if (days > 0L) {
                    long remainderHours = metric % 86400L / 3600L;
                    result = days + " days, " + remainderHours + " hours";
                } else if (hours > 0L) {
                    long remainderMins = metric % 3600L / 60L;
                    result = hours + " hours, " + remainderMins + " mins";
                } else if (minutes > 0L) {
                    long remainderSecs = metric % 60L;
                    result = minutes + " mins, " + remainderSecs + " secs";
                } else {
                    result = seconds + " secs";
                }
                return result;
            }
        };
    }

    public static Button.OnPress onPress_scuttle(final TerminalScreen thisTerminal, final DummyEntity dummy) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.termination_in_progress"), List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit(1);
                XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.SHIP_SCUTTLE, dummy, thisTerminal.pos));
            }
        };
    }

    public static Button.OnPress onPress_rename(final TerminalScreen thisTerminal, final DummyEntity dummy) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.new_ship_name"), List.of(new TerminalScreen.TerminalButton(), new TerminalScreen.TerminalButton(), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.accept"), TerminalScreen.onPress_acceptNewShipName(thisTerminal, dummy)), new TerminalScreen.TerminalButton(), new TerminalScreen.TerminalButton(), new TerminalScreen.TerminalButton(), new TerminalScreen.TerminalButton(), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.cancel"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit(1);
                thisTerminal.addShipNameBox(dummy);
            }
        };
    }

    public static Button.OnPress onPress_digitize(final TerminalScreen thisTerminal, final DummyEntity dummy) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.digitization_in_progress"), List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit(1);
                XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.SHIP_DIGITIZE, dummy, thisTerminal.pos));
            }
        };
    }

    public static Button.OnPress onPress_disableDrill(final TerminalScreen thisTerminal, final DummyEntity dummy) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.drill_is_disabled"), List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit(1);
                XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.SHIP_DISABLE_DRILL, dummy, thisTerminal.pos));
            }
        };
    }

    public static Button.OnPress onPress_enableDrill(final TerminalScreen thisTerminal, final DummyEntity dummy) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.drill_is_enabled"), List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit(1);
                XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.SHIP_ENABLE_DRILL, dummy, thisTerminal.pos));
            }
        };
    }

    public static Button.OnPress onPress_disableBuzzsaw(final TerminalScreen thisTerminal, final DummyEntity dummy) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.buzzsaw_is_disabled"), List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit(1);
                XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.SHIP_DISABLE_BUZZSAW, dummy, thisTerminal.pos));
            }
        };
    }

    public static Button.OnPress onPress_enableBuzzsaw(final TerminalScreen thisTerminal, final DummyEntity dummy) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.buzzsaw_is_enabled"), List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit(1);
                XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.SHIP_ENABLE_BUZZSAW, dummy, thisTerminal.pos));
            }
        };
    }

    public static Button.OnPress onPress_disableWeapons(final TerminalScreen thisTerminal, final DummyEntity dummy) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.weapons_disabled"), List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit(1);
                XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.SHIP_DISABLE_WEAPONS, dummy, thisTerminal.pos));
            }
        };
    }

    public static Button.OnPress onPress_enableWeapons(final TerminalScreen thisTerminal, final DummyEntity dummy) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.weapons_enabled"), List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit(1);
                XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.SHIP_ENABLE_WEAPONS, dummy, thisTerminal.pos));
            }
        };
    }

    public static Button.OnPress onPress_toggleInvisTerminal(final TerminalScreen thisTerminal, DummyEntity dummy) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                XenoTechConfig.CLIENT.terminalVisibleWhilePiloted.set((Object)(!DummyEntity.terminalVisibleWhilePiloted ? 1 : 0));
                recentlyToggledInvis = true;
                String terminalStatusText = "Terminal will now be visible while piloting.";
                if (Boolean.FALSE.equals(DummyEntity.terminalVisibleWhilePiloted)) {
                    terminalStatusText = "Terminal will now be hidden while piloting.";
                }
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.confirmed").getString() + terminalStatusText, List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.back"), TerminalScreen.onPress_back(thisTerminal)), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit();
            }
        };
    }

    public static Button.OnPress onPress_disassemble(final TerminalScreen thisTerminal, final DummyEntity dummy) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                boolean canDisassemble = false;
                Float disassemblyRot = dummy.getDisassemblyRotation();
                String disassemblyText = Component.m_237115_((String)"terminal.xenotech.impossible_please_relocate").getString();
                if (disassemblyRot != null) {
                    canDisassemble = true;
                    Rotation rotation = dummy.getBlockStateRotationForDisassembly(dummy.get90DegreeDisassemblyAngle(), disassemblyRot.floatValue());
                    if (rotation == Rotation.NONE) {
                        disassemblyText = Component.m_237115_((String)"terminal.xenotech.possible_at_current_location").getString();
                    } else if (rotation == Rotation.CLOCKWISE_90) {
                        disassemblyText = Component.m_237115_((String)"terminal.xenotech.possible_with_90_clockwise_rotation").getString();
                    } else if (rotation == Rotation.CLOCKWISE_180) {
                        disassemblyText = Component.m_237115_((String)"terminal.xenotech.possible_with_180_clockwise_rotation").getString();
                    } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                        disassemblyText = Component.m_237115_((String)"terminal.xenotech.possible_with_270_clockwise_rotation").getString();
                    }
                }
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.disassembly_is").getString() + disassemblyText, List.of(canDisassemble ? new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.yes"), XenoTechClient.onPress_disassembleConfirm(thisTerminal, dummy)) : new TerminalScreen.TerminalButton(), canDisassemble ? new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.no"), TerminalScreen.onPress_back(thisTerminal)) : new TerminalScreen.TerminalButton(), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit(1);
            }
        };
    }

    public static Button.OnPress onPress_disassembleConfirm(final TerminalScreen thisTerminal, final DummyEntity dummy) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.disassembly_in_progress"), List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit(1);
                XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.SHIP_DISASSEMBLE, dummy, thisTerminal.pos));
            }
        };
    }

    @SubscribeEvent
    public void onRightClick(InputEvent.MouseButton.Post e) {
        if (Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        if (e.getButton() == 0) {
            isLeftMouseDown = e.getAction() == 1;
        }
        if (e.getButton() == 1) {
            if (e.getAction() == 1) {
                isRightMouseDown = true;
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player == null) {
                    return;
                }
                Vec3 vec3 = player.m_146892_();
                Vec3 vec31 = player.m_20252_(1.0f);
                double distMult = 2.5;
                Vec3 vec32 = vec3.m_82520_(vec31.f_82479_ * distMult, vec31.f_82480_ * distMult, vec31.f_82481_ * distMult);
                EntityHitResult entityhitresult = ProjectileUtil.m_150175_((Level)player.m_9236_(), (Entity)player, (Vec3)vec3, (Vec3)vec32, (AABB)new AABB(vec3, vec32).m_82400_(1.0), testEntity -> !testEntity.m_5833_() && testEntity instanceof DummyEntity, (float)0.0f);
                boolean foundTargetEntity = true;
                if (entityhitresult == null || entityhitresult.m_6662_() != HitResult.Type.ENTITY) {
                    foundTargetEntity = false;
                }
                if (foundTargetEntity) {
                    Entity entity;
                    if ((player.m_275832_() == null || DummyEntity.terminalVisibleWhilePiloted) && (entity = entityhitresult.m_82443_()) instanceof DummyEntity) {
                        DummyEntity dummy = (DummyEntity)entity;
                        if (dummy.renderables.size() > 0) {
                            TerminalScreen terminal = new TerminalScreen(dummy.m_20183_());
                            terminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.awaiting_selection"), List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.autopilot"), XenoTechClient.onPress_autopilot(terminal, dummy)), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.assume_direct_control"), XenoTechClient.onPress_assumeDirectControl(terminal, dummy)), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.view_ship_stats"), XenoTechClient.onPress_viewShipStats(terminal, dummy)), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.captains_options"), XenoTechClient.onPress_captainsOptions(terminal, dummy)), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(terminal)))));
                            terminal.setTypeSpeedOverride(1);
                            if (Minecraft.m_91087_().f_91080_ == null) {
                                Minecraft.m_91087_().m_91152_((Screen)terminal);
                                if (resumeAtAutopilot) {
                                    XenoTechClient.onPress_autopilot(terminal, dummy).m_93750_(null);
                                }
                            } else {
                                Minecraft.m_91087_().m_91152_((Screen)terminal);
                            }
                        }
                    }
                } else {
                    boolean enableBlockClicks = true;
                    if (enableBlockClicks) {
                        DummyEntity closest = null;
                        closest = DummyEntity.getNearestDummyEntityConsideringBoundingBox((Entity)player);
                        if (closest == null) {
                            return;
                        }
                        boolean nearby = closest.entityIsNearby((Entity)player);
                        if (!nearby) {
                            return;
                        }
                        float centerDistanceThreshold = 0.5f;
                        float centerDistanceThresholdSqr = centerDistanceThreshold * centerDistanceThreshold;
                        Vec3 viewVec = player.m_20252_(1.0f);
                        float scaleIncrement = 0.4f;
                        for (float scale = 0.0f; scale <= 4.0f; scale += scaleIncrement) {
                            Vec3 rightClickPos = player.m_146892_().m_82549_(viewVec.m_82490_((double)scale));
                            BlockPos rightClickBlockPos = BlockPos.m_274446_((Position)rightClickPos);
                            if (closest == null || closest.renderables == null || closest.renderables.isEmpty()) continue;
                            RenderableBlock closestBlock = null;
                            for (RenderableBlock renderable : closest.renderables) {
                                boolean realDistMatch;
                                Vec3 rotPos = XenoTechUtils.getRotPosForRenderable(closest, renderable);
                                BlockPos blockRotPos = XenoTechUtils.blockPosFromRotPos(rotPos);
                                Vec3 centerRotPos = rotPos.m_82520_(0.5, 0.5, 0.5);
                                double realDist = rightClickPos.m_82557_(centerRotPos);
                                if (renderable.state.m_60713_(Blocks.f_50486_)) {
                                    // empty if block
                                }
                                boolean blockPosMatch = blockRotPos.equals((Object)rightClickBlockPos);
                                boolean bl = realDistMatch = realDist <= this.renderableInteractDistanceSqr;
                                if (!blockPosMatch && !realDistMatch) continue;
                                closestBlock = renderable;
                                int result = this.processOneRenderable(closest, rightClickPos, closestBlock);
                                if (result == CLICKRESULT_SUCCESS) {
                                    return;
                                }
                                if (result != CLICKRESULT_DOOR_SKIP) continue;
                            }
                        }
                    }
                }
            } else {
                isRightMouseDown = false;
            }
        }
    }

    private int processOneRenderable(DummyEntity closest, Vec3 rightClickPos, RenderableBlock closestBlock) {
        if (closestBlock != null) {
            Vec3 foundRotPos = XenoTechUtils.getRotPosForRenderable(closest, closestBlock);
            LOGGER.debug("closestBlock=" + closestBlock + " with rotPos=" + foundRotPos);
            double distanceSqrToClickedPos = foundRotPos.m_82557_(rightClickPos);
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            BlockPos blockRotPos = XenoTechUtils.blockPosFromRotPos(foundRotPos);
            BlockHitResult bhr = new BlockHitResult(foundRotPos, player.m_6350_(), blockRotPos, false);
            if (!closestBlock.state.m_60713_((Block)XenoBlocks.BLOCK_SHIP_TERMINAL.get())) {
                Object tempEntity = null;
                Object chunk = null;
                boolean playerHoldingBow = Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof BowItem || Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof BowItem;
                boolean isTrapdoor = closestBlock.state.m_60734_() instanceof TrapDoorBlock;
                boolean isDoor = closestBlock.state.m_60734_() instanceof DoorBlock;
                boolean isBed = closestBlock.state.m_60734_() instanceof BedBlock;
                boolean isCraftingTable = closestBlock.state.m_60734_() instanceof CraftingTableBlock;
                boolean isDriverSeat = closestBlock.state.m_60734_() instanceof DriverSeatBlock;
                if (isDoor || closestBlock.state.m_155947_() && DummyEntity.enableBlockEntitiesOnboard || isCraftingTable || isDriverSeat || isTrapdoor) {
                    DummyEntity.doBlockStateOverride = true;
                    LOGGER.debug("float rotPos=" + foundRotPos + " with angle=" + closest.getYRotDiff());
                    LOGGER.debug("Use block=" + closestBlock.state + " with blockRotPos=" + bhr.m_82425_() + " with networkPos=" + closestBlock.pos);
                    if (!(isDoor || isBed || isTrapdoor)) {
                        closestBlock.state.m_60664_(player.m_9236_(), (Player)player, InteractionHand.MAIN_HAND, bhr);
                    }
                    DummyEntity.doBlockStateOverride = DummyEntity.debug_alwaysShowBlockState;
                    if (isDoor && (distanceSqrToClickedPos > this.doorInteractDistanceSqr || playerHoldingBow)) {
                        return CLICKRESULT_DOOR_SKIP;
                    }
                    XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundRenderableInteractPacket(closest, closestBlock.pos));
                    return CLICKRESULT_SUCCESS;
                }
            }
        }
        return CLICKRESULT_MISS;
    }

    private void renderRect(PoseStack matrixStack, int x, int y, int width, int height) {
        int alpha = 255;
        int r = 249;
        int g = 8;
        int b = 40;
        Integer alarmClockTextColorR = 255;
        Integer alarmClockTextColorG = 0;
        Integer alarmClockTextColorB = 0;
        if (alarmClockTextColorR != null) {
            r = alarmClockTextColorR;
        }
        if (alarmClockTextColorG != null) {
            g = alarmClockTextColorG;
        }
        if (alarmClockTextColorB != null) {
            b = alarmClockTextColorB;
        }
        int combinedColor = alpha << 24 | r << 16 | g << 8 | b;
        if (Minecraft.m_91087_().m_91269_().m_110104_() != null) {
            GuiGraphics graphics = new GuiGraphics(Minecraft.m_91087_(), Minecraft.m_91087_().m_91269_().m_110104_());
            graphics.m_280168_().m_166856_();
            graphics.m_280168_().m_252931_(matrixStack.m_85850_().m_252922_());
            graphics.m_285944_(RenderType.m_285907_(), x + width, y + height, x, y, combinedColor);
            graphics.m_280262_();
        }
    }

    @SubscribeEvent
    public void onRenderHand(RenderHandEvent renderHandEvent) {
        ItemStack itemStack = renderHandEvent.getItemStack();
        if (itemStack.m_150930_((Item)XenoBlocks.ITEM_STASIS_GUN.get())) {
            long timeDiff;
            long timestamp = System.currentTimeMillis();
            if (renderHandEvent.getHand() != this.lastHand) {
                this.lastItemTimestamp = timestamp;
                this.lastHand = renderHandEvent.getHand();
            }
            if (!((timeDiff = timestamp - this.lastItemTimestamp) <= 250L || Minecraft.m_91087_().f_91074_.f_20911_ && renderHandEvent.getHand() == InteractionHand.MAIN_HAND)) {
                PoseStack poseStack = renderHandEvent.getPoseStack();
                Entity stored = DummyEntity.entityFromNbt((Level)Minecraft.m_91087_().f_91073_, itemStack.m_41783_());
                long entityTimestamp = 0L;
                if (itemStack != null && itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("EntityTimestamp")) {
                    entityTimestamp = itemStack.m_41783_().m_128454_("EntityTimestamp");
                }
                long entityTimestampDiff = timestamp - entityTimestamp;
                double xOffset = 0.42f;
                if (renderHandEvent.getHand() == InteractionHand.OFF_HAND) {
                    xOffset = -xOffset;
                }
                if (stored != null && entityTimestampDiff >= 3400L) {
                    poseStack.m_85836_();
                    poseStack.m_85837_(xOffset, -0.24, -0.43);
                    float bbHeight = stored.m_20206_();
                    AABB bb = stored.m_20191_();
                    float xSize = (float)(bb.f_82291_ - bb.f_82288_);
                    float zSize = (float)(bb.f_82293_ - bb.f_82290_);
                    if (xSize > bbHeight) {
                        bbHeight = xSize;
                    }
                    if (zSize > bbHeight) {
                        bbHeight = zSize;
                    }
                    float scaleForNormalHeight = 0.05f;
                    float normalHeight = 2.0f;
                    float calculatedScale = scaleForNormalHeight * normalHeight / bbHeight;
                    poseStack.m_85841_(calculatedScale, calculatedScale, calculatedScale);
                    float facing = 0.0f;
                    if (stored instanceof LivingEntity) {
                        LivingEntity le = (LivingEntity)stored;
                        le.f_20883_ = facing;
                        le.f_20884_ = facing;
                        le.f_20885_ = facing;
                        le.f_20886_ = facing;
                        int twitchTick = 15;
                        if (clientTick % (long)twitchTick == 0L || clientTick % (long)(twitchTick + 1) == 0L) {
                            if (this.twitchRand < 0.0) {
                                this.twitchRand = Math.random();
                                this.twitchRandReverse = Math.random();
                                this.twitchRandAmplitude = Math.random();
                            }
                            if (this.twitchRand < 0.33) {
                                float twitchValue = (float)(this.twitchRandAmplitude * 15.0 * 2.0 - 15.0);
                                if (this.twitchRandReverse < 0.5) {
                                    twitchValue = -twitchValue;
                                }
                                le.f_20884_ = facing + twitchValue;
                                le.f_20886_ = facing + twitchValue;
                            }
                        } else {
                            this.twitchRand = -1.0;
                        }
                    }
                    float partialTicks = 0.0f;
                    int packedLight = 0xF00000;
                    EntityRenderer renderer = (EntityRenderer)Minecraft.m_91087_().m_91290_().f_114362_.get(stored.m_6095_());
                    DummyRenderer.isDummyRender = true;
                    renderer.m_7392_(stored, 0.0f, partialTicks, poseStack, renderHandEvent.getMultiBufferSource(), packedLight);
                    DummyRenderer.isDummyRender = false;
                    poseStack.m_85849_();
                }
                int renderHp = -1;
                int renderHpMax = -1;
                Item zSize = itemStack.m_41720_();
                if (zSize instanceof StasisGunItem) {
                    StasisGunItem stasis = (StasisGunItem)zSize;
                    if (stasis.lastTargetedEntityIdMap.get(Minecraft.m_91087_().f_91074_) != null && stasis.lastTargetedEntityIdMap.get(Minecraft.m_91087_().f_91074_) != -1) {
                        renderHp = stasis.entityHealthRemainingMap.get(Minecraft.m_91087_().f_91074_);
                        renderHpMax = stasis.entityMaxHealthMap.get(Minecraft.m_91087_().f_91074_);
                    }
                }
                if (renderHp != -1) {
                    xOffset = 0.31f;
                    poseStack.m_85836_();
                    float pct = 1.0f - (float)renderHp / (float)renderHpMax;
                    float xScale = 0.2f * pct;
                    float zpDegrees = -1.95f;
                    if (renderHandEvent.getHand() == InteractionHand.OFF_HAND) {
                        xOffset = -xOffset;
                        xScale = -xScale;
                        zpDegrees = -zpDegrees;
                    }
                    BlockState renderState = null;
                    renderState = (double)pct <= 0.33 ? Blocks.f_50504_.m_49966_() : ((double)pct <= 0.66 ? Blocks.f_50494_.m_49966_() : Blocks.f_50495_.m_49966_());
                    poseStack.m_85837_(Math.random(), Math.random(), Math.random());
                    poseStack.m_85841_(0.01f, 0.01f, 0.01f);
                    RenderSystem.enableDepthTest();
                    this.renderRect(poseStack, 0, 0, 4, 4);
                    poseStack.m_85849_();
                }
            }
        } else {
            ItemStack mainHand = Minecraft.m_91087_().f_91074_.m_21205_();
            ItemStack offHand = Minecraft.m_91087_().f_91074_.m_21206_();
            if (!mainHand.m_150930_((Item)XenoBlocks.ITEM_STASIS_GUN.get()) && !offHand.m_150930_((Item)XenoBlocks.ITEM_STASIS_GUN.get())) {
                this.lastItemTimestamp = System.currentTimeMillis();
            }
        }
        if (this.playerIsMountingGun()) {
            renderHandEvent.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onInteractEvent(PlayerInteractEvent interactEvent) {
        if (Minecraft.m_91087_() != null) {
            if (Minecraft.m_91087_().f_91074_ != null) {
                if (this.playerIsMountingGun() || this.weaponsReady(Minecraft.m_91087_().f_91074_.m_275832_())) {
                    if ((interactEvent instanceof PlayerInteractEvent.LeftClickBlock || interactEvent instanceof PlayerInteractEvent.LeftClickEmpty) && interactEvent.isCancelable()) {
                        interactEvent.setCanceled(true);
                    }
                    if ((interactEvent instanceof PlayerInteractEvent.RightClickBlock || interactEvent instanceof PlayerInteractEvent.RightClickEmpty) && interactEvent.isCancelable()) {
                        interactEvent.setCanceled(true);
                    }
                }
            } else {
                Log.error((Object[])new Object[]{"onInteractEvent: Minecraft local player is null: " + interactEvent});
            }
        }
    }

    private boolean playerIsMountingGun() {
        Entity entity;
        if (Minecraft.m_91087_().f_91074_ != null && (entity = Minecraft.m_91087_().f_91074_.m_275832_()) instanceof DummyEntity) {
            DummyEntity dummy = (DummyEntity)entity;
            if (dummy.thisMountedGun != null && dummy.thisMountedGun.canEverFire) {
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public void renderOverlayEvent(RenderGuiOverlayEvent.Pre overlayEvent) {
        if (overlayEvent.getOverlay() == VanillaGuiOverlay.CROSSHAIR.type()) {
            boolean mountingGun = this.playerIsMountingGun();
            boolean wr = false;
            if (!mountingGun) {
                wr = this.weaponsReady(Minecraft.m_91087_().f_91074_.m_275832_());
            }
            if ((this.playerIsMountingGun() || wr) && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
                overlayEvent.setCanceled(true);
                int movementFactor = 0;
                boolean useMovementSpread = true;
                boolean useAdsSpread = true;
                if (useMovementSpread) {
                    Vec3 movement = Minecraft.m_91087_().f_91074_.m_20184_();
                    movementFactor = (int)((movement.f_82479_ * movement.f_82479_ + movement.f_82481_ * movement.f_82481_) / 0.002);
                }
                GuiGraphics graphics = new GuiGraphics(Minecraft.m_91087_(), Minecraft.m_91087_().m_91269_().m_110104_());
                if (useAdsSpread && !wr && !isRightMouseDown) {
                    this.drawSizedCrosshair(overlayEvent.getGuiGraphics(), 5 + movementFactor, 3);
                } else {
                    this.drawSizedCrosshair(overlayEvent.getGuiGraphics(), 2 + movementFactor, 3);
                }
            }
        }
        if (overlayEvent.getOverlay() == VanillaGuiOverlay.HOTBAR.type()) {
            DummyEntity carrier = DummyEntity.getDummyEntityForCarried((Entity)Minecraft.m_91087_().f_91074_);
            Entity movementFactor = Minecraft.m_91087_().f_91074_.m_275832_();
            if (movementFactor instanceof DummyEntity) {
                DummyEntity dummy;
                carrier = dummy = (DummyEntity)movementFactor;
            }
            if (carrier != null && carrier.isOutOfFuel()) {
                MutableComponent component1 = MutableComponent.m_237204_((ComponentContents)new LiteralContents("Out of fuel!")).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)));
                overlayEvent.getGuiGraphics().m_280614_(Minecraft.m_91087_().f_91062_, (Component)component1, (int)((float)overlayEvent.getWindow().m_85445_() * 0.3f), (int)((float)overlayEvent.getWindow().m_85446_() * 0.35f), 0, true);
            }
            if (carrier != null && carrier.hasDrill && !carrier.isDrillEnabled()) {
                MutableComponent component1 = MutableComponent.m_237204_((ComponentContents)new LiteralContents("Drill disabled")).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF)));
                overlayEvent.getGuiGraphics().m_280614_(Minecraft.m_91087_().f_91062_, (Component)component1, (int)((float)overlayEvent.getWindow().m_85445_() * 0.1f), (int)((float)overlayEvent.getWindow().m_85446_() * 0.9f), 0, true);
            }
            if (carrier != null && carrier.hasBuzzsaw && !carrier.isBuzzsawEnabled()) {
                MutableComponent component1 = MutableComponent.m_237204_((ComponentContents)new LiteralContents("Buzzsaw disabled")).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF)));
                overlayEvent.getGuiGraphics().m_280614_(Minecraft.m_91087_().f_91062_, (Component)component1, (int)((float)overlayEvent.getWindow().m_85445_() * 0.1f), (int)((float)overlayEvent.getWindow().m_85446_() * 0.9f), 0, true);
            }
            if (carrier != null && !carrier.integratedWeapons.isEmpty() && !carrier.isWeaponsEnabled()) {
                MutableComponent component1 = MutableComponent.m_237204_((ComponentContents)new LiteralContents("Weapons disabled")).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF)));
                overlayEvent.getGuiGraphics().m_280614_(Minecraft.m_91087_().f_91062_, (Component)component1, (int)((float)overlayEvent.getWindow().m_85445_() * 0.1f), (int)((float)overlayEvent.getWindow().m_85446_() * 0.9f), 0, true);
            }
            if (carrier != null && carrier.m_6109_() && DummyEntity.freeFlightMode) {
                MutableComponent component1 = MutableComponent.m_237204_((ComponentContents)new LiteralContents("Free-flight (" + SHIP_FREE_FLIGHT_HOTKEY.getKey().m_84875_().getString() + ")")).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF)));
                overlayEvent.getGuiGraphics().m_280614_(Minecraft.m_91087_().f_91062_, (Component)component1, (int)((float)overlayEvent.getWindow().m_85445_() * 0.1f), (int)((float)overlayEvent.getWindow().m_85446_() * 0.9f), 0, true);
            }
            if (this.weaponsReady(carrier) && Minecraft.m_91087_().f_91074_.m_275832_() == carrier && Minecraft.m_91087_().f_91080_ == null) {
                MutableComponent component1;
                int rgb;
                String displayText;
                String intgText;
                boolean hasWeapon1 = false;
                boolean hasWeapon2 = false;
                if (carrier.weaponAssignments.size() >= 2) {
                    hasWeapon2 = true;
                    hasWeapon1 = true;
                } else if (carrier.weaponAssignments.size() >= 1) {
                    hasWeapon1 = true;
                }
                int redRgb = 0xFF0000;
                int whiteRgb = 0xFFFFFF;
                if (hasWeapon1) {
                    intgText = "Integrated ";
                    displayText = carrier.weaponAssignments.get((int)0).blockEntity.m_58900_().m_60734_().m_49954_().getString();
                    if (displayText.startsWith(intgText)) {
                        displayText = displayText.substring(intgText.length());
                    }
                    rgb = whiteRgb;
                    if (weapon1Active) {
                        rgb = redRgb;
                    }
                    component1 = MutableComponent.m_237204_((ComponentContents)new LiteralContents("[M1: " + displayText + "]")).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)rgb)));
                    overlayEvent.getGuiGraphics().m_280614_(Minecraft.m_91087_().f_91062_, (Component)component1, (int)((float)overlayEvent.getWindow().m_85445_() * 0.1f), (int)((float)overlayEvent.getWindow().m_85446_() * 0.9f), 0, true);
                }
                if (hasWeapon2) {
                    intgText = "Integrated ";
                    displayText = carrier.weaponAssignments.get((int)1).blockEntity.m_58900_().m_60734_().m_49954_().getString();
                    if (displayText.startsWith(intgText)) {
                        displayText = displayText.substring(intgText.length());
                    }
                    rgb = whiteRgb;
                    if (weapon2Active) {
                        rgb = redRgb;
                    }
                    component1 = MutableComponent.m_237204_((ComponentContents)new LiteralContents("[M2: " + displayText + "]")).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)rgb)));
                    overlayEvent.getGuiGraphics().m_280614_(Minecraft.m_91087_().f_91062_, (Component)component1, (int)((float)overlayEvent.getWindow().m_85445_() * 0.1f), (int)((float)overlayEvent.getWindow().m_85446_() * 0.94f), 0, true);
                }
            }
        }
    }

    private boolean weaponsReady(Entity carrierEntity) {
        if (carrierEntity instanceof DummyEntity) {
            DummyEntity carrier = (DummyEntity)carrierEntity;
            return carrier != null && !carrier.integratedWeapons.isEmpty() && carrier.playerRidingTicks >= 4 && carrier.isWeaponsEnabled();
        }
        return false;
    }

    @SubscribeEvent
    public void onRenderLevel(RenderLevelStageEvent renderLevelLastEvent) {
        PoseStack matrixStack;
        if (renderLevelLastEvent.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            DummyEntity.entityLastClientFrameTime = renderLevelLastEvent.getPartialTick();
            if (spellRenderStep < 0L) {
                return;
            }
            matrixStack = renderLevelLastEvent.getPoseStack();
            matrixStack.m_85836_();
            Vec3 cam = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            matrixStack.m_85837_(-cam.f_82479_, -cam.f_82480_, -cam.f_82481_);
            LocalPlayer entity = Minecraft.m_91087_().f_91074_;
            if (entity != null) {
                if (xInitial == 0.0 && yInitial == 0.0 && zInitial == 0.0) {
                    xInitial = entity.m_20185_();
                    yInitial = entity.m_20188_() - 0.05;
                    zInitial = entity.m_20189_();
                    yRot = entity.m_146908_();
                    xRot = entity.m_146909_();
                }
                matrixStack.m_85837_(xInitial, yInitial, zInitial);
                matrixStack.m_252781_(Axis.f_252392_.m_252977_(yRot));
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(xRot));
                double xOffset = -0.25;
                if (mirrorSpellRenderX) {
                    xOffset = -xOffset;
                }
                double zOffset = 0.7;
                matrixStack.m_85837_(xOffset, 0.0, zOffset);
                if (DummyRenderer.lastEntity != null) {
                    Vec3 currentVec = new Vec3(xInitial, yInitial, zInitial);
                    Vec3 lastEntityVec = new Vec3(DummyRenderer.lastEntity.m_20185_(), DummyRenderer.lastEntity.m_20188_(), DummyRenderer.lastEntity.m_20189_());
                    Vec3 vec3 = lastEntityVec.m_82546_(currentVec);
                }
            } else {
                return;
            }
            long currentTime = System.currentTimeMillis();
            for (int i = 0; i < this.sparkRenderers.length; ++i) {
                if (this.sparkRenderers[i] == null) {
                    this.sparkRenderers[i] = new SparkRenderer();
                }
                if (spellRenderMax == 0L) {
                    spellRenderMax = this.sparkRenderers[i].getSpellRenderTimeMs();
                }
                if (spellRenderStep != 0L) continue;
                this.sparkRenderers[i].init();
            }
            spellRenderStep = currentTime - spellRenderStart;
            if (spellRenderStep > spellRenderMax) {
                xInitial = 0.0;
                yInitial = 0.0;
                zInitial = 0.0;
                spellRenderStep = -1L;
            }
            if (spellRenderStep != -1L) {
                for (SparkRenderer sparkRenderer : this.sparkRenderers) {
                    if (spellRenderStep > spellRenderMax) continue;
                    sparkRenderer.renderSpell(matrixStack, (float)spellRenderStep / (float)spellRenderMax);
                }
            }
            matrixStack.m_85849_();
        }
        if (renderLevelLastEvent.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            matrixStack = renderLevelLastEvent.getPoseStack();
            matrixStack.m_85836_();
            ArrayList<BulletHoleInfo> bulletHolesToRemove = new ArrayList<BulletHoleInfo>();
            try {
                Vec3 cam = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
                matrixStack.m_85837_(-cam.f_82479_, -cam.f_82480_, -cam.f_82481_);
                for (int i = 0; i < bulletHoles.size(); ++i) {
                    boolean timestampExpired;
                    BulletHoleInfo bulletHole = bulletHoles.get(i);
                    if (!Minecraft.m_91087_().f_91074_.m_9236_().m_46472_().m_135782_().toString().equals(bulletHole.dim) || !Minecraft.m_91087_().f_91074_.m_9236_().m_46749_(bulletHole.pos)) continue;
                    long timeDiff = System.currentTimeMillis() - bulletHole.timestamp;
                    boolean bl = timestampExpired = timeDiff > 30000L;
                    if (!Minecraft.m_91087_().f_91074_.m_9236_().m_8055_(bulletHole.pos).m_60795_() && !timestampExpired) {
                        matrixStack.m_85836_();
                        double yBoost = 0.0;
                        matrixStack.m_85837_(bulletHole.loc.f_82479_, bulletHole.loc.f_82480_ + yBoost, bulletHole.loc.f_82481_);
                        RenderSystem.setShader(GameRenderer::m_172817_);
                        ResourceLocation textureResourceLocation = null;
                        textureResourceLocation = bulletHole.holeNo == 0 ? this.BULLET_HOLE_1_TEX : (bulletHole.holeNo == 1 ? this.BULLET_HOLE_2_TEX : this.BULLET_HOLE_3_TEX);
                        if (bulletHole.facing == Direction.EAST) {
                            matrixStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                        } else if (bulletHole.facing == Direction.SOUTH) {
                            matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                        } else if (bulletHole.facing == Direction.WEST) {
                            matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                        } else if (bulletHole.facing == Direction.UP) {
                            matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                        } else if (bulletHole.facing == Direction.DOWN) {
                            matrixStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                        }
                        matrixStack.m_85837_(0.0, 0.0, -0.001);
                        if (bulletHole.randomDepth == null) {
                            double randomAvoidCollision = Math.random() * 0.001;
                            bulletHole.randomDepth = randomAvoidCollision;
                        }
                        matrixStack.m_85837_(0.0, 0.0, -bulletHole.randomDepth.doubleValue());
                        matrixStack.m_85837_(-0.08, -0.08, 0.0);
                        matrixStack.m_85841_(0.005f, 0.005f, 0.005f);
                        int brightness = Minecraft.m_91087_().f_91074_.m_9236_().m_46803_(bulletHole.pos.m_121945_(bulletHole.facing));
                        if (--brightness < 1) {
                            brightness = 1;
                        }
                        if (brightness > 8) {
                            brightness = 8;
                        }
                        float bright = (float)brightness / 15.0f;
                        RenderSystem.setShader(GameRenderer::m_172817_);
                        RenderSystem.setShaderColor((float)bright, (float)bright, (float)bright, (float)1.0f);
                        GuiGraphics graphics = new GuiGraphics(Minecraft.m_91087_(), Minecraft.m_91087_().m_91269_().m_110104_());
                        graphics.m_280168_().m_166856_();
                        graphics.m_280168_().m_252931_(matrixStack.m_85850_().m_252922_());
                        if (textureResourceLocation != null) {
                            graphics.m_280163_(textureResourceLocation, 0, 0, 0.0f, 0.0f, this.BULLET_HOLE_TEX_SIZE, this.BULLET_HOLE_TEX_SIZE, this.BULLET_HOLE_TEX_SIZE, this.BULLET_HOLE_TEX_SIZE);
                        }
                        matrixStack.m_85849_();
                        continue;
                    }
                    bulletHolesToRemove.add(bulletHole);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bulletHolesToRemove.size() > 0) {
                bulletHoles.removeAll(bulletHolesToRemove);
            }
            matrixStack.m_85849_();
        }
    }

    @SubscribeEvent
    public void entityRenderEvent(RenderLivingEvent.Post event) {
        LivingEntity e;
        ItemStack mainHand = Minecraft.m_91087_().f_91074_.m_21205_();
        ItemStack offHand = Minecraft.m_91087_().f_91074_.m_21206_();
        if ((mainHand.m_150930_((Item)XenoBlocks.ITEM_STASIS_GUN.get()) || offHand.m_150930_((Item)XenoBlocks.ITEM_STASIS_GUN.get())) && (e = event.getEntity()) instanceof LivingEntity) {
            LivingEntity le = e;
            float healthThreshold = le.m_21233_() * 0.5f;
            if (le.m_21223_() <= healthThreshold && le.m_21223_() > 0.0f && le.m_20202_() == null && !(e instanceof DummyEntity) && !(e instanceof Player) && !e.m_213877_() && !DummyRenderer.isDummyRender) {
                if (clientTick % 4L == 0L && !Minecraft.m_91087_().m_91104_()) {
                    if (!this.madeParticles) {
                        this.madeParticles = true;
                        double spanX = 0.8;
                        double spanY = 0.25;
                        double spanZ = 0.8;
                        double gotoSpanX = 0.2;
                        double gotoSpanY = 0.2;
                        double gotoSpanZ = 0.2;
                        int particleCount = 1;
                        for (int i = 0; i < particleCount; ++i) {
                            double randX = Math.random() * spanX * 2.0 - spanX;
                            double randY = Math.random() * spanY * 2.0 - spanY;
                            double randZ = Math.random() * spanZ * 2.0 - spanZ;
                            double gotoRandX = Math.random() * gotoSpanX * 2.0 - gotoSpanX;
                            double gotoRandY = Math.random() * gotoSpanY * 2.0 - gotoSpanY;
                            double gotoRandZ = Math.random() * gotoSpanZ * 2.0 - gotoSpanZ;
                            le.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123808_, le.m_20185_() + randX, le.m_20188_() + randY, le.m_20189_() + randZ, gotoRandX, gotoRandY, gotoRandZ);
                        }
                    }
                } else {
                    this.madeParticles = false;
                }
            }
        }
    }

    static {
        keyMappingToScanCodeMap.put(SHIP_DESCENT_HOTKEY, 341);
        keyMappingToScanCodeMap.put(SHIP_AUTO_LEFT_HOTKEY, 263);
        keyMappingToScanCodeMap.put(SHIP_AUTO_RIGHT_HOTKEY, 262);
        keyMappingToScanCodeMap.put(SHIP_AUTO_FORWARD_HOTKEY, 265);
        keyMappingToScanCodeMap.put(SHIP_AUTO_STOP_HOTKEY, 264);
        keyMappingToScanCodeMap.put(SHIP_AUTO_ASCEND_HOTKEY, 266);
        keyMappingToScanCodeMap.put(SHIP_AUTO_DESCEND_HOTKEY, 267);
        keyMappingToScanCodeMap.put(SHIP_HOVER_STRAFE_HOTKEY, 342);
        keyMappingToScanCodeMap.put(SHIP_FREE_FLIGHT_HOTKEY, 73);
        clientTick = 0L;
        pendingHitscanResults = new ArrayList<ServerboundHitscanArrayPacket.SingleHitscanResult>();
        oneGunActiveAtATime = false;
        weapon1Active = false;
        weapon2Active = false;
        xInitial = 0.0;
        yInitial = 0.0;
        zInitial = 0.0;
        yRot = 0.0f;
        xRot = 0.0f;
        spellRenderStep = -1L;
        spellRenderMax = 0L;
        spellRenderStart = 0L;
        isControlDown = false;
        isAltDown = false;
        resumeAtAutopilot = false;
        recentlyToggledInvis = false;
        isLeftMouseDown = false;
        isRightMouseDown = false;
        CLICKRESULT_SUCCESS = 0;
        CLICKRESULT_DOOR_SKIP = 1;
        CLICKRESULT_MISS = 2;
        mirrorSpellRenderX = false;
        partialTickNow = 0.0f;
        partialTickLast = 0.0f;
        bulletHoles = new ArrayList<BulletHoleInfo>();
    }

    public static class OnReloadListener
    extends SimplePreparableReloadListener<Void> {
        protected Void prepare(ResourceManager paramResourceManager, ProfilerFiller paramProfilerFiller) {
            return null;
        }

        protected void apply(Void paramT, ResourceManager paramResourceManager, ProfilerFiller paramProfilerFiller) {
            DummyRenderer.gameWasReloaded = true;
            LOGGER.debug("Game reloaded");
        }
    }

    public static class BulletHoleInfo {
        public BlockPos pos;
        public Vec3 loc;
        public int holeNo;
        public String dim;
        public Direction facing;
        public long timestamp;
        public Double randomDepth;
    }

    @Mod.EventBusSubscriber(modid="xenotech", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public class OptiscaleClientModEventBusHandler {
        @SubscribeEvent
        public static void registerBindings(RegisterKeyMappingsEvent event) {
            LOGGER.info("register keybinds");
            for (KeyMapping mapping : allKeyMappings) {
                event.register(mapping);
            }
        }
    }
}

