/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech;

import net.minecraftforge.common.ForgeConfigSpec;

public class XenoTechClientConfig {
    public final ForgeConfigSpec.BooleanValue doBatchRendering;
    public final ForgeConfigSpec.BooleanValue disableBatchRenderingDuringOutline;
    public final ForgeConfigSpec.BooleanValue showOutlineWarningMessage;
    public final ForgeConfigSpec.BooleanValue terminalVisibleWhilePiloted;
    public final ForgeConfigSpec.BooleanValue helicopterHoverSound;
    public final ForgeConfigSpec.BooleanValue useOldHelicopterHoverSound;
    public final ForgeConfigSpec.ConfigValue<Double> helicopterHoverSoundVolume;
    public final ForgeConfigSpec.ConfigValue<Double> engineSoundVolume;
    public final ForgeConfigSpec.ConfigValue<Double> drillSoundVolume;
    public final ForgeConfigSpec.ConfigValue<Double> buzzsawSoundVolume;
    public final ForgeConfigSpec.BooleanValue terminalInteractiveWhilePiloted;
    public final ForgeConfigSpec.BooleanValue useImperialUnits;
    public final ForgeConfigSpec.BooleanValue useGradualTurning;
    public final ForgeConfigSpec.ConfigValue<Double> flagshipHelicopterRotorWidthScale;
    public final ForgeConfigSpec.ConfigValue<Double> flagshipHelicopterRotorHeightScale;
    public final ForgeConfigSpec.ConfigValue<Double> flagshipPropellerWidthScale;
    public final ForgeConfigSpec.ConfigValue<Double> flagshipPropellerHeightScale;
    public final ForgeConfigSpec.BooleanValue enableShipStepUp;
    public final ForgeConfigSpec.BooleanValue useBlockLightingForShip;

    public XenoTechClientConfig(ForgeConfigSpec.Builder builder) {
        builder.push("client");
        builder.push("rendering");
        this.doBatchRendering = builder.comment("Render ships with batch rendering mode?").translation("config.xenotech.doBatchRendering").define("doBatchRendering", true);
        this.disableBatchRenderingDuringOutline = builder.comment("Auto-disable batch rendering during outline").translation("config.xenotech.disableBatchRenderingDuringOutline").define("disableBatchRenderingDuringOutline", true);
        this.showOutlineWarningMessage = builder.comment("Batch rendering disabled warning message during outlines").translation("config.xenotech.showOutlineWarningMessage").define("showOutlineWarningMessage", false);
        this.useBlockLightingForShip = builder.comment("Use block lighting for ship?").translation("config.xenotech.useBlockLightingForShip").define("useBlockLightingForShip", true);
        builder.pop();
        builder.push("ship");
        this.terminalVisibleWhilePiloted = builder.comment("Should terminal be visible while piloted?").translation("config.xenotech.terminalVisibleWhilePiloted").define("terminalVisibleWhilePiloted", false);
        this.helicopterHoverSound = builder.comment("Should the helicopter make a hover sound?").translation("config.xenotech.helicopterHoverSound").define("helicopterHoverSound", true);
        this.useOldHelicopterHoverSound = builder.comment("Use older & shorter hover sound loop?").translation("config.xenotech.useOldHelicopterHoverSound").define("useOldHelicopterHoverSound", false);
        this.helicopterHoverSoundVolume = builder.comment("Volume to use for helicopter hover sound").translation("config.xenotech.helicopterHoverSoundVolume").defineInRange("helicopterHoverSoundVolume", 100.0, 0.0, 150.0);
        this.engineSoundVolume = builder.comment("Volume to use for engine sound").translation("config.xenotech.engineSoundVolume").defineInRange("engineSoundVolume", 100.0, 0.0, 150.0);
        this.terminalInteractiveWhilePiloted = builder.comment("Should terminal be interactive while piloted?").translation("config.xenotech.terminalInteractiveWhilePiloted").define("terminalInteractiveWhilePiloted", false);
        this.drillSoundVolume = builder.comment("Volume to use for drill sound").translation("config.xenotech.drillSoundVolume").defineInRange("drillSoundVolume", 100.0, 0.0, 150.0);
        this.buzzsawSoundVolume = builder.comment("Volume to use for buzzsaw sound").translation("config.xenotech.buzzsawSoundVolume").defineInRange("buzzsawSoundVolume", 100.0, 0.0, 150.0);
        this.useImperialUnits = builder.comment("Use imperial units for weight?").translation("config.xenotech.useImperialUnits").define("useImperialUnits", true);
        this.useGradualTurning = builder.comment("Use gradual turning for airships?").translation("config.xenotech.useGradualTurning").define("useGradualTurning", true);
        this.flagshipHelicopterRotorWidthScale = builder.comment("Visual width multiplier for flagship helicopter rotor").translation("config.xenotech.flagshipHelicopterRotorWidthScale").defineInRange("flagshipHelicopterRotorWidthScale", 4.5, 0.1, 100.0);
        this.flagshipHelicopterRotorHeightScale = builder.comment("Visual height multiplier for flagship helicopter rotor").translation("config.xenotech.flagshipHelicopterRotorHeightScale").defineInRange("flagshipHelicopterRotorHeightScale", 2.5, 0.1, 100.0);
        this.flagshipPropellerWidthScale = builder.comment("Visual width multiplier for flagship propeller").translation("config.xenotech.flagshipPropellerWidthScale").defineInRange("flagshipPropellerWidthScale", 4.3, 0.1, 100.0);
        this.flagshipPropellerHeightScale = builder.comment("Visual height multiplier for flagship propeller").translation("config.xenotech.flagshipPropellerHeightScale").defineInRange("flagshipPropellerHeightScale", 1.7, 0.1, 100.0);
        this.enableShipStepUp = builder.comment("Enable block step-up for constructed ships?").translation("config.xenotech.enableShipStepUp").define("enableShipStepUp", true);
        builder.pop();
        builder.pop();
    }
}

