/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech;

import com.dairymoose.xenotech.ModCompat;
import com.dairymoose.xenotech.XenoBlocks;
import com.dairymoose.xenotech.XenoTechConfig;
import com.dairymoose.xenotech.XenoTechCraftingFlags;
import com.dairymoose.xenotech.client.gui.screens.DialogScreen;
import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.entity.WaterColliderEntity;
import com.dairymoose.xenotech.network.ClientboundBlockEntitySyncPacket;
import com.dairymoose.xenotech.network.ClientboundBulletHoleArrayPacket;
import com.dairymoose.xenotech.network.ClientboundBulletHolePacket;
import com.dairymoose.xenotech.network.ClientboundGunMountPacket;
import com.dairymoose.xenotech.network.ClientboundMultipartShipDataPacket;
import com.dairymoose.xenotech.network.ClientboundRenderableInteractPacket;
import com.dairymoose.xenotech.network.ClientboundShipDataPacket;
import com.dairymoose.xenotech.network.ClientboundShipTerminalPacket;
import com.dairymoose.xenotech.network.ClientboundTasklistPacket;
import com.dairymoose.xenotech.network.ServerboundAdjustVehicleDeltaPacket;
import com.dairymoose.xenotech.network.ServerboundCarriedPlayerReminder;
import com.dairymoose.xenotech.network.ServerboundCreateBlueprintsPacket;
import com.dairymoose.xenotech.network.ServerboundDismountVillagerPacket;
import com.dairymoose.xenotech.network.ServerboundHitscanArrayPacket;
import com.dairymoose.xenotech.network.ServerboundHitscanPacket;
import com.dairymoose.xenotech.network.ServerboundRenderableInteractPacket;
import com.dairymoose.xenotech.network.ServerboundRequestRepositionPacket;
import com.dairymoose.xenotech.network.ServerboundShipNamePacket;
import com.dairymoose.xenotech.network.ServerboundTasklistPacket;
import com.dairymoose.xenotech.network.ServerboundTerminalSelectionPacket;
import com.dairymoose.xenotech.network.XenoTechNetwork;
import com.dairymoose.xenotech.world.level.block.entity.ManipulatorBlockEntity;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XenoTechCommon {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"xenotech");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"xenotech");
    private static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"xenotech");
    private static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"xenotech");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"xenotech");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"xenotech");
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"xenotech");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"xenotech");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"xenotech");
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"xenotech");
    public static final ModCompat CREATE_MOD = new ModCompat("create");
    private static XenoTechCraftingFlags craftingFlags;
    public static long serverTick;
    public static int dummyUpdates;
    public static boolean KEYBOARD_EVENT_SHIP_LEFT;
    public static boolean KEYBOARD_EVENT_SHIP_RIGHT;
    public static boolean KEYBOARD_EVENT_SHIP_BRAKE;
    public static boolean KEYBOARD_EVENT_SHIP_ASCEND;
    public static boolean KEYBOARD_EVENT_SHIP_DESCEND;
    private double allowedAttackDistance = 1.7;
    private double allowedAttackDistanceSqr = this.allowedAttackDistance * this.allowedAttackDistance;
    private double allowedAttackDistanceBelow = 2.5;
    private double allowedAttackDistanceBelowSqr = this.allowedAttackDistanceBelow * this.allowedAttackDistanceBelow;
    public static int bulletHoleUpdatePeriod;
    public static List<ClientboundBulletHoleArrayPacket.SingleBulletHole> pendingBulletHoleUpdates;
    public static String ServerLevelFolderName;
    public static String singleplayerLevelName;
    private static long nextUniqueShipId;

    public XenoTechCommon() {
        LOGGER.debug(XenoBlocks.BLOCK_SHIP_TERMINAL.toString());
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::addItemsToCreativeTab);
        craftingFlags = new XenoTechCraftingFlags();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)XenoTechConfig.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)XenoTechConfig.clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)XenoTechConfig.serverSpec);
        ENTITIES.register("dummy", () -> DummyEntity.DUMMY_ENTITY);
        ENTITIES.register("water_collider", () -> WaterColliderEntity.WATER_COLLIDER_ENTITY);
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        SOUND_EVENTS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        BLOCK_ENTITY_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        CREATIVE_MODE_TABS.register(FMLJavaModLoadingContext.get().getModEventBus());
        SOUNDS.register(FMLJavaModLoadingContext.get().getModEventBus());
        MENU_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        FLUID_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        FLUIDS.register(FMLJavaModLoadingContext.get().getModEventBus());
        int msgId = 0;
        XenoTechNetwork.INSTANCE.registerMessage(msgId++, ServerboundTerminalSelectionPacket.class, ServerboundTerminalSelectionPacket::m_5779_, ServerboundTerminalSelectionPacket::new, ServerboundTerminalSelectionPacket::handle);
        XenoTechNetwork.INSTANCE.registerMessage(msgId++, ServerboundAdjustVehicleDeltaPacket.class, ServerboundAdjustVehicleDeltaPacket::m_5779_, ServerboundAdjustVehicleDeltaPacket::new, ServerboundAdjustVehicleDeltaPacket::handle);
        XenoTechNetwork.INSTANCE.registerMessage(msgId++, ClientboundShipDataPacket.class, ClientboundShipDataPacket::m_5779_, ClientboundShipDataPacket::new, ClientboundShipDataPacket::handle);
        XenoTechNetwork.INSTANCE.registerMessage(msgId++, ServerboundRequestRepositionPacket.class, ServerboundRequestRepositionPacket::m_5779_, ServerboundRequestRepositionPacket::new, ServerboundRequestRepositionPacket::handle);
        XenoTechNetwork.INSTANCE.registerMessage(msgId++, ServerboundShipNamePacket.class, ServerboundShipNamePacket::m_5779_, ServerboundShipNamePacket::new, ServerboundShipNamePacket::handle);
        XenoTechNetwork.INSTANCE.registerMessage(msgId++, ServerboundRenderableInteractPacket.class, ServerboundRenderableInteractPacket::m_5779_, ServerboundRenderableInteractPacket::new, ServerboundRenderableInteractPacket::handle);
        XenoTechNetwork.INSTANCE.registerMessage(msgId++, ServerboundCarriedPlayerReminder.class, ServerboundCarriedPlayerReminder::m_5779_, ServerboundCarriedPlayerReminder::new, ServerboundCarriedPlayerReminder::handle);
        XenoTechNetwork.INSTANCE.registerMessage(msgId++, ClientboundRenderableInteractPacket.class, ClientboundRenderableInteractPacket::m_5779_, ClientboundRenderableInteractPacket::new, ClientboundRenderableInteractPacket::handle);
        XenoTechNetwork.INSTANCE.registerMessage(msgId++, ServerboundDismountVillagerPacket.class, ServerboundDismountVillagerPacket::m_5779_, ServerboundDismountVillagerPacket::new, ServerboundDismountVillagerPacket::handle);
        XenoTechNetwork.INSTANCE.registerMessage(msgId++, ServerboundTasklistPacket.class, ServerboundTasklistPacket::m_5779_, ServerboundTasklistPacket::new, ServerboundTasklistPacket::handle);
        XenoTechNetwork.INSTANCE.registerMessage(msgId++, ClientboundTasklistPacket.class, ClientboundTasklistPacket::m_5779_, ClientboundTasklistPacket::new, ClientboundTasklistPacket::handle);
        XenoTechNetwork.INSTANCE.registerMessage(msgId++, ServerboundCreateBlueprintsPacket.class, ServerboundCreateBlueprintsPacket::m_5779_, ServerboundCreateBlueprintsPacket::new, ServerboundCreateBlueprintsPacket::handle);
        XenoTechNetwork.INSTANCE.registerMessage(msgId++, ClientboundBlockEntitySyncPacket.class, ClientboundBlockEntitySyncPacket::m_5779_, ClientboundBlockEntitySyncPacket::new, ClientboundBlockEntitySyncPacket::handle);
        XenoTechNetwork.INSTANCE.registerMessage(msgId++, ClientboundShipTerminalPacket.class, ClientboundShipTerminalPacket::m_5779_, ClientboundShipTerminalPacket::new, ClientboundShipTerminalPacket::handle);
        XenoTechNetwork.INSTANCE.registerMessage(msgId++, ClientboundGunMountPacket.class, ClientboundGunMountPacket::m_5779_, ClientboundGunMountPacket::new, ClientboundGunMountPacket::handle);
        XenoTechNetwork.INSTANCE.registerMessage(msgId++, ServerboundHitscanPacket.class, ServerboundHitscanPacket::m_5779_, ServerboundHitscanPacket::new, ServerboundHitscanPacket::handle);
        XenoTechNetwork.INSTANCE.registerMessage(msgId++, ClientboundBulletHolePacket.class, ClientboundBulletHolePacket::m_5779_, ClientboundBulletHolePacket::new, ClientboundBulletHolePacket::handle);
        XenoTechNetwork.INSTANCE.registerMessage(msgId++, ClientboundBulletHoleArrayPacket.class, ClientboundBulletHoleArrayPacket::m_5779_, ClientboundBulletHoleArrayPacket::new, ClientboundBulletHoleArrayPacket::handle);
        XenoTechNetwork.INSTANCE.registerMessage(msgId++, ServerboundHitscanArrayPacket.class, ServerboundHitscanArrayPacket::m_5779_, ServerboundHitscanArrayPacket::new, ServerboundHitscanArrayPacket::handle);
        XenoTechNetwork.INSTANCE.registerMessage(msgId++, ClientboundMultipartShipDataPacket.class, ClientboundMultipartShipDataPacket::m_5779_, ClientboundMultipartShipDataPacket::new, ClientboundMultipartShipDataPacket::handle);
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
    }

    public static void shipAscend(DummyEntity dummy, BlockPos pos, boolean longAscend) {
        ServerboundTerminalSelectionPacket.shipAscendLogic(dummy, longAscend);
        if (longAscend) {
            XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.SHIP_ASCEND_LONG, dummy, pos));
        } else {
            XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.SHIP_ASCEND, dummy, pos));
        }
    }

    public static void shipDescend(DummyEntity dummy, BlockPos pos, boolean longDescend) {
        ServerboundTerminalSelectionPacket.shipDescendLogic(dummy, longDescend);
        if (longDescend) {
            XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.SHIP_DESCEND_LONG, dummy, pos));
        } else {
            XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.SHIP_DESCEND, dummy, pos));
        }
    }

    public static void ship5Left(DummyEntity dummy, BlockPos pos) {
        XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.SHIP_LEFT5, dummy, pos));
    }

    public static void ship5Right(DummyEntity dummy, BlockPos pos) {
        XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.SHIP_RIGHT5, dummy, pos));
    }

    public static void shipStopTurning(DummyEntity dummy, BlockPos pos) {
        XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.SHIP_STOP_TURNING, dummy, pos));
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        LOGGER.debug("onWorldUnload");
        try {
            ManipulatorBlockEntity.cleanupFakePlayerList(event.getLevel());
        }
        catch (Exception e) {
            LOGGER.error("Error cleaning up fake players", (Throwable)e);
        }
        if (event.getLevel().m_5776_()) {
            DummyEntity.clearDummiesGlobal();
        }
    }

    public void addItemsToCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == XenoBlocks.TAB_XENOTECH_CREATIVE.get()) {
            Field[] allFields;
            for (Field f : allFields = XenoBlocks.class.getDeclaredFields()) {
                if (f.getType() != RegistryObject.class) continue;
                try {
                    RegistryObject value = (RegistryObject)f.get(null);
                    if (value == null || !(value.get() instanceof Item)) continue;
                    event.accept((Supplier)value);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    LOGGER.error("Error registering items with creative tab", (Throwable)e);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingDamaged(LivingAttackEvent event) {
        LivingEntity living = event.getEntity();
        if (living != null && !living.m_9236_().f_46443_ && (event.getSource().m_276093_(DamageTypes.f_268565_) || event.getSource().m_276093_(DamageTypes.f_268482_) || event.getSource().m_276093_(DamageTypes.f_268566_) || event.getSource().m_276093_(DamageTypes.f_268511_) || event.getSource().m_276093_(DamageTypes.f_268534_) || event.getSource().m_276093_(DamageTypes.f_268433_) || event.getSource().m_276093_(DamageTypes.f_268493_) || event.getSource().m_276093_(DamageTypes.f_268641_) || event.getSource().m_276093_(DamageTypes.f_268714_) || event.getSource().m_276093_(DamageTypes.f_268425_) || event.getSource().m_276093_(DamageTypes.f_268739_) || event.getSource().m_276093_(DamageTypes.f_268515_) || event.getSource().m_276093_(DamageTypes.f_268530_) || event.getSource().m_276093_(DamageTypes.f_268464_))) {
            boolean closeAttackerIsBelowVictim;
            if (event.getSource() == null) {
                return;
            }
            Entity instigator = event.getSource().m_7639_();
            if (instigator == null) {
                return;
            }
            DummyEntity instigatorCarried = DummyEntity.getDummyEntityForCarried(instigator);
            DummyEntity carried = DummyEntity.getDummyEntityForCarried((Entity)living);
            boolean victimIsCarried = carried != null || living.m_275832_() instanceof DummyEntity;
            boolean outsideAttackingIn = carried != null && instigatorCarried == null;
            boolean insideAttackingOut = carried == null && instigatorCarried != null;
            boolean attackerIsFarAway = living.m_20280_(instigator) > this.allowedAttackDistanceSqr;
            boolean belowAttackerIsFarAway = living.m_20280_(instigator) > this.allowedAttackDistanceBelowSqr;
            boolean attackerIsClose = !attackerIsFarAway;
            boolean belowAttackerIsClose = !belowAttackerIsFarAway;
            boolean attackIsPlayerProjectile = instigator instanceof Player && event.getSource().m_269014_();
            boolean bl = closeAttackerIsBelowVictim = belowAttackerIsClose && !(instigator instanceof Player) && living.m_20186_() - instigator.m_20186_() > 0.0;
            if (victimIsCarried && !attackIsPlayerProjectile && closeAttackerIsBelowVictim) {
                LOGGER.debug("cancel attack:" + outsideAttackingIn + "/" + insideAttackingOut);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific interactEvent) {
        ItemStack stasisGun = null;
        InteractionHand gunHand = null;
        ItemStack mainHand = interactEvent.getEntity().m_21205_();
        if (mainHand.m_150930_((Item)XenoBlocks.ITEM_STASIS_GUN.get())) {
            stasisGun = mainHand;
            gunHand = InteractionHand.MAIN_HAND;
        } else {
            ItemStack offHand = interactEvent.getEntity().m_21206_();
            if (offHand.m_150930_((Item)XenoBlocks.ITEM_STASIS_GUN.get())) {
                stasisGun = offHand;
                gunHand = InteractionHand.OFF_HAND;
            }
        }
        if (stasisGun != null) {
            interactEvent.setCanceled(true);
            interactEvent.setCancellationResult(InteractionResult.PASS);
        }
    }

    @SubscribeEvent
    public void onEntityInteract(final PlayerInteractEvent.EntityInteract interactEvent) {
        Villager villager;
        Entity entity;
        Entity entity2;
        ItemStack stasisGun = null;
        InteractionHand gunHand = null;
        ItemStack mainHand = interactEvent.getEntity().m_21205_();
        if (mainHand.m_150930_((Item)XenoBlocks.ITEM_STASIS_GUN.get())) {
            stasisGun = mainHand;
            gunHand = InteractionHand.MAIN_HAND;
        } else {
            ItemStack offHand = interactEvent.getEntity().m_21206_();
            if (offHand.m_150930_((Item)XenoBlocks.ITEM_STASIS_GUN.get())) {
                stasisGun = offHand;
                gunHand = InteractionHand.OFF_HAND;
            }
        }
        if (stasisGun != null) {
            interactEvent.setCanceled(true);
            interactEvent.setCancellationResult(InteractionResult.PASS);
        }
        if ((entity2 = interactEvent.getTarget()) instanceof Villager && (entity = (villager = (Villager)entity2).m_275832_()) instanceof DummyEntity) {
            DummyEntity dummyEntity = (DummyEntity)entity;
            if (dummyEntity.villagerRidingTicks >= 20 || dummyEntity.villagerRidingTicks < 0) {
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                    @Override
                    public void run() {
                        if (interactEvent.getLevel().f_46443_) {
                            Minecraft.m_91087_().m_91152_((Screen)new DialogScreen(villager));
                        }
                    }
                });
                interactEvent.setCanceled(true);
                interactEvent.setCancellationResult(InteractionResult.CONSUME);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent e) {
        LOGGER.debug("[XenoTech] " + e.getEntity() + " disconnected");
        DummyEntity carrier = DummyEntity.getDummyEntityForCarried((Entity)e.getEntity());
        if (carrier != null) {
            LOGGER.info(e.getEntity() + " logged out on a ship!");
            DummyEntity.playerLogoutRelativePosMap.put(e.getEntity().m_20148_(), new DummyEntity.LogoutPositionInfo(carrier, e.getEntity().m_20182_().m_82546_(carrier.m_20182_())));
        }
    }

    @SubscribeEvent
    public void onCheckSleepLocationCondition(SleepingLocationCheckEvent e) {
        e.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent
    public void onPlayerConnect(PlayerEvent.PlayerLoggedInEvent e) {
        LOGGER.debug("[XenoTech] " + e.getEntity() + " connected");
        DummyEntity.LogoutPositionInfo logoutInfo = DummyEntity.playerLogoutRelativePosMap.get(e.getEntity().m_20148_());
        if (logoutInfo != null) {
            DummyEntity.newlyLoggedIn.add(e.getEntity());
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ++serverTick;
            dummyUpdates = 0;
        }
        if (event.phase == TickEvent.Phase.END && serverTick % (long)bulletHoleUpdatePeriod == 0L && !pendingBulletHoleUpdates.isEmpty()) {
            XenoTechNetwork.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundBulletHoleArrayPacket(pendingBulletHoleUpdates));
            pendingBulletHoleUpdates.clear();
        }
    }

    public static boolean ensureDirectory(String subDir) {
        if (StringUtils.isEmpty((CharSequence)subDir)) {
            return false;
        }
        String dir = subDir;
        File f = new File(dir);
        return f.mkdirs();
    }

    public static String getFolderPath() {
        String root = "";
        String folderName = null;
        String prefix = "";
        if (FMLEnvironment.dist == Dist.CLIENT) {
            prefix = "multiplayer/";
            if (singleplayerLevelName != null) {
                prefix = "singleplayer/";
                folderName = singleplayerLevelName;
                LOGGER.debug("currentServer name: " + folderName);
            } else if (Minecraft.m_91087_().m_91089_() != null) {
                folderName = Minecraft.m_91087_().m_91089_().f_105362_;
                if (StringUtils.isEmpty((CharSequence)(folderName = folderName.replaceAll("\\W+", "_").trim()).replaceAll("_", ""))) {
                    folderName = Minecraft.m_91087_().m_91089_().f_105363_;
                }
                LOGGER.debug("getServer name: " + folderName);
            } else {
                folderName = "offline";
            }
        } else {
            folderName = "";
            if (ServerLevelFolderName != null) {
                root = ServerLevelFolderName;
            }
        }
        String path = root + "xenotech/" + prefix + folderName;
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        XenoTechCommon.ensureDirectory(path);
        return path;
    }

    public static String getSubFolderPrepend() {
        String folderName = null;
        folderName = XenoTechCommon.getFolderPath();
        Object subFolder = "";
        if (folderName != null && !((String)(subFolder = folderName)).endsWith("/")) {
            subFolder = (String)subFolder + "/";
        }
        return subFolder;
    }

    public static synchronized long getNextShipId() {
        long toReturn = nextUniqueShipId++;
        LOGGER.debug("Got new unique ship ID=" + toReturn);
        String subFolder = XenoTechCommon.getSubFolderPrepend();
        File shipData = new File(subFolder + "ship_data.txt");
        try {
            FileWriter fw = new FileWriter(shipData);
            String toWrite = String.valueOf(nextUniqueShipId);
            fw.write(toWrite);
            fw.close();
        }
        catch (IOException e) {
            LOGGER.debug("Error writing to ship_data.txt");
        }
        return toReturn;
    }

    @SubscribeEvent
    public void onServerStarting(ServerAboutToStartEvent event) {
        Path path;
        LOGGER.info("server about to start");
        if (event != null && event.getServer() != null && (path = event.getServer().m_129843_(LevelResource.f_78182_)) != null && !(ServerLevelFolderName = path.toString()).isEmpty() && !(ServerLevelFolderName = ServerLevelFolderName.replace('\\', '/')).endsWith("/")) {
            ServerLevelFolderName = ServerLevelFolderName + "/";
        }
        if (FMLEnvironment.dist == Dist.CLIENT && Minecraft.m_91087_().m_91091_()) {
            singleplayerLevelName = Minecraft.m_91087_().m_91092_().m_129910_().m_5462_();
            LOGGER.info("Server starting: Singleplayer world load for level: " + singleplayerLevelName);
        }
        String subFolder = XenoTechCommon.getSubFolderPrepend();
        LOGGER.debug("use folder: " + subFolder);
        File shipData = new File(subFolder + "ship_data.txt");
        if (shipData.exists()) {
            try {
                FileReader fr = new FileReader(shipData);
                BufferedReader br = new BufferedReader(fr);
                String line = br.readLine();
                nextUniqueShipId = Long.valueOf(line);
            }
            catch (IOException | NumberFormatException e) {
                LOGGER.error("ship_data.txt not found", (Throwable)e);
            }
        }
    }

    static {
        serverTick = 0L;
        dummyUpdates = 0;
        KEYBOARD_EVENT_SHIP_LEFT = false;
        KEYBOARD_EVENT_SHIP_RIGHT = false;
        KEYBOARD_EVENT_SHIP_BRAKE = false;
        KEYBOARD_EVENT_SHIP_ASCEND = false;
        KEYBOARD_EVENT_SHIP_DESCEND = false;
        pendingBulletHoleUpdates = new ArrayList<ClientboundBulletHoleArrayPacket.SingleBulletHole>();
        ServerLevelFolderName = null;
        singleplayerLevelName = null;
        nextUniqueShipId = 1L;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void setAttributes(EntityAttributeCreationEvent e) {
            e.put(WaterColliderEntity.WATER_COLLIDER_ENTITY, WaterColliderEntity.createAttributes().m_22265_());
        }
    }
}

