/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech;

import com.dairymoose.xenotech.XenoTechClientConfig;
import com.dairymoose.xenotech.XenoTechCommon;
import com.dairymoose.xenotech.XenoTechCommonConfig;
import com.dairymoose.xenotech.XenoTechCraftingFlags;
import com.dairymoose.xenotech.XenoTechServerConfig;
import com.dairymoose.xenotech.XenoTechUtils;
import com.dairymoose.xenotech.block.FlagshipHelicopterRotor;
import com.dairymoose.xenotech.block.FlagshipPropellerBlock;
import com.dairymoose.xenotech.block.SnowBlockerBlock;
import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.entity.DummyRenderer;
import com.dairymoose.xenotech.network.ServerboundHitscanArrayPacket;
import com.dairymoose.xenotech.world.level.block.entity.ManipulatorBlockEntity;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="xenotech", bus=Mod.EventBusSubscriber.Bus.MOD)
public class XenoTechConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ForgeConfigSpec clientSpec;
    public static final XenoTechClientConfig CLIENT;
    public static final ForgeConfigSpec commonSpec;
    public static final XenoTechCommonConfig COMMON;
    public static final ForgeConfigSpec serverSpec;
    public static final XenoTechServerConfig SERVER;

    public XenoTechConfig() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    private static void addConfigElement(ForgeConfigSpec.BooleanValue configElement) {
        List path = configElement.getPath();
        String key = (String)path.get(path.size() - 1);
        XenoTechCraftingFlags.putFlag(key, (Boolean)configElement.get());
    }

    public static void reinit() {
        LOGGER.debug("[XenoTech]: Update config");
        try {
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enablePropeller);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableHeavyDutyPropeller);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableTractorWheel);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableSportTire);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableJetThruster);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableAirRudder);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableBoatRudder);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableSubmarineRudder);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableSteamEngine);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableCombustionEngine);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableSiftingNet);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableStasisGun);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableHelicopterRotor);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableBalloonBlock);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableBoatSail);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableTeleportationTransponder);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enablePlatinumBow);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableFluidShippingTank);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableManipulator);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableAutoCraftingTable);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableBlueprintingTable);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableVerticalRedstoneConduit);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableXorGate);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableOrGate);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableAndGate);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableNotGate);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableFlagshipHelicopterRotor);
            XenoTechConfig.addConfigElement(XenoTechConfig.COMMON.enableFlagshipPropeller);
            XenoTechUtils.maxShipBlockCount = (Integer)XenoTechConfig.COMMON.maxShipBlockCount.get();
            XenoTechUtils.weightConversionRatio = ((Double)XenoTechConfig.COMMON.weightConversionRatio.get()).floatValue();
            XenoTechUtils.moverDiminishingReturns = ((Double)XenoTechConfig.COMMON.moverDiminishingReturns.get()).floatValue();
            DummyEntity.pilotingWindshieldDistance = ((Double)XenoTechConfig.COMMON.pilotingWindshieldDistance.get()).floatValue();
            DummyEntity.useComplexCollisionProperty = (Boolean)XenoTechConfig.COMMON.useComplexCollision.get();
            XenoTechUtils.woodWeightMultiplier = (Double)XenoTechConfig.COMMON.woodWeightMultiplier.get();
            XenoTechUtils.chainWeightMultiplier = (Double)XenoTechConfig.COMMON.chainWeightMultiplier.get();
            XenoTechUtils.blockWeightExponent = (Double)XenoTechConfig.COMMON.blockWeightExponent.get();
            DummyEntity.checkForNewEntitiesTickPeriod = (Integer)XenoTechConfig.COMMON.checkForNewEntitiesTickPeriod.get();
            DummyEntity.planeAscentAccelScaleFactor = ((Double)XenoTechConfig.COMMON.planeAscentAccelScaleFactor.get()).floatValue();
            DummyEntity.planeAscentSpeedScaleFactor = ((Double)XenoTechConfig.COMMON.planeAscentSpeedScaleFactor.get()).floatValue();
            XenoTechUtils.largeShipMoverThreshold = (Integer)XenoTechConfig.COMMON.largeShipMoverThreshold.get();
            XenoTechUtils.tractorWheelTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.tractorWheelTopSpeedBpsPer1000lb.get()).floatValue();
            XenoTechUtils.tractorWheelTimeToTopSpeedPer1000lb = ((Double)XenoTechConfig.COMMON.tractorWheelTimeToTopSpeedPer1000lb.get()).floatValue();
            XenoTechUtils.sportTireTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.sportTireTopSpeedBpsPer1000lb.get()).floatValue();
            XenoTechUtils.sportTireTimeToTopSpeedPer1000lb = ((Double)XenoTechConfig.COMMON.sportTireTimeToTopSpeedPer1000lb.get()).floatValue();
            XenoTechUtils.boatSailTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.boatSailTopSpeedBpsPer1000lb.get()).floatValue();
            XenoTechUtils.boatSailTimeToTopSpeedPer1000lb = ((Double)XenoTechConfig.COMMON.boatSailTimeToTopSpeedPer1000lb.get()).floatValue();
            XenoTechUtils.balloonTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.balloonTopSpeedBpsPer1000lb.get()).floatValue();
            XenoTechUtils.balloonTimeToTopSpeedPer1000lb = ((Double)XenoTechConfig.COMMON.balloonTimeToTopSpeedPer1000lb.get()).floatValue();
            XenoTechUtils.propellerTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.propellerTopSpeedBpsPer1000lb.get()).floatValue();
            XenoTechUtils.propellerTimeToTopSpeedPer1000lb = ((Double)XenoTechConfig.COMMON.propellerTimeToTopSpeedPer1000lb.get()).floatValue();
            XenoTechUtils.flagshipHelicopterRotorTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.flagshipHelicopterRotorTopSpeedBpsPer1000lb.get()).floatValue();
            XenoTechUtils.flagshipHelicopterRotorTimeToTopSpeedPer1000lb = ((Double)XenoTechConfig.COMMON.flagshipHelicopterRotorTimeToTopSpeedPer1000lb.get()).floatValue();
            XenoTechUtils.flagshipPropellerTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.flagshipPropellerTopSpeedBpsPer1000lb.get()).floatValue();
            XenoTechUtils.flagshipPropellerTimeToTopSpeedPer1000lb = ((Double)XenoTechConfig.COMMON.flagshipPropellerTimeToTopSpeedPer1000lb.get()).floatValue();
            XenoTechUtils.heavyDutyPropellerTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.heavyDutyPropellerTopSpeedBpsPer1000lb.get()).floatValue();
            XenoTechUtils.heavyDutyPropellerTimeToTopSpeedPer1000lb = ((Double)XenoTechConfig.COMMON.heavyDutyPropellerTimeToTopSpeedPer1000lb.get()).floatValue();
            XenoTechUtils.jetThrusterTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.jetThrusterTopSpeedBpsPer1000lb.get()).floatValue();
            XenoTechUtils.jetThrusterTimeToTopSpeedPer1000lb = ((Double)XenoTechConfig.COMMON.jetThrusterTimeToTopSpeedPer1000lb.get()).floatValue();
            XenoTechUtils.helicopterRotorTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.helicopterRotorTopSpeedBpsPer1000lb.get()).floatValue();
            XenoTechUtils.helicopterRotorTimeToTopSpeedPer1000lb = ((Double)XenoTechConfig.COMMON.helicopterRotorTimeToTopSpeedPer1000lb.get()).floatValue();
            XenoTechUtils.verticalBalloonTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.verticalBalloonTopSpeedBpsPer1000lb.get()).floatValue();
            XenoTechUtils.verticalBalloonTimeToTopSpeedPer1000lb = ((Double)XenoTechConfig.COMMON.verticalBalloonTimeToTopSpeedPer1000lb.get()).floatValue();
            XenoTechUtils.verticalPropellerTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.verticalPropellerTopSpeedBpsPer1000lb.get()).floatValue();
            XenoTechUtils.verticalPropellerTimeToTopSpeedPer1000lb = ((Double)XenoTechConfig.COMMON.verticalPropellerTimeToTopSpeedPer1000lb.get()).floatValue();
            XenoTechUtils.verticalHeavyDutyPropellerTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.verticalHeavyDutyPropellerTopSpeedBpsPer1000lb.get()).floatValue();
            XenoTechUtils.verticalHeavyDutyPropellerTimeToTopSpeedPer1000lb = ((Double)XenoTechConfig.COMMON.verticalHeavyDutyPropellerTimeToTopSpeedPer1000lb.get()).floatValue();
            XenoTechUtils.verticalJetThrusterTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.verticalJetThrusterTopSpeedBpsPer1000lb.get()).floatValue();
            XenoTechUtils.verticalJetThrusterTimeToTopSpeedPer1000lb = ((Double)XenoTechConfig.COMMON.verticalJetThrusterTimeToTopSpeedPer1000lb.get()).floatValue();
            XenoTechUtils.verticalHelicopterRotorTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.verticalHelicopterRotorTopSpeedBpsPer1000lb.get()).floatValue();
            XenoTechUtils.verticalHelicopterRotorTimeToTopSpeedPer1000lb = ((Double)XenoTechConfig.COMMON.verticalHelicopterRotorTimeToTopSpeedPer1000lb.get()).floatValue();
            XenoTechUtils.verticalFlagshipHelicopterRotorTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.verticalFlagshipHelicopterRotorTopSpeedBpsPer1000lb.get()).floatValue();
            XenoTechUtils.verticalFlagshipHelicopterRotorTimeToTopSpeedPer1000lb = ((Double)XenoTechConfig.COMMON.verticalFlagshipHelicopterRotorTimeToTopSpeedPer1000lb.get()).floatValue();
            XenoTechUtils.verticalFlagshipPropellerTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.verticalFlagshipPropellerTopSpeedBpsPer1000lb.get()).floatValue();
            XenoTechUtils.verticalFlagshipPropellerTimeToTopSpeedPer1000lb = ((Double)XenoTechConfig.COMMON.verticalFlagshipPropellerTimeToTopSpeedPer1000lb.get()).floatValue();
            XenoTechUtils.tractorWheelTopSpeedBps = ((Double)XenoTechConfig.COMMON.tractorWheelTopSpeedBps.get()).floatValue();
            XenoTechUtils.tractorWheelTimeToTopSpeed = ((Double)XenoTechConfig.COMMON.tractorWheelTimeToTopSpeed.get()).floatValue();
            XenoTechUtils.sportTireTopSpeedBps = ((Double)XenoTechConfig.COMMON.sportTireTopSpeedBps.get()).floatValue();
            XenoTechUtils.sportTireTimeToTopSpeed = ((Double)XenoTechConfig.COMMON.sportTireTimeToTopSpeed.get()).floatValue();
            XenoTechUtils.boatSailTopSpeedBps = ((Double)XenoTechConfig.COMMON.boatSailTopSpeedBps.get()).floatValue();
            XenoTechUtils.boatSailTimeToTopSpeed = ((Double)XenoTechConfig.COMMON.boatSailTimeToTopSpeed.get()).floatValue();
            XenoTechUtils.balloonTopSpeedBps = ((Double)XenoTechConfig.COMMON.balloonTopSpeedBps.get()).floatValue();
            XenoTechUtils.balloonTimeToTopSpeed = ((Double)XenoTechConfig.COMMON.balloonTimeToTopSpeed.get()).floatValue();
            XenoTechUtils.propellerTopSpeedBps = ((Double)XenoTechConfig.COMMON.propellerTopSpeedBps.get()).floatValue();
            XenoTechUtils.propellerTimeToTopSpeed = ((Double)XenoTechConfig.COMMON.propellerTimeToTopSpeed.get()).floatValue();
            XenoTechUtils.heavyDutyPropellerTopSpeedBps = ((Double)XenoTechConfig.COMMON.heavyDutyPropellerTopSpeedBps.get()).floatValue();
            XenoTechUtils.heavyDutyPropellerTimeToTopSpeed = ((Double)XenoTechConfig.COMMON.heavyDutyPropellerTimeToTopSpeed.get()).floatValue();
            XenoTechUtils.jetThrusterTopSpeedBps = ((Double)XenoTechConfig.COMMON.jetThrusterTopSpeedBps.get()).floatValue();
            XenoTechUtils.jetThrusterTimeToTopSpeed = ((Double)XenoTechConfig.COMMON.jetThrusterTimeToTopSpeed.get()).floatValue();
            XenoTechUtils.helicopterRotorTopSpeedBps = ((Double)XenoTechConfig.COMMON.helicopterRotorTopSpeedBps.get()).floatValue();
            XenoTechUtils.helicopterRotorTimeToTopSpeed = ((Double)XenoTechConfig.COMMON.helicopterRotorTimeToTopSpeed.get()).floatValue();
            XenoTechUtils.verticalBalloonTopSpeedBps = ((Double)XenoTechConfig.COMMON.verticalBalloonTopSpeedBps.get()).floatValue();
            XenoTechUtils.verticalBalloonTimeToTopSpeed = ((Double)XenoTechConfig.COMMON.verticalBalloonTimeToTopSpeed.get()).floatValue();
            XenoTechUtils.verticalPropellerTopSpeedBps = ((Double)XenoTechConfig.COMMON.verticalPropellerTopSpeedBps.get()).floatValue();
            XenoTechUtils.verticalPropellerTimeToTopSpeed = ((Double)XenoTechConfig.COMMON.verticalPropellerTimeToTopSpeed.get()).floatValue();
            XenoTechUtils.verticalHeavyDutyPropellerTopSpeedBps = ((Double)XenoTechConfig.COMMON.verticalHeavyDutyPropellerTopSpeedBps.get()).floatValue();
            XenoTechUtils.verticalHeavyDutyPropellerTimeToTopSpeed = ((Double)XenoTechConfig.COMMON.verticalHeavyDutyPropellerTimeToTopSpeed.get()).floatValue();
            XenoTechUtils.verticalJetThrusterTopSpeedBps = ((Double)XenoTechConfig.COMMON.verticalJetThrusterTopSpeedBps.get()).floatValue();
            XenoTechUtils.verticalJetThrusterTimeToTopSpeed = ((Double)XenoTechConfig.COMMON.verticalJetThrusterTimeToTopSpeed.get()).floatValue();
            XenoTechUtils.verticalHelicopterRotorTopSpeedBps = ((Double)XenoTechConfig.COMMON.verticalHelicopterRotorTopSpeedBps.get()).floatValue();
            XenoTechUtils.verticalHelicopterRotorTimeToTopSpeed = ((Double)XenoTechConfig.COMMON.verticalHelicopterRotorTimeToTopSpeed.get()).floatValue();
            XenoTechUtils.submarineTopSpeedModifier = ((Double)XenoTechConfig.COMMON.submarineTopSpeedModifier.get()).floatValue();
            XenoTechUtils.submarineAccelerationModifier = ((Double)XenoTechConfig.COMMON.submarineAccelerationModifier.get()).floatValue();
            XenoTechUtils.populateBuiltInMovers();
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                @Override
                public void run() {
                    DummyEntity.drillSoundVolume = ((Double)XenoTechConfig.CLIENT.drillSoundVolume.get()).floatValue();
                    DummyEntity.buzzsawSoundVolume = ((Double)XenoTechConfig.CLIENT.buzzsawSoundVolume.get()).floatValue();
                    DummyEntity.useOldHelicopterHoverSound = (Boolean)XenoTechConfig.CLIENT.useOldHelicopterHoverSound.get();
                    DummyEntity.enableHelicopterHoverSound = (Boolean)XenoTechConfig.CLIENT.helicopterHoverSound.get();
                    DummyEntity.helicopterHoverSoundVolume = ((Double)XenoTechConfig.CLIENT.helicopterHoverSoundVolume.get()).floatValue();
                    DummyEntity.engineSoundVolume = ((Double)XenoTechConfig.CLIENT.engineSoundVolume.get()).floatValue();
                    DummyEntity.terminalVisibleWhilePiloted = (Boolean)XenoTechConfig.CLIENT.terminalVisibleWhilePiloted.get();
                    DummyEntity.doBatchRendering = (Boolean)XenoTechConfig.CLIENT.doBatchRendering.get();
                    DummyEntity.disableBatchRenderingDuringOutline = (Boolean)XenoTechConfig.CLIENT.disableBatchRenderingDuringOutline.get();
                    DummyEntity.showOutlineWarningMessage = (Boolean)XenoTechConfig.CLIENT.showOutlineWarningMessage.get();
                    XenoTechUtils.useImperialUnits = (Boolean)XenoTechConfig.CLIENT.useImperialUnits.get();
                    DummyEntity.usePlayerGradualTurning = (Boolean)XenoTechConfig.CLIENT.useGradualTurning.get();
                    FlagshipHelicopterRotor.flagshipHelicopterRotorWidthScale = ((Double)XenoTechConfig.CLIENT.flagshipHelicopterRotorWidthScale.get()).floatValue();
                    FlagshipHelicopterRotor.flagshipHelicopterRotorHeightScale = ((Double)XenoTechConfig.CLIENT.flagshipHelicopterRotorHeightScale.get()).floatValue();
                    FlagshipPropellerBlock.flagshipPropellerWidthScale = ((Double)XenoTechConfig.CLIENT.flagshipPropellerWidthScale.get()).floatValue();
                    FlagshipPropellerBlock.flagshipPropellerHeightScale = ((Double)XenoTechConfig.CLIENT.flagshipPropellerHeightScale.get()).floatValue();
                    DummyEntity.enableStepUp = (Boolean)XenoTechConfig.CLIENT.enableShipStepUp.get();
                    DummyRenderer.useBlockLightingForShip = (Boolean)XenoTechConfig.CLIENT.useBlockLightingForShip.get();
                }
            });
            DummyEntity.MAX_LEAF_DESTROY_SIZE = (Integer)XenoTechConfig.SERVER.maxBuzzsawLeafDestroySize.get();
            DummyEntity.drillCanMineAxeBlocks = (Boolean)XenoTechConfig.SERVER.drillCanMineAxeBlocks.get();
            DummyEntity.drillCanMineShovelBlocks = (Boolean)XenoTechConfig.SERVER.drillCanMineShovelBlocks.get();
            DummyEntity.ignorePersistentLeaves = (Boolean)XenoTechConfig.SERVER.buzzsawIgnorePersistentLeaves.get();
            DummyEntity.buzzsawIgnorePersistentLeaves = (Boolean)XenoTechConfig.SERVER.buzzsawIgnorePersistentLeaves.get();
            DummyEntity.drillCanMineAxeBlocks = (Boolean)XenoTechConfig.SERVER.drillCanMineAxeBlocks.get();
            DummyEntity.drillCanMineShovelBlocks = (Boolean)XenoTechConfig.SERVER.drillCanMineShovelBlocks.get();
            DummyEntity.unloadIntoChestDistanceMultiplier = (Integer)XenoTechConfig.SERVER.unloadIntoChestDistanceMultiplier.get();
            DummyEntity.autoKillAllNpcProjectiles = (Boolean)XenoTechConfig.SERVER.autoKillAllEnemyProjectiles.get();
            DummyEntity.drillKillsFallingBlock = (Boolean)XenoTechConfig.SERVER.drillKillsFallingBlock.get();
            DummyEntity.killProjectilesUsingMixin = (Boolean)XenoTechConfig.SERVER.killProjectilesByCollision.get();
            ManipulatorBlockEntity.manipulatorTickPeriod = (Integer)XenoTechConfig.SERVER.manipulatorTickPeriod.get();
            SnowBlockerBlock.snowBlockerRadius = (Integer)XenoTechConfig.SERVER.snowBlockerBlockRadius.get();
            ServerboundHitscanArrayPacket.bulletsCanHeadshot = (Boolean)XenoTechConfig.SERVER.bulletsCanHeadshot.get();
            ServerboundHitscanArrayPacket.bulletDamage = (Double)XenoTechConfig.SERVER.bulletDamage.get();
            ServerboundHitscanArrayPacket.bulletHeadshotDamageMultiplier = (Double)XenoTechConfig.SERVER.bulletHeadshotDamageMultiplier.get();
            ServerboundHitscanArrayPacket.integratedGunDamageMultiplier = (Double)XenoTechConfig.SERVER.integratedGunDamageMultiplier.get();
            ServerboundHitscanArrayPacket.bulletsCanDestroyBlocks = (Boolean)XenoTechConfig.SERVER.bulletsCanDestroyBlocks.get();
            ServerboundHitscanArrayPacket.bulletBlockDestroySpeed = ((Double)XenoTechConfig.SERVER.bulletDestroyBlockSpeed.get()).floatValue();
            ServerboundHitscanArrayPacket.bulletsCreateBulletHoles = (Boolean)XenoTechConfig.SERVER.bulletsCreateBulletHoles.get();
            XenoTechCommon.bulletHoleUpdatePeriod = (Integer)XenoTechConfig.SERVER.bulletHoleUpdatePeriod.get();
            DummyEntity.FURNANCE_BURN_TIME_MULT = ((Double)XenoTechConfig.SERVER.furnaceBurnTimeMult.get()).floatValue();
            DummyEntity.FURNANCE_BURN_TIME_MAX_SECONDS = (Integer)XenoTechConfig.SERVER.furnaceBurnTimeMaxSeconds.get();
            DummyEntity.REFINED_OIL_BURN_MINUTES = (Integer)XenoTechConfig.SERVER.refinedOilBurnTimeMinutes.get();
            ManipulatorBlockEntity.disallowTakingEmptyBucketFromManipulator = (Boolean)XenoTechConfig.SERVER.disallowTakingEmptyBucketFromManipulator.get();
        }
        catch (Exception ex) {
            LOGGER.error("Error initializing config", (Throwable)ex);
        }
    }

    @SubscribeEvent
    public static void onConfigReloaded(ModConfigEvent.Reloading event) {
        if (commonSpec.isLoaded()) {
            XenoTechConfig.reinit();
        }
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        XenoTechConfig.reinit();
    }

    static {
        Pair pair2client = new ForgeConfigSpec.Builder().configure(XenoTechClientConfig::new);
        clientSpec = (ForgeConfigSpec)pair2client.getRight();
        CLIENT = (XenoTechClientConfig)pair2client.getLeft();
        Pair pair2common = new ForgeConfigSpec.Builder().configure(XenoTechCommonConfig::new);
        commonSpec = (ForgeConfigSpec)pair2common.getRight();
        COMMON = (XenoTechCommonConfig)pair2common.getLeft();
        Pair pair2server = new ForgeConfigSpec.Builder().configure(XenoTechServerConfig::new);
        serverSpec = (ForgeConfigSpec)pair2server.getRight();
        SERVER = (XenoTechServerConfig)pair2server.getLeft();
    }
}

