/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech;

import net.minecraftforge.common.ForgeConfigSpec;

public class XenoTechServerConfig {
    public final ForgeConfigSpec.ConfigValue<Integer> unloadIntoChestDistanceMultiplier;
    public final ForgeConfigSpec.ConfigValue<Integer> manipulatorTickPeriod;
    public final ForgeConfigSpec.ConfigValue<Integer> snowBlockerBlockRadius;
    public final ForgeConfigSpec.ConfigValue<Integer> maxBuzzsawLeafDestroySize;
    public final ForgeConfigSpec.BooleanValue manipulatorArmHasNoCollision;
    public final ForgeConfigSpec.BooleanValue drillCanMineAxeBlocks;
    public final ForgeConfigSpec.BooleanValue drillCanMineShovelBlocks;
    public final ForgeConfigSpec.BooleanValue autoKillAllEnemyProjectiles;
    public final ForgeConfigSpec.BooleanValue drillKillsFallingBlock;
    public final ForgeConfigSpec.BooleanValue killProjectilesByCollision;
    public final ForgeConfigSpec.BooleanValue buzzsawIgnorePersistentLeaves;
    public final ForgeConfigSpec.BooleanValue bulletsCanHeadshot;
    public final ForgeConfigSpec.ConfigValue<Double> bulletDamage;
    public final ForgeConfigSpec.ConfigValue<Double> bulletHeadshotDamageMultiplier;
    public final ForgeConfigSpec.ConfigValue<Double> integratedGunDamageMultiplier;
    public final ForgeConfigSpec.BooleanValue bulletsCanDestroyBlocks;
    public final ForgeConfigSpec.ConfigValue<Double> bulletDestroyBlockSpeed;
    public final ForgeConfigSpec.BooleanValue bulletsCreateBulletHoles;
    public final ForgeConfigSpec.ConfigValue<Integer> bulletHoleUpdatePeriod;
    public final ForgeConfigSpec.ConfigValue<Double> furnaceBurnTimeMult;
    public final ForgeConfigSpec.ConfigValue<Integer> furnaceBurnTimeMaxSeconds;
    public final ForgeConfigSpec.ConfigValue<Integer> refinedOilBurnTimeMinutes;
    public final ForgeConfigSpec.BooleanValue disallowTakingEmptyBucketFromManipulator;

    public XenoTechServerConfig(ForgeConfigSpec.Builder builder) {
        builder.push("server");
        builder.push("ship");
        this.unloadIntoChestDistanceMultiplier = builder.comment("Unload-into-chest distance multiplier").translation("config.xenotech.unloadIntoChestDistanceMultiplier").defineInRange("unloadIntoChestDistanceMultiplier", 3, 1, 10);
        this.drillCanMineAxeBlocks = builder.comment("drillCanMineAxeBlocks").translation("config.xenotech.drillCanMineAxeBlocks").define("drillCanMineAxeBlocks", true);
        this.drillCanMineShovelBlocks = builder.comment("drillCanMineShovelBlocks").translation("config.xenotech.drillCanMineShovelBlocks").define("drillCanMineShovelBlocks", true);
        this.maxBuzzsawLeafDestroySize = builder.comment("maxBuzzsawLeafDestroySize").translation("config.xenotech.maxBuzzsawLeafDestroySize").defineInRange("maxBuzzsawLeafDestroySize", 200, 0, 1000000);
        this.autoKillAllEnemyProjectiles = builder.comment("autoKillAllEnemyProjectiles").translation("config.xenotech.autoKillAllEnemyProjectiles").define("autoKillAllEnemyProjectiles", false);
        this.drillKillsFallingBlock = builder.comment("drillKillsFallingBlock").translation("config.xenotech.drillKillsFallingBlock").define("drillKillsFallingBlock", true);
        this.killProjectilesByCollision = builder.comment("killProjectilesByCollision").translation("config.xenotech.killProjectilesByCollision").define("killProjectilesByCollision", true);
        this.buzzsawIgnorePersistentLeaves = builder.comment("buzzsawIgnorePersistentLeaves").translation("config.xenotech.buzzsawIgnorePersistentLeaves").define("buzzsawIgnorePersistentLeaves", true);
        builder.pop();
        builder.push("misc");
        this.manipulatorTickPeriod = builder.comment("Manipulator Tick Period").translation("config.xenotech.manipulatorTickPeriod").defineInRange("manipulatorTickPeriod", 10, 5, 1200);
        this.manipulatorArmHasNoCollision = builder.comment("manipulatorArmHasNoCollision").translation("config.xenotech.manipulatorArmHasNoCollision").define("manipulatorArmHasNoCollision", true);
        this.snowBlockerBlockRadius = builder.comment("snowBlockerBlockRadius").translation("config.xenotech.snowBlockerBlockRadius").defineInRange("snowBlockerBlockRadius", 500, 1, 1000000);
        this.disallowTakingEmptyBucketFromManipulator = builder.comment("disallowTakingEmptyBucketFromManipulator").translation("config.xenotech.disallowTakingEmptyBucketFromManipulator").define("disallowTakingEmptyBucketFromManipulator", true);
        builder.pop();
        builder.push("weapons");
        this.bulletsCanHeadshot = builder.comment("Bullets can headshot").translation("config.xenotech.bulletsCanHeadshot").define("bulletsCanHeadshot", true);
        this.bulletDamage = builder.comment("bulletDamage").translation("config.xenotech.bulletDamage").defineInRange("bulletDamage", 1.5, 0.0, 100.0);
        this.bulletHeadshotDamageMultiplier = builder.comment("bulletHeadshotDamageMultiplier").translation("config.xenotech.bulletHeadshotDamageMultiplier").defineInRange("bulletHeadshotDamageMultiplier", 1.2, 1.0, 10.0);
        this.integratedGunDamageMultiplier = builder.comment("integratedGunDamageMultiplier").translation("config.xenotech.integratedGunDamageMultiplier").defineInRange("integratedGunDamageMultiplier", 0.6, 0.0, 10.0);
        this.bulletsCanDestroyBlocks = builder.comment("Bullets can destroy blocks").translation("config.xenotech.bulletsCanDestroyBlocks").define("bulletsCanDestroyBlocks", true);
        this.bulletDestroyBlockSpeed = builder.comment("bulletDestroyBlockSpeed").translation("config.xenotech.bulletDestroyBlockSpeed").defineInRange("bulletDestroyBlockSpeed", 0.3, 0.0, 10.0);
        this.bulletsCreateBulletHoles = builder.comment("Bullets create bullet holes").translation("config.xenotech.bulletsCreateBulletHoles").define("bulletsCreateBulletHoles", true);
        this.bulletHoleUpdatePeriod = builder.comment("Bullet Hole Update Period").translation("config.xenotech.bulletHoleUpdatePeriod").defineInRange("bulletHoleUpdatePeriod", 3, 1, 40);
        builder.pop();
        builder.push("engines");
        this.furnaceBurnTimeMult = builder.comment("furnaceBurnTimeMult").translation("config.xenotech.furnaceBurnTimeMult").defineInRange("furnaceBurnTimeMult", 1.0, 0.0, 10.0);
        this.furnaceBurnTimeMaxSeconds = builder.comment("furnaceBurnTimeMaxSeconds").translation("config.xenotech.furnaceBurnTimeMaxSeconds").defineInRange("furnaceBurnTimeMaxSeconds", 800, 0, 999999);
        this.refinedOilBurnTimeMinutes = builder.comment("refinedOilBurnTimeMinutes").translation("config.xenotech.refinedOilBurnTimeMinutes").defineInRange("refinedOilBurnTimeMinutes", 10, 0, 999999);
        builder.pop();
        builder.pop();
    }
}

