/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech;

import com.dairymoose.xenotech.BuiltInMoverStats;
import com.dairymoose.xenotech.XenoBlocks;
import com.dairymoose.xenotech.XenoTechConfig;
import com.dairymoose.xenotech.block.BalloonBlock;
import com.dairymoose.xenotech.block.JetThrusterBlock;
import com.dairymoose.xenotech.block.PropellerBlock;
import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.entity.RenderableBlock;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XenoTechUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Map<TagKey<Block>, BuiltInMoverStats> builtInMovers = new HashMap<TagKey<Block>, BuiltInMoverStats>();
    private static TagKey<Block> dualMoverBlockTag = ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation("forge", "dual_mover"));
    private static TagKey<Block> liftMoverBlockTag = ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation("forge", "lift_mover"));
    private static TagKey<Block> moverBlockTag = ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation("forge", "mover"));
    private static TagKey<Block> boatSteeringBlockTag = ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation("forge", "boat_steering"));
    private static TagKey<Block> submarineSteeringBlockTag = ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation("forge", "submarine_steering"));
    private static TagKey<Block> airshipSteeringBlockTag = ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation("forge", "airship_steering"));
    private static TagKey<Block> groundSteeringBlockTag = ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation("forge", "ground_steering"));
    private static TagKey<Block> boatSailBlockTag = ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation("forge", "boat_sail"));
    private static TagKey<Block> balloonBlockTag = ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation("forge", "balloon_block"));
    private static TagKey<Block> propellerBlockTag = ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation("forge", "propeller"));
    private static TagKey<Block> heavyDutyPropellerBlockTag = ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation("forge", "heavy_duty_propeller"));
    private static TagKey<Block> jetThrusterBlockTag = ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation("forge", "jet_thruster"));
    private static TagKey<Block> tractorWheelBlockTag = ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation("forge", "tractor_wheel"));
    private static TagKey<Block> sportTireBlockTag = ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation("forge", "sport_tire"));
    private static TagKey<Block> helicopterRotorBlockTag = ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation("forge", "helicopter_rotor"));
    private static TagKey<Block> flagshipHelicopterRotorBlockTag = ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation("forge", "flagship_helicopter_rotor"));
    private static TagKey<Block> flagshipPropellerBlockTag = ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation("forge", "flagship_propeller"));
    private static TagKey<Block> vehicleBorderBlockTag = ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation("forge", "vehicle_border"));
    private static TagKey<Block> largeShipOnlyMoverBlockTag = ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation("forge", "large_ship_only_mover"));
    public static boolean useImperialUnits = true;
    static boolean firstRunRotate2D = true;
    static double lastCalculatedAngle = 0.0;
    static double lastCos = 0.0;
    static double lastSin = 0.0;
    public static Set<Block> blacklisted = null;
    public static boolean constructionPlatformIsRequired = false;
    public static double woodWeightMultiplier;
    public static double chainWeightMultiplier;
    public static double blockWeightExponent;
    public static float ticksPerSecond;
    public static int largeShipMoverThreshold;
    public static float tractorWheelTopSpeedBpsPer1000lb;
    public static float tractorWheelTimeToTopSpeedPer1000lb;
    public static float sportTireTopSpeedBpsPer1000lb;
    public static float sportTireTimeToTopSpeedPer1000lb;
    public static float boatSailTopSpeedBpsPer1000lb;
    public static float boatSailTimeToTopSpeedPer1000lb;
    public static float balloonTopSpeedBpsPer1000lb;
    public static float balloonTimeToTopSpeedPer1000lb;
    public static float propellerTopSpeedBpsPer1000lb;
    public static float propellerTimeToTopSpeedPer1000lb;
    public static float heavyDutyPropellerTopSpeedBpsPer1000lb;
    public static float heavyDutyPropellerTimeToTopSpeedPer1000lb;
    public static float jetThrusterTopSpeedBpsPer1000lb;
    public static float jetThrusterTimeToTopSpeedPer1000lb;
    public static float helicopterRotorTopSpeedBpsPer1000lb;
    public static float helicopterRotorTimeToTopSpeedPer1000lb;
    public static float flagshipHelicopterRotorTopSpeedBpsPer1000lb;
    public static float flagshipHelicopterRotorTimeToTopSpeedPer1000lb;
    public static float flagshipPropellerTopSpeedBpsPer1000lb;
    public static float flagshipPropellerTimeToTopSpeedPer1000lb;
    public static float verticalBalloonTopSpeedBpsPer1000lb;
    public static float verticalBalloonTimeToTopSpeedPer1000lb;
    public static float verticalPropellerTopSpeedBpsPer1000lb;
    public static float verticalPropellerTimeToTopSpeedPer1000lb;
    public static float verticalHeavyDutyPropellerTopSpeedBpsPer1000lb;
    public static float verticalHeavyDutyPropellerTimeToTopSpeedPer1000lb;
    public static float verticalJetThrusterTopSpeedBpsPer1000lb;
    public static float verticalJetThrusterTimeToTopSpeedPer1000lb;
    public static float verticalHelicopterRotorTopSpeedBpsPer1000lb;
    public static float verticalHelicopterRotorTimeToTopSpeedPer1000lb;
    public static float verticalFlagshipHelicopterRotorTopSpeedBpsPer1000lb;
    public static float verticalFlagshipHelicopterRotorTimeToTopSpeedPer1000lb;
    public static float verticalFlagshipPropellerTopSpeedBpsPer1000lb;
    public static float verticalFlagshipPropellerTimeToTopSpeedPer1000lb;
    public static float submarineTopSpeedModifier;
    public static float submarineAccelerationModifier;
    public static float tractorWheelTopSpeedBps;
    public static float tractorWheelTimeToTopSpeed;
    public static float sportTireTopSpeedBps;
    public static float sportTireTimeToTopSpeed;
    public static float boatSailTopSpeedBps;
    public static float boatSailTimeToTopSpeed;
    public static float balloonTopSpeedBps;
    public static float balloonTimeToTopSpeed;
    public static float propellerTopSpeedBps;
    public static float propellerTimeToTopSpeed;
    public static float heavyDutyPropellerTopSpeedBps;
    public static float heavyDutyPropellerTimeToTopSpeed;
    public static float jetThrusterTopSpeedBps;
    public static float jetThrusterTimeToTopSpeed;
    public static float helicopterRotorTopSpeedBps;
    public static float helicopterRotorTimeToTopSpeed;
    public static float flagshipHelicopterRotorTopSpeedBps;
    public static float flagshipHelicopterRotorTimeToTopSpeed;
    public static float flagshipPropellerTopSpeedBps;
    public static float flagshipPropellerTimeToTopSpeed;
    public static float verticalBalloonTopSpeedBps;
    public static float verticalBalloonTimeToTopSpeed;
    public static float verticalPropellerTopSpeedBps;
    public static float verticalPropellerTimeToTopSpeed;
    public static float verticalHeavyDutyPropellerTopSpeedBps;
    public static float verticalHeavyDutyPropellerTimeToTopSpeed;
    public static float verticalJetThrusterTopSpeedBps;
    public static float verticalJetThrusterTimeToTopSpeed;
    public static float verticalHelicopterRotorTopSpeedBps;
    public static float verticalHelicopterRotorTimeToTopSpeed;
    public static float verticalFlagshipHelicopterRotorTopSpeedBps;
    public static float verticalFlagshipHelicopterRotorTimeToTopSpeed;
    public static float verticalFlagshipPropellerTopSpeedBps;
    public static float verticalFlagshipPropellerTimeToTopSpeed;
    public static float moverDiminishingReturns;
    public static boolean includeDiagonals;
    public static float weightConversionRatio;
    public static int maxShipBlockCount;

    public static void populateBuiltInMovers() {
        HashMap<TagKey<Block>, BuiltInMoverStats> stagingBuiltInMovers = new HashMap<TagKey<Block>, BuiltInMoverStats>();
        BuiltInMoverStats stats = new BuiltInMoverStats();
        TagKey<Block> tag = balloonBlockTag;
        stagingBuiltInMovers.put(tag, stats);
        stats.blockTag = tag;
        stats.horizontalPrecedence = 10;
        stats.verticalPrecendence = 10;
        stats.topSpeedBps = ((Double)XenoTechConfig.COMMON.balloonTopSpeedBps.get()).floatValue();
        stats.timeToTopSpeed = ((Double)XenoTechConfig.COMMON.balloonTimeToTopSpeed.get()).floatValue();
        stats.verticalTopSpeedBps = ((Double)XenoTechConfig.COMMON.verticalBalloonTopSpeedBps.get()).floatValue();
        stats.verticalTimeToTopSpeed = ((Double)XenoTechConfig.COMMON.verticalBalloonTimeToTopSpeed.get()).floatValue();
        stats.topSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.balloonTopSpeedBpsPer1000lb.get()).floatValue();
        stats.timeToTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.balloonTimeToTopSpeedPer1000lb.get()).floatValue();
        stats.verticalTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.verticalBalloonTopSpeedBpsPer1000lb.get()).floatValue();
        stats.verticalTimeToTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.verticalBalloonTimeToTopSpeedPer1000lb.get()).floatValue();
        stats = new BuiltInMoverStats();
        tag = boatSailBlockTag;
        stagingBuiltInMovers.put(tag, stats);
        stats.blockTag = tag;
        stats.horizontalPrecedence = 10;
        stats.topSpeedBps = ((Double)XenoTechConfig.COMMON.boatSailTopSpeedBps.get()).floatValue();
        stats.timeToTopSpeed = ((Double)XenoTechConfig.COMMON.boatSailTimeToTopSpeed.get()).floatValue();
        stats.topSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.boatSailTopSpeedBpsPer1000lb.get()).floatValue();
        stats.timeToTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.boatSailTimeToTopSpeedPer1000lb.get()).floatValue();
        stats = new BuiltInMoverStats();
        tag = tractorWheelBlockTag;
        stagingBuiltInMovers.put(tag, stats);
        stats.blockTag = tag;
        stats.horizontalPrecedence = 10;
        stats.topSpeedBps = ((Double)XenoTechConfig.COMMON.tractorWheelTopSpeedBps.get()).floatValue();
        stats.timeToTopSpeed = ((Double)XenoTechConfig.COMMON.tractorWheelTimeToTopSpeed.get()).floatValue();
        stats.topSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.tractorWheelTopSpeedBpsPer1000lb.get()).floatValue();
        stats.timeToTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.tractorWheelTimeToTopSpeedPer1000lb.get()).floatValue();
        stats = new BuiltInMoverStats();
        tag = sportTireBlockTag;
        stagingBuiltInMovers.put(tag, stats);
        stats.blockTag = tag;
        stats.horizontalPrecedence = 20;
        stats.topSpeedBps = ((Double)XenoTechConfig.COMMON.sportTireTopSpeedBps.get()).floatValue();
        stats.timeToTopSpeed = ((Double)XenoTechConfig.COMMON.sportTireTimeToTopSpeed.get()).floatValue();
        stats.topSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.sportTireTopSpeedBpsPer1000lb.get()).floatValue();
        stats.timeToTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.sportTireTimeToTopSpeedPer1000lb.get()).floatValue();
        stats = new BuiltInMoverStats();
        tag = propellerBlockTag;
        stagingBuiltInMovers.put(tag, stats);
        stats.blockTag = tag;
        stats.horizontalPrecedence = 30;
        stats.verticalPrecendence = 20;
        stats.topSpeedBps = ((Double)XenoTechConfig.COMMON.propellerTopSpeedBps.get()).floatValue();
        stats.timeToTopSpeed = ((Double)XenoTechConfig.COMMON.propellerTimeToTopSpeed.get()).floatValue();
        stats.verticalTopSpeedBps = ((Double)XenoTechConfig.COMMON.verticalPropellerTopSpeedBps.get()).floatValue();
        stats.verticalTimeToTopSpeed = ((Double)XenoTechConfig.COMMON.verticalPropellerTimeToTopSpeed.get()).floatValue();
        stats.topSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.propellerTopSpeedBpsPer1000lb.get()).floatValue();
        stats.timeToTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.propellerTimeToTopSpeedPer1000lb.get()).floatValue();
        stats.verticalTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.verticalPropellerTopSpeedBpsPer1000lb.get()).floatValue();
        stats.verticalTimeToTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.verticalPropellerTimeToTopSpeedPer1000lb.get()).floatValue();
        stats = new BuiltInMoverStats();
        tag = heavyDutyPropellerBlockTag;
        stagingBuiltInMovers.put(tag, stats);
        stats.blockTag = tag;
        stats.horizontalPrecedence = 40;
        stats.verticalPrecendence = 30;
        stats.topSpeedBps = ((Double)XenoTechConfig.COMMON.heavyDutyPropellerTopSpeedBps.get()).floatValue();
        stats.timeToTopSpeed = ((Double)XenoTechConfig.COMMON.heavyDutyPropellerTimeToTopSpeed.get()).floatValue();
        stats.verticalTopSpeedBps = ((Double)XenoTechConfig.COMMON.verticalHeavyDutyPropellerTopSpeedBps.get()).floatValue();
        stats.verticalTimeToTopSpeed = ((Double)XenoTechConfig.COMMON.verticalHeavyDutyPropellerTimeToTopSpeed.get()).floatValue();
        stats.topSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.heavyDutyPropellerTopSpeedBpsPer1000lb.get()).floatValue();
        stats.timeToTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.heavyDutyPropellerTimeToTopSpeedPer1000lb.get()).floatValue();
        stats.verticalTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.verticalHeavyDutyPropellerTopSpeedBpsPer1000lb.get()).floatValue();
        stats.verticalTimeToTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.verticalHeavyDutyPropellerTimeToTopSpeedPer1000lb.get()).floatValue();
        stats = new BuiltInMoverStats();
        tag = jetThrusterBlockTag;
        stagingBuiltInMovers.put(tag, stats);
        stats.blockTag = tag;
        stats.horizontalPrecedence = 50;
        stats.verticalPrecendence = 40;
        stats.topSpeedBps = ((Double)XenoTechConfig.COMMON.jetThrusterTopSpeedBps.get()).floatValue();
        stats.timeToTopSpeed = ((Double)XenoTechConfig.COMMON.jetThrusterTimeToTopSpeed.get()).floatValue();
        stats.verticalTopSpeedBps = ((Double)XenoTechConfig.COMMON.verticalJetThrusterTopSpeedBps.get()).floatValue();
        stats.verticalTimeToTopSpeed = ((Double)XenoTechConfig.COMMON.verticalJetThrusterTimeToTopSpeed.get()).floatValue();
        stats.topSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.jetThrusterTopSpeedBpsPer1000lb.get()).floatValue();
        stats.timeToTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.jetThrusterTimeToTopSpeedPer1000lb.get()).floatValue();
        stats.verticalTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.verticalJetThrusterTopSpeedBpsPer1000lb.get()).floatValue();
        stats.verticalTimeToTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.verticalJetThrusterTimeToTopSpeedPer1000lb.get()).floatValue();
        stats = new BuiltInMoverStats();
        tag = helicopterRotorBlockTag;
        stagingBuiltInMovers.put(tag, stats);
        stats.blockTag = tag;
        stats.horizontalPrecedence = 20;
        stats.verticalPrecendence = 30;
        stats.topSpeedBps = ((Double)XenoTechConfig.COMMON.helicopterRotorTopSpeedBps.get()).floatValue();
        stats.timeToTopSpeed = ((Double)XenoTechConfig.COMMON.helicopterRotorTimeToTopSpeed.get()).floatValue();
        stats.verticalTopSpeedBps = ((Double)XenoTechConfig.COMMON.verticalHelicopterRotorTopSpeedBps.get()).floatValue();
        stats.verticalTimeToTopSpeed = ((Double)XenoTechConfig.COMMON.verticalHelicopterRotorTimeToTopSpeed.get()).floatValue();
        stats.topSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.helicopterRotorTopSpeedBpsPer1000lb.get()).floatValue();
        stats.timeToTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.helicopterRotorTimeToTopSpeedPer1000lb.get()).floatValue();
        stats.verticalTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.verticalHelicopterRotorTopSpeedBpsPer1000lb.get()).floatValue();
        stats.verticalTimeToTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.verticalHelicopterRotorTimeToTopSpeedPer1000lb.get()).floatValue();
        stats = new BuiltInMoverStats();
        tag = flagshipHelicopterRotorBlockTag;
        stagingBuiltInMovers.put(tag, stats);
        stats.blockTag = tag;
        stats.horizontalPrecedence = 30;
        stats.verticalPrecendence = 40;
        stats.topSpeedBps = ((Double)XenoTechConfig.COMMON.flagshipHelicopterRotorTopSpeedBps.get()).floatValue();
        stats.timeToTopSpeed = ((Double)XenoTechConfig.COMMON.flagshipHelicopterRotorTimeToTopSpeed.get()).floatValue();
        stats.verticalTopSpeedBps = ((Double)XenoTechConfig.COMMON.verticalFlagshipHelicopterRotorTopSpeedBps.get()).floatValue();
        stats.verticalTimeToTopSpeed = ((Double)XenoTechConfig.COMMON.verticalFlagshipHelicopterRotorTimeToTopSpeed.get()).floatValue();
        stats.topSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.flagshipHelicopterRotorTopSpeedBpsPer1000lb.get()).floatValue();
        stats.timeToTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.flagshipHelicopterRotorTimeToTopSpeedPer1000lb.get()).floatValue();
        stats.verticalTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.verticalFlagshipHelicopterRotorTopSpeedBpsPer1000lb.get()).floatValue();
        stats.verticalTimeToTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.verticalFlagshipHelicopterRotorTimeToTopSpeedPer1000lb.get()).floatValue();
        stats = new BuiltInMoverStats();
        tag = flagshipPropellerBlockTag;
        stagingBuiltInMovers.put(tag, stats);
        stats.blockTag = tag;
        stats.horizontalPrecedence = 40;
        stats.verticalPrecendence = 30;
        stats.topSpeedBps = ((Double)XenoTechConfig.COMMON.flagshipPropellerTopSpeedBps.get()).floatValue();
        stats.timeToTopSpeed = ((Double)XenoTechConfig.COMMON.flagshipPropellerTimeToTopSpeed.get()).floatValue();
        stats.verticalTopSpeedBps = ((Double)XenoTechConfig.COMMON.verticalFlagshipPropellerTopSpeedBps.get()).floatValue();
        stats.verticalTimeToTopSpeed = ((Double)XenoTechConfig.COMMON.verticalFlagshipPropellerTimeToTopSpeed.get()).floatValue();
        stats.topSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.flagshipPropellerTopSpeedBpsPer1000lb.get()).floatValue();
        stats.timeToTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.flagshipPropellerTimeToTopSpeedPer1000lb.get()).floatValue();
        stats.verticalTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.verticalFlagshipPropellerTopSpeedBpsPer1000lb.get()).floatValue();
        stats.verticalTimeToTopSpeedBpsPer1000lb = ((Double)XenoTechConfig.COMMON.verticalFlagshipPropellerTimeToTopSpeedPer1000lb.get()).floatValue();
        builtInMovers = stagingBuiltInMovers;
    }

    public static Point2D.Double rotate2D(double xDiff, double yDiff, double angle, Point2D.Double origin) {
        double cos = 0.0;
        double sin = 0.0;
        boolean recalculate = true;
        if (!firstRunRotate2D && angle == lastCalculatedAngle) {
            recalculate = false;
            cos = lastCos;
            sin = lastSin;
        }
        if (recalculate) {
            cos = Math.cos(angle * 0.01745329238474369);
            sin = Math.sin(angle * 0.01745329238474369);
            firstRunRotate2D = false;
            lastCalculatedAngle = angle;
            lastCos = cos;
            lastSin = sin;
        }
        double xFinal = cos * xDiff - sin * yDiff + origin.x;
        double yFinal = sin * xDiff + cos * yDiff + origin.y;
        return new Point2D.Double(xFinal, yFinal);
    }

    public static Vec3 revolve(Point2D.Double origin, float yRotDiff, Vec3 input) {
        double xDist = input.f_82479_ - origin.getX();
        double zDist = input.f_82481_ - origin.getY();
        Point2D.Double rotated = XenoTechUtils.rotate2D(xDist, zDist, yRotDiff, origin);
        return new Vec3(rotated.x, input.f_82480_, rotated.y);
    }

    public static Vec3 getRotPosForRenderable(DummyEntity dummy, RenderableBlock renderable) {
        Vec3 rotPos = XenoTechUtils.revolve(dummy, new Vec3(renderable.absoluteX(dummy), renderable.absoluteY(dummy), renderable.absoluteZ(dummy)));
        return rotPos;
    }

    public static BlockPos blockPosFromRotPos(Vec3 rotPos) {
        return BlockPos.m_274446_((Position)new Vec3((double)Math.round(rotPos.f_82479_), (double)Math.round(rotPos.f_82480_), (double)Math.round(rotPos.f_82481_)));
    }

    public static Vec3 getInterpRotPosForRenderable(float partialTick, DummyEntity dummy, RenderableBlock renderable) {
        Vec3 pos = dummy.m_20318_(partialTick);
        Vec3 rotPos = XenoTechUtils.revolveInterpOrigin(partialTick, dummy, new Vec3(renderable.relativeX + pos.f_82479_, renderable.relativeY + pos.f_82480_, renderable.relativeZ + pos.f_82481_));
        return rotPos;
    }

    public static BlockState getRotatedBlockState(DummyEntity dummy, RenderableBlock renderable) {
        if (renderable.tag != null) {
            return renderable.state;
        }
        float disassemblyRot = dummy.get90DegreeDisassemblyAngle();
        Rotation rotation = dummy.getBlockStateRotationForDisassembly(dummy.getSanitizedStartingAngle(), disassemblyRot);
        BlockState rotated = renderable.state;
        try {
            rotated = renderable.state.m_60717_(rotation);
        }
        catch (Exception ex) {
            LOGGER.error("Error rotating state: " + renderable.state);
        }
        return rotated;
    }

    public static Vec3 revolve(DummyEntity e, Vec3 input) {
        input = new Vec3(input.f_82479_ + 0.5, input.f_82480_, input.f_82481_ + 0.5);
        Vec3 result = XenoTechUtils.revolve(new Point2D.Double(e.m_20185_(), e.m_20189_()), e.getYRotDiff(), input);
        result = new Vec3(result.f_82479_ - 0.5, result.f_82480_, result.f_82481_ - 0.5);
        return result;
    }

    public static Vec3 revolveInterpOrigin(float partialTick, DummyEntity e, Vec3 input) {
        Vec3 origin = e.m_20318_(partialTick);
        input = new Vec3(input.f_82479_ + 0.5, input.f_82480_, input.f_82481_ + 0.5);
        Vec3 result = XenoTechUtils.revolve(new Point2D.Double(origin.f_82479_, origin.f_82481_), e.getInterpYRotDiff(partialTick), input);
        result = new Vec3(result.f_82479_ - 0.5, result.f_82480_, result.f_82481_ - 0.5);
        return result;
    }

    private static BlockPos blockPosRotateClockwise(DummyEntity e, BlockPos pos) {
        BlockPos terminalPos = e.startingTerminalPos;
        BlockPos posDiff = pos.m_121996_((Vec3i)terminalPos);
        return new BlockPos(terminalPos.m_123341_() - posDiff.m_123343_(), pos.m_123342_(), terminalPos.m_123343_() + posDiff.m_123341_());
    }

    private static BlockPos startingPosToCurrentPos(DummyEntity e, BlockPos pos) {
        return new BlockPos(e.m_20183_().m_123341_() + pos.m_123341_() - e.startingTerminalPos.m_123341_(), e.m_20183_().m_123342_() + pos.m_123342_() - e.startingTerminalPos.m_123342_(), e.m_20183_().m_123343_() + pos.m_123343_() - e.startingTerminalPos.m_123343_());
    }

    public static BlockPos blockPosRotate(DummyEntity e, BlockPos pos) {
        float sanitizedYRot = e.get90DegreeReassemblyAngle();
        BlockPos rotated = pos;
        if ((double)sanitizedYRot == 0.0) {
            return XenoTechUtils.startingPosToCurrentPos(e, rotated);
        }
        if (sanitizedYRot == 90.0f) {
            rotated = XenoTechUtils.blockPosRotateClockwise(e, rotated);
            LOGGER.debug("Got 90deg rotation from =" + pos + " to " + rotated + " from startingTerminalPos=" + e.startingTerminalPos);
            return XenoTechUtils.startingPosToCurrentPos(e, rotated);
        }
        if (sanitizedYRot == 180.0f) {
            rotated = XenoTechUtils.blockPosRotateClockwise(e, rotated);
            rotated = XenoTechUtils.blockPosRotateClockwise(e, rotated);
            LOGGER.debug("Got 180deg rotation from =" + pos + " to " + rotated + " from startingTerminalPos=" + e.startingTerminalPos);
            return XenoTechUtils.startingPosToCurrentPos(e, rotated);
        }
        if (sanitizedYRot == 270.0f) {
            rotated = XenoTechUtils.blockPosRotateClockwise(e, rotated);
            rotated = XenoTechUtils.blockPosRotateClockwise(e, rotated);
            rotated = XenoTechUtils.blockPosRotateClockwise(e, rotated);
            LOGGER.debug("Got 270deg rotation from =" + pos + " to " + rotated + " from startingTerminalPos=" + e.startingTerminalPos);
            return XenoTechUtils.startingPosToCurrentPos(e, rotated);
        }
        return new BlockPos(0, 0, 0);
    }

    public static boolean canVisit(BlockState visitingFromState, BlockPos pos, Level level, Set<BlockPos> enqueuedBlocks) {
        BlockState state;
        boolean isVehicleBorderBlock;
        boolean isWaterloggedRudder = visitingFromState.m_204336_(boatSteeringBlockTag) && (Boolean)visitingFromState.m_61143_((Property)BlockStateProperties.f_61362_) != false;
        boolean bl = isVehicleBorderBlock = visitingFromState.m_204336_(vehicleBorderBlockTag) && level.m_8055_(pos).m_60734_() != visitingFromState.m_60734_();
        if (isWaterloggedRudder || isVehicleBorderBlock) {
            return false;
        }
        if (blacklisted == null) {
            blacklisted = Set.of(Blocks.f_49991_, Blocks.f_49990_, Blocks.f_50088_, Blocks.f_50125_, Blocks.f_50035_, Blocks.f_50360_, Blocks.f_50034_, Blocks.f_50359_, Blocks.f_50037_, Blocks.f_50038_, Blocks.f_50575_, Blocks.f_50576_, (Block)XenoBlocks.BLOCK_SHIPYARD_CONSTRUCTION_PLATFORM.get());
        }
        return (state = level.m_8055_(pos)).m_60808_((BlockGetter)level, pos) != Shapes.m_83040_() && !state.m_60795_() && !blacklisted.contains(state.m_60734_()) && !enqueuedBlocks.contains(pos);
    }

    public static void addToQueueIfPossible(BlockState visitingFromState, Queue<BlockPos> toVisit, BlockPos pos, Level level, Set<BlockPos> enqueuedBlocks) {
        if (XenoTechUtils.canVisit(visitingFromState, pos, level, enqueuedBlocks)) {
            enqueuedBlocks.add(pos);
            toVisit.add(pos);
        }
    }

    public static String getImperialOrMetricWeightText(float weightInLbs) {
        float convertedWeight = weightInLbs;
        String unitText = " lb";
        if (!useImperialUnits) {
            convertedWeight = weightInLbs / 2.205f;
            unitText = " kg";
        }
        return String.format("%,.1f", Float.valueOf(convertedWeight)) + unitText;
    }

    public static void appendFailureTextBlockCounts(Map<Block, Integer> blockCountMap, Set<BlockPos> visited, FailureInfo failure, float weight) {
        int otherBlockCount;
        if (failure.text == null) {
            failure.text = "";
        }
        StringBuilder sb = new StringBuilder();
        String foundXBlocksWithWeightText = Component.m_237110_((String)"terminal.xenotech.found_x_blocks_with_weight", (Object[])new Object[]{visited.size()}).getString();
        sb.append(foundXBlocksWithWeightText + XenoTechUtils.getImperialOrMetricWeightText(weight) + ": \n");
        TreeSet<Map.Entry<Block, Integer>> blockCounts = new TreeSet<Map.Entry<Block, Integer>>(new Comparator<Map.Entry<Block, Integer>>(){

            @Override
            public int compare(Map.Entry<Block, Integer> a, Map.Entry<Block, Integer> b) {
                int diff = b.getValue() - a.getValue();
                if (diff == 0) {
                    return a.getKey().m_49954_().getString().compareTo(b.getKey().m_49954_().getString());
                }
                return diff;
            }
        });
        for (Map.Entry<Block, Integer> entry : blockCountMap.entrySet()) {
            boolean bl = blockCounts.add(entry);
        }
        int blockCountSum = 0;
        int counter = 0;
        for (Map.Entry entry : blockCounts) {
            sb.append("    " + ((Block)entry.getKey()).m_49954_().getString() + ": " + entry.getValue() + " \n");
            blockCountSum += ((Integer)entry.getValue()).intValue();
            if (++counter != 4) continue;
            break;
        }
        if ((otherBlockCount = visited.size() - blockCountSum) > 0) {
            sb.append("    Other: " + otherBlockCount + " \n");
        }
        failure.text = failure.text.concat(sb.toString());
    }

    public static float getWeightForBlock(BlockState state) {
        float destroyTime = state.m_60734_().m_155943_();
        if (destroyTime >= 30.0f) {
            destroyTime = 10.0f;
        }
        if (destroyTime < 0.0f) {
            destroyTime = 15.0f;
        }
        if (state.m_60827_() == SoundType.f_56736_) {
            destroyTime = (float)((double)destroyTime * woodWeightMultiplier);
        }
        if (state.m_60734_() instanceof ChainBlock) {
            destroyTime = (float)((double)destroyTime * chainWeightMultiplier);
        }
        float destroyTimeSqr = (float)Math.pow(destroyTime, blockWeightExponent);
        return destroyTimeSqr * weightConversionRatio;
    }

    public static boolean isLiftMover(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof PropellerBlock) {
            PropellerBlock prop = (PropellerBlock)block;
            if (state.m_61143_((Property)PropellerBlock.f_52588_) == Direction.UP) {
                return true;
            }
        } else {
            block = state.m_60734_();
            if (block instanceof JetThrusterBlock) {
                JetThrusterBlock jet = (JetThrusterBlock)block;
                if (state.m_61143_((Property)PropellerBlock.f_52588_) == Direction.UP) {
                    return true;
                }
            } else if (state.m_204336_(liftMoverBlockTag)) {
                return true;
            }
        }
        return false;
    }

    public static int getMoverPrecedence(Block moverBlock, boolean liftPower) {
        if (moverBlock == null) {
            return -1;
        }
        for (BuiltInMoverStats m : builtInMovers.values()) {
            if (!liftPower && moverBlock.m_204297_().m_203656_(m.blockTag)) {
                return m.horizontalPrecedence;
            }
            if (!liftPower || !moverBlock.m_204297_().m_203656_(m.blockTag)) continue;
            return m.verticalPrecendence;
        }
        return -1;
    }

    public static MoverStats getPowerForMover(Block moverBlock, int moverCount, boolean liftPower) {
        MoverStats result = new MoverStats();
        result.acceleration = 0.0f;
        result.topSpeed = 0.0f;
        if (moverCount <= 0) {
            return result;
        }
        float diminish = (float)Math.pow(moverDiminishingReturns, moverCount - 1);
        float topSpeedAddedBpsAt1000Lb = 0.0f;
        float timeToReachAddedSpeedSec = 10.0f;
        for (BuiltInMoverStats m : builtInMovers.values()) {
            if (!liftPower && moverBlock.m_204297_().m_203656_(m.blockTag)) {
                topSpeedAddedBpsAt1000Lb = m.topSpeedBpsPer1000lb;
                timeToReachAddedSpeedSec = m.timeToTopSpeedBpsPer1000lb;
            }
            if (!liftPower || !moverBlock.m_204297_().m_203656_(m.blockTag)) continue;
            topSpeedAddedBpsAt1000Lb = m.verticalTopSpeedBpsPer1000lb;
            timeToReachAddedSpeedSec = m.verticalTimeToTopSpeedBpsPer1000lb;
        }
        float topSpeedPerTickAt1000Lb = topSpeedAddedBpsAt1000Lb / ticksPerSecond;
        result.acceleration = topSpeedPerTickAt1000Lb / timeToReachAddedSpeedSec / ticksPerSecond * diminish;
        result.topSpeed = topSpeedPerTickAt1000Lb * diminish;
        return result;
    }

    public static void limitMaxPowerForMover(MoverStats moverStats, boolean liftPower, DummyEntity.VehicleType vehicleType) {
        Block engineBlock = moverStats.moverBlockType;
        if (engineBlock == null) {
            return;
        }
        float topSpeedBps = 1.0f;
        float secsToReachTopSpeed = 10.0f;
        for (BuiltInMoverStats m : builtInMovers.values()) {
            if (!liftPower && engineBlock.m_204297_().m_203656_(m.blockTag)) {
                topSpeedBps = m.topSpeedBps;
                secsToReachTopSpeed = m.timeToTopSpeed;
                break;
            }
            if (!liftPower || !engineBlock.m_204297_().m_203656_(m.blockTag)) continue;
            topSpeedBps = m.verticalTopSpeedBps;
            secsToReachTopSpeed = m.verticalTimeToTopSpeed;
            break;
        }
        float maxTopSpeedPerTick = topSpeedBps / ticksPerSecond;
        float accelPerSec = maxTopSpeedPerTick / secsToReachTopSpeed;
        float maxAccelPerTick = accelPerSec / ticksPerSecond;
        moverStats.acceleration = Math.min(maxAccelPerTick, moverStats.acceleration);
        moverStats.topSpeed = Math.min(maxTopSpeedPerTick, moverStats.topSpeed);
        if (vehicleType == DummyEntity.VehicleType.SUBMARINE) {
            moverStats.acceleration *= submarineTopSpeedModifier;
            moverStats.topSpeed *= submarineAccelerationModifier;
        }
    }

    public static Set<BlockPos> getNewShipBlocks(Level level, BlockPos pos, FailureInfo failure, CompositionInfo composition) {
        LinkedList<BlockPos> toVisit = new LinkedList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        HashSet<BlockPos> enqueuedBlocks = new HashSet<BlockPos>();
        HashMap<Block, Integer> blockCountMap = new HashMap<Block, Integer>();
        float weight = 0.0f;
        MoverStats moverStats = new MoverStats();
        MoverStats liftMoverStats = new MoverStats();
        int minX = pos.m_123341_();
        int minY = pos.m_123342_();
        int minZ = pos.m_123343_();
        int maxX = pos.m_123341_();
        int maxY = pos.m_123342_();
        int maxZ = pos.m_123343_();
        toVisit.add(pos);
        enqueuedBlocks.add(pos);
        boolean foundShipyardBlockUnderneath = false;
        boolean foundMover = false;
        boolean foundSteering = false;
        boolean steeringTypeConflict = false;
        boolean isBoat = false;
        boolean isGroundVehicle = false;
        int fwdMoverCount = 0;
        int liftMoverCount = 0;
        DummyEntity.VehicleType vehicleType = null;
        boolean isLargeShipOnlyMover = false;
        while (!toVisit.isEmpty()) {
            BlockPos current = (BlockPos)toVisit.poll();
            visited.add(current);
            BlockState currentState = level.m_8055_(current);
            Integer count = (Integer)blockCountMap.get(currentState.m_60734_());
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            blockCountMap.put(currentState.m_60734_(), count);
            weight += XenoTechUtils.getWeightForBlock(currentState);
            if (visited.size() > maxShipBlockCount) {
                if (failure != null) {
                    failure.code = FailureCode.EXCEEDED_MAX_BLOCKS;
                    failure.text = "Exceeded maximum block count for ship: " + maxShipBlockCount + " \n \n";
                    XenoTechUtils.appendFailureTextBlockCounts(blockCountMap, visited, failure, weight);
                }
                return null;
            }
            if (currentState.m_204336_(moverBlockTag)) {
                boolean isLiftMover = XenoTechUtils.isLiftMover(currentState);
                int loopCount = 1;
                if (currentState.m_204336_(dualMoverBlockTag)) {
                    LOGGER.debug("got dual engine: " + currentState);
                    loopCount = 2;
                }
                for (int p = 0; p < loopCount; ++p) {
                    Block priorBlockType = isLiftMover ? liftMoverStats.moverBlockType : moverStats.moverBlockType;
                    int priorPrecedence = XenoTechUtils.getMoverPrecedence(priorBlockType, isLiftMover);
                    int precedence = XenoTechUtils.getMoverPrecedence(currentState.m_60734_(), isLiftMover);
                    String engineType = "fwd";
                    if (isLiftMover) {
                        engineType = "lift";
                    }
                    LOGGER.debug("got " + engineType + " engine=" + currentState + " with precedence=" + precedence + " and prior=" + priorPrecedence);
                    if (precedence > priorPrecedence) {
                        LOGGER.debug("got new highest precedence value=" + precedence + ", for lift=" + isLiftMover);
                        if (isLiftMover) {
                            liftMoverCount = 0;
                            liftMoverStats.acceleration = 0.0f;
                            liftMoverStats.topSpeed = 0.0f;
                        } else {
                            fwdMoverCount = 0;
                            moverStats.acceleration = 0.0f;
                            moverStats.topSpeed = 0.0f;
                        }
                    }
                    if (precedence >= priorPrecedence && precedence != -1) {
                        if (isLiftMover) {
                            ++liftMoverCount;
                            if (currentState.m_204336_(largeShipOnlyMoverBlockTag)) {
                                isLargeShipOnlyMover = true;
                            }
                            if ((result = XenoTechUtils.getPowerForMover(currentState.m_60734_(), liftMoverCount, true)) != null) {
                                liftMoverStats.acceleration += result.acceleration;
                                liftMoverStats.topSpeed += result.topSpeed;
                                liftMoverStats.moverBlockType = currentState.m_60734_();
                                liftMoverStats.moverCount = liftMoverCount;
                            }
                        } else {
                            foundMover = true;
                            ++fwdMoverCount;
                            if (currentState.m_204336_(largeShipOnlyMoverBlockTag)) {
                                isLargeShipOnlyMover = true;
                            }
                            if ((result = XenoTechUtils.getPowerForMover(currentState.m_60734_(), fwdMoverCount, false)) != null) {
                                moverStats.acceleration += result.acceleration;
                                moverStats.topSpeed += result.topSpeed;
                                moverStats.moverBlockType = currentState.m_60734_();
                                moverStats.moverCount = fwdMoverCount;
                                LOGGER.debug("add top speed: " + result.topSpeed + " for new topSpeed=" + moverStats.topSpeed);
                            }
                        }
                    }
                    isLiftMover = !isLiftMover;
                }
            }
            if (!foundSteering && currentState.m_204336_(boatSteeringBlockTag)) {
                isGroundVehicle = false;
                foundSteering = true;
                isBoat = true;
                vehicleType = DummyEntity.VehicleType.BOAT;
            }
            if (!foundSteering && currentState.m_204336_(submarineSteeringBlockTag)) {
                isGroundVehicle = false;
                foundSteering = true;
                isBoat = false;
                vehicleType = DummyEntity.VehicleType.SUBMARINE;
                liftMoverStats.acceleration = 0.5f;
                liftMoverStats.moverBlockType = (Block)XenoBlocks.BLOCK_PROPELLER.get();
                liftMoverStats.moverCount = 1;
                liftMoverStats.topSpeed = 3.0f;
            }
            if (!foundSteering && currentState.m_204336_(airshipSteeringBlockTag)) {
                foundSteering = true;
                isBoat = false;
                isGroundVehicle = false;
            }
            if (!foundSteering && currentState.m_204336_(groundSteeringBlockTag)) {
                isBoat = false;
                foundSteering = true;
                isGroundVehicle = true;
                vehicleType = DummyEntity.VehicleType.GROUND;
            }
            if (current.m_123341_() < minX) {
                minX = current.m_123341_();
            }
            if (current.m_123342_() < minY) {
                minY = current.m_123342_();
            }
            if (current.m_123343_() < minZ) {
                minZ = current.m_123343_();
            }
            if (current.m_123341_() > maxX) {
                maxX = current.m_123341_();
            }
            if (current.m_123342_() > maxY) {
                maxY = current.m_123342_();
            }
            if (current.m_123343_() > maxZ) {
                maxZ = current.m_123343_();
            }
            BlockPos above = current.m_7494_();
            BlockPos below = current.m_7495_();
            BlockPos north = current.m_122012_();
            BlockPos south = current.m_122019_();
            BlockPos east = current.m_122029_();
            BlockPos west = current.m_122024_();
            BlockState belowState = level.m_8055_(below);
            if (belowState.m_60713_((Block)XenoBlocks.BLOCK_SHIPYARD_CONSTRUCTION_PLATFORM.get())) {
                foundShipyardBlockUnderneath = true;
            }
            XenoTechUtils.addToQueueIfPossible(currentState, toVisit, above, level, enqueuedBlocks);
            XenoTechUtils.addToQueueIfPossible(currentState, toVisit, below, level, enqueuedBlocks);
            XenoTechUtils.addToQueueIfPossible(currentState, toVisit, north, level, enqueuedBlocks);
            XenoTechUtils.addToQueueIfPossible(currentState, toVisit, east, level, enqueuedBlocks);
            XenoTechUtils.addToQueueIfPossible(currentState, toVisit, south, level, enqueuedBlocks);
            XenoTechUtils.addToQueueIfPossible(currentState, toVisit, west, level, enqueuedBlocks);
            if (!includeDiagonals) continue;
            BlockPos ne = current.m_122012_().m_122029_();
            BlockPos nw = current.m_122012_().m_122024_();
            BlockPos se = current.m_122019_().m_122029_();
            BlockPos sw = current.m_122019_().m_122024_();
            XenoTechUtils.addToQueueIfPossible(currentState, toVisit, ne, level, enqueuedBlocks);
            XenoTechUtils.addToQueueIfPossible(currentState, toVisit, nw, level, enqueuedBlocks);
            XenoTechUtils.addToQueueIfPossible(currentState, toVisit, se, level, enqueuedBlocks);
            XenoTechUtils.addToQueueIfPossible(currentState, toVisit, sw, level, enqueuedBlocks);
            BlockPos aboveNorth = current.m_7494_().m_122012_();
            BlockPos aboveSouth = current.m_7494_().m_122019_();
            BlockPos aboveEast = current.m_7494_().m_122029_();
            BlockPos aboveWest = current.m_7494_().m_122024_();
            BlockPos belowNorth = current.m_7495_().m_122012_();
            BlockPos belowSouth = current.m_7495_().m_122019_();
            BlockPos belowEast = current.m_7495_().m_122029_();
            BlockPos belowWest = current.m_7495_().m_122024_();
            XenoTechUtils.addToQueueIfPossible(currentState, toVisit, aboveNorth, level, enqueuedBlocks);
            XenoTechUtils.addToQueueIfPossible(currentState, toVisit, aboveSouth, level, enqueuedBlocks);
            XenoTechUtils.addToQueueIfPossible(currentState, toVisit, aboveEast, level, enqueuedBlocks);
            XenoTechUtils.addToQueueIfPossible(currentState, toVisit, aboveWest, level, enqueuedBlocks);
            XenoTechUtils.addToQueueIfPossible(currentState, toVisit, belowNorth, level, enqueuedBlocks);
            XenoTechUtils.addToQueueIfPossible(currentState, toVisit, belowSouth, level, enqueuedBlocks);
            XenoTechUtils.addToQueueIfPossible(currentState, toVisit, belowEast, level, enqueuedBlocks);
            XenoTechUtils.addToQueueIfPossible(currentState, toVisit, belowWest, level, enqueuedBlocks);
        }
        if (constructionPlatformIsRequired && !foundShipyardBlockUnderneath) {
            if (failure != null) {
                failure.code = FailureCode.REQUIRES_PLATFORM;
                failure.text = "Did not find any Shipyard Construction Platform blocks under your ship, these are required \n \n";
                XenoTechUtils.appendFailureTextBlockCounts(blockCountMap, visited, failure, weight);
            }
            return null;
        }
        if (!foundMover && !foundSteering) {
            if (failure != null) {
                failure.code = FailureCode.NO_MOVER_AND_NO_STEERING;
                failure.text = "Ship contains no 'mover' and no steering element \n \n";
                XenoTechUtils.appendFailureTextBlockCounts(blockCountMap, visited, failure, weight);
            }
            return null;
        }
        if (!foundMover || foundMover && !isBoat && moverStats.moverBlockType.m_204297_().m_203656_(boatSailBlockTag)) {
            if (failure != null) {
                failure.code = FailureCode.NO_MOVER;
                failure.text = "Ship has steering but lacks 'mover' \n \n";
                XenoTechUtils.appendFailureTextBlockCounts(blockCountMap, visited, failure, weight);
            }
            return null;
        }
        if (!foundSteering) {
            if (failure != null) {
                failure.code = FailureCode.NO_STEERING;
                failure.text = "Ship has 'mover' but lacks steering \n \n";
                XenoTechUtils.appendFailureTextBlockCounts(blockCountMap, visited, failure, weight);
            }
            return null;
        }
        if (isLargeShipOnlyMover && visited.size() < largeShipMoverThreshold) {
            if (failure != null) {
                failure.code = FailureCode.LARGE_MOVER_ONLY;
                failure.text = "Ship 'mover' can only support very large ships: " + largeShipMoverThreshold + "+ blocks \n \n";
                XenoTechUtils.appendFailureTextBlockCounts(blockCountMap, visited, failure, weight);
            }
            return null;
        }
        if (failure != null) {
            XenoTechUtils.appendFailureTextBlockCounts(blockCountMap, visited, failure, weight);
        }
        if (vehicleType == null) {
            if (liftMoverStats.moverBlockType instanceof BalloonBlock) {
                vehicleType = DummyEntity.VehicleType.BALLOON;
            } else if (liftMoverStats.moverBlockType != null) {
                LOGGER.debug("assigned helicopter");
                vehicleType = DummyEntity.VehicleType.HELICOPTER;
            } else {
                vehicleType = DummyEntity.VehicleType.PLANE;
            }
        }
        if (vehicleType == DummyEntity.VehicleType.SUBMARINE) {
            if (moverStats.moverBlockType instanceof JetThrusterBlock || liftMoverStats.moverBlockType instanceof JetThrusterBlock) {
                failure.code = FailureCode.CONFLICTING_STEERING_TYPES;
                failure.text = "Submarines cannot be powered by jet thrusters! \n \n";
                XenoTechUtils.appendFailureTextBlockCounts(blockCountMap, visited, failure, weight);
                return null;
            }
            moverStats.acceleration *= 1.3f;
            moverStats.topSpeed *= 1.3f;
        }
        if (composition != null) {
            composition.blockCountMap = blockCountMap;
            composition.weight = weight;
            composition.fwdMoverStats = moverStats;
            composition.liftMoverStats = liftMoverStats;
            composition.isBoat = isBoat;
            composition.isGroundVehicle = isGroundVehicle;
            composition.vehicleType = vehicleType;
            composition.minX = minX;
            composition.minY = minY;
            composition.minZ = minZ;
            composition.maxX = maxX;
            composition.maxY = maxY;
            composition.maxZ = maxZ;
        }
        return visited;
    }

    public static VoxelShape breakIntoCubesWithSameHeight(final BlockPos pos, VoxelShape shape, final int outputMultiplierCount, final DummyEntity rotateAround) {
        VoxelShape result = null;
        if (outputMultiplierCount <= 0) {
            return shape;
        }
        final ArrayList miniCubes = new ArrayList();
        final ArrayList<Integer> boxCount = new ArrayList<Integer>(1);
        boxCount.add(0);
        shape.m_83286_(new Shapes.DoubleLineConsumer(){

            public void m_83161_(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
                boxCount.set(0, (Integer)boxCount.get(0) + 1);
                double xSpan = maxX - minX;
                double ySpan = maxY - minY;
                double zSpan = maxZ - minZ;
                double unitX = xSpan / (double)outputMultiplierCount;
                double unitY = ySpan / (double)outputMultiplierCount;
                double unitZ = zSpan / (double)outputMultiplierCount;
                double xCurrent = minX;
                double yCurrent = minY;
                double zCurrent = minZ;
                for (int x = 0; x < 1; ++x) {
                    yCurrent = minY;
                    for (int y = 0; y < 1; ++y) {
                        zCurrent = minZ;
                        for (int z = 0; z < outputMultiplierCount; ++z) {
                            double cubeX = maxX;
                            double cubeY = maxY;
                            double cubeZ = zCurrent + unitZ;
                            Vec3 minPoint = new Vec3(xCurrent, yCurrent, zCurrent);
                            Vec3 maxPoint = new Vec3(cubeX, cubeY, cubeZ);
                            float yRotDiff = 0.0f;
                            if (rotateAround != null) {
                                DummyEntity e = rotateAround;
                                Vec3 minPointOrig = minPoint;
                                Vec3 maxPointOrig = maxPoint;
                                Point2D.Double pt = new Point2D.Double((double)pos.m_123341_() + 0.5, (double)pos.m_123343_() + 0.5);
                                boolean shouldRoundRotation = true;
                                float roundingMultiple = 45.0f;
                                yRotDiff = e.getYRotDiff();
                                if (shouldRoundRotation) {
                                    yRotDiff = roundingMultiple * (float)((int)((yRotDiff + roundingMultiple / 2.0f) / roundingMultiple));
                                }
                                minPoint = XenoTechUtils.revolve(pt, yRotDiff, minPoint);
                                maxPoint = XenoTechUtils.revolve(pt, yRotDiff, maxPoint);
                                boolean swapX = false;
                                boolean swapZ = false;
                                if (minPoint.f_82479_ > maxPoint.f_82479_) {
                                    swapX = true;
                                }
                                if (minPoint.f_82481_ > maxPoint.f_82481_) {
                                    swapZ = true;
                                }
                                if (swapX || swapZ) {
                                    double smallestX = Math.min(minPoint.f_82479_, maxPoint.f_82479_);
                                    double largestX = Math.max(minPoint.f_82479_, maxPoint.f_82479_);
                                    double smallestZ = Math.min(minPoint.f_82481_, maxPoint.f_82481_);
                                    double largestZ = Math.max(minPoint.f_82481_, maxPoint.f_82481_);
                                    minPoint = new Vec3(smallestX, minPoint.f_82480_, smallestZ);
                                    maxPoint = new Vec3(largestX, maxPoint.f_82480_, largestZ);
                                }
                                LOGGER.trace("Converted minPoint from: " + minPointOrig + " to " + minPoint + " from midpoint: " + pt);
                                LOGGER.trace("Converted maxPoint from: " + maxPointOrig + " to " + maxPoint);
                            }
                            miniCubes.add(Shapes.m_166049_((double)minPoint.f_82479_, (double)minPoint.f_82480_, (double)minPoint.f_82481_, (double)maxPoint.f_82479_, (double)maxPoint.f_82480_, (double)maxPoint.f_82481_));
                            zCurrent += unitZ;
                        }
                    }
                }
            }
        });
        if (!miniCubes.isEmpty()) {
            result = Shapes.m_83040_();
            for (int i = 0; i < miniCubes.size(); ++i) {
                result = Shapes.m_83110_((VoxelShape)result, (VoxelShape)((VoxelShape)miniCubes.get(i)));
            }
            LOGGER.trace("Broke shape: " + shape + " of " + boxCount.get(0) + " boxes into " + miniCubes.size() + " cubes based on multiplier count=" + outputMultiplierCount + ", resultant=" + result);
            result.m_83286_(new Shapes.DoubleLineConsumer(){

                public void m_83161_(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
                    LOGGER.trace("Min=(" + minX + ", " + minY + ", " + minZ + "), Max=(" + maxX + ", " + maxY + ", " + maxZ + ")");
                }
            });
            LOGGER.trace("Shape finished");
        }
        if (result == null || result.m_83281_()) {
            return shape;
        }
        return result;
    }

    public static VoxelShape breakIntoCubes(final BlockPos pos, VoxelShape shape, final int outputMultiplierCount, final DummyEntity rotateAround) {
        VoxelShape result = null;
        if (outputMultiplierCount <= 0) {
            return shape;
        }
        final ArrayList miniCubes = new ArrayList();
        final ArrayList<Integer> boxCount = new ArrayList<Integer>(1);
        boxCount.add(0);
        shape.m_83286_(new Shapes.DoubleLineConsumer(){

            public void m_83161_(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
                boxCount.set(0, (Integer)boxCount.get(0) + 1);
                double xSpan = maxX - minX;
                double ySpan = maxY - minY;
                double zSpan = maxZ - minZ;
                double unitX = xSpan / (double)outputMultiplierCount;
                double unitY = ySpan / (double)outputMultiplierCount;
                double unitZ = zSpan / (double)outputMultiplierCount;
                double xCurrent = minX;
                double yCurrent = minY;
                double zCurrent = minZ;
                for (int x = 0; x < outputMultiplierCount; ++x) {
                    yCurrent = minY;
                    for (int y = 0; y < outputMultiplierCount; ++y) {
                        zCurrent = minZ;
                        for (int z = 0; z < outputMultiplierCount; ++z) {
                            double cubeX = xCurrent + unitX;
                            double cubeY = yCurrent + unitY;
                            double cubeZ = zCurrent + unitZ;
                            Vec3 minPoint = new Vec3(xCurrent, yCurrent, zCurrent);
                            Vec3 maxPoint = new Vec3(cubeX, cubeY, cubeZ);
                            if (rotateAround != null) {
                                DummyEntity e = rotateAround;
                                minPoint = XenoTechUtils.revolve(new Point2D.Double((double)pos.m_123341_() + 0.5, (double)pos.m_123343_() + 0.5), e.getYRotDiff(), minPoint);
                                maxPoint = XenoTechUtils.revolve(new Point2D.Double((double)pos.m_123341_() + 0.5, (double)pos.m_123343_() + 0.5), e.getYRotDiff(), maxPoint);
                            }
                            miniCubes.add(Shapes.m_166049_((double)minPoint.f_82479_, (double)minPoint.f_82480_, (double)minPoint.f_82481_, (double)maxPoint.f_82479_, (double)maxPoint.f_82480_, (double)maxPoint.f_82481_));
                            zCurrent += unitZ;
                        }
                        yCurrent += unitY;
                    }
                    xCurrent += unitX;
                }
            }
        });
        if (!miniCubes.isEmpty()) {
            result = Shapes.m_83040_();
            for (int i = 0; i < miniCubes.size(); ++i) {
                result = Shapes.m_83110_((VoxelShape)result, (VoxelShape)((VoxelShape)miniCubes.get(i)));
            }
            LOGGER.info("Broke shape: " + shape + " of " + boxCount.get(0) + " boxes into " + miniCubes.size() + " cubes based on multiplier count=" + outputMultiplierCount + ", resultant=" + result);
            result.m_83286_(new Shapes.DoubleLineConsumer(){

                public void m_83161_(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
                    LOGGER.info("Min=(" + minX + ", " + minY + ", " + minZ + "), Max=(" + maxX + ", " + maxY + ", " + maxZ + ")");
                }
            });
            LOGGER.info("Shape finished");
        }
        if (result == null || result.m_83281_()) {
            return shape;
        }
        return result;
    }

    public static void rotateVoxelShapeCubes(VoxelShape shape, final DummyEntity e) {
        shape.m_83286_(new Shapes.DoubleLineConsumer(){

            public void m_83161_(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
                Vec3 minPoint = new Vec3(minX, minY, minZ);
                Vec3 maxPoint = new Vec3(maxX, maxY, maxZ);
                XenoTechUtils.revolve(new Point2D.Double(e.m_20185_(), e.m_20189_()), e.getYRotDiff(), minPoint);
                XenoTechUtils.revolve(new Point2D.Double(e.m_20185_(), e.m_20189_()), e.getYRotDiff(), maxPoint);
            }
        });
    }

    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> inputType, BlockEntityType<E> expectedType, BlockEntityTicker<? super E> tickerInterface) {
        return inputType == expectedType ? tickerInterface : null;
    }

    public static void getCollisionShapesForDummy(Entity e, DummyEntity dummyEntity, List<VoxelShape> shapes, List<RenderableBlock> renderables) {
        for (RenderableBlock renderable : renderables) {
            Vec3 location = new Vec3(renderable.absoluteX(dummyEntity), renderable.absoluteY(dummyEntity), renderable.absoluteZ(dummyEntity));
            BlockPos pos = BlockPos.m_274561_((double)location.f_82479_, (double)location.f_82480_, (double)location.f_82481_);
            CollisionContext ctx = null;
            VoxelShape collisionShape = null;
            try {
                collisionShape = renderable.state.m_60742_((BlockGetter)dummyEntity.m_9236_(), pos, ctx);
            }
            catch (Exception ex) {
                LOGGER.debug("getCollisionShape error from BlockState=" + renderable.state + ", this is a bug in another mod, please report it to the author", (Throwable)ex);
            }
            if (collisionShape == null || collisionShape.m_83281_() || renderable.state.m_60734_() instanceof BedBlock && e instanceof LivingEntity && !((LivingEntity)e).m_5803_()) continue;
            collisionShape = collisionShape.m_83216_(location.f_82479_, location.f_82480_, location.f_82481_);
            shapes.add(collisionShape);
        }
    }

    public static VoxelShape RotateVoxelShapeClockwise(VoxelShape in) {
        final ArrayList generatedShapes = new ArrayList();
        in.m_83286_(new Shapes.DoubleLineConsumer(){

            public void m_83161_(double arg0, double arg1, double arg2, double arg3, double arg4, double arg5) {
                double xMin = arg0;
                double yMin = arg1;
                double zMin = arg2;
                double xMax = arg3;
                double yMax = arg4;
                double zMax = arg5;
                VoxelShape shape = Shapes.m_83048_((double)(1.0 - zMax), (double)yMin, (double)xMin, (double)(1.0 - zMin), (double)yMax, (double)xMax);
                generatedShapes.add(shape);
            }
        });
        if (generatedShapes.size() == 0) {
            return Shapes.m_83144_();
        }
        VoxelShape out = (VoxelShape)generatedShapes.get(0);
        for (int i = 1; i < generatedShapes.size(); ++i) {
            VoxelShape shape = (VoxelShape)generatedShapes.get(i);
            out = Shapes.m_83110_((VoxelShape)out, (VoxelShape)shape);
        }
        out.m_83296_();
        return out;
    }

    public static VoxelShape RotateVoxelShapeXAxis(VoxelShape in) {
        final ArrayList generatedShapes = new ArrayList();
        in.m_83286_(new Shapes.DoubleLineConsumer(){

            public void m_83161_(double arg0, double arg1, double arg2, double arg3, double arg4, double arg5) {
                double xMin = arg0;
                double yMin = arg1;
                double zMin = arg2;
                double xMax = arg3;
                double yMax = arg4;
                double zMax = arg5;
                VoxelShape shape = Shapes.m_83048_((double)xMin, (double)(1.0 - zMax), (double)yMin, (double)xMax, (double)(1.0 - zMin), (double)yMax);
                generatedShapes.add(shape);
            }
        });
        if (generatedShapes.size() == 0) {
            return Shapes.m_83144_();
        }
        VoxelShape out = (VoxelShape)generatedShapes.get(0);
        for (int i = 1; i < generatedShapes.size(); ++i) {
            VoxelShape shape = (VoxelShape)generatedShapes.get(i);
            out = Shapes.m_83110_((VoxelShape)out, (VoxelShape)shape);
        }
        out.m_83296_();
        return out;
    }

    static {
        ticksPerSecond = 20.0f;
        moverDiminishingReturns = 0.98f;
        includeDiagonals = true;
        weightConversionRatio = 35.0f;
        maxShipBlockCount = 2000;
    }

    public static class FailureInfo {
        public String text = null;
        public FailureCode code = FailureCode.NONE;
    }

    public static class MoverStats {
        public float acceleration = 0.0f;
        public float topSpeed = 0.0f;
        public int moverCount = 0;
        public Block moverBlockType = null;
    }

    public static enum FailureCode {
        NONE,
        REQUIRES_PLATFORM,
        EXCEEDED_MAX_BLOCKS,
        NO_MOVER_AND_NO_STEERING,
        NO_MOVER,
        NO_STEERING,
        CONFLICTING_STEERING_TYPES,
        LARGE_MOVER_ONLY;

    }

    public static class CompositionInfo {
        public Map<Block, Integer> blockCountMap = new HashMap<Block, Integer>();
        public float weight = 0.0f;
        public MoverStats fwdMoverStats = new MoverStats();
        public MoverStats liftMoverStats = new MoverStats();
        public boolean isBoat = false;
        public boolean isGroundVehicle = false;
        public DummyEntity.VehicleType vehicleType = null;
        public int minX = 0;
        public int minY = 0;
        public int minZ = 0;
        public int maxX = 0;
        public int maxY = 0;
        public int maxZ = 0;
    }
}

