/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.block;

import com.dairymoose.xenotech.XenoTechCommon;
import com.dairymoose.xenotech.XenoTechUtils;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractGateBlock
extends HorizontalDirectionalBlock {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    private boolean shouldSignal = true;
    private boolean allowSideInputs = true;
    protected static final VoxelShape NORTH_AABB = AbstractGateBlock.makeShape();
    protected static final VoxelShape EAST_AABB = XenoTechUtils.RotateVoxelShapeClockwise(NORTH_AABB);
    protected static final VoxelShape SOUTH_AABB = XenoTechUtils.RotateVoxelShapeClockwise(EAST_AABB);
    protected static final VoxelShape WEST_AABB = XenoTechUtils.RotateVoxelShapeClockwise(SOUTH_AABB);
    private int maxUpdatesPerTick = 2;
    private Map<BlockPos, Integer> updatesThisTickMap = new HashMap<BlockPos, Integer>();
    private long lastUpdatedTick = 0L;

    public AbstractGateBlock(BlockBehaviour.Properties blockProperties, boolean allowSideInputs) {
        super(blockProperties.m_60955_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH));
        this.allowSideInputs = allowSideInputs;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_}).m_61104_(new Property[]{POWER});
        super.m_7926_(builder);
    }

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.0, (double)0.8125, (double)0.1875, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext ctx) {
        switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case NORTH: {
                return NORTH_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
        }
        return NORTH_AABB;
    }

    public void m_5871_(ItemStack p_49816_, BlockGetter p_49817_, List<Component> components, TooltipFlag p_49819_) {
        components.add((Component)Component.m_237113_((String)"Redstone component"));
        super.m_5871_(p_49816_, p_49817_, components, p_49819_);
    }

    private int calculateTargetStrength(Level level, BlockPos blockPos, BlockState blockState) {
        Direction facing = (Direction)blockState.m_61143_((Property)f_54117_);
        Direction input1Direction = facing.m_122427_();
        Direction input2Direction = input1Direction.m_122427_();
        Direction input3Direction = input2Direction.m_122427_();
        BlockPos input1BlockPos = blockPos.m_121945_(input1Direction);
        BlockPos input2BlockPos = blockPos.m_121945_(input2Direction);
        BlockPos input3BlockPos = blockPos.m_121945_(input3Direction);
        BlockState input1BlockState = level.m_8055_(input1BlockPos);
        BlockState input2BlockState = level.m_8055_(input2BlockPos);
        BlockState input3BlockState = level.m_8055_(input3BlockPos);
        int inputSignal1 = level.m_277185_(input1BlockPos, input1Direction);
        int inputSignal2 = level.m_277185_(input2BlockPos, input2Direction);
        int inputSignal3 = level.m_277185_(input3BlockPos, input3Direction);
        int bool1 = inputSignal1 > 0 ? 1 : 0;
        int bool2 = inputSignal2 > 0 ? 1 : 0;
        int bool3 = inputSignal3 > 0 ? 1 : 0;
        LOGGER.trace("signals = [" + inputSignal1 + "," + inputSignal2 + "," + inputSignal3 + "]");
        if (this.allowSideInputs) {
            if (input1BlockState.canRedstoneConnectTo((BlockGetter)level, input1BlockPos, input1Direction.m_122424_()) && input2BlockState.canRedstoneConnectTo((BlockGetter)level, input2BlockPos, input2Direction.m_122424_()) && input3BlockState.canRedstoneConnectTo((BlockGetter)level, input3BlockPos, input3Direction.m_122424_())) {
                LOGGER.trace("three inputs");
                return this.threeInputsSignal(bool1, bool2, bool3);
            }
            if (input1BlockState.canRedstoneConnectTo((BlockGetter)level, input1BlockPos, input1Direction.m_122424_()) && input2BlockState.canRedstoneConnectTo((BlockGetter)level, input2BlockPos, input2Direction.m_122424_()) && !input3BlockState.canRedstoneConnectTo((BlockGetter)level, input3BlockPos, input3Direction.m_122424_())) {
                LOGGER.trace("two inputs");
                return this.twoInputsSignal(bool1, bool2);
            }
            if (input1BlockState.canRedstoneConnectTo((BlockGetter)level, input1BlockPos, input1Direction.m_122424_()) && !input2BlockState.canRedstoneConnectTo((BlockGetter)level, input2BlockPos, input2Direction.m_122424_()) && input3BlockState.canRedstoneConnectTo((BlockGetter)level, input3BlockPos, input3Direction.m_122424_())) {
                LOGGER.trace("two inputs");
                return this.twoInputsSignal(bool1, bool3);
            }
            if (!input1BlockState.canRedstoneConnectTo((BlockGetter)level, input1BlockPos, input1Direction.m_122424_()) && input2BlockState.canRedstoneConnectTo((BlockGetter)level, input2BlockPos, input2Direction.m_122424_()) && input3BlockState.canRedstoneConnectTo((BlockGetter)level, input3BlockPos, input3Direction.m_122424_())) {
                LOGGER.trace("two inputs");
                return this.twoInputsSignal(bool2, bool3);
            }
        }
        LOGGER.trace("one input");
        return this.oneInputSignal(inputSignal1, inputSignal2, inputSignal3);
    }

    protected abstract int twoInputsSignal(int var1, int var2);

    protected abstract int threeInputsSignal(int var1, int var2, int var3);

    protected int oneInputSignal(int inputSignal1, int inputSignal2, int inputSignal3) {
        return Collections.max(List.of(Integer.valueOf(inputSignal1), Integer.valueOf(inputSignal2), Integer.valueOf(inputSignal3)));
    }

    private void updatePowerStrength(Level level, BlockPos blockPos, BlockState blockState) {
        int i = this.calculateTargetStrength(level, blockPos, blockState);
        if ((Integer)blockState.m_61143_((Property)POWER) != i && level.m_8055_(blockPos) == blockState) {
            boolean isNewTick = XenoTechCommon.serverTick != this.lastUpdatedTick;
            int updatesThisTick = this.updatesThisTickMap.computeIfAbsent(blockPos, pos -> 0);
            if (isNewTick || updatesThisTick < this.maxUpdatesPerTick) {
                if (isNewTick) {
                    this.updatesThisTickMap.clear();
                    updatesThisTick = 0;
                }
                this.updatesThisTickMap.put(blockPos, ++updatesThisTick);
                this.lastUpdatedTick = XenoTechCommon.serverTick;
                level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)POWER, (Comparable)Integer.valueOf(i)), 2);
                HashSet set = Sets.newHashSet();
                set.add(blockPos);
                for (Direction direction : Direction.values()) {
                    set.add(blockPos.m_121945_(direction));
                }
                level.m_46672_(blockPos, (Block)this);
                level.m_46672_(blockPos.m_121945_((Direction)blockState.m_61143_((Property)f_54117_)), (Block)this);
            }
        }
    }

    public void m_6807_(BlockState p_55630_, Level p_55631_, BlockPos p_55632_, BlockState p_55633_, boolean p_55634_) {
        if (!p_55633_.m_60713_(p_55630_.m_60734_()) && !p_55631_.f_46443_) {
            this.updatePowerStrength(p_55631_, p_55632_, p_55630_);
            for (Direction direction : Direction.Plane.VERTICAL) {
                p_55631_.m_46672_(p_55632_.m_121945_(direction), (Block)this);
            }
            this.updateNeighborsOfNeighboringWires(p_55631_, p_55632_);
        }
    }

    public void m_6810_(BlockState p_55568_, Level p_55569_, BlockPos p_55570_, BlockState p_55571_, boolean p_55572_) {
        if (!p_55572_ && !p_55568_.m_60713_(p_55571_.m_60734_())) {
            super.m_6810_(p_55568_, p_55569_, p_55570_, p_55571_, p_55572_);
            if (!p_55569_.f_46443_) {
                for (Direction direction : Direction.values()) {
                    p_55569_.m_46672_(p_55570_.m_121945_(direction), (Block)this);
                }
                this.updatePowerStrength(p_55569_, p_55570_, p_55568_);
                this.updateNeighborsOfNeighboringWires(p_55569_, p_55570_);
            }
        }
    }

    private void checkCornerChangeAt(Level p_55617_, BlockPos p_55618_) {
        if (p_55617_.m_8055_(p_55618_).m_60713_((Block)this)) {
            p_55617_.m_46672_(p_55618_, (Block)this);
            for (Direction direction : Direction.values()) {
                p_55617_.m_46672_(p_55618_.m_121945_(direction), (Block)this);
            }
        }
    }

    private void updateNeighborsOfNeighboringWires(Level p_55638_, BlockPos p_55639_) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.checkCornerChangeAt(p_55638_, p_55639_.m_121945_(direction));
        }
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = p_55639_.m_121945_(direction1);
            if (p_55638_.m_8055_(blockpos).m_60796_((BlockGetter)p_55638_, blockpos)) {
                this.checkCornerChangeAt(p_55638_, blockpos.m_7494_());
                continue;
            }
            this.checkCornerChangeAt(p_55638_, blockpos.m_7495_());
        }
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPosNeighbor, boolean p_55566_) {
        if (!level.f_46443_) {
            if (blockState.m_60710_((LevelReader)level, blockPos)) {
                if (!blockPosNeighbor.equals((Object)blockPos.m_121945_((Direction)blockState.m_61143_((Property)f_54117_)))) {
                    this.updatePowerStrength(level, blockPos, blockState);
                }
            } else {
                AbstractGateBlock.m_49950_((BlockState)blockState, (Level)level, (BlockPos)blockPos);
                level.m_7471_(blockPos, false);
            }
        }
    }

    public int m_6376_(BlockState p_60559_, BlockGetter p_60560_, BlockPos p_60561_, Direction p_60562_) {
        return this.m_6378_(p_60559_, p_60560_, p_60561_, p_60562_);
    }

    public int m_6378_(BlockState blockState, BlockGetter level, BlockPos blockPos, Direction direction) {
        if (!this.shouldSignal) {
            return 0;
        }
        Direction facing = (Direction)blockState.m_61143_((Property)f_54117_);
        if (direction == facing.m_122424_()) {
            return (Integer)blockState.m_61143_((Property)POWER);
        }
        return 0;
    }

    public boolean m_7899_(BlockState p_60571_) {
        return this.shouldSignal;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        Direction facing = ctx.m_8125_();
        return (BlockState)super.m_5573_(ctx).m_61124_((Property)f_54117_, (Comparable)facing);
    }
}

