/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.block;

import com.dairymoose.xenotech.XenoBlocks;
import com.dairymoose.xenotech.XenoTechUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AngularSlabHull
extends HorizontalDirectionalBlock {
    public static final EnumProperty<SlabType> TYPE = BlockStateProperties.f_61397_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape NORTH_AABB = AngularSlabHull.makeShapeBottom();
    protected static final VoxelShape EAST_AABB = XenoTechUtils.RotateVoxelShapeClockwise(NORTH_AABB);
    protected static final VoxelShape SOUTH_AABB = XenoTechUtils.RotateVoxelShapeClockwise(EAST_AABB);
    protected static final VoxelShape WEST_AABB = XenoTechUtils.RotateVoxelShapeClockwise(SOUTH_AABB);
    protected static final VoxelShape NORTH_AABB_TOP = AngularSlabHull.makeShapeTop();
    protected static final VoxelShape EAST_AABB_TOP = XenoTechUtils.RotateVoxelShapeClockwise(NORTH_AABB_TOP);
    protected static final VoxelShape SOUTH_AABB_TOP = XenoTechUtils.RotateVoxelShapeClockwise(EAST_AABB_TOP);
    protected static final VoxelShape WEST_AABB_TOP = XenoTechUtils.RotateVoxelShapeClockwise(SOUTH_AABB_TOP);
    protected static final VoxelShape NORTH_AABB_DOUBLE = AngularSlabHull.makeShapeDouble();
    protected static final VoxelShape EAST_AABB_DOUBLE = XenoTechUtils.RotateVoxelShapeClockwise(NORTH_AABB_DOUBLE);
    protected static final VoxelShape SOUTH_AABB_DOUBLE = XenoTechUtils.RotateVoxelShapeClockwise(EAST_AABB_DOUBLE);
    protected static final VoxelShape WEST_AABB_DOUBLE = XenoTechUtils.RotateVoxelShapeClockwise(SOUTH_AABB_DOUBLE);

    public AngularSlabHull(BlockBehaviour.Properties blockProperties) {
        super(blockProperties.m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)SlabType.BOTTOM)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5909_(BlockState blockState, BlockGetter p_48736_, BlockPos p_48737_, CollisionContext p_48738_) {
        if (blockState.m_60713_((Block)XenoBlocks.BLOCK_GLASS_ANGULAR_SLAB_HULL.get())) {
            return Shapes.m_83040_();
        }
        return super.m_5909_(blockState, p_48736_, p_48737_, p_48738_);
    }

    public float m_7749_(BlockState blockState, BlockGetter p_48732_, BlockPos p_48733_) {
        if (blockState.m_60713_((Block)XenoBlocks.BLOCK_GLASS_ANGULAR_SLAB_HULL.get())) {
            return 1.0f;
        }
        return super.m_7749_(blockState, p_48732_, p_48733_);
    }

    public boolean m_7420_(BlockState blockState, BlockGetter p_48741_, BlockPos p_48742_) {
        if (blockState.m_60713_((Block)XenoBlocks.BLOCK_GLASS_ANGULAR_SLAB_HULL.get())) {
            return true;
        }
        return super.m_7420_(blockState, p_48741_, p_48742_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_}).m_61104_(new Property[]{TYPE}).m_61104_(new Property[]{WATERLOGGED});
        super.m_7926_(builder);
    }

    public static VoxelShape makeShapeBottom() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0031250000000000444, (double)0.12812500000000004, (double)0.125, (double)0.49687499999999996, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.0031250000000000444, (double)0.259375, (double)0.25, (double)0.49687499999999996, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.0031250000000000444, (double)0.384375, (double)0.375, (double)0.49687499999999996, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.0031250000000000444, (double)0.509375, (double)0.5, (double)0.49687499999999996, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.5, (double)0.0031250000000000444, (double)0.634375, (double)0.625, (double)0.49687499999999996, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.625, (double)0.0031250000000000444, (double)0.759375, (double)0.75, (double)0.49687499999999996, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.0031250000000000444, (double)0.884375, (double)0.875, (double)0.49687499999999996, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.0031250000000000444, (double)1.0, (double)1.0, (double)0.49687499999999996, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public static VoxelShape makeShapeTop() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.49687499999999996, (double)0.12812500000000004, (double)0.125, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.49687499999999996, (double)0.259375, (double)0.25, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.49687499999999996, (double)0.384375, (double)0.375, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.49687499999999996, (double)0.509375, (double)0.5, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.5, (double)0.49687499999999996, (double)0.634375, (double)0.625, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.625, (double)0.49687499999999996, (double)0.759375, (double)0.75, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.49687499999999996, (double)0.884375, (double)0.875, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.49687499999999996, (double)1.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public static VoxelShape makeShapeDouble() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.12812500000000004, (double)0.125, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.0, (double)0.259375, (double)0.25, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.0, (double)0.384375, (double)0.375, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.0, (double)0.509375, (double)0.5, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.5, (double)0.0, (double)0.634375, (double)0.625, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.625, (double)0.0, (double)0.759375, (double)0.75, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.0, (double)0.884375, (double)0.875, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext ctx) {
        if (state.m_61143_(TYPE) == SlabType.BOTTOM) {
            switch ((Direction)state.m_61143_((Property)f_54117_)) {
                case NORTH: {
                    return NORTH_AABB;
                }
                case EAST: {
                    return EAST_AABB;
                }
                case WEST: {
                    return WEST_AABB;
                }
                case SOUTH: {
                    return SOUTH_AABB;
                }
            }
            return NORTH_AABB;
        }
        if (state.m_61143_(TYPE) == SlabType.TOP) {
            switch ((Direction)state.m_61143_((Property)f_54117_)) {
                case NORTH: {
                    return NORTH_AABB_TOP;
                }
                case EAST: {
                    return EAST_AABB_TOP;
                }
                case WEST: {
                    return WEST_AABB_TOP;
                }
                case SOUTH: {
                    return SOUTH_AABB_TOP;
                }
            }
            return NORTH_AABB_TOP;
        }
        if (state.m_61143_(TYPE) == SlabType.DOUBLE) {
            switch ((Direction)state.m_61143_((Property)f_54117_)) {
                case NORTH: {
                    return NORTH_AABB_DOUBLE;
                }
                case EAST: {
                    return EAST_AABB_DOUBLE;
                }
                case WEST: {
                    return WEST_AABB_DOUBLE;
                }
                case SOUTH: {
                    return SOUTH_AABB_DOUBLE;
                }
            }
            return NORTH_AABB_DOUBLE;
        }
        return NORTH_AABB;
    }

    public boolean m_6864_(BlockState blockState, BlockPlaceContext ctx) {
        ItemStack itemstack = ctx.m_43722_();
        SlabType slabtype = (SlabType)blockState.m_61143_(TYPE);
        if (slabtype != SlabType.DOUBLE && itemstack.m_150930_(this.m_5456_())) {
            if (ctx.m_7058_()) {
                boolean flag = ctx.m_43720_().f_82480_ - (double)ctx.m_8083_().m_123342_() > 0.5;
                Direction direction = ctx.m_43719_();
                if (slabtype == SlabType.BOTTOM) {
                    return direction == Direction.UP || flag && direction.m_122434_().m_122479_();
                }
                return direction == Direction.DOWN || !flag && direction.m_122434_().m_122479_();
            }
            return true;
        }
        return false;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction facing = ctx.m_8125_().m_122424_();
        BlockPos blockpos = ctx.m_8083_();
        BlockState blockstate = ctx.m_43725_().m_8055_(blockpos);
        if (blockstate.m_60713_((Block)this)) {
            return (BlockState)((BlockState)blockstate.m_61124_(TYPE, (Comparable)SlabType.DOUBLE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        FluidState fluidstate = ctx.m_43725_().m_6425_(blockpos);
        BlockState blockstate1 = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)SlabType.BOTTOM)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_))).m_61124_((Property)f_54117_, (Comparable)facing);
        Direction direction = ctx.m_43719_();
        return !(direction == Direction.DOWN || direction != Direction.UP && ctx.m_43720_().f_82480_ - (double)blockpos.m_123342_() > 0.5) ? blockstate1 : (BlockState)blockstate1.m_61124_(TYPE, (Comparable)SlabType.TOP);
    }
}

