/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.block;

import com.dairymoose.xenotech.XenoBlocks;
import com.dairymoose.xenotech.menu.FluidShippingTankMenu;
import com.dairymoose.xenotech.world.level.block.entity.FluidShippingTankBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FluidShippingTankBlock
extends BaseEntityBlock
implements EntityBlock {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Component CONTAINER_TITLE = Component.m_237115_((String)"block.xenotech.fluid_shipping_tank");
    protected static final VoxelShape NORTH_AABB = FluidShippingTankBlock.makeShape();

    public FluidShippingTankBlock(BlockBehaviour.Properties blockProperties) {
        super(blockProperties.m_60955_());
        this.m_49959_(this.m_49966_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
    }

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext ctx) {
        return NORTH_AABB;
    }

    public void m_6810_(BlockState state, Level level, BlockPos blockPos, BlockState state2, boolean p_60519_) {
        if (!level.f_46443_) {
            ItemStack itemStack = new ItemStack((ItemLike)XenoBlocks.ITEM_FLUID_SHIPPING_TANK.get());
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof FluidShippingTankBlockEntity) {
                FluidShippingTankBlockEntity tank = (FluidShippingTankBlockEntity)blockEntity;
                CompoundTag itemTag = itemStack.m_41784_();
                CompoundTag fluidInfo = new CompoundTag();
                tank.getFluidInventory().writeToNBT(fluidInfo);
                itemTag.m_128365_("FluidInfo", (Tag)fluidInfo);
            }
            ItemEntity itemEntity = new ItemEntity(level, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, itemStack);
            level.m_7967_((Entity)itemEntity);
        }
        super.m_6810_(state, level, blockPos, state2, p_60519_);
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState p_180633_3_, LivingEntity p_180633_4_, ItemStack itemStack) {
        if (!level.f_46443_) {
            CompoundTag fluidInfo = null;
            if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("FluidInfo")) {
                fluidInfo = itemStack.m_41783_().m_128469_("FluidInfo");
            }
            if (fluidInfo != null) {
                LOGGER.debug("Add fluid");
                BlockEntity blockEntity = level.m_7702_(blockPos);
                if (blockEntity instanceof FluidShippingTankBlockEntity) {
                    FluidShippingTankBlockEntity tank = (FluidShippingTankBlockEntity)blockEntity;
                    tank.getFluidInventory().readFromNBT(fluidInfo);
                }
            }
        }
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        Direction facing = ctx.m_8125_();
        return super.m_5573_(ctx);
    }

    public boolean isValidContainerBlock(BlockState state) {
        return true;
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand p_52237_, BlockHitResult p_52238_) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof FluidShippingTankBlockEntity) {
                FluidShippingTankBlockEntity tank = (FluidShippingTankBlockEntity)blockEntity;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)blockState.m_60750_(level, blockPos), (BlockPos)tank.m_58899_());
            }
        }
        return InteractionResult.CONSUME;
    }

    public MenuProvider m_7246_(BlockState p_52240_, Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof FluidShippingTankBlockEntity) {
            FluidShippingTankBlockEntity tank = (FluidShippingTankBlockEntity)blockEntity;
            return new SimpleMenuProvider((menuId, inventory, player) -> new FluidShippingTankMenu(menuId, inventory, (Container)tank), CONTAINER_TITLE);
        }
        return null;
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new FluidShippingTankBlockEntity(blockPos, blockState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> type) {
        return FluidShippingTankBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)XenoBlocks.BLOCK_ENTITY_FLUID_SHIPPING_TANK.get()), FluidShippingTankBlockEntity::tick);
    }
}

