/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.block;

import com.dairymoose.xenotech.XenoTechUtils;
import com.dairymoose.xenotech.world.level.block.entity.InternalCombustionEngineBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class InternalCombustionEngineBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    private boolean embedded = false;
    protected static final VoxelShape NORTH_AABB = InternalCombustionEngineBlock.makeShape();
    protected static final VoxelShape EAST_AABB = XenoTechUtils.RotateVoxelShapeClockwise(NORTH_AABB);
    protected static final VoxelShape SOUTH_AABB = XenoTechUtils.RotateVoxelShapeClockwise(EAST_AABB);
    protected static final VoxelShape WEST_AABB = XenoTechUtils.RotateVoxelShapeClockwise(SOUTH_AABB);

    public InternalCombustionEngineBlock(BlockBehaviour.Properties blockProperties, boolean embedded) {
        super(blockProperties.m_60955_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH));
        this.embedded = embedded;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
        super.m_7926_(builder);
    }

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0, (double)0.9375, (double)0.875, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext ctx) {
        if (this.embedded) {
            return Shapes.m_83144_();
        }
        switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case NORTH: {
                return NORTH_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
        }
        return NORTH_AABB;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        Direction facing = ctx.m_8125_();
        return (BlockState)super.m_5573_(ctx).m_61124_((Property)f_54117_, (Comparable)facing);
    }

    public MenuProvider m_7246_(BlockState p_52240_, Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof InternalCombustionEngineBlockEntity) {
            InternalCombustionEngineBlockEntity engine = (InternalCombustionEngineBlockEntity)blockEntity;
            return new SimpleMenuProvider((syncId, inventory, player) -> new ChestMenu(MenuType.f_39957_, syncId, inventory, (Container)engine, engine.m_6643_() / 9), engine.getDefaultName());
        }
        return null;
    }

    public boolean isValidContainerBlock(BlockState state) {
        return true;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.isValidContainerBlock(state)) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            MenuProvider menuprovider = this.m_7246_(state, level, pos);
            if (menuprovider != null) {
                player.m_5893_(menuprovider);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState oldBlockState, boolean p_51542_) {
        if (!blockState.m_60713_(oldBlockState.m_60734_())) {
            BlockEntity blockentity = level.m_7702_(blockPos);
            if (blockentity instanceof Container) {
                Containers.m_19002_((Level)level, (BlockPos)blockPos, (Container)((Container)blockentity));
                level.m_46717_(blockPos, (Block)this);
            }
            super.m_6810_(blockState, level, blockPos, oldBlockState, p_51542_);
        }
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new InternalCombustionEngineBlockEntity(blockPos, blockState);
    }
}

