/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.block;

import com.dairymoose.xenotech.XenoTechUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class JetThrusterBlock
extends DirectionalBlock {
    public static final BooleanProperty ATTACH_TOP = BooleanProperty.m_61465_((String)"attach_top");
    public static final BooleanProperty ATTACH_BOTTOM = BooleanProperty.m_61465_((String)"attach_bottom");
    public static final BooleanProperty ATTACH_RIGHT = BooleanProperty.m_61465_((String)"attach_right");
    public static final BooleanProperty ATTACH_LEFT = BooleanProperty.m_61465_((String)"attach_left");
    protected static final VoxelShape NORTH_AABB = JetThrusterBlock.makeShape();
    protected static final VoxelShape EAST_AABB = XenoTechUtils.RotateVoxelShapeClockwise(NORTH_AABB);
    protected static final VoxelShape SOUTH_AABB = XenoTechUtils.RotateVoxelShapeClockwise(EAST_AABB);
    protected static final VoxelShape WEST_AABB = XenoTechUtils.RotateVoxelShapeClockwise(SOUTH_AABB);
    protected static final VoxelShape UP_AABB = XenoTechUtils.RotateVoxelShapeXAxis(NORTH_AABB);
    protected static final VoxelShape DOWN_AABB = XenoTechUtils.RotateVoxelShapeXAxis(SOUTH_AABB);

    public JetThrusterBlock(BlockBehaviour.Properties blockProperties) {
        super(blockProperties.m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH)).m_61124_((Property)ATTACH_TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ATTACH_BOTTOM, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ATTACH_RIGHT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ATTACH_LEFT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52588_}).m_61104_(new Property[]{ATTACH_TOP}).m_61104_(new Property[]{ATTACH_BOTTOM}).m_61104_(new Property[]{ATTACH_RIGHT}).m_61104_(new Property[]{ATTACH_LEFT});
        super.m_7926_(builder);
    }

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.125, (double)0.0, (double)0.875, (double)0.875, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext ctx) {
        switch ((Direction)state.m_61143_((Property)f_52588_)) {
            case NORTH: {
                return NORTH_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case UP: {
                return UP_AABB;
            }
            case DOWN: {
                return DOWN_AABB;
            }
        }
        return NORTH_AABB;
    }

    public BlockState m_6843_(BlockState p_55115_, Rotation p_55116_) {
        return (BlockState)p_55115_.m_61124_((Property)f_52588_, (Comparable)p_55116_.m_55954_((Direction)p_55115_.m_61143_((Property)f_52588_)));
    }

    public BlockState m_6943_(BlockState p_55112_, Mirror p_55113_) {
        return p_55112_.m_60717_(p_55113_.m_54846_((Direction)p_55112_.m_61143_((Property)f_52588_)));
    }

    public BlockState getNewShape(BlockState state, BlockPos blockPos, LevelAccessor level) {
        if (state.m_61143_((Property)f_52588_) == Direction.UP || state.m_61143_((Property)f_52588_) == Direction.DOWN) {
            return state;
        }
        Direction facing = (Direction)state.m_61143_((Property)f_52588_);
        BlockPos abovePos = blockPos.m_7494_();
        BlockPos belowPos = blockPos.m_7495_();
        BlockState aboveState = level.m_8055_(abovePos);
        BlockState belowState = level.m_8055_(belowPos);
        boolean aboveIsSturdy = aboveState.m_60783_((BlockGetter)level, abovePos, Direction.DOWN);
        boolean belowIsSturdy = belowState.m_60783_((BlockGetter)level, belowPos, Direction.UP);
        Direction cw = facing.m_122427_();
        Direction ccw = facing.m_122428_();
        BlockPos rightPos = blockPos.m_121945_(cw);
        BlockPos leftPos = blockPos.m_121945_(ccw);
        BlockState rightState = level.m_8055_(rightPos);
        BlockState leftState = level.m_8055_(leftPos);
        boolean rightIsSturdy = rightState.m_60783_((BlockGetter)level, rightPos, cw.m_122424_());
        boolean leftIsSturdy = leftState.m_60783_((BlockGetter)level, leftPos, ccw.m_122424_());
        if (aboveIsSturdy) {
            state = (BlockState)state.m_61124_((Property)ATTACH_TOP, (Comparable)Boolean.valueOf(true));
        } else if (belowIsSturdy) {
            state = (BlockState)state.m_61124_((Property)ATTACH_BOTTOM, (Comparable)Boolean.valueOf(true));
        } else if (rightIsSturdy) {
            state = (BlockState)state.m_61124_((Property)ATTACH_RIGHT, (Comparable)Boolean.valueOf(true));
        } else if (leftIsSturdy) {
            state = (BlockState)state.m_61124_((Property)ATTACH_LEFT, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public BlockState m_7417_(BlockState p_53323_, Direction p_53324_, BlockState p_53325_, LevelAccessor level, BlockPos thisBlockPos, BlockPos p_53328_) {
        return this.getNewShape(super.m_7417_(p_53323_, p_53324_, p_53325_, level, thisBlockPos, p_53328_), thisBlockPos, level);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        Direction facing = ctx.m_7820_();
        return this.getNewShape((BlockState)super.m_5573_(ctx).m_61124_((Property)f_52588_, (Comparable)facing), ctx.m_8083_(), (LevelAccessor)ctx.m_43725_());
    }
}

