/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.block;

import com.dairymoose.xenotech.XenoTechUtils;
import com.dairymoose.xenotech.block.ManipulatorBlock;
import com.dairymoose.xenotech.world.level.block.entity.ManipulatorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ManipulatorArmBlock
extends HorizontalDirectionalBlock {
    private static final Logger LOGGER = LogManager.getLogger();
    public static BooleanProperty END = BooleanProperty.m_61465_((String)"end");
    protected static final VoxelShape NORTH_AABB = ManipulatorArmBlock.makeShape();
    protected static final VoxelShape EAST_AABB = XenoTechUtils.RotateVoxelShapeClockwise(NORTH_AABB);
    protected static final VoxelShape SOUTH_AABB = XenoTechUtils.RotateVoxelShapeClockwise(EAST_AABB);
    protected static final VoxelShape WEST_AABB = XenoTechUtils.RotateVoxelShapeClockwise(SOUTH_AABB);
    protected static final VoxelShape NORTH_AABB_END = ManipulatorArmBlock.makeEndShape();
    protected static final VoxelShape EAST_AABB_END = XenoTechUtils.RotateVoxelShapeClockwise(NORTH_AABB_END);
    protected static final VoxelShape SOUTH_AABB_END = XenoTechUtils.RotateVoxelShapeClockwise(EAST_AABB_END);
    protected static final VoxelShape WEST_AABB_END = XenoTechUtils.RotateVoxelShapeClockwise(SOUTH_AABB_END);

    public ManipulatorArmBlock(BlockBehaviour.Properties blockProperties) {
        super(blockProperties.m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)END, (Comparable)Boolean.valueOf(true)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_}).m_61104_(new Property[]{END});
        super.m_7926_(builder);
    }

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.3125, (double)0.0, (double)0.6875, (double)0.6875, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public static VoxelShape makeEndShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.3125, (double)0.5625, (double)0.6875, (double)0.6875, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.25, (double)0.4375, (double)0.75, (double)0.75, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.625, (double)0.375, (double)0.125, (double)0.875, (double)0.625, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.375, (double)0.125, (double)0.375, (double)0.625, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.625, (double)0.125, (double)0.625, (double)0.875, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public VoxelShape m_5939_(BlockState p_60572_, BlockGetter p_60573_, BlockPos p_60574_, CollisionContext p_60575_) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext ctx) {
        if (!((Boolean)state.m_61143_((Property)END)).booleanValue()) {
            switch ((Direction)state.m_61143_((Property)f_54117_)) {
                case NORTH: {
                    return NORTH_AABB;
                }
                case EAST: {
                    return EAST_AABB;
                }
                case WEST: {
                    return WEST_AABB;
                }
                case SOUTH: {
                    return SOUTH_AABB;
                }
            }
            return NORTH_AABB;
        }
        switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case NORTH: {
                return NORTH_AABB_END;
            }
            case EAST: {
                return EAST_AABB_END;
            }
            case WEST: {
                return WEST_AABB_END;
            }
            case SOUTH: {
                return SOUTH_AABB_END;
            }
        }
        return NORTH_AABB_END;
    }

    public BlockState getNewShape(BlockState state, BlockPos blockPos, LevelAccessor level) {
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        Direction oppoosite = facing.m_122424_();
        BlockState fwdState = level.m_8055_(blockPos.m_5484_(facing, 1));
        BlockState backState = level.m_8055_(blockPos.m_5484_(oppoosite, 1));
        boolean fwdIsSame = fwdState.m_60734_() instanceof ManipulatorArmBlock;
        boolean backIsSame = backState.m_60734_() instanceof ManipulatorArmBlock;
        state = fwdIsSame ? (BlockState)state.m_61124_((Property)END, (Comparable)Boolean.valueOf(false)) : (BlockState)state.m_61124_((Property)END, (Comparable)Boolean.valueOf(true));
        return state;
    }

    public BlockState m_7417_(BlockState p_53323_, Direction p_53324_, BlockState p_53325_, LevelAccessor level, BlockPos thisBlockPos, BlockPos p_53328_) {
        return this.getNewShape(super.m_7417_(p_53323_, p_53324_, p_53325_, level, thisBlockPos, p_53328_), thisBlockPos, level);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        Direction facing = ctx.m_8125_().m_122424_();
        return this.getNewShape((BlockState)super.m_5573_(ctx).m_61124_((Property)f_54117_, (Comparable)facing), ctx.m_8083_(), (LevelAccessor)ctx.m_43725_());
    }

    public void m_6810_(BlockState existingState, Level level, BlockPos blockPos, BlockState newState, boolean b) {
        if (existingState.m_60734_() != newState.m_60734_() && existingState.m_60734_() instanceof ManipulatorArmBlock) {
            LOGGER.debug("Removed manipulator end arm");
            blockPos = blockPos.m_121945_(((Direction)existingState.m_61143_((Property)f_54117_)).m_122424_());
            if (blockPos != null) {
                ManipulatorInfo mi = this.getManipulatorBlockEntity(level, blockPos);
                if (mi != null) {
                    Direction direction = mi.connectedDirection;
                    if (direction == null) {
                        direction = (Direction)existingState.m_61143_((Property)f_54117_);
                    }
                    LOGGER.debug("Removed manipulator endpoint with direction=" + direction);
                    mi.manipulator.removeEndpoint(direction);
                } else {
                    LOGGER.debug("Remove: No manipulator was found!");
                }
            }
        }
        super.m_6810_(existingState, level, blockPos, newState, b);
    }

    public void m_6807_(BlockState state, Level level, BlockPos blockPos, BlockState blockStateOld, boolean b) {
        if (state.m_60734_() instanceof ManipulatorArmBlock) {
            if (((Boolean)state.m_61143_((Property)END)).booleanValue()) {
                LOGGER.debug("Placed manipulator end arm");
            }
            if ((blockPos = this.getManipulatorEndBlock(level, blockPos)) != null) {
                ManipulatorInfo mi = this.getManipulatorBlockEntity(level, blockPos);
                Direction endFacing = (Direction)state.m_61143_((Property)f_54117_);
                blockPos = blockPos.m_121945_(endFacing);
                if (mi != null) {
                    LOGGER.debug("Added manipulator endpoint with direction=" + mi.connectedDirection);
                    mi.manipulator.addEndpoint(blockPos, mi.connectedDirection);
                } else {
                    LOGGER.debug("Add: No manipulator was found!");
                }
            }
        }
        super.m_6807_(blockStateOld, level, blockPos, blockStateOld, b);
    }

    private BlockPos getManipulatorEndBlock(Level level, BlockPos currentPos) {
        BlockState currentState;
        Block block;
        BlockState priorState = null;
        while ((block = (currentState = level.m_8055_(currentPos)).m_60734_()) instanceof ManipulatorArmBlock) {
            ManipulatorArmBlock arm = (ManipulatorArmBlock)block;
            if (((Boolean)currentState.m_61143_((Property)END)).booleanValue()) {
                return currentPos;
            }
            Direction facing = (Direction)currentState.m_61143_((Property)f_54117_);
            currentPos = currentPos.m_121945_(facing);
            priorState = currentState;
        }
        return null;
    }

    private ManipulatorInfo getManipulatorBlockEntity(Level level, BlockPos currentPos) {
        block3: {
            Block block;
            BlockEntity blockEntity;
            BlockState priorState = null;
            while (true) {
                Block facing;
                BlockState currentState;
                Block block2;
                if ((block2 = (currentState = level.m_8055_(currentPos)).m_60734_()) instanceof ManipulatorArmBlock) {
                    ManipulatorArmBlock arm = (ManipulatorArmBlock)block2;
                    facing = (Direction)currentState.m_61143_((Property)f_54117_);
                    currentPos = currentPos.m_121945_(facing.m_122424_());
                    priorState = currentState;
                    continue;
                }
                facing = currentState.m_60734_();
                if (!(facing instanceof ManipulatorBlock)) break block3;
                ManipulatorBlock manipBlock = (ManipulatorBlock)facing;
                blockEntity = level.m_7702_(currentPos);
                if (blockEntity instanceof ManipulatorBlockEntity) break;
            }
            ManipulatorBlockEntity manip = (ManipulatorBlockEntity)blockEntity;
            ManipulatorInfo mi = new ManipulatorInfo();
            mi.manipulator = manip;
            mi.connectedState = priorState;
            if (priorState != null && (block = priorState.m_60734_()) instanceof ManipulatorArmBlock) {
                ManipulatorArmBlock arm = (ManipulatorArmBlock)block;
                mi.connectedDirection = (Direction)priorState.m_61143_((Property)f_54117_);
            }
            return mi;
        }
        return null;
    }

    private static class ManipulatorInfo {
        public ManipulatorBlockEntity manipulator = null;
        public BlockState connectedState;
        public Direction connectedDirection;

        private ManipulatorInfo() {
        }
    }
}

