/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.block;

import com.dairymoose.xenotech.XenoBlocks;
import com.dairymoose.xenotech.XenoTechUtils;
import com.dairymoose.xenotech.world.level.block.entity.BuzzsawBlockEntity;
import com.dairymoose.xenotech.world.level.block.entity.MiningDrillBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MiningDrillBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    protected static final VoxelShape NORTH_AABB = MiningDrillBlock.makeShape();
    protected static final VoxelShape EAST_AABB = XenoTechUtils.RotateVoxelShapeClockwise(NORTH_AABB);
    protected static final VoxelShape SOUTH_AABB = XenoTechUtils.RotateVoxelShapeClockwise(EAST_AABB);
    protected static final VoxelShape WEST_AABB = XenoTechUtils.RotateVoxelShapeClockwise(SOUTH_AABB);

    public MiningDrillBlock(BlockBehaviour.Properties blockProperties) {
        super(blockProperties.m_60955_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
        super.m_7926_(builder);
    }

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.125, (double)0.0, (double)0.875, (double)0.875, (double)0.5), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext ctx) {
        switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case NORTH: {
                return NORTH_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
        }
        return NORTH_AABB;
    }

    public void m_6810_(BlockState p_60515_, Level level, BlockPos blockPos, BlockState p_60518_, boolean p_60519_) {
        boolean silkTouch = false;
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof BuzzsawBlockEntity) {
            BuzzsawBlockEntity buzzsaw = (BuzzsawBlockEntity)blockEntity;
            if (buzzsaw.hasSilkTouch) {
                silkTouch = true;
            }
        }
        ItemStack itemStack = new ItemStack((ItemLike)XenoBlocks.ITEM_MINING_DRILL.get());
        if (silkTouch) {
            itemStack.m_41663_(Enchantments.f_44985_, 1);
        }
        ItemEntity itemEntity = new ItemEntity(level, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, itemStack);
        level.m_7967_((Entity)itemEntity);
        super.m_6810_(p_60515_, level, blockPos, p_60518_, p_60519_);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        Direction facing = ctx.m_8125_();
        return (BlockState)super.m_5573_(ctx).m_61124_((Property)f_54117_, (Comparable)facing.m_122424_());
    }

    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new MiningDrillBlockEntity(p_153215_, p_153216_);
    }
}

