/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.block;

import com.dairymoose.xenotech.block.IntegratedGunBlock;
import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.network.ClientboundGunMountPacket;
import com.dairymoose.xenotech.network.XenoTechNetwork;
import com.dairymoose.xenotech.world.level.block.entity.IntegratedGunBlockEntity;
import com.dairymoose.xenotech.world.level.block.entity.MountedGunBlockEntity;
import com.dairymoose.xenotech.world.level.block.entity.PassengerSeatBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MountedGunBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final BooleanProperty MOUNTED = BooleanProperty.m_61465_((String)"mounted");
    protected VoxelShape NORTH_AABB;
    protected VoxelShape EAST_AABB;
    protected VoxelShape SOUTH_AABB;
    protected VoxelShape WEST_AABB;

    public MountedGunBlock(BlockBehaviour.Properties blockProperties) {
        super(blockProperties.m_60955_());
        if (!(this instanceof IntegratedGunBlock)) {
            this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)MOUNTED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public abstract Block getStaticBlock();

    public abstract Block getAnimatedBlock();

    public abstract float animatedBlockCenterOffset();

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_}).m_61104_(new Property[]{MOUNTED});
        super.m_7926_(builder);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand p_225533_5_, BlockHitResult p_225533_6_) {
        if (!level.f_46443_) {
            MountedGunBlockEntity minigun = (MountedGunBlockEntity)level.m_7702_(blockPos);
            if (!(minigun instanceof IntegratedGunBlockEntity) && minigun != null) {
                Entity entity;
                LOGGER.debug("use minigun");
                if (minigun.mountedTo != null && minigun.mountedTo.m_217005_()) {
                    LOGGER.debug("cancel minigun use: mountedTo is non-null: " + minigun.mountedTo);
                    return InteractionResult.CONSUME;
                }
                level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)MOUNTED, (Comparable)Boolean.valueOf(true)), 2);
                DummyEntity carrier = DummyEntity.getDummyEntityForCarried((Entity)player);
                BlockPos networkBlockPos = blockPos;
                DummyEntity dummy = DummyEntity.getEntity(-0.4f, level, blockPos, false, false);
                if (carrier == null && minigun.renderable != null && (entity = minigun.renderable.parent) instanceof DummyEntity) {
                    DummyEntity parent;
                    carrier = parent = (DummyEntity)entity;
                    LOGGER.debug("Get parent from renderable");
                }
                if (carrier != null) {
                    float facingY = ((Direction)blockState.m_61143_((Property)f_54117_)).m_122435_();
                    float newAngle = facingY + carrier.getYRotDiff();
                    LOGGER.debug("using state=" + blockState + ": adjust starting angle from " + facingY + " to " + newAngle + " from yRotDiff=" + carrier.getYRotDiff());
                    dummy.setStartingAngle(Mth.m_14177_((float)newAngle));
                    if (minigun.renderable != null) {
                        networkBlockPos = minigun.renderable.pos;
                        LOGGER.debug("use renderable pos=" + networkBlockPos);
                    }
                } else if (minigun.renderable != null) {
                    dummy.m_6074_();
                    LOGGER.warn("minigun can only be used by carried players - reject attempt");
                    return InteractionResult.CONSUME;
                }
                minigun.assignMountVariables(blockPos, dummy, carrier);
                if (minigun instanceof PassengerSeatBlockEntity) {
                    dummy.setMountedGunType(1);
                } else {
                    dummy.setMountedGunType(0);
                }
                XenoTechNetwork.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundGunMountPacket(dummy, carrier, networkBlockPos, carrier != null));
                dummy.ride(player);
            } else if (minigun == null) {
                LOGGER.warn("minigun is null for entity=" + this);
            }
        }
        return InteractionResult.CONSUME;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext ctx) {
        switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case NORTH: {
                return this.NORTH_AABB;
            }
            case EAST: {
                return this.EAST_AABB;
            }
            case WEST: {
                return this.WEST_AABB;
            }
            case SOUTH: {
                return this.SOUTH_AABB;
            }
        }
        return this.NORTH_AABB;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        Direction facing = ctx.m_8125_();
        return (BlockState)super.m_5573_(ctx).m_61124_((Property)f_54117_, (Comparable)facing);
    }

    public RenderShape m_7514_(BlockState blockState) {
        if (((Boolean)blockState.m_61143_((Property)MOUNTED)).booleanValue()) {
            return RenderShape.ENTITYBLOCK_ANIMATED;
        }
        return RenderShape.MODEL;
    }

    public boolean m_8133_(BlockState p_49226_, Level p_49227_, BlockPos p_49228_, int p_49229_, int p_49230_) {
        super.m_8133_(p_49226_, p_49227_, p_49228_, p_49229_, p_49230_);
        BlockEntity blockentity = p_49227_.m_7702_(p_49228_);
        return blockentity == null ? false : blockentity.m_7531_(p_49229_, p_49230_);
    }

    @Nullable
    public MenuProvider m_7246_(BlockState p_49234_, Level p_49235_, BlockPos p_49236_) {
        BlockEntity blockentity = p_49235_.m_7702_(p_49236_);
        return blockentity instanceof MenuProvider ? (MenuProvider)blockentity : null;
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> p_152133_, BlockEntityType<E> p_152134_, BlockEntityTicker<? super E> p_152135_) {
        return p_152134_ == p_152133_ ? p_152135_ : null;
    }

    public abstract BlockEntity m_142194_(BlockPos var1, BlockState var2);
}

