/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.block;

import com.dairymoose.xenotech.XenoBlocks;
import com.dairymoose.xenotech.XenoTechUtils;
import com.dairymoose.xenotech.world.level.block.SiftingNetPostBlock;
import com.dairymoose.xenotech.world.level.block.entity.SiftingNetPostBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SiftingNetBlock
extends HorizontalDirectionalBlock {
    private static final Logger LOGGER = LogManager.getLogger();
    public static BooleanProperty FULL = BooleanProperty.m_61465_((String)"full");
    protected static final VoxelShape NORTH_AABB = SiftingNetBlock.makeShape();
    protected static final VoxelShape EAST_AABB = XenoTechUtils.RotateVoxelShapeClockwise(NORTH_AABB);
    protected static final VoxelShape SOUTH_AABB = XenoTechUtils.RotateVoxelShapeClockwise(EAST_AABB);
    protected static final VoxelShape WEST_AABB = XenoTechUtils.RotateVoxelShapeClockwise(SOUTH_AABB);
    public static int blocksToCheck = 1000;

    public SiftingNetBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_.m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FULL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_}).m_61104_(new Property[]{FULL}).m_61104_(new Property[]{BlockStateProperties.f_61362_});
        super.m_7926_(builder);
    }

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.35, (double)0.0, (double)0.0, (double)0.65, (double)0.9375, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public BlockState m_6843_(BlockState p_55115_, Rotation p_55116_) {
        return (BlockState)p_55115_.m_61124_((Property)f_54117_, (Comparable)p_55116_.m_55954_((Direction)p_55115_.m_61143_((Property)f_54117_)));
    }

    public BlockState m_6943_(BlockState p_55112_, Mirror p_55113_) {
        return p_55112_.m_60717_(p_55113_.m_54846_((Direction)p_55112_.m_61143_((Property)f_54117_)));
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos pos, CollisionContext ctx) {
        return Shapes.m_83040_();
    }

    public void m_7892_(BlockState state, Level level, BlockPos p_60497_, Entity e) {
        if (e instanceof WaterAnimal) {
            e.m_7601_(state, new Vec3(0.33, 0.33, 0.33));
            e.m_6469_(level.m_269111_().m_269318_(), 0.5f);
        } else if (e instanceof ItemEntity) {
            e.m_7601_(state, new Vec3(0.05, 0.05, 0.05));
            e.m_20334_(0.0, -0.15, 0.0);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext ctx) {
        BlockEntity entity = blockGetter.m_7702_(pos);
        switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case NORTH: {
                return NORTH_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
        }
        return NORTH_AABB;
    }

    public boolean m_6724_(BlockState blockState) {
        Block block = blockState.m_60734_();
        if (block instanceof SiftingNetBlock) {
            SiftingNetBlock net = (SiftingNetBlock)block;
            return (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_);
        }
        return false;
    }

    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randSource) {
        if (!serverLevel.isAreaLoaded(blockPos, 1)) {
            return;
        }
        SiftingNetPostBlockEntity siftingPost = SiftingNetPostBlockEntity.siftingNetMap.get(blockPos);
        if (siftingPost != null) {
            if (siftingPost.m_58901_()) {
                SiftingNetPostBlockEntity.siftingNetMap.remove(blockPos);
            } else {
                siftingPost.m_58900_().m_222972_(serverLevel, siftingPost.m_58899_(), randSource);
            }
        }
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState p_49849_, LivingEntity living, ItemStack p_49851_) {
        super.m_6402_(level, blockPos, p_49849_, living, p_49851_);
        SiftingNetBlock.scanBothDirectionsForContainer(level, blockPos, living, InteractionHand.MAIN_HAND, null);
    }

    public static InteractionResult scanInDirectionForContainer(Level level, BlockPos pos, Direction direction, LivingEntity living, InteractionHand hand, BlockHitResult hit) {
        BlockPos current = pos;
        int blocksChecked = 0;
        while (blocksChecked < blocksToCheck) {
            ++blocksChecked;
            BlockState checkedState = level.m_8055_(current);
            if (checkedState.m_60713_((Block)XenoBlocks.BLOCK_SIFTING_NET_POST.get()) && (((Boolean)checkedState.m_61143_((Property)SiftingNetPostBlock.NORTH)).booleanValue() || ((Boolean)checkedState.m_61143_((Property)SiftingNetPostBlock.EAST)).booleanValue())) {
                BlockEntity entity = level.m_7702_(current);
                if (entity instanceof SiftingNetPostBlockEntity) {
                    SiftingNetPostBlockEntity siftingEntity = (SiftingNetPostBlockEntity)entity;
                    if (hit != null) {
                        BlockHitResult newHitResult = new BlockHitResult(hit.m_82450_(), hit.m_82434_(), current, hit.m_82436_());
                        return ((SiftingNetPostBlock)checkedState.m_60734_()).m_6227_(checkedState, level, current, (Player)living, hand, newHitResult);
                    }
                    siftingEntity.updateSiftingNetMap();
                }
            } else if (checkedState.m_60713_((Block)XenoBlocks.BLOCK_SIFTING_NET_POST.get()) && blocksChecked > 1) {
                return null;
            }
            if (!checkedState.m_60713_((Block)XenoBlocks.BLOCK_SIFTING_NET.get()) && !checkedState.m_60713_((Block)XenoBlocks.BLOCK_SIFTING_NET_POST.get())) break;
            current = current.m_121945_(direction);
        }
        return null;
    }

    public static InteractionResult scanBothDirectionsForContainer(Level level, BlockPos pos, LivingEntity living, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockState state = level.m_8055_(pos);
        Direction scanDirection = null;
        if (state.m_60713_((Block)XenoBlocks.BLOCK_SIFTING_NET_POST.get())) {
            if (((Boolean)state.m_61143_((Property)SiftingNetPostBlock.NORTH)).booleanValue()) {
                scanDirection = Direction.NORTH;
            } else if (((Boolean)state.m_61143_((Property)SiftingNetPostBlock.EAST)).booleanValue()) {
                scanDirection = Direction.EAST;
            } else if (((Boolean)state.m_61143_((Property)SiftingNetPostBlock.WEST)).booleanValue()) {
                scanDirection = Direction.WEST;
            } else if (((Boolean)state.m_61143_((Property)SiftingNetPostBlock.SOUTH)).booleanValue()) {
                scanDirection = Direction.SOUTH;
            }
        } else if (state.m_60713_((Block)XenoBlocks.BLOCK_SIFTING_NET.get())) {
            scanDirection = (Direction)state.m_61143_((Property)f_54117_);
        }
        if (scanDirection != null) {
            InteractionResult ir = null;
            ir = SiftingNetBlock.scanInDirectionForContainer(level, pos, scanDirection, living, hand, hit);
            if (ir == null) {
                ir = SiftingNetBlock.scanInDirectionForContainer(level, pos, scanDirection.m_122424_(), living, hand, hit);
            }
            if (ir != null) {
                return ir;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!player.m_21120_(hand).m_150930_((Item)XenoBlocks.ITEM_SIFTING_NET.get()) && !player.m_21120_(hand).m_150930_((Item)XenoBlocks.ITEM_SIFTING_NET_POST.get())) {
            return SiftingNetBlock.scanBothDirectionsForContainer(level, pos, (LivingEntity)player, hand, hit);
        }
        return InteractionResult.PASS;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState getNewShape(BlockState state, BlockPos blockPos, LevelAccessor level) {
        BlockState aboveState = level.m_8055_(blockPos.m_7494_());
        BlockState belowState = level.m_8055_(blockPos.m_7495_());
        boolean matchingAbove = aboveState.m_60713_((Block)XenoBlocks.BLOCK_SIFTING_NET.get()) && (aboveState.m_61143_((Property)f_54117_) == state.m_61143_((Property)f_54117_) || aboveState.m_61143_((Property)f_54117_) == ((Direction)state.m_61143_((Property)f_54117_)).m_122424_());
        boolean matchingBelow = belowState.m_60713_((Block)XenoBlocks.BLOCK_SIFTING_NET.get()) && (belowState.m_61143_((Property)f_54117_) == state.m_61143_((Property)f_54117_) || belowState.m_61143_((Property)f_54117_) == ((Direction)state.m_61143_((Property)f_54117_)).m_122424_());
        return (BlockState)state.m_61124_((Property)FULL, (Comparable)Boolean.valueOf(matchingAbove || matchingBelow));
    }

    public BlockState m_7417_(BlockState p_53323_, Direction p_53324_, BlockState p_53325_, LevelAccessor level, BlockPos thisBlockPos, BlockPos p_53328_) {
        if (((Boolean)p_53323_.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_186469_(thisBlockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return this.getNewShape(super.m_7417_(p_53323_, p_53324_, p_53325_, level, thisBlockPos, p_53328_), thisBlockPos, level);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        Direction facing = ctx.m_8125_().m_122427_();
        BlockPos originBlockPos = ctx.m_8083_().m_121945_(ctx.m_43719_().m_122424_());
        BlockState originBlockState = ctx.m_43725_().m_8055_(originBlockPos);
        if (originBlockState.m_60713_((Block)this)) {
            facing = (Direction)originBlockState.m_61143_((Property)f_54117_);
        }
        return this.getNewShape((BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_))).m_61124_((Property)f_54117_, (Comparable)facing), ctx.m_8083_(), (LevelAccessor)ctx.m_43725_());
    }
}

