/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.block;

import com.dairymoose.xenotech.XenoTechCommon;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VerticalRedstoneConduitBlock
extends Block {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final BooleanProperty BASE = BooleanProperty.m_61465_((String)"base");
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    private boolean shouldSignal = true;
    private boolean transmitsPowerDown = true;
    private static boolean powerDecreasesPerConduit = true;
    private static boolean powerDecreasesFromSource = true;
    protected static final VoxelShape NORTH_AABB_BASE = VerticalRedstoneConduitBlock.makeShapeBase();
    protected static final VoxelShape NORTH_AABB = VerticalRedstoneConduitBlock.makeShape();
    private int maxUpdatesPerTick = 999;
    private Map<BlockPos, Integer> updatesThisTickMap = new HashMap<BlockPos, Integer>();
    private long lastUpdatedTick = 0L;

    public VerticalRedstoneConduitBlock(BlockBehaviour.Properties blockProperties) {
        super(blockProperties.m_60955_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BASE, (Comparable)Boolean.valueOf(true)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWER}).m_61104_(new Property[]{BASE});
        super.m_7926_(builder);
    }

    public static VoxelShape makeShapeBase() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.0, (double)0.6875, (double)0.125, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.3125, (double)1.0, (double)0.121875, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.125, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext ctx) {
        if (((Boolean)state.m_61143_((Property)BASE)).booleanValue()) {
            return NORTH_AABB_BASE;
        }
        return NORTH_AABB;
    }

    public void m_5871_(ItemStack p_49816_, BlockGetter p_49817_, List<Component> components, TooltipFlag p_49819_) {
        components.add((Component)Component.m_237113_((String)"Redstone component"));
        super.m_5871_(p_49816_, p_49817_, components, p_49819_);
    }

    public int m_6376_(BlockState p_60559_, BlockGetter p_60560_, BlockPos p_60561_, Direction p_60562_) {
        return this.m_6378_(p_60559_, p_60560_, p_60561_, p_60562_);
    }

    public int m_6378_(BlockState blockState, BlockGetter level, BlockPos blockPos, Direction direction) {
        if (!this.shouldSignal) {
            return 0;
        }
        if (direction == Direction.DOWN) {
            return (Integer)blockState.m_61143_((Property)POWER);
        }
        if (this.transmitsPowerDown && direction == Direction.UP) {
            return (Integer)blockState.m_61143_((Property)POWER);
        }
        return 0;
    }

    public boolean m_7899_(BlockState p_60571_) {
        return this.shouldSignal;
    }

    private void updatePowerStrength(Level level, BlockPos blockPos, BlockState blockState) {
        BlockPos northPos = blockPos.m_122012_();
        BlockPos eastPos = blockPos.m_122029_();
        BlockPos southPos = blockPos.m_122019_();
        BlockPos westPos = blockPos.m_122024_();
        BlockPos belowPos = blockPos.m_7495_();
        BlockPos abovePos = blockPos.m_7494_();
        int n = level.m_277185_(northPos, Direction.NORTH);
        int e = level.m_277185_(eastPos, Direction.EAST);
        int s = level.m_277185_(southPos, Direction.SOUTH);
        int w = level.m_277185_(westPos, Direction.WEST);
        int d = level.m_277185_(belowPos, Direction.DOWN);
        int u = level.m_277185_(abovePos, Direction.UP);
        if (!this.transmitsPowerDown) {
            u = 0;
        }
        if (powerDecreasesFromSource) {
            --n;
            --e;
            --w;
            --s;
            --d;
            --u;
            if (n < 0) {
                n = 0;
            }
            if (e < 0) {
                e = 0;
            }
            if (w < 0) {
                w = 0;
            }
            if (s < 0) {
                s = 0;
            }
            if (d < 0) {
                d = 0;
            }
            if (u < 0) {
                u = 0;
            }
        }
        int i = Collections.max(List.of(Integer.valueOf(n), Integer.valueOf(e), Integer.valueOf(s), Integer.valueOf(w), Integer.valueOf(u), Integer.valueOf(d)));
        if ((Integer)blockState.m_61143_((Property)POWER) != i && level.m_8055_(blockPos) == blockState) {
            boolean isNewTick = XenoTechCommon.serverTick != this.lastUpdatedTick;
            int updatesThisTick = this.updatesThisTickMap.computeIfAbsent(blockPos, pos -> 0);
            if (isNewTick || updatesThisTick < this.maxUpdatesPerTick) {
                if (isNewTick) {
                    this.updatesThisTickMap.clear();
                    updatesThisTick = 0;
                }
                this.updatesThisTickMap.put(blockPos, ++updatesThisTick);
                this.lastUpdatedTick = XenoTechCommon.serverTick;
                level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)POWER, (Comparable)Integer.valueOf(i)), 2);
                level.m_46672_(blockPos, (Block)this);
                level.m_46672_(blockPos.m_7494_(), (Block)this);
                if (this.transmitsPowerDown) {
                    level.m_46672_(blockPos.m_7495_(), (Block)this);
                }
            }
        }
    }

    private int getVerticalConduitSignal(Level level, BlockPos blockPos) {
        int p;
        BlockPos abovePos = blockPos.m_7494_();
        BlockPos belowPos = blockPos.m_7495_();
        BlockState aboveState = level.m_8055_(abovePos);
        BlockState belowState = level.m_8055_(belowPos);
        int k = 0;
        if (this.transmitsPowerDown && aboveState.m_60713_((Block)this) && (p = ((Integer)aboveState.m_61143_((Property)POWER)).intValue()) > k) {
            k = p;
        }
        if (belowState.m_60713_((Block)this) && (p = ((Integer)belowState.m_61143_((Property)POWER)).intValue()) > k) {
            k = p;
        }
        if (powerDecreasesPerConduit) {
            --k;
        }
        if (k < 0) {
            return 0;
        }
        return k;
    }

    public void m_6807_(BlockState p_55630_, Level p_55631_, BlockPos p_55632_, BlockState p_55633_, boolean p_55634_) {
        if (!p_55633_.m_60713_(p_55630_.m_60734_()) && !p_55631_.f_46443_) {
            this.updatePowerStrength(p_55631_, p_55632_, p_55630_);
            for (Direction direction : Direction.Plane.VERTICAL) {
                p_55631_.m_46672_(p_55632_.m_121945_(direction), (Block)this);
            }
            this.updateNeighborsOfNeighboringWires(p_55631_, p_55632_);
        }
    }

    public void m_6810_(BlockState p_55568_, Level p_55569_, BlockPos p_55570_, BlockState p_55571_, boolean p_55572_) {
        if (!p_55572_ && !p_55568_.m_60713_(p_55571_.m_60734_())) {
            super.m_6810_(p_55568_, p_55569_, p_55570_, p_55571_, p_55572_);
            if (!p_55569_.f_46443_) {
                for (Direction direction : Direction.values()) {
                    p_55569_.m_46672_(p_55570_.m_121945_(direction), (Block)this);
                }
                this.updatePowerStrength(p_55569_, p_55570_, p_55568_);
                this.updateNeighborsOfNeighboringWires(p_55569_, p_55570_);
            }
        }
    }

    private void checkCornerChangeAt(Level p_55617_, BlockPos p_55618_) {
        if (p_55617_.m_8055_(p_55618_).m_60713_((Block)this)) {
            p_55617_.m_46672_(p_55618_, (Block)this);
            for (Direction direction : Direction.values()) {
                p_55617_.m_46672_(p_55618_.m_121945_(direction), (Block)this);
            }
        }
    }

    private void updateNeighborsOfNeighboringWires(Level p_55638_, BlockPos p_55639_) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.checkCornerChangeAt(p_55638_, p_55639_.m_121945_(direction));
        }
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = p_55639_.m_121945_(direction1);
            if (p_55638_.m_8055_(blockpos).m_60796_((BlockGetter)p_55638_, blockpos)) {
                this.checkCornerChangeAt(p_55638_, blockpos.m_7494_());
                continue;
            }
            this.checkCornerChangeAt(p_55638_, blockpos.m_7495_());
        }
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPosNeighbor, boolean p_55566_) {
        if (!level.f_46443_) {
            if (blockState.m_60710_((LevelReader)level, blockPos)) {
                this.updatePowerStrength(level, blockPos, blockState);
            } else {
                VerticalRedstoneConduitBlock.m_49950_((BlockState)blockState, (Level)level, (BlockPos)blockPos);
                level.m_7471_(blockPos, false);
            }
        }
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        Direction facing = ctx.m_8125_();
        boolean hasMatchingBlockBelow = ctx.m_43725_().m_8055_(ctx.m_8083_().m_7495_()).m_60734_() instanceof VerticalRedstoneConduitBlock;
        if (hasMatchingBlockBelow) {
            return (BlockState)super.m_5573_(ctx).m_61124_((Property)BASE, (Comparable)Boolean.valueOf(false));
        }
        return super.m_5573_(ctx);
    }
}

