/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.client.gui.screens;

import com.dairymoose.xenotech.menu.BlueprintingTableMenu;
import com.dairymoose.xenotech.network.ServerboundCreateBlueprintsPacket;
import com.dairymoose.xenotech.network.XenoTechNetwork;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlueprintingTableScreen
extends AbstractContainerScreen<BlueprintingTableMenu> {
    private static final Component CONTAINER_TITLE = Component.m_237115_((String)"block.xenotech.blueprinting_table");
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation BLUEPRINTING_TABLE_GUI = new ResourceLocation("xenotech", "textures/gui/blueprinting_table.png");
    final int GUI_WIDTH = 176;
    final int GUI_HEIGHT = 133;
    private Button makeBlueprintButton;
    int startX;
    int startY;
    int tooltipState = -1;

    private void setNoPaperTooltip() {
        this.tooltipState = 0;
        this.makeBlueprintButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Blueprinting not possible!  Add paper to paper slot")));
    }

    private void setFullOutputTooltip() {
        this.tooltipState = 1;
        this.makeBlueprintButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Blueprinting not possible!  Output slot must be empty")));
    }

    private void setNoTargetItemTooltip() {
        this.tooltipState = 2;
        this.makeBlueprintButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Blueprinting not possible!  Target item slot is empty")));
    }

    private void setCreateNewBlueprintTooltip() {
        this.tooltipState = 3;
        this.makeBlueprintButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Create new blueprint")));
    }

    private void updateTooltipFromState(int tooltipState) {
        if (this.tooltipState != tooltipState) {
            this.tooltipState = tooltipState;
            if (tooltipState == 0) {
                this.setNoPaperTooltip();
            } else if (tooltipState == 1) {
                this.setFullOutputTooltip();
            } else if (tooltipState == 2) {
                this.setNoTargetItemTooltip();
            } else if (tooltipState == 3) {
                this.setCreateNewBlueprintTooltip();
            }
        }
    }

    private int getTooltipState() {
        ItemStack paperItem = ((BlueprintingTableMenu)this.m_6262_()).m_38853_(0).m_7993_();
        ItemStack targetItem = ((BlueprintingTableMenu)this.m_6262_()).m_38853_(1).m_7993_();
        ItemStack outputItem = ((BlueprintingTableMenu)this.m_6262_()).m_38853_(2).m_7993_();
        if (!paperItem.m_150930_(Items.f_42516_)) {
            return 0;
        }
        if (!outputItem.m_41619_()) {
            return 1;
        }
        if (targetItem.m_41619_()) {
            return 2;
        }
        return 3;
    }

    public BlueprintingTableScreen(BlueprintingTableMenu blueprintingTableMenu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)blueprintingTableMenu, inventory, title == null ? CONTAINER_TITLE : title);
        this.f_97726_ = 176;
        this.f_97727_ = 133;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.startX = (this.f_96543_ - 176) / 2;
        this.startY = (this.f_96544_ - 133) / 2;
        int buttonStartX = 88;
        int buttonStartY = 19;
        int buttonWidth = 20;
        int buttonHeight = 18;
        int buttonCurrentY = this.startY + buttonStartY;
        if (this.makeBlueprintButton == null) {
            this.makeBlueprintButton = new ImageButton(this.startX + buttonStartX, buttonCurrentY, buttonWidth, buttonHeight, 0, 220, BLUEPRINTING_TABLE_GUI, button -> {
                XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundCreateBlueprintsPacket());
                button.m_93692_(false);
            });
        }
        this.m_142416_((GuiEventListener)this.makeBlueprintButton);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_88315_(GuiGraphics p_282918_, int p_282102_, int p_282423_, float p_282621_) {
        int newTooltipState = this.getTooltipState();
        this.updateTooltipFromState(newTooltipState);
        this.m_280273_(p_282918_);
        super.m_88315_(p_282918_, p_282102_, p_282423_, p_282621_);
        this.m_280072_(p_282918_, p_282102_, p_282423_);
    }

    protected void m_7286_(GuiGraphics graphics, float p_97788_, int p_97789_, int p_97790_) {
        graphics.m_280218_(BLUEPRINTING_TABLE_GUI, this.startX, this.startY, 0, 0, 176, 133);
    }
}

