/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.client.gui.screens;

import com.dairymoose.xenotech.menu.FluidShippingTankMenu;
import com.dairymoose.xenotech.world.level.block.entity.FluidShippingTankBlockEntity;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FluidShippingTankScreen
extends AbstractContainerScreen<FluidShippingTankMenu> {
    private static final Component CONTAINER_TITLE = Component.m_237115_((String)"block.xenotech.fluid_shipping_tank");
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation FLUID_SHIPPING_TANK_GUI = new ResourceLocation("xenotech", "textures/gui/fluid_shipping_tank.png");
    final int GUI_WIDTH = 176;
    final int GUI_HEIGHT = 149;
    int startX;
    int startY;

    public FluidShippingTankScreen(FluidShippingTankMenu fluidShippingTankMenu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)fluidShippingTankMenu, inventory, title == null ? CONTAINER_TITLE : title);
        this.f_97726_ = 176;
        this.f_97727_ = 149;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.startX = (this.f_96543_ - 176) / 2;
        this.startY = (this.f_96544_ - 149) / 2;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_88315_(GuiGraphics p_282918_, int p_282102_, int p_282423_, float p_282621_) {
        this.m_280273_(p_282918_);
        super.m_88315_(p_282918_, p_282102_, p_282423_, p_282621_);
        this.m_280072_(p_282918_, p_282102_, p_282423_);
    }

    ResourceLocation transformToTextureLocation(ResourceLocation input) {
        return new ResourceLocation(input.m_135827_(), "textures/" + input.m_135815_() + ".png");
    }

    public boolean m_7933_(int key, int p_96553_, int p_96554_) {
        if (key == 69) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(key, p_96553_, p_96554_);
    }

    protected void m_7286_(GuiGraphics graphics, float p_97788_, int p_97789_, int p_97790_) {
        IClientFluidTypeExtensions ext;
        FluidShippingTankBlockEntity tank;
        FluidShippingTankMenu menu;
        BlockEntity blockEntity;
        graphics.m_280218_(FLUID_SHIPPING_TANK_GUI, this.startX, this.startY, 0, 0, 176, 149);
        AbstractContainerMenu abstractContainerMenu = Minecraft.m_91087_().f_91074_.f_36096_;
        if (abstractContainerMenu instanceof FluidShippingTankMenu && (blockEntity = (menu = (FluidShippingTankMenu)abstractContainerMenu).getBlockEntity()) instanceof FluidShippingTankBlockEntity && !(tank = (FluidShippingTankBlockEntity)blockEntity).getFluidInventory().isEmpty() && (ext = IClientFluidTypeExtensions.of((Fluid)tank.getFluidInventory().getFluid().getFluid())) != null) {
            int tint = ext.getTintColor(tank.getFluidInventory().getFluid());
            int r = (tint & 0xFF0000) >> 16;
            int g = (tint & 0xFF00) >> 8;
            int b = tint & 0xFF;
            int fluidAmount = tank.getFluidInventory().getFluidAmount();
            Minecraft client = Minecraft.m_91087_();
            int left = this.startX + 20;
            int bottom = this.startY + 53;
            int sWidth = 32;
            int sHeight = Mth.m_14167_((float)(32.0f * (float)fluidAmount / (float)tank.getFluidInventory().getCapacity()));
            double scale = client.m_91268_().m_85449_();
            RenderSystem.enableScissor((int)((int)((double)left * scale)), (int)((int)((double)client.m_91268_().m_85442_() - (double)bottom * scale)), (int)((int)((double)sWidth * scale)), (int)((int)((double)sHeight * scale)));
            RenderSystem.setShaderColor((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)1.0f);
            if (ext.getStillTexture() != null) {
                ResourceLocation texturePath = ext.getStillTexture();
                TextureAtlasSprite fluidSprite = (TextureAtlasSprite)this.f_96541_.m_91258_(InventoryMenu.f_39692_).apply(texturePath);
                this.f_96541_.m_91097_().m_174784_(new ResourceLocation(texturePath.m_135827_(), "textures/" + texturePath.m_135815_() + ".png"));
                graphics.m_280159_(this.startX + 22, this.startY + 21, 0, 32, 32, fluidSprite);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableScissor();
            graphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)(fluidAmount + " mB")), this.startX + 24, this.startY + 14, -16777216, false);
            graphics.m_280614_(this.f_96547_, tank.getFluidInventory().getFluid().getDisplayName(), this.startX + 65, this.startY + 54, -16777216, false);
        }
    }
}

