/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.client.gui.screens;

import com.dairymoose.xenotech.client.gui.screens.TaskElement;
import com.dairymoose.xenotech.client.gui.screens.TaskItemType;
import com.dairymoose.xenotech.client.gui.screens.TaskParamType;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.Size2i;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskItem
implements Cloneable {
    private static final Logger LOGGER = LogManager.getLogger();
    public String displayName;
    public TaskElement element;
    public TaskItemType taskType;
    public Map<TaskParamType, TaskParam> taskParams = new HashMap<TaskParamType, TaskParam>();
    public boolean inProgress = false;
    public ResourceLocation icon;
    public Size2i iconDim;
    public List<Object> inputBoxes;
    public int listIndex = -1;

    public String toString() {
        return this.displayName + ": " + this.element.name();
    }

    protected TaskItem(TaskElement element, String displayName, TaskItemType taskType, ResourceLocation icon, Size2i iconDim, List<Object> inputBoxes) {
        this.element = element;
        this.displayName = displayName;
        this.taskType = taskType;
        this.icon = icon;
        this.iconDim = iconDim;
        this.inputBoxes = inputBoxes;
    }

    public static TaskItem copy(TaskItem toCopy) {
        try {
            return (TaskItem)toCopy.clone();
        }
        catch (Exception e) {
            LOGGER.error("Failed to make copy of TaskItem: " + toCopy);
            return null;
        }
    }

    public static TaskItem create(TaskElement element, String displayName, TaskItemType taskType, ResourceLocation icon, Size2i iconDim, List<Object> inputBoxes) {
        try {
            Constructor cons = null;
            cons = element.getClassMapping().getDeclaredConstructor(TaskElement.class, String.class, TaskItemType.class, ResourceLocation.class, Size2i.class, List.class);
            TaskItem result = (TaskItem)cons.newInstance(new Object[]{element, displayName, taskType, icon, iconDim, inputBoxes});
            return result;
        }
        catch (Exception e) {
            LOGGER.error("Could not generate new instance for element: " + element, (Throwable)e);
            return null;
        }
    }

    public static TaskItem event(TaskElement element) {
        TaskItem newTaskItem = new TaskItem(element, "", TaskItemType.EVENT, null, null, null);
        return newTaskItem;
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Element", this.element.name());
        tag.m_128359_("Name", this.displayName);
        tag.m_128405_("TaskType", this.taskType.ordinal());
        tag.m_128379_("InProgress", this.inProgress);
        ListTag listTag = new ListTag();
        for (Map.Entry<TaskParamType, TaskParam> entry : this.taskParams.entrySet()) {
            TaskParamType key = entry.getKey();
            TaskParam param = entry.getValue();
            if (param.value == null) {
                param.value = "";
            }
            listTag.add((Object)StringTag.m_129297_((String)(key.name() + ";" + param.name + ";" + param.value)));
        }
        tag.m_128365_("Params", (Tag)listTag);
        this.saveNbtExtras(tag);
        return tag;
    }

    protected void saveNbtExtras(CompoundTag tag) {
    }

    protected void loadNbtExtras(CompoundTag tag) {
    }

    public void reset() {
    }

    public static TaskItem fromNbt(CompoundTag tag) {
        try {
            TaskItem taskItem;
            TaskElement element;
            String elementText;
            if (tag != null && (elementText = tag.m_128461_("Element")) != null && (element = TaskElement.valueOf(elementText)) != null && (taskItem = TaskItem.create(element, null, null, null, null, null)) != null) {
                taskItem.displayName = tag.m_128461_("Name");
                int taskTypeId = tag.m_128451_("TaskType");
                if (taskTypeId >= TaskItemType.values().length) {
                    return null;
                }
                taskItem.taskType = TaskItemType.values()[taskTypeId];
                taskItem.inProgress = tag.m_128471_("InProgress");
                ListTag listTag = tag.m_128437_("Params", 8);
                for (int i = 0; i < listTag.size(); ++i) {
                    String[] split;
                    String full = listTag.m_128778_(i);
                    if (full == null || (split = full.split(";", -1)).length != 3) continue;
                    try {
                        TaskParam taskParam = new TaskParam();
                        taskParam.type = TaskParamType.valueOf(split[0]);
                        taskParam.name = split[1];
                        taskParam.value = split[2];
                        taskItem.taskParams.put(taskParam.type, taskParam);
                        continue;
                    }
                    catch (Exception ex) {
                        LOGGER.error("Error loading taskParam", (Throwable)ex);
                    }
                }
                taskItem.loadNbtExtras(tag);
                return taskItem;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error loading TaskItem", (Throwable)e);
        }
        return null;
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TaskItem) {
            TaskItem taskItem = (TaskItem)obj;
            return this.element.equals((Object)taskItem.element);
        }
        return false;
    }

    public static class TaskParam {
        public TaskParamType type;
        public String name;
        public String value;

        public int toInt(int defaultValue, int min, int max) {
            int ret = defaultValue;
            try {
                ret = Integer.parseInt(this.value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (ret < min) {
                ret = min;
            } else if (ret > max) {
                ret = max;
            }
            return ret;
        }
    }
}

