/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.client.gui.screens;

import com.dairymoose.xenotech.client.gui.screens.TaskElement;
import com.dairymoose.xenotech.client.gui.screens.TaskItem;
import com.dairymoose.xenotech.client.gui.screens.TaskItemType;
import com.dairymoose.xenotech.client.gui.screens.TaskParamType;
import com.dairymoose.xenotech.client.gui.screens.TasklistScreen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskList {
    private static final Logger LOGGER = LogManager.getLogger();
    private Map<TaskItem, List<TaskItem>> eventActionList = new HashMap<TaskItem, List<TaskItem>>();
    public static String REDSTONE_EVENT = "Redstone event";
    public static String REDSTONE_EVENT2 = "Redstone event (2)";
    public static String DAILY_EVENT = "Daily event";
    public static String PERIODIC_EVENT = "Periodic event";
    public static String PARAM_MIN_REDSTONE = "Min redstone power";
    public static String PARAM_MAX_REDSTONE = "Max redstone power";
    public static final String PARAM_AM_PM = "Time in AM/PM format (e.g., 8:30 am)";
    public static String FORWARD_ACTION = "Forward action";
    public static String PARAM_DELAY_SEC = "Time (seconds)";
    public static String BACKWARDS_ACTION = "Backwards action";
    public static String PARAM_BLOCK_COUNT = "Block count";
    public static String PARAM_ITEM_FILTER = "Item Filter (name)";
    public static String DELAY_ACTION = "Delay action";
    public static String TURN_LEFT_ACTION = "Turn-left action";
    public static String TURN_RIGHT_ACTION = "Turn-right action";
    public static String PARAM_DEGREES = "Degrees";
    public static String UNLOAD_CARGO_ACTION = "Unload-cargo action";
    public static String LOAD_CARGO_ACTION = "Load-cargo action";
    public static String VERTICAL_ASCENT_ACTION = "Vertical ascent action";
    public static String VERTICAL_DESCENT_ACTION = "Vertical descent action";
    public static String CREATE_MOD_TAKE_FROM_ITEM_VAULT = "[Create] Take from Item Vault";
    public static String CREATE_MOD_ADD_TO_ITEM_VAULT = "[Create] Add to Item Vault";
    public static String CREATE_MOD_TAKE_FROM_FLUID_TANK = "[Create] Take from Fluid Tank";
    public static String CREATE_MOD_ADD_TO_FLUID_TANK = "[Create] Add to Fluid Tank";

    public void cleanupBadData() {
        ArrayList<TaskItem> toRemove = new ArrayList<TaskItem>();
        for (TaskItem item : this.eventActionList.keySet()) {
            TaskItem firstTask = this.getFirstTaskForEvent(item);
            if (firstTask != null && firstTask.displayName != null && firstTask.displayName.length() != 0) continue;
            toRemove.add(item);
        }
        for (TaskItem item : toRemove) {
            this.removeAllTasksForEvent(item);
        }
    }

    public Set<TaskItem> getAllEventTasks() {
        return this.eventActionList.keySet();
    }

    public boolean isEmpty() {
        return this.eventActionList.isEmpty();
    }

    public boolean removeAllTasksForEvent(TaskItem event) {
        if (event.taskType == TaskItemType.EVENT) {
            this.eventActionList.remove(event);
            return true;
        }
        return false;
    }

    public boolean removeTaskForEvent(TaskItem toRemove, TaskItem event) {
        if (event.taskType == TaskItemType.EVENT) {
            List<TaskItem> taskItems = this.eventActionList.get(event);
            if (taskItems == null || taskItems.isEmpty()) {
                return false;
            }
            if (toRemove.listIndex != -1 && toRemove.listIndex < taskItems.size()) {
                taskItems.remove(toRemove.listIndex);
                return true;
            }
        }
        return false;
    }

    public boolean hasTaskListForEvent(TaskItem taskItem) {
        if (taskItem.taskType == TaskItemType.EVENT) {
            List<TaskItem> taskItems = this.eventActionList.get(taskItem);
            return taskItems != null && !taskItems.isEmpty();
        }
        return false;
    }

    public List<TaskItem> getTaskItemsForEvent(TaskItem taskItem) {
        if (taskItem.taskType == TaskItemType.EVENT) {
            List<TaskItem> taskItems = this.eventActionList.get(taskItem);
            if (taskItems == null) {
                taskItems = new ArrayList<TaskItem>();
                taskItems.add(taskItem);
                this.eventActionList.put(taskItem, taskItems);
            }
            return taskItems;
        }
        return null;
    }

    public TaskItem getFirstTaskForEvent(TaskItem taskItem) {
        List<TaskItem> taskItems = this.getTaskItemsForEvent(taskItem);
        if (taskItems != null && !taskItems.isEmpty()) {
            return taskItems.get(0);
        }
        return null;
    }

    public CompoundTag toNbt() {
        this.cleanupBadData();
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<TaskItem, List<TaskItem>> entry : this.eventActionList.entrySet()) {
            TaskItem key = entry.getKey();
            List<TaskItem> list = entry.getValue();
            CompoundTag eventTag = new CompoundTag();
            ListTag listTag = new ListTag();
            for (TaskItem taskItem : list) {
                listTag.add((Object)taskItem.toNbt());
            }
            eventTag.m_128365_("Actions", (Tag)listTag);
            eventTag.m_128365_("TaskItem", (Tag)key.toNbt());
            tag.m_128365_(key.element.name(), (Tag)eventTag);
        }
        return tag;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static List<TasklistScreen.ParameterizedEditBox> editBoxList(List<Object> editBoxObjs) {
        if (editBoxObjs == null) {
            return new ArrayList<TasklistScreen.ParameterizedEditBox>();
        }
        return editBoxObjs;
    }

    @OnlyIn(value=Dist.CLIENT)
    private EditBox getMatchingEditBox(List<Object> editBoxes, TaskParamType lookup) {
        List<TasklistScreen.ParameterizedEditBox> paramEditBoxes = TaskList.editBoxList(editBoxes);
        for (TasklistScreen.ParameterizedEditBox editBoxObj : paramEditBoxes) {
            EditBox editBox = editBoxObj.editBox;
            if (editBoxObj.type != lookup) continue;
            return editBox;
        }
        return null;
    }

    private void enrichFromGlobalList(final TaskItem toEnrich, final List<TaskItem> globalList) {
        if (toEnrich == null) {
            return;
        }
        final TaskElement element = toEnrich.element;
        if (element == null) {
            return;
        }
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

            @Override
            public void run() {
                for (TaskItem taskItem : globalList) {
                    if (!element.equals((Object)taskItem.element)) continue;
                    toEnrich.icon = taskItem.icon;
                    toEnrich.iconDim = taskItem.iconDim;
                    toEnrich.inputBoxes = taskItem.inputBoxes;
                    for (Map.Entry<TaskParamType, TaskItem.TaskParam> entry : toEnrich.taskParams.entrySet()) {
                        TaskItem.TaskParam taskParam = entry.getValue();
                        EditBox match = TaskList.this.getMatchingEditBox(toEnrich.inputBoxes, taskParam.type);
                        if (match == null) continue;
                        match.m_94144_(taskParam.value);
                    }
                    return;
                }
            }
        });
    }

    public boolean fromNbt(CompoundTag tag, Optional<List<TaskItem>> globalList) {
        this.eventActionList.clear();
        try {
            Set keys = tag.m_128431_();
            if (keys != null && !keys.isEmpty()) {
                for (String key : keys) {
                    CompoundTag eventTag = (CompoundTag)tag.m_128423_(key);
                    if (eventTag == null) continue;
                    CompoundTag eventTaskItemTag = (CompoundTag)eventTag.m_128423_("TaskItem");
                    TaskItem eventTaskItem = TaskItem.fromNbt(eventTaskItemTag);
                    if (globalList.isPresent()) {
                        this.enrichFromGlobalList(eventTaskItem, globalList.get());
                    }
                    ArrayList<TaskItem> taskItems = new ArrayList<TaskItem>();
                    this.eventActionList.put(eventTaskItem, taskItems);
                    ListTag listTag = eventTag.m_128437_("Actions", 10);
                    for (int i = 0; i < listTag.size(); ++i) {
                        CompoundTag actionTag = listTag.m_128728_(i);
                        TaskItem actionTaskItem = TaskItem.fromNbt(actionTag);
                        if (globalList.isPresent()) {
                            this.enrichFromGlobalList(actionTaskItem, globalList.get());
                        }
                        taskItems.add(actionTaskItem);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error loading tasklist NBT", (Throwable)e);
        }
        return false;
    }
}

