/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.client.gui.screens;

import com.dairymoose.xenotech.XenoTechCommon;
import com.dairymoose.xenotech.client.gui.screens.TaskElement;
import com.dairymoose.xenotech.client.gui.screens.TaskItem;
import com.dairymoose.xenotech.client.gui.screens.TaskItemType;
import com.dairymoose.xenotech.client.gui.screens.TaskList;
import com.dairymoose.xenotech.client.gui.screens.TaskParamType;
import com.dairymoose.xenotech.client.gui.screens.TasklistScrollPanel;
import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.network.ServerboundTasklistPacket;
import com.dairymoose.xenotech.network.XenoTechNetwork;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraftforge.common.util.Size2i;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TasklistScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation TASKLIST_GUI = new ResourceLocation("xenotech", "textures/gui/tasklist.png");
    private static final ResourceLocation BUTTONS_GUI = new ResourceLocation("xenotech", "textures/gui/tasklist_buttons.png");
    private static final ResourceLocation ICON_REDSTONE_EVENT_GUI = new ResourceLocation("xenotech", "textures/gui/redstone_event.png");
    private static final ResourceLocation ICON_DAILY_EVENT_GUI = new ResourceLocation("xenotech", "textures/gui/daily_event.png");
    private static final ResourceLocation ICON_PERIODIC_EVENT_GUI = new ResourceLocation("xenotech", "textures/gui/periodic_event.png");
    private static final ResourceLocation ICON_FORWARD_ACTION_GUI = new ResourceLocation("xenotech", "textures/gui/forward_action.png");
    private static final ResourceLocation ICON_BACKWARDS_ACTION_GUI = new ResourceLocation("xenotech", "textures/gui/backwards_action.png");
    private static final ResourceLocation ICON_VERTICAL_ASCENT_ACTION_GUI = new ResourceLocation("xenotech", "textures/gui/ascent_action.png");
    private static final ResourceLocation ICON_VERTICAL_DESCENT_ACTION_GUI = new ResourceLocation("xenotech", "textures/gui/descent_action.png");
    private static final ResourceLocation ICON_ADD_TO_ITEM_VAULT_GUI = new ResourceLocation("xenotech", "textures/gui/add_to_item_vault.png");
    private static final ResourceLocation ICON_TAKE_FROM_ITEM_VAULT_GUI = new ResourceLocation("xenotech", "textures/gui/take_from_item_vault.png");
    private static final ResourceLocation ICON_ADD_TO_FLUID_TANK_GUI = new ResourceLocation("xenotech", "textures/gui/add_to_fluid_tank.png");
    private static final ResourceLocation ICON_TAKE_FROM_FLUID_TANK_GUI = new ResourceLocation("xenotech", "textures/gui/take_from_fluid_tank.png");
    private static final ResourceLocation ICON_TURN_LEFT_ACTION_GUI = new ResourceLocation("xenotech", "textures/gui/turn_left_action.png");
    private static final ResourceLocation ICON_TURN_RIGHT_ACTION_GUI = new ResourceLocation("xenotech", "textures/gui/turn_right_action.png");
    private static final ResourceLocation ICON_DELAY_ACTION_GUI = new ResourceLocation("xenotech", "textures/gui/delay_action.png");
    private static final ResourceLocation ICON_UNLOAD_CARGO_ACTION_GUI = new ResourceLocation("xenotech", "textures/gui/take_from_chest_action.png");
    private static final ResourceLocation ICON_LOAD_CARGO_ACTION_GUI = new ResourceLocation("xenotech", "textures/gui/deposit_into_chest_action.png");
    final int GUI_WIDTH = 256;
    final int GUI_HEIGHT = 256;
    private int textColor = 2555173;
    private Style textStyle = Style.f_131099_.m_131150_(Minecraft.f_91058_).m_131136_(Boolean.TRUE).m_178520_(this.textColor);
    private Button eventsButton;
    private Button actionsButton;
    private TasklistScrollPanel choicesScrollPanel;
    private TasklistScrollPanel taskScrollPanel;
    private Villager villager;
    private TaskList taskList;
    private static boolean autoselectFirstValidEvent = true;
    public static int widthPerChar = 10;
    private static int textBoxHeight = 8;
    private static int editBox60CharWidth = 60 * widthPerChar;
    private static int editBox8CharWidth = 8 * widthPerChar;
    private static int editBox4CharWidth = 4 * widthPerChar;
    private static int editBox3CharWidth = 3 * widthPerChar;
    private static int editBox2CharWidth = 2 * widthPerChar;
    private static EditBox blockCountTemplate = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, editBox3CharWidth, textBoxHeight, (Component)Component.m_237113_((String)TaskList.PARAM_BLOCK_COUNT));
    private static EditBox delayTemplate = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, editBox4CharWidth, textBoxHeight, (Component)Component.m_237113_((String)TaskList.PARAM_DELAY_SEC));
    private static EditBox degreesTemplate = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, editBox3CharWidth, textBoxHeight, (Component)Component.m_237113_((String)TaskList.PARAM_DEGREES));
    private static EditBox minRedstonePowerTemplate = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, editBox2CharWidth, textBoxHeight, (Component)Component.m_237113_((String)TaskList.PARAM_MIN_REDSTONE));
    private static EditBox maxRedstonePowerTemplate = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, editBox2CharWidth, textBoxHeight, (Component)Component.m_237113_((String)TaskList.PARAM_MAX_REDSTONE));
    private static EditBox amPmTemplate = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, editBox8CharWidth, textBoxHeight, (Component)Component.m_237113_((String)"Time in AM/PM format (e.g., 8:30 am)"));
    private static EditBox itemFilterTemplate = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, editBox60CharWidth, textBoxHeight, (Component)Component.m_237113_((String)TaskList.PARAM_ITEM_FILTER));
    private static ParameterizedEditBox blockCountParam = new ParameterizedEditBox(TaskParamType.PARAM_BLOCK_COUNT, blockCountTemplate);
    private static ParameterizedEditBox delayParam = new ParameterizedEditBox(TaskParamType.PARAM_DELAY_SEC, delayTemplate);
    private static ParameterizedEditBox degreesParam = new ParameterizedEditBox(TaskParamType.PARAM_DEGREES, degreesTemplate);
    private static ParameterizedEditBox minRedstonePowerParam = new ParameterizedEditBox(TaskParamType.PARAM_MIN_REDSTONE, minRedstonePowerTemplate);
    private static ParameterizedEditBox maxRedstonePowerParam = new ParameterizedEditBox(TaskParamType.PARAM_MAX_REDSTONE, maxRedstonePowerTemplate);
    private static ParameterizedEditBox amPmParam = new ParameterizedEditBox(TaskParamType.PARAM_AM_PM, amPmTemplate);
    private static ParameterizedEditBox itemFilterParam = new ParameterizedEditBox(TaskParamType.PARAM_ITEM_FILTER, itemFilterTemplate);
    private static Size2i dim = new Size2i(20, 20);
    public static List<TaskItem> eventList = Stream.of(TaskItem.create(TaskElement.REDSTONE_EVENT, TaskList.REDSTONE_EVENT, TaskItemType.EVENT, ICON_REDSTONE_EVENT_GUI, dim, List.of(minRedstonePowerParam, maxRedstonePowerParam)), TaskItem.create(TaskElement.DAILY_EVENT, TaskList.DAILY_EVENT, TaskItemType.EVENT, ICON_DAILY_EVENT_GUI, dim, List.of(amPmParam)), TaskItem.create(TaskElement.PERIODIC_EVENT, TaskList.PERIODIC_EVENT, TaskItemType.EVENT, ICON_PERIODIC_EVENT_GUI, dim, List.of(delayParam)), TaskItem.create(TaskElement.REDSTONE_EVENT2, TaskList.REDSTONE_EVENT2, TaskItemType.EVENT, ICON_REDSTONE_EVENT_GUI, dim, List.of(minRedstonePowerParam, maxRedstonePowerParam))).collect(Collectors.toList());
    public static List<TaskItem> actionList = Stream.of(TaskItem.create(TaskElement.FORWARD_ACTION, TaskList.FORWARD_ACTION, TaskItemType.ACTION, ICON_FORWARD_ACTION_GUI, dim, List.of(blockCountParam)), TaskItem.create(TaskElement.BACKWARDS_ACTION, TaskList.BACKWARDS_ACTION, TaskItemType.ACTION, ICON_BACKWARDS_ACTION_GUI, dim, List.of(blockCountParam)), TaskItem.create(TaskElement.TURN_LEFT_ACTION, TaskList.TURN_LEFT_ACTION, TaskItemType.ACTION, ICON_TURN_LEFT_ACTION_GUI, dim, List.of(degreesParam)), TaskItem.create(TaskElement.TURN_RIGHT_ACTION, TaskList.TURN_RIGHT_ACTION, TaskItemType.ACTION, ICON_TURN_RIGHT_ACTION_GUI, dim, List.of(degreesParam)), TaskItem.create(TaskElement.DELAY_ACTION, TaskList.DELAY_ACTION, TaskItemType.ACTION, ICON_DELAY_ACTION_GUI, dim, List.of(delayParam)), TaskItem.create(TaskElement.UNLOAD_CARGO_ACTION, TaskList.UNLOAD_CARGO_ACTION, TaskItemType.ACTION, ICON_UNLOAD_CARGO_ACTION_GUI, dim, List.of(itemFilterParam)), TaskItem.create(TaskElement.LOAD_CARGO_ACTION, TaskList.LOAD_CARGO_ACTION, TaskItemType.ACTION, ICON_LOAD_CARGO_ACTION_GUI, dim, List.of(itemFilterParam)), TaskItem.create(TaskElement.VERTICAL_ASCENT_ACTION, TaskList.VERTICAL_ASCENT_ACTION, TaskItemType.ACTION, ICON_VERTICAL_ASCENT_ACTION_GUI, dim, List.of(blockCountParam)), TaskItem.create(TaskElement.VERTICAL_DESCENT_ACTION, TaskList.VERTICAL_DESCENT_ACTION, TaskItemType.ACTION, ICON_VERTICAL_DESCENT_ACTION_GUI, dim, List.of(blockCountParam))).collect(Collectors.toList());
    public static List<TaskItem> combinedList = Stream.concat(eventList.stream(), actionList.stream()).collect(Collectors.toList());
    int startX;
    int startY;
    public static boolean enrichedListWithMods = false;

    public TasklistScreen(TaskList taskList, Villager villager) {
        super((Component)Component.m_237113_((String)"Dialog"));
        if (taskList != null) {
            taskList.cleanupBadData();
        }
        this.modInit();
        this.villager = villager;
        this.taskList = taskList;
    }

    public static void modInit() {
        if (!enrichedListWithMods) {
            enrichedListWithMods = true;
            XenoTechCommon.CREATE_MOD.exec(() -> {
                actionList.add(TaskItem.create(TaskElement.CREATE_MOD_TAKE_FROM_ITEM_VAULT, TaskList.CREATE_MOD_TAKE_FROM_ITEM_VAULT, TaskItemType.ACTION, ICON_TAKE_FROM_ITEM_VAULT_GUI, dim, List.of(itemFilterParam)));
                combinedList.add(actionList.get(actionList.size() - 1));
                actionList.add(TaskItem.create(TaskElement.CREATE_MOD_ADD_TO_ITEM_VAULT, TaskList.CREATE_MOD_ADD_TO_ITEM_VAULT, TaskItemType.ACTION, ICON_ADD_TO_ITEM_VAULT_GUI, dim, List.of(itemFilterParam)));
                combinedList.add(actionList.get(actionList.size() - 1));
                actionList.add(TaskItem.create(TaskElement.CREATE_MOD_TAKE_FROM_FLUID_TANK, TaskList.CREATE_MOD_TAKE_FROM_FLUID_TANK, TaskItemType.ACTION, ICON_TAKE_FROM_FLUID_TANK_GUI, dim, List.of()));
                combinedList.add(actionList.get(actionList.size() - 1));
                actionList.add(TaskItem.create(TaskElement.CREATE_MOD_ADD_TO_FLUID_TANK, TaskList.CREATE_MOD_ADD_TO_FLUID_TANK, TaskItemType.ACTION, ICON_ADD_TO_FLUID_TANK_GUI, dim, List.of()));
                combinedList.add(actionList.get(actionList.size() - 1));
            });
        }
    }

    private void applyEventChoices() {
        Size2i dim = new Size2i(20, 20);
        this.choicesScrollPanel.setInfo(eventList);
        this.choicesScrollPanel.scrollToTop();
    }

    private void applyActionChoices() {
        this.choicesScrollPanel.setInfo(actionList);
        this.choicesScrollPanel.scrollToTop();
    }

    public void transferFromList(TasklistScrollPanel fromList, TaskItem taskItem, int mouseButton) {
        LOGGER.debug("Transfer item: " + taskItem.displayName);
        if (fromList == this.choicesScrollPanel) {
            if (taskItem.taskType == TaskItemType.EVENT) {
                List<TaskItem> taskItems = this.taskList.getTaskItemsForEvent(taskItem);
                this.taskScrollPanel.setInfo(taskItems);
            } else if (taskItem.taskType == TaskItemType.ACTION && !this.taskScrollPanel.taskItems().isEmpty()) {
                this.taskScrollPanel.taskItems().add(taskItem);
                this.taskScrollPanel.setInfo(this.taskScrollPanel.taskItems());
            }
        } else if (fromList == this.taskScrollPanel && mouseButton == 1) {
            TaskItem firstItem;
            if (taskItem.taskType == TaskItemType.EVENT) {
                this.taskList.removeAllTasksForEvent(taskItem);
                this.taskScrollPanel.setInfo(new ArrayList<TaskItem>());
            } else if (taskItem.taskType == TaskItemType.ACTION && !this.taskScrollPanel.taskItems().isEmpty() && (firstItem = this.taskScrollPanel.taskItems().get(0)) != null && firstItem.taskType == TaskItemType.EVENT) {
                this.taskList.removeTaskForEvent(taskItem, firstItem);
                this.taskScrollPanel.setInfo(this.taskList.getTaskItemsForEvent(firstItem));
            }
        }
    }

    public boolean m_7933_(int key, int p_96553_, int p_96554_) {
        boolean handled = false;
        if (this.taskScrollPanel != null) {
            handled = this.taskScrollPanel.m_7933_(key, p_96553_, p_96554_);
        }
        if (!handled && key == 69) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(key, p_96553_, p_96554_);
    }

    public boolean m_5534_(char ch, int keycode) {
        if (this.taskScrollPanel != null) {
            this.taskScrollPanel.m_5534_(ch, keycode);
        }
        return super.m_5534_(ch, keycode);
    }

    private void populateParamsForTasklist(TaskList taskList) {
        Set<TaskItem> eventTaskItems = taskList.getAllEventTasks();
        if (eventTaskItems != null) {
            for (TaskItem eventTaskItem : eventTaskItems) {
                List<TaskItem> actionTaskItems = taskList.getTaskItemsForEvent(eventTaskItem);
                for (TaskItem actionTask : actionTaskItems) {
                    for (ParameterizedEditBox paramEditBox : TaskList.editBoxList(actionTask.inputBoxes)) {
                        TaskItem.TaskParam taskParam = new TaskItem.TaskParam();
                        taskParam.type = paramEditBox.type;
                        taskParam.name = paramEditBox.editBox.m_6035_().getString();
                        taskParam.value = paramEditBox.editBox.m_94155_();
                        if (taskParam.value == null) {
                            taskParam.value = "";
                        }
                        actionTask.taskParams.put(paramEditBox.type, taskParam);
                    }
                }
            }
        }
    }

    public void m_7379_() {
        LOGGER.debug("exiting tasklist screen");
        Entity entity = this.villager.m_275832_();
        if (entity instanceof DummyEntity) {
            DummyEntity dummy = (DummyEntity)entity;
            this.populateParamsForTasklist(this.taskList);
            XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTasklistPacket(dummy, this.taskList));
        }
        super.m_7379_();
    }

    protected void m_7856_() {
        this.startX = (this.f_96543_ - 256) / 2;
        this.startY = (this.f_96544_ - 256) / 2;
        int buttonStartX = 227;
        int buttonStartY = 9;
        int buttonWidth = 20;
        int buttonHeight = 20;
        if (this.choicesScrollPanel == null) {
            this.choicesScrollPanel = new TasklistScrollPanel(this, Minecraft.m_91087_(), 210, 42, this.startX + 8, this.startY + 8, false);
            this.choicesScrollPanel.setGlobalTaskList(combinedList);
            this.choicesScrollPanel.setTaskList(this.taskList);
            this.applyEventChoices();
        }
        this.m_142416_((GuiEventListener)this.choicesScrollPanel);
        if (this.taskScrollPanel == null) {
            this.taskScrollPanel = new TasklistScrollPanel(this, Minecraft.m_91087_(), 240, 182, this.startX + 8, this.startY + 66, true);
            this.taskScrollPanel.setGlobalTaskList(combinedList);
            this.taskScrollPanel.setTaskList(this.taskList);
        }
        this.m_142416_((GuiEventListener)this.taskScrollPanel);
        int buttonCurrentY = this.startY + buttonStartY;
        if (this.eventsButton == null) {
            this.eventsButton = new ImageButton(this.startX + buttonStartX, buttonCurrentY, buttonWidth, buttonHeight, 0, 0, BUTTONS_GUI, button -> this.applyEventChoices());
        }
        this.m_142416_((GuiEventListener)this.eventsButton);
        buttonCurrentY += buttonHeight;
        if (this.actionsButton == null) {
            this.actionsButton = new ImageButton(this.startX + buttonStartX, buttonCurrentY, buttonWidth, buttonHeight, buttonWidth, 0, BUTTONS_GUI, button -> this.applyActionChoices());
        }
        this.m_142416_((GuiEventListener)this.actionsButton);
        if (autoselectFirstValidEvent && this.taskList != null) {
            for (TaskItem taskItem : eventList) {
                if (!this.taskList.hasTaskListForEvent(taskItem)) continue;
                this.taskScrollPanel.setInfo(this.taskList.getTaskItemsForEvent(taskItem));
                return;
            }
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_88315_(GuiGraphics graphics, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        graphics.m_280218_(TASKLIST_GUI, this.startX, this.startY, 0, 0, 256, 256);
        this.m_257404_((Component)Component.m_237119_());
        super.m_88315_(graphics, p_230430_2_, p_230430_3_, p_230430_4_);
    }

    public static class ParameterizedEditBox {
        TaskParamType type = null;
        boolean isTemplateVersion = true;
        EditBox editBox;

        public ParameterizedEditBox(TaskParamType type, EditBox editBox) {
            this(type, true, editBox);
        }

        public ParameterizedEditBox(TaskParamType type, boolean isTemplateVersion, EditBox editBox) {
            this.type = type;
            this.isTemplateVersion = isTemplateVersion;
            this.editBox = editBox;
        }
    }
}

