/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.client.gui.screens;

import com.dairymoose.xenotech.client.gui.screens.TaskElement;
import com.dairymoose.xenotech.client.gui.screens.TaskItem;
import com.dairymoose.xenotech.client.gui.screens.TaskItemType;
import com.dairymoose.xenotech.client.gui.screens.TaskList;
import com.dairymoose.xenotech.client.gui.screens.TasklistScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraftforge.client.gui.widget.ScrollPanel;
import net.minecraftforge.common.ForgeHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class TasklistScrollPanel
extends ScrollPanel {
    private List<FormattedCharSequence> lines = Collections.emptyList();
    private List<TaskItem> taskItems = new ArrayList<TaskItem>();
    private static int PADDING = 2;
    private static int textOnlyPadding = 1;
    private TasklistScreen parent = null;
    private List<TaskItem> globalTaskList;
    private TaskList taskList;
    private boolean drawParamBoxes;
    private int lastIconPadding = 0;
    private int verticalPadding = 0;
    private static final Logger LOGGER = LogManager.getLogger();
    public static boolean handledKeyPress = false;

    TasklistScrollPanel(TasklistScreen parent, Minecraft mcIn, int widthIn, int heightIn, int x, int y, boolean drawParamBoxes) {
        super(mcIn, widthIn, heightIn, y + PADDING, x);
        this.parent = parent;
        this.drawParamBoxes = drawParamBoxes;
    }

    private List<String> extractStringsFromTasks(List<TaskItem> taskItems) {
        ArrayList<String> result = new ArrayList<String>();
        for (TaskItem taskItem : taskItems) {
            result.add(taskItem.displayName);
        }
        return result;
    }

    public void setTaskList(TaskList taskList) {
        this.taskList = taskList;
    }

    public void setGlobalTaskList(List<TaskItem> globalTaskList) {
        this.globalTaskList = globalTaskList;
    }

    public List<TaskItem> taskItems() {
        return this.taskItems;
    }

    void setInfo(List<TaskItem> taskItems) {
        this.taskItems = taskItems;
        if (this.drawParamBoxes) {
            int i = 0;
            for (TaskItem taskItem : taskItems) {
                if (taskItem.inputBoxes != null) {
                    ArrayList<Object> newInputBoxes = new ArrayList<Object>();
                    for (TasklistScreen.ParameterizedEditBox paramInputBox : TaskList.editBoxList(taskItem.inputBoxes)) {
                        TaskItem.TaskParam taskParam;
                        EditBox editBox = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, paramInputBox.editBox.m_5711_(), paramInputBox.editBox.m_93694_(), paramInputBox.editBox.m_6035_());
                        String editBoxText = paramInputBox.editBox.m_94155_();
                        editBox.m_94144_(editBoxText);
                        if (paramInputBox.isTemplateVersion && (taskParam = taskItem.taskParams.get((Object)paramInputBox.type)) != null && taskParam.value != null) {
                            editBox.m_94144_(taskParam.value);
                        }
                        editBox.m_94199_(paramInputBox.editBox.m_5711_() / TasklistScreen.widthPerChar);
                        editBox.m_257544_(Tooltip.m_257550_((Component)paramInputBox.editBox.m_6035_()));
                        newInputBoxes.add(new TasklistScreen.ParameterizedEditBox(paramInputBox.type, false, editBox));
                    }
                    TaskItem newTaskItem = TaskItem.copy(taskItem);
                    newTaskItem.inputBoxes = newInputBoxes;
                    taskItems.set(i, newTaskItem);
                }
                ++i;
            }
        }
        this.lines = this.resizeContent(this.extractStringsFromTasks(taskItems));
    }

    void clearInfo() {
        this.taskItems = Collections.emptyList();
        this.lines = Collections.emptyList();
    }

    private List<FormattedCharSequence> resizeContent(List<String> lines) {
        ArrayList<FormattedCharSequence> ret = new ArrayList<FormattedCharSequence>();
        for (String line : lines) {
            if (line == null) {
                ret.add(null);
                continue;
            }
            Component chat = ForgeHooks.newChatWithLinks((String)line, (boolean)false);
            int maxTextLength = this.width - 12;
            if (maxTextLength < 0) continue;
            ret.addAll(Language.m_128107_().m_128112_(Minecraft.m_91087_().f_91062_.m_92865_().m_92414_((FormattedText)chat, maxTextLength, Style.f_131099_)));
        }
        return ret;
    }

    public int oneLineSize() {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return 9 + this.verticalPadding;
    }

    public int getContentHeight() {
        int height = 0;
        if ((height += this.lines.size() * this.oneLineSize()) < this.bottom - this.top - 8) {
            height = this.bottom - this.top - 8;
        }
        return height;
    }

    protected int getScrollAmount() {
        return this.oneLineSize() * 1;
    }

    public void scrollToTop() {
        this.scrollDistance = 0.0f;
    }

    protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
        int i = 0;
        for (FormattedCharSequence line : this.lines) {
            TaskItem taskItem = null;
            if (i < this.taskItems.size()) {
                taskItem = this.taskItems.get(i);
            }
            int iconPadding = 0;
            if (taskItem != null && taskItem.iconDim != null) {
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int headerHeight = 50;
                int iconWidth = 10;
                int iconHeight = 10;
                guiGraphics.blitInscribed(taskItem.icon, this.left + PADDING, relativeY - 1, iconWidth, iconHeight, taskItem.iconDim.width, taskItem.iconDim.height, false, false);
                this.lastIconPadding = iconPadding = iconWidth;
                if (this.drawParamBoxes && taskItem.inputBoxes != null) {
                    int textWidth = Minecraft.m_91087_().f_91062_.m_92724_(line);
                    int currentX = 5;
                    for (TasklistScreen.ParameterizedEditBox paramInputBox : TaskList.editBoxList(taskItem.inputBoxes)) {
                        EditBox inputBox = paramInputBox.editBox;
                        inputBox.m_264152_(this.left + PADDING + iconPadding + textWidth + currentX, relativeY);
                        inputBox.m_88315_(guiGraphics, entryRight, relativeY, 1.0f);
                        currentX += inputBox.m_5711_();
                        currentX += 5;
                    }
                }
            }
            if (line != null) {
                RenderSystem.enableBlend();
                int color = 0xFFFFFF;
                if (taskItem != null && taskItem.taskType == TaskItemType.EVENT && this.taskList != null && !this.taskList.hasTaskListForEvent(taskItem)) {
                    color = 0xA0A0A0;
                }
                guiGraphics.m_280648_(Minecraft.m_91087_().f_91062_, line, this.left + PADDING + iconPadding + textOnlyPadding, relativeY, color);
                RenderSystem.disableBlend();
            }
            relativeY += this.oneLineSize();
            ++i;
        }
        Style component = this.findTextLineStyle(mouseX, mouseY);
        if (component != null) {
            guiGraphics.m_280304_(Minecraft.m_91087_().f_91062_, component, mouseX, mouseY);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        for (TaskItem taskItem : this.taskItems) {
            if (taskItem.inputBoxes == null) continue;
            TaskList.editBoxList(taskItem.inputBoxes).forEach(paramEditBox -> {
                EditBox editBox = paramEditBox.editBox;
                if (editBox.m_5953_((double)mouseX, (double)mouseY)) {
                    guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, editBox.m_6035_(), mouseX, mouseY);
                }
            });
        }
    }

    private TaskItem getTaskFromTaskElement(TaskElement element) {
        if (this.globalTaskList != null) {
            for (TaskItem taskItem : this.globalTaskList) {
                if (!taskItem.element.equals((Object)element)) continue;
                return taskItem;
            }
        }
        return null;
    }

    private TaskItem findClickedTask(int mouseX, int mouseY) {
        FormattedCharSequence charSeq;
        int width;
        if (!this.m_5953_(mouseX, mouseY)) {
            return null;
        }
        double offset = (float)(mouseY - this.top + this.border) + this.scrollDistance + 1.0f;
        if (offset <= 0.0) {
            return null;
        }
        int lineIdx = (int)(offset / (double)this.oneLineSize());
        if (lineIdx > this.lines.size() || lineIdx < 1) {
            return null;
        }
        int idx = lineIdx - 1;
        TaskItem taskItem = this.taskItems.get(idx);
        if (taskItem != null && mouseX <= this.left + PADDING + this.lastIconPadding + textOnlyPadding + (width = Minecraft.m_91087_().f_91062_.m_92724_(charSeq = this.lines.get(idx)))) {
            taskItem.listIndex = idx;
            return taskItem;
        }
        return null;
    }

    private String findTextLine(int mouseX, int mouseY) {
        if (!this.m_5953_(mouseX, mouseY)) {
            return null;
        }
        double offset = (float)(mouseY - this.top + this.border) + this.scrollDistance + 1.0f;
        if (offset <= 0.0) {
            return null;
        }
        int lineIdx = (int)(offset / (double)this.oneLineSize());
        if (lineIdx > this.lines.size() || lineIdx < 1) {
            return null;
        }
        FormattedCharSequence line = this.lines.get(lineIdx - 1);
        if (line != null) {
            final StringBuilder sb = new StringBuilder();
            line.m_13731_(new FormattedCharSink(){

                public boolean m_6411_(int p_13746_, Style p_13747_, int p_13748_) {
                    char ch = (char)p_13748_;
                    sb.append(ch);
                    return true;
                }
            });
            String taskName = sb.toString();
            return taskName;
        }
        return null;
    }

    private Style findTextLineStyle(int mouseX, int mouseY) {
        if (!this.m_5953_(mouseX, mouseY)) {
            return null;
        }
        double offset = (float)(mouseY - this.top + this.border) + this.scrollDistance + 1.0f;
        if (offset <= 0.0) {
            return null;
        }
        int lineIdx = (int)(offset / (double)this.oneLineSize());
        if (lineIdx >= this.lines.size() || lineIdx < 1) {
            return null;
        }
        FormattedCharSequence line = this.lines.get(lineIdx - 1);
        if (line != null) {
            return Minecraft.m_91087_().f_91062_.m_92865_().m_92338_(line, mouseX - this.left - this.border);
        }
        return null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        TaskItem clickedTask = this.findClickedTask((int)mouseX, (int)mouseY);
        if (this.parent != null && clickedTask != null) {
            this.parent.transferFromList(this, clickedTask, button);
        }
        for (TaskItem taskItem : this.taskItems) {
            TaskList.editBoxList(taskItem.inputBoxes).forEach(paramEditBox -> {
                EditBox editBox = paramEditBox.editBox;
                if (editBox.m_5953_(mouseX, mouseY)) {
                    editBox.m_93692_(true);
                } else {
                    editBox.m_93692_(false);
                }
            });
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int p_94710_, int p_94711_, int p_94712_) {
        handledKeyPress = false;
        for (TaskItem taskItem : this.taskItems) {
            TaskList.editBoxList(taskItem.inputBoxes).forEach(paramEditBox -> {
                EditBox editBox = paramEditBox.editBox;
                if (editBox.m_93696_()) {
                    editBox.m_7933_(p_94710_, p_94711_, p_94712_);
                    handledKeyPress = true;
                }
            });
        }
        if (handledKeyPress) {
            return true;
        }
        return super.m_7933_(p_94710_, p_94711_, p_94712_);
    }

    public boolean m_5534_(char ch, int keycode) {
        for (TaskItem taskItem : this.taskItems) {
            TaskList.editBoxList(taskItem.inputBoxes).forEach(paramEditBox -> {
                EditBox editBox = paramEditBox.editBox;
                if (editBox.m_93696_()) {
                    editBox.m_5534_(ch, keycode);
                }
            });
        }
        return super.m_5534_(ch, keycode);
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }
}

